/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.io.async;

import com.ibm.io.async.AbstractAsyncChannel;
import com.ibm.io.async.AsyncChannelGroup;
import com.ibm.io.async.AsyncException;
import com.ibm.io.async.AsyncLibrary;
import com.ibm.io.async.CompletionKey;
import com.ibm.io.async.IAsyncProvider;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class AsyncSocketChannel
extends AbstractAsyncChannel {
    protected static final TraceComponent tc = Tr.register(AsyncSocketChannel.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");
    private static final long INVALID_SOCKET = -1L;
    private static IAsyncProvider provider = AsyncLibrary.getInstance();
    protected static boolean nioUtilsClassChecked = false;
    protected static Class<?> nioUtilsClass = null;
    protected static Method getFileDescriptorMethod = null;
    protected SocketChannel channel;
    private boolean prepared = false;

    public static AsyncSocketChannel open(AsyncChannelGroup asyncChannelGroup) throws AsyncException, IOException {
        return new AsyncSocketChannel(SocketChannel.open(), asyncChannelGroup);
    }

    public AsyncSocketChannel(SocketChannel channel, AsyncChannelGroup asyncChannelGroup) throws IOException {
        super(asyncChannelGroup);
        this.channel = channel;
        if (this.channel.isConnected()) {
            this.prepareSocket();
        }
    }

    public SocketChannel getSocketChannel() {
        return this.channel;
    }

    @Override
    public synchronized void close() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"close", (Object[])new Object[0]);
        }
        if (this.prepared) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("close - disposing of socket, channel id: " + this.channelIdentifier + ", local: " + this.channel.socket().getLocalSocketAddress() + ", remote: " + this.channel.socket().getRemoteSocketAddress()), (Object[])new Object[0]);
            }
            if (this.readFuture != null && this.readFuture.getTimeoutWorkItem() != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("cancelling timeout entry. readFuture.getTimeoutWorkItem().state: " + this.readFuture.getTimeoutWorkItem().state), (Object[])new Object[0]);
                }
                this.readFuture.getTimeoutWorkItem().state = 2L;
            }
            if (this.writeFuture != null && this.writeFuture.getTimeoutWorkItem() != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("cancelling timeout entry writeFuture.getTimeoutWorkItem().state: " + this.writeFuture.getTimeoutWorkItem().state), (Object[])new Object[0]);
                }
                this.writeFuture.getTimeoutWorkItem().state = 2L;
            }
            if (this.channelVCI != null && this.channelVCI.isInputStateTrackingOperational()) {
                int rc;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Input Tracking (Permission logic) is on", (Object[])new Object[0]);
                }
                if (this.channelVCI.isCloseWithReadOutstanding()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("calling cancel2 on readiocb: channel id: " + this.channelIdentifier + "  call id: " + this.readIOCB.getCallIdentifier()), (Object[])new Object[0]);
                    }
                    rc = provider.cancel2(this.channelIdentifier, this.readIOCB.getCallIdentifier());
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("return from cancel2 rc (0 - success): " + rc), (Object[])new Object[0]);
                    }
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"read was not outstanding", (Object[])new Object[0]);
                }
                if (this.channelVCI.isCloseWithWriteOutstanding()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("calling cancel2 on writeiocb channel id: " + this.channelIdentifier + " call id: " + this.writeIOCB.getCallIdentifier()), (Object[])new Object[0]);
                    }
                    rc = provider.cancel2(this.channelIdentifier, this.writeIOCB.getCallIdentifier());
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("return from cancel2 rc (0 - success): " + rc), (Object[])new Object[0]);
                    }
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"write was not outstanding", (Object[])new Object[0]);
                }
            }
            provider.terminateIOCB(this.readIOCB);
            AsyncLibrary.completionKeyPool.put(this.readIOCB);
            provider.terminateIOCB(this.writeIOCB);
            AsyncLibrary.completionKeyPool.put(this.writeIOCB);
            provider.dispose(this.channelIdentifier);
            this.prepared = false;
        }
        this.channel.close();
        super.close();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"close");
        }
    }

    protected long getFileDescriptor() throws AsyncException {
        FieldReturn fRet = AccessController.doPrivileged(new PrivFieldCheck(this.channel));
        if (fRet.e != null) {
            throw fRet.e;
        }
        return fRet.val;
    }

    public boolean isConnected() {
        return this.channel.isConnected();
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public synchronized void prepareSocket() throws IOException {
        if (!this.prepared) {
            long fd = this.getFileDescriptor();
            if (fd == -1L) {
                throw new AsyncException("Unable to get socket handle");
            }
            this.channelIdentifier = provider.prepare2(fd, this.asyncChannelGroup.getCompletionPort());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("prepareSocket - socket prepared, fd = " + fd + " channel id: " + this.channelIdentifier + " , local: " + this.channel.socket().getLocalSocketAddress() + ", remote: " + this.channel.socket().getRemoteSocketAddress()), (Object[])new Object[0]);
            }
            long callid = 0L;
            this.readIOCB = (CompletionKey)AsyncLibrary.completionKeyPool.get();
            if (this.readIOCB != null) {
                this.readIOCB.initializePoolEntry(this.channelIdentifier, callid);
                this.writeIOCB = (CompletionKey)AsyncLibrary.completionKeyPool.get();
                if (this.writeIOCB != null) {
                    this.writeIOCB.initializePoolEntry(this.channelIdentifier, callid);
                } else {
                    this.writeIOCB = new CompletionKey(this.channelIdentifier, callid, 10);
                }
            } else {
                this.readIOCB = new CompletionKey(this.channelIdentifier, callid, 10);
                this.writeIOCB = new CompletionKey(this.channelIdentifier, callid, 10);
            }
            provider.initializeIOCB(this.readIOCB);
            provider.initializeIOCB(this.writeIOCB);
            this.prepared = true;
        }
    }

    public Socket socket() {
        return this.channel.socket();
    }

    class PrivFieldCheck
    implements PrivilegedAction<FieldReturn> {
        private SocketChannel ioSocket;

        public PrivFieldCheck(SocketChannel _ioSocket) {
            this.ioSocket = _ioSocket;
        }

        @Override
        public FieldReturn run() {
            FieldReturn ret = new FieldReturn();
            if (!nioUtilsClassChecked) {
                block10: {
                    try {
                        nioUtilsClass = Class.forName("com.ibm.nio.NIOUtils");
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"NIOUtils class was found", (Object[])new Object[0]);
                        }
                        getFileDescriptorMethod = nioUtilsClass.getDeclaredMethod("getFileDescriptor", SocketChannel.class);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"NIOUtils getFileDescriptor method was found", (Object[])new Object[0]);
                        }
                    }
                    catch (Exception e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block10;
                        Tr.debug((TraceComponent)tc, (String)("Problem loading NIOUtils class/method: " + e.getMessage()), (Object[])new Object[0]);
                    }
                }
                nioUtilsClassChecked = true;
            }
            try {
                if (getFileDescriptorMethod != null) {
                    ret.val = (Long)getFileDescriptorMethod.invoke(nioUtilsClass, AsyncSocketChannel.this.channel);
                } else {
                    Field fdValField = this.ioSocket.getClass().getDeclaredField("fdVal");
                    fdValField.setAccessible(true);
                    ret.val = fdValField.getInt(this.ioSocket);
                }
            }
            catch (Exception e) {
                ret.e = new AsyncException(e.getLocalizedMessage());
            }
            if (ret.val == -1L) {
                ret.e = new AsyncException("Invalid fd val obtained from JDK");
                FFDCFilter.processException((Throwable)ret.e, (String)"com.ibm.io.async.AsyncSocketChannel", (String)"161");
            }
            return ret;
        }
    }

    protected static class FieldReturn {
        protected long val;
        protected AsyncException e = null;

        protected FieldReturn() {
        }
    }

    protected static class ConnectReturn {
        protected boolean isConnected = false;
        protected IOException ioe = null;

        protected ConnectReturn() {
        }
    }
}

