/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.io.async;

import com.ibm.io.async.AsyncException;
import com.ibm.io.async.AsyncProperties;
import com.ibm.io.async.CompletionKey;
import com.ibm.io.async.IAsyncProvider;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.channelfw.internal.ChannelFrameworkImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.channelfw.objectpool.CircularObjectPool;
import com.ibm.wsspi.channelfw.objectpool.ObjectDestroyer;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;

public class AsyncLibrary
implements IAsyncProvider {
    protected static final TraceComponent tc = Tr.register(AsyncLibrary.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");
    protected static final String LIBRARY_NAME = AsyncProperties.libraryName;
    static final int MAX_IDENTIFIERS = AsyncProperties.maxIdentifiers;
    private static int capabilities = 0;
    private static volatile IAsyncProvider instance = null;
    static LinkedList<Long> completionPorts = new LinkedList();
    static Object oneAtATime = new Object();
    static final int AIO_NOT_INITIALIZED = 0;
    static final int AIO_INITIALIZED = 1;
    static final int AIO_SHUTDOWN = 2;
    static volatile int aioInitialized = 0;
    protected static CircularObjectPool completionKeyPool;
    int compKeyPoolSize = AsyncProperties.COMPLETION_KEY_POOL_SIZE_DEFAULT;
    protected boolean doNativeIOCBInitAndTerm = true;

    protected static native int aio_cancel2(long var0, long var2) throws AsyncException;

    protected static native void aio_closeport2(long var0) throws AsyncException;

    protected static native long aio_dispose(long var0) throws AsyncException;

    protected static native boolean aio_getioev2(long var0, int var2, long var3) throws AsyncException;

    protected static native int aio_getioev3(long[] var0, int var1, int var2, long var3) throws AsyncException;

    protected static native int aio_init(int var0, Class<?> var1) throws AsyncException;

    protected static native int aio_getErrorString(int var0, byte[] var1) throws AsyncException;

    protected static native long aio_prepare2(long var0, long var2) throws AsyncException;

    protected static native long aio_newCompletionPort() throws AsyncException;

    protected static native boolean aio_multiIO3(long var0, long var2, int var4, boolean var5, boolean var6, long var7, boolean var9) throws AsyncException;

    protected static native void aio_shutdown() throws AsyncException;

    protected static native void aio_initIOCB(long var0) throws AsyncException;

    protected static native void aio_termIOCB(long var0) throws AsyncException;

    private static void initialize() throws AsyncException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize", (Object[])new Object[0]);
        }
        capabilities = AsyncLibrary.aio_init(MAX_IDENTIFIERS, AsyncException.class);
        aioInitialized = 1;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("initialize: " + capabilities));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"shutdown", (Object[])new Object[0]);
        }
        Object object = oneAtATime;
        synchronized (object) {
            block9: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"have lock", (Object[])new Object[0]);
                }
                if (aioInitialized == 1) {
                    aioInitialized = 2;
                    AsyncLibrary.closeAllCompletionPorts();
                    try {
                        AsyncLibrary.aio_shutdown();
                    }
                    catch (AsyncException ae) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block9;
                        Tr.debug((TraceComponent)tc, (String)("AsyncException occured while shutting down: " + ae.getMessage()), (Object[])new Object[0]);
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"shutdown");
        }
    }

    public static IAsyncProvider getInstance() {
        if (instance != null) {
            return instance;
        }
        try {
            return AsyncLibrary.createInstance();
        }
        catch (AsyncException x) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Error getting async provider instance, exception: " + x.getMessage()), (Object[])new Object[0]);
            }
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.io.async.AsyncLibrary", (String)"331");
            return null;
        }
    }

    public static synchronized IAsyncProvider createInstance() throws AsyncException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createInstance", (Object[])new Object[0]);
        }
        if (instance == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"instance is null.  Instantiating new AsyncLibrary ", (Object[])new Object[0]);
            }
            instance = new AsyncLibrary();
        }
        if (aioInitialized == 0 || aioInitialized == 2) {
            AsyncLibrary.initialize();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createInstance");
        }
        return instance;
    }

    protected AsyncLibrary() throws AsyncException {
        AsyncException loadException = AccessController.doPrivileged(new PrivLoadLibrary());
        if (loadException != null) {
            throw loadException;
        }
        AsyncLibrary.initialize();
        if (AsyncProperties.sCompKeyPoolSize != null) {
            this.compKeyPoolSize = Integer.parseInt(AsyncProperties.sCompKeyPoolSize);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("CompKeyPoolSize is: " + this.compKeyPoolSize), (Object[])new Object[0]);
        }
        completionKeyPool = new CircularObjectPool(this.compKeyPoolSize, null, new CompletionKeyPoolDestroy());
    }

    @Override
    public boolean hasCapability(int capability) {
        return (capabilities & capability) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int cancel2(long channelId, long callId) throws AsyncException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("cancel2: channel = " + channelId + " call id = " + callId), (Object[])new Object[0]);
        }
        int rc = 0;
        Object object = oneAtATime;
        synchronized (object) {
            block10: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"have lock", (Object[])new Object[0]);
                }
                if (aioInitialized == 1) {
                    try {
                        rc = AsyncLibrary.aio_cancel2(channelId, callId);
                    }
                    catch (Throwable t) {
                        if (aioInitialized == 2) break block10;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("caught throwable:" + t), (Object[])new Object[0]);
                        }
                        throw new AsyncException("Throwable caught from aio dll: aio_cancel2: " + t.getMessage());
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("cancel2: " + rc));
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long dispose(long channelIdentifier) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"dispose", (Object[])new Object[]{channelIdentifier});
        }
        long rc = 0L;
        Object object = oneAtATime;
        synchronized (object) {
            block12: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"have lock", (Object[])new Object[0]);
                }
                if (aioInitialized == 1) {
                    try {
                        rc = AsyncLibrary.aio_dispose(channelIdentifier);
                    }
                    catch (AsyncException ae) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Error disposing channel: " + channelIdentifier + ", error: " + ae.getMessage()), (Object[])new Object[0]);
                        }
                    }
                    catch (Throwable t) {
                        if (aioInitialized == 2) break block12;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("caught throwable:" + t), (Object[])new Object[0]);
                        }
                        throw new RuntimeException("Throwable caught from aio dll: aio_dispose: " + t.getMessage());
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"dispose");
        }
        return rc;
    }

    @Override
    public boolean getCompletionData2(long bufferAddress, int timeout, long completionPort) throws AsyncException {
        boolean gotData = false;
        if (aioInitialized == 1) {
            gotData = AsyncLibrary.aio_getioev2(bufferAddress, timeout, completionPort);
            if (aioInitialized == 2) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getCompletionData2: Shutdown after callout", (Object[])new Object[0]);
                }
                gotData = false;
            }
        }
        return gotData;
    }

    @Override
    public int getCompletionData3(long[] iocbs, int size, int timeout, long completionPort) throws AsyncException {
        int gotData = 0;
        if (aioInitialized == 1) {
            gotData = AsyncLibrary.aio_getioev3(iocbs, size, timeout, completionPort);
            if (aioInitialized == 2) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Shutdown after callout", (Object[])new Object[0]);
                }
                gotData = 0;
            }
        }
        return gotData;
    }

    @Override
    public long prepare2(long fd, long completionPort) throws AsyncException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("prepare2: fd = " + fd + " port = " + completionPort), (Object[])new Object[0]);
        }
        return AsyncLibrary.aio_prepare2(fd, completionPort);
    }

    @Override
    public synchronized long getNewCompletionPort() throws AsyncException {
        long port = AsyncLibrary.aio_newCompletionPort();
        completionPorts.add(port);
        return port;
    }

    @Override
    public synchronized boolean isCompletionPortValid(long completionPort) {
        for (Long port : completionPorts) {
            if (port != completionPort) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void closeCompletionPort(long completionPort) {
        int listSize = completionPorts.size();
        for (int i = 0; i < listSize; ++i) {
            block3: {
                if (completionPorts.get(i) != completionPort) continue;
                try {
                    AsyncLibrary.aio_closeport2(completionPort);
                }
                catch (AsyncException ae) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)("Error closing completion port: " + completionPort + ", error:" + ae.getMessage()), (Object[])new Object[0]);
                }
            }
            completionPorts.remove(i);
            break;
        }
    }

    private static void closeAllCompletionPorts() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"closeAllCompletionPorts", (Object[])new Object[0]);
        }
        block4: while (true) {
            try {
                while (!completionPorts.isEmpty()) {
                    Long completionPort = completionPorts.removeFirst();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Closing completion port: " + completionPort), (Object[])new Object[0]);
                    }
                    try {
                        AsyncLibrary.aio_closeport2(completionPort);
                        continue block4;
                    }
                    catch (AsyncException ae) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Error closing completion port: " + completionPort + ", error:" + ae.getMessage()), (Object[])new Object[0]);
                    }
                }
                break;
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
                break;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"closeAllCompletionPorts");
        }
    }

    @Override
    public boolean multiIO3(long iobufferAddress, long position, int count, boolean isRead, boolean forceQueue, long bytesRequested, boolean useJITBuffer) throws AsyncException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("multiIO3: pos=" + position + " count=" + count), (Object[])new Object[0]);
        }
        return AsyncLibrary.aio_multiIO3(iobufferAddress, position, count, isRead, forceQueue, bytesRequested, useJITBuffer);
    }

    @Override
    public void initializeIOCB(CompletionKey theKey) throws AsyncException {
        if (this.doNativeIOCBInitAndTerm) {
            AsyncLibrary.aio_initIOCB(theKey.getAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminateIOCB(CompletionKey theKey) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"terminateIOCB", (Object[])new Object[0]);
        }
        if (this.doNativeIOCBInitAndTerm && 1 == aioInitialized) {
            Object object = oneAtATime;
            synchronized (object) {
                block13: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"have lock", (Object[])new Object[0]);
                    }
                    if (aioInitialized == 1) {
                        try {
                            AsyncLibrary.aio_termIOCB(theKey.getAddress());
                        }
                        catch (AsyncException ae) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Error occured while terminating IOCB" + ae.getMessage()), (Object[])new Object[0]);
                            }
                        }
                        catch (Throwable t) {
                            if (aioInitialized == 2) break block13;
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("caught throwable: " + t), (Object[])new Object[0]);
                            }
                            throw new RuntimeException("Throwable caught from aio dll: aio_termIOCB: " + t.getMessage());
                        }
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"terminateIOCB");
        }
    }

    public static IOException getIOException(String desc, int code) {
        return new IOException(desc + ErrorMessageCache.get(code));
    }

    class PrivLoadLibrary
    implements PrivilegedAction<AsyncException> {
        @Override
        public AsyncException run() {
            try {
                String os = System.getProperty("os.name").toLowerCase();
                if (os.contains("sunos") || os.contains("solaris") || os.contains("hp-ux") || os.startsWith("aix") || os.startsWith("z/os") || os.indexOf("os/390") > -1 || os.indexOf("linux") != -1) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("on " + os + ", won't be calling Init/TermIOCB"), (Object[])new Object[0]);
                    }
                    AsyncLibrary.this.doNativeIOCBInitAndTerm = false;
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("on " + os + ", will be calling Init/TermIOCB"), (Object[])new Object[0]);
                    }
                    AsyncLibrary.this.doNativeIOCBInitAndTerm = true;
                }
                if (os.equals("os/400")) {
                    System.load(LIBRARY_NAME);
                } else {
                    ChannelFrameworkImpl chfw = ChannelFrameworkImpl.getRef();
                    IAsyncProvider.AsyncIOHelper asyncIOHelper = chfw.getAsyncIOHelper();
                    if (asyncIOHelper != null) {
                        asyncIOHelper.loadLibrary(AsyncLibrary.class, LIBRARY_NAME);
                    } else {
                        System.loadLibrary(LIBRARY_NAME);
                    }
                }
            }
            catch (Throwable t) {
                return new AsyncException("could not load native AIO support library. Exception " + t.getMessage());
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("loaded native AIO library: " + LIBRARY_NAME), (Object[])new Object[0]);
            }
            return null;
        }
    }

    public class CompletionKeyPoolDestroy
    implements ObjectDestroyer {
        @Override
        public void destroy(Object obj) {
            ((CompletionKey)obj).destroy();
        }
    }

    static class ErrorMessageCache {
        ErrorMessageCache next;
        int errorCode;
        String message;
        static final AtomicReference<ErrorMessageCache> cache = new AtomicReference();

        ErrorMessageCache(int code, String msg) {
            this.errorCode = code;
            this.message = msg;
        }

        protected static String get(int errorCode) {
            ErrorMessageCache head;
            ErrorMessageCache entry = head = cache.get();
            while (entry != null && entry.errorCode != errorCode) {
                entry = entry.next;
            }
            if (entry == null) {
                ErrorMessageCache head2;
                byte[] msg = new byte[255];
                int len = 0;
                String sRet = null;
                try {
                    len = AsyncLibrary.aio_getErrorString(errorCode, msg);
                }
                catch (AsyncException ae) {
                    sRet = "Unspecified error, error code: " + errorCode;
                }
                if (len != 0) {
                    sRet = new String(msg, 0, len);
                }
                String message = sRet != null ? "RC: " + errorCode + "  " + sRet : "Error Return Code: " + errorCode;
                entry = new ErrorMessageCache(errorCode, message);
                do {
                    entry.next = head2 = cache.get();
                } while (!cache.weakCompareAndSet(head2, entry));
            }
            return entry.message;
        }
    }
}

