/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.oidcclientcore.discovery;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.http.HttpUtils;
import com.ibm.ws.security.common.structures.SingleTableCache;
import io.openliberty.security.oidcclientcore.exceptions.OidcDiscoveryException;
import javax.net.ssl.SSLSocketFactory;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class DiscoveryHandler {
    public static final TraceComponent tc = Tr.register(DiscoveryHandler.class, (String)"OpenIdConnect", (String)"io.openliberty.security.oidcclientcore.internal.resources.OidcClientCoreMessages");
    private static SingleTableCache cachedDiscoveryMetadata = new SingleTableCache(300000L);
    private final SSLSocketFactory sslSocketFactory;
    protected HttpUtils httpUtils;
    static final long serialVersionUID = 4153252000267191638L;

    public DiscoveryHandler(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
        this.httpUtils = this.getHttpUtils();
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject fetchDiscoveryDataJson(String discoveryUri, String clientId) throws OidcDiscoveryException {
        JSONObject discoveryData = (JSONObject)cachedDiscoveryMetadata.get((Object)discoveryUri);
        if (discoveryData != null) {
            return discoveryData;
        }
        try {
            String jsonString = this.fetchDiscoveryDataString(discoveryUri, true, false);
            discoveryData = JSONObject.parse((String)jsonString);
        }
        catch (Exception jsonString) {
            void e;
            FFDCFilter.processException((Throwable)jsonString, (String)"io.openliberty.security.oidcclientcore.discovery.DiscoveryHandler", (String)"49", (Object)this, (Object[])new Object[]{discoveryUri, clientId});
            throw new OidcDiscoveryException(clientId, discoveryUri, e.toString());
        }
        cachedDiscoveryMetadata.put((Object)discoveryUri, (Object)discoveryData);
        return discoveryData;
    }

    public String fetchDiscoveryDataString(String discoveryUrl, boolean hostNameVerificationEnabled, boolean useSystemProperties) throws Exception {
        return this.httpUtils.getHttpJsonRequest(this.sslSocketFactory, discoveryUrl, hostNameVerificationEnabled, useSystemProperties);
    }

    protected HttpUtils getHttpUtils() {
        return new HttpUtils();
    }
}

