/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.matchspace.Selector;
import com.ibm.ws.sib.processor.matching.MessageProcessorMatching;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;

public class DestinationNamePattern {
    private static final TraceComponent tc = SibTr.register(DestinationNamePattern.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private String destinationNamePatternString;
    private Selector parsedPattern;
    private String wildcardStem = null;
    private boolean patternIsWildcarded = false;
    private MessageProcessorMatching mpm;

    protected DestinationNamePattern(String destinationNamePatternString, MessageProcessorMatching messageProcessorMatching) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"DestinationNamePattern", (Object)new Object[]{destinationNamePatternString, messageProcessorMatching});
        }
        this.destinationNamePatternString = destinationNamePatternString = destinationNamePatternString.trim();
        this.mpm = messageProcessorMatching;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"DestinationNamePattern", (Object)this);
        }
    }

    public void prepare() throws SIDiscriminatorSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"prepare");
        }
        this.patternIsWildcarded = this.mpm.isWildCarded(this.destinationNamePatternString);
        if (this.patternIsWildcarded) {
            this.wildcardStem = this.mpm.retrieveNonWildcardStem(this.destinationNamePatternString);
            this.parsedPattern = this.mpm.parseDiscriminator(this.destinationNamePatternString);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"prepare");
        }
    }

    public boolean match(String destinationName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"match", (Object)destinationName);
        }
        boolean matches = false;
        if (!this.patternIsWildcarded) {
            matches = destinationName.equals(this.destinationNamePatternString);
        } else if (destinationName.startsWith(this.wildcardStem)) {
            try {
                matches = this.mpm.evaluateDiscriminator(destinationName, this.destinationNamePatternString, this.parsedPattern);
            }
            catch (SIDiscriminatorSyntaxException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationNamePattern.match", (String)"1:141:1.2", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"match", (Object)"SIErrorException");
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.DestinationNamePattern", "1:152:1.2", e});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.DestinationNamePattern", "1:160:1.2", e}, null), (Throwable)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"match", (Object)matches);
        }
        return matches;
    }
}

