/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.cdi.CDIException;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedApplicationInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedModuleInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import jakarta.enterprise.inject.spi.AnnotatedType;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CDIServiceUtils {
    static final long serialVersionUID = -5565380728192620605L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static ApplicationMetaData getApplicationMetaData(Container moduleContainer) throws CDIException {
        ApplicationMetaData appMetaData = null;
        ModuleInfo moduleInfo = CDIServiceUtils.getModuleInfo(moduleContainer);
        if (moduleInfo != null) {
            ExtendedApplicationInfo applicationInfo = (ExtendedApplicationInfo)moduleInfo.getApplicationInfo();
            appMetaData = applicationInfo.getMetaData();
        }
        return appMetaData;
    }

    public static ModuleMetaData getModuleMetaData(Container moduleContainer) throws CDIException {
        ModuleMetaData moduleMetaData = null;
        ExtendedModuleInfo moduleInfo = (ExtendedModuleInfo)CDIServiceUtils.getModuleInfo(moduleContainer);
        if (moduleInfo != null) {
            moduleMetaData = moduleInfo.getMetaData();
        }
        return moduleMetaData;
    }

    /*
     * WARNING - void declaration
     */
    private static ModuleInfo getModuleInfo(Container container) throws CDIException {
        ModuleInfo moduleInfo = null;
        try {
            NonPersistentCache cache = (NonPersistentCache)container.adapt(NonPersistentCache.class);
            moduleInfo = (ModuleInfo)cache.getFromCache(ModuleInfo.class);
        }
        catch (UnableToAdaptException cache) {
            void e;
            FFDCFilter.processException((Throwable)cache, (String)"com.ibm.ws.cdi.CDIServiceUtils", (String)"61", null, (Object[])new Object[]{container});
            throw new CDIException((Throwable)e);
        }
        return moduleInfo;
    }

    public static String getAnnotatedTypeIdentifier(AnnotatedType annotatedType, Class<?> extensionClass) {
        Bundle bundle = FrameworkUtil.getBundle(extensionClass);
        String symbolicName = CDIServiceUtils.getSymbolicNameWithoutMinorOrMicroVersionPart(bundle.getSymbolicName());
        if (annotatedType != null) {
            return annotatedType.getJavaClass().getCanonicalName() + "#" + extensionClass.getCanonicalName() + "#" + symbolicName;
        }
        return "NULL#" + extensionClass.getCanonicalName() + "#" + symbolicName;
    }

    @Trivial
    public static String getOSGIVersionForBndName(Version version) {
        return String.valueOf(version.getMajor());
    }

    @Trivial
    public static String getSymbolicNameWithoutMinorOrMicroVersionPart(String symbolicName) {
        if (symbolicName.matches(".*\\d+\\.\\d+\\.\\d+$")) {
            return symbolicName.replaceAll("\\.\\d+\\.\\d+$", "");
        }
        return symbolicName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.cdi.CDIServiceUtils", CDIServiceUtils.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
    }
}

