/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.oidcclientcore.userinfo;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.security.oidcclientcore.client.OidcClientConfig;
import io.openliberty.security.oidcclientcore.config.MetadataUtils;
import io.openliberty.security.oidcclientcore.exceptions.OidcClientConfigurationException;
import io.openliberty.security.oidcclientcore.exceptions.OidcDiscoveryException;
import io.openliberty.security.oidcclientcore.exceptions.UserInfoResponseException;
import io.openliberty.security.oidcclientcore.userinfo.UserInfoRequestor;
import io.openliberty.security.oidcclientcore.userinfo.UserInfoResponse;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class UserInfoHandler {
    public static final TraceComponent tc = Tr.register(UserInfoHandler.class, (String)"OpenIdConnect", (String)"io.openliberty.security.oidcclientcore.internal.resources.OidcClientCoreMessages");
    static final long serialVersionUID = -3804454395035927549L;

    public Map<String, Object> getUserInfoClaims(OidcClientConfig oidcClientConfig, String accessToken) throws UserInfoResponseException, OidcDiscoveryException, OidcClientConfigurationException {
        String userInfoEndpoint = MetadataUtils.getUserInfoEndpoint(oidcClientConfig);
        UserInfoRequestor userInfoRequester = this.createUserInfoRequestor(userInfoEndpoint, oidcClientConfig, accessToken);
        UserInfoResponse userInfoResponse = userInfoRequester.requestUserInfo();
        if (userInfoResponse != null) {
            return userInfoResponse.asMap();
        }
        return null;
    }

    UserInfoRequestor createUserInfoRequestor(String userInfoEndpoint, OidcClientConfig oidcClientConfig, String accessToken) throws OidcDiscoveryException {
        UserInfoRequestor.Builder builder = new UserInfoRequestor.Builder(oidcClientConfig, userInfoEndpoint, accessToken);
        return builder.build();
    }
}

