/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.client.rest.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.ws.jmx.connector.client.rest.internal.ClientConstants;
import com.ibm.ws.jmx.connector.client.rest.internal.RESTMBeanServerConnection;
import com.ibm.ws.jmx.connector.client.rest.internal.resources.FileTransferClientMessagesUtil;
import com.ibm.ws.jmx.connector.converter.JSONConverter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;

class FileTransferClient {
    private static final Logger logger = Logger.getLogger(FileTransferClient.class.getName());
    private static final String OPERATION_DOWNLOAD = "downloadFile";
    private static final String OPERATION_UPLOAD = "uploadFile";
    private static final String OPERATION_DELETE = "deleteFile";
    private static final String OPERATION_DELETE_ALL = "deleteAll";
    private static final String QUERY_PARAM_UPLOAD_EXPAND = "expandOnCompletion";
    private static final String QUERY_PARAM_START_OFFSET = "startOffset";
    private static final String QUERY_PARAM_END_OFFSET = "endOffset";
    private static final String FILE_TRANSFER_URL_V2 = "/fileTransfer";
    private static final String FILE_TRANSFER_ROUTER_URL_V2 = "/fileTransfer/router";
    private static final String COLLECTION_URL = "/collection";
    private static final String COLLECTION_OPERATION_DELETE = "delete";
    private static final String FILE_TRANSFER_CONTENT_TYPE = "application/gzip";
    private static final String FILE_TRANSFER_ZIP_MIME = "application/zip";
    private static final String FILE_TRANSFER_PAX_MIME = "application/pax";
    private static final String FILE_TRANSFER_JSON_MIME = "application/json";
    private static final int FILE_TRANSFER_DEFAULT_BUFFER_SIZE = 8192;
    private static final String RANDOM_FILE_ACCESS_READ_MODE = "r";
    private static final String RANDOM_FILE_ACCESS_READ_WRITE_MODE = "rw";
    private final RESTMBeanServerConnection restConnection;

    public FileTransferClient(RESTMBeanServerConnection restConnection) throws IOException {
        this.restConnection = restConnection;
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, logger.getName(), "constructor", FileTransferClientMessagesUtil.getMessage("filetransfer.client.init", restConnection.connector.getConnectionId()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object handleOperation(String operation, Object[] params) throws IOException {
        if (OPERATION_DOWNLOAD.equals(operation)) {
            if (params.length != 2) return this.downloadFile((String)params[0], (String)params[1], (Long)params[2], (Long)params[3]);
            this.downloadFile((String)params[0], (String)params[1]);
            return null;
        } else if (OPERATION_UPLOAD.equals(operation)) {
            this.uploadFile((String)params[0], (String)params[1], (Boolean)params[2]);
            return null;
        } else if (OPERATION_DELETE.equals(operation)) {
            this.deleteFile((String)params[0]);
            return null;
        } else {
            if (!OPERATION_DELETE_ALL.equals(operation)) throw this.logUnsupportedOperationError("handleOperation", operation);
            this.deleteAll((List)params[0]);
        }
        return null;
    }

    HttpsURLConnection getFileTransferConnection(URL url, ClientConstants.HttpMethod method) throws IOException {
        return this.getFileTransferConnection(url, method, true);
    }

    HttpsURLConnection getFileTransferConnection(URL url, ClientConstants.HttpMethod method, boolean setEncoding) throws IOException {
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.setDoInput(true);
        if (method == ClientConstants.HttpMethod.POST) {
            if (this.restConnection.serverVersion == 2) {
                connection.setRequestProperty("Content-Type", FILE_TRANSFER_CONTENT_TYPE);
            }
            connection.setDoOutput(true);
        } else {
            connection.setDoOutput(false);
        }
        connection.setUseCaches(false);
        connection.setRequestMethod(method.toString());
        connection.setReadTimeout(this.restConnection.connector.getReadTimeout());
        if (this.restConnection.connector.getBasicAuthHeader() != null) {
            connection.setRequestProperty("Authorization", this.restConnection.connector.getBasicAuthHeader());
        }
        if (this.restConnection.connector.isHostnameVerificationDisabled()) {
            connection.setHostnameVerifier(this.restConnection.hostnameVerificationDisabler);
        }
        connection.setRequestProperty("User-Agent", "IBM_JMX_REST_client_v5");
        if (this.restConnection.isHostLevelRouting()) {
            connection.addRequestProperty("com.ibm.websphere.jmx.connector.rest.routing.hostName", (String)this.restConnection.mapRouting.get("com.ibm.websphere.jmx.connector.rest.routing.hostName"));
        } else if (this.restConnection.isServerLevelRouting()) {
            connection.addRequestProperty("com.ibm.websphere.jmx.connector.rest.routing.hostName", (String)this.restConnection.mapRouting.get("com.ibm.websphere.jmx.connector.rest.routing.hostName"));
            connection.addRequestProperty("com.ibm.websphere.jmx.connector.rest.routing.serverUserDir", (String)this.restConnection.mapRouting.get("com.ibm.websphere.jmx.connector.rest.routing.serverUserDir"));
            connection.addRequestProperty("com.ibm.websphere.jmx.connector.rest.routing.serverName", (String)this.restConnection.mapRouting.get("com.ibm.websphere.jmx.connector.rest.routing.serverName"));
        }
        if (this.restConnection.getConnector().getCustomSSLSocketFactory() != null) {
            connection.setSSLSocketFactory(this.restConnection.getConnector().getCustomSSLSocketFactory());
        }
        if (this.restConnection.serverVersion > 2 && setEncoding) {
            if (method == ClientConstants.HttpMethod.POST) {
                connection.addRequestProperty("Content-Encoding", "gzip");
            } else {
                connection.addRequestProperty("Accept-Encoding", "gzip");
            }
        }
        return connection;
    }

    private String getEncodedFilePath(String path) throws IOException {
        return "/" + URLEncoder.encode(path, "UTF-8");
    }

    private String getFileTransferURL() throws IOException {
        if (this.restConnection.serverVersion == 2) {
            return this.restConnection.getRootURL() + FILE_TRANSFER_URL_V2;
        }
        return this.restConnection.getFileTransferURL().toString();
    }

    private String getFileTransferRoutingURL() throws IOException {
        if (this.restConnection.serverVersion == 2) {
            return this.restConnection.getRootURL() + FILE_TRANSFER_ROUTER_URL_V2;
        }
        return this.restConnection.getFileTransferURL().toString();
    }

    private URL getURL(Map<String, String> queryParameters, String additionalURL) throws IOException {
        String coreURLStr = this.restConnection.isServerLevelRouting() || this.restConnection.isHostLevelRouting() ? this.getFileTransferRoutingURL() + additionalURL : this.getFileTransferURL() + additionalURL;
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "getURL", "coreURLStr: " + coreURLStr);
        }
        try {
            if (queryParameters != null && !queryParameters.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                Set<Map.Entry<String, String>> params = queryParameters.entrySet();
                for (Map.Entry<String, String> param : params) {
                    if (sb.length() == 0) {
                        sb.append('?');
                    } else {
                        sb.append('&');
                    }
                    sb.append(param.getKey());
                    sb.append('=');
                    sb.append(URLEncoder.encode(param.getValue(), "UTF-8"));
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, logger.getName(), "getURL", "queryURL: " + sb.toString());
                }
                return new URL(coreURLStr + sb.toString());
            }
            return new URL(coreURLStr);
        }
        catch (Exception e) {
            throw this.logClientException("getURL", e);
        }
    }

    public void downloadFile(String remoteSourceFile, String localTargetFile) throws IOException {
        this.downloadFile(remoteSourceFile, localTargetFile, 0L, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long downloadFile(String remoteSourceFile, String localTargetFile, long startOffset, long endOffset) throws IOException {
        String methodName = "downloadFile(String remoteSourceFile, String localTargetFile, long startOffset, long endOffset)";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "downloadFile(String remoteSourceFile, String localTargetFile, long startOffset, long endOffset)", "Entering downloadFile with remoteSourceFile: " + remoteSourceFile + " ; localTargetFile: " + localTargetFile + " ; startOffset: " + startOffset + " and endOffset: " + endOffset);
        }
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (startOffset > 0L) {
            queryParams.put(QUERY_PARAM_START_OFFSET, String.valueOf(startOffset));
        }
        if (endOffset > -1L) {
            queryParams.put(QUERY_PARAM_END_OFFSET, String.valueOf(endOffset));
        }
        URL url = this.getURL(queryParams, this.getEncodedFilePath(remoteSourceFile));
        HttpsURLConnection connection = this.getFileTransferConnection(url, ClientConstants.HttpMethod.GET);
        int responseCode = connection.getResponseCode();
        InputStream is = null;
        switch (responseCode) {
            case 200: {
                is = connection.getInputStream();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, logger.getName(), "downloadFile(String remoteSourceFile, String localTargetFile, long startOffset, long endOffset)", "Received stream: " + FileTransferClientMessagesUtil.getObjID(is));
                }
                is = new GZIPInputStream(is, 8192);
                break;
            }
            case 400: 
            case 500: {
                throw this.logServerException("downloadFile(String remoteSourceFile, String localTargetFile, long startOffset, long endOffset)", connection);
            }
            case 401: 
            case 403: {
                throw this.logCredentialsException("downloadFile(String remoteSourceFile, String localTargetFile, long startOffset, long endOffset)", responseCode, connection);
            }
            case 404: 
            case 410: {
                IOException ioe = this.logResponseCodeException("downloadFile(String remoteSourceFile, String localTargetFile, long startOffset, long endOffset)", responseCode, connection);
                this.restConnection.recoverConnection(ioe);
                throw ioe;
            }
            default: {
                throw this.logResponseCodeException("downloadFile(String remoteSourceFile, String localTargetFile, long startOffset, long endOffset)", responseCode, connection);
            }
        }
        RandomAccessFile destFile = new RandomAccessFile(localTargetFile, RANDOM_FILE_ACCESS_READ_WRITE_MODE);
        long totalBytesRead = 0L;
        try {
            int bytesRead;
            byte[] buf = new byte[8192];
            while ((bytesRead = is.read(buf)) > 0) {
                destFile.write(buf, 0, bytesRead);
                totalBytesRead += (long)bytesRead;
            }
            destFile.setLength(totalBytesRead);
        }
        finally {
            FileTransferClient.tryToClose(is);
            FileTransferClient.tryToClose(destFile);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, logger.getName(), "downloadFile(String remoteSourceFile, String localTargetFile, long startOffset, long endOffset)", FileTransferClientMessagesUtil.getMessage("filetransfer.download.file", remoteSourceFile, localTargetFile, this.restConnection.connector.getConnectionId()));
        }
        if (startOffset < 0L) {
            startOffset = 0L;
        }
        long nextStartOffset = startOffset + totalBytesRead;
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "downloadFile(String remoteSourceFile, String localTargetFile, long startOffset, long endOffset)", "Exiting downloadFile with nextStartOffset=" + nextStartOffset);
        }
        return nextStartOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadFile(String localSourceFile, String remoteTargetFile, boolean expandOnCompletion) throws IOException {
        String methodName = "uploadFile(String localSourceFile, String remoteTargetFile, boolean expandOnCompletion)";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "uploadFile(String localSourceFile, String remoteTargetFile, boolean expandOnCompletion)", "Entering uploadFile with localSourceFile: " + localSourceFile + " and remoteTargetFile: " + remoteTargetFile);
        }
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put(QUERY_PARAM_UPLOAD_EXPAND, String.valueOf(expandOnCompletion));
        URL url = this.getURL(queryParams, this.getEncodedFilePath(remoteTargetFile));
        HttpsURLConnection connection = this.getFileTransferConnection(url, ClientConstants.HttpMethod.POST);
        if (expandOnCompletion && this.restConnection.serverVersion >= 5) {
            if (localSourceFile.endsWith(".pax")) {
                connection.setRequestProperty("Content-Type", FILE_TRANSFER_PAX_MIME);
            } else {
                connection.setRequestProperty("Content-Type", FILE_TRANSFER_ZIP_MIME);
            }
        }
        RandomAccessFile uploadFile = new RandomAccessFile(localSourceFile, RANDOM_FILE_ACCESS_READ_MODE);
        OutputStream outStream = null;
        try {
            outStream = connection.getOutputStream();
        }
        catch (ConnectException ce) {
            this.restConnection.recoverConnection(ce);
            FileTransferClient.tryToClose(outStream);
            FileTransferClient.tryToClose(uploadFile);
            throw ce;
        }
        outStream = new GZIPOutputStream(outStream, 8192);
        try {
            int bytesRead;
            byte[] buf = new byte[8192];
            while ((bytesRead = uploadFile.read(buf)) > 0) {
                outStream.write(buf, 0, bytesRead);
            }
            outStream.flush();
        }
        finally {
            FileTransferClient.tryToClose(outStream);
            FileTransferClient.tryToClose(uploadFile);
        }
        int responseCode = connection.getResponseCode();
        switch (responseCode) {
            case 204: {
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, logger.getName(), "uploadFile(String localSourceFile, String remoteTargetFile, boolean expandOnCompletion)", FileTransferClientMessagesUtil.getMessage("filetransfer.upload.file", localSourceFile, remoteTargetFile, this.restConnection.connector.getConnectionId()));
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, logger.getName(), "uploadFile(String localSourceFile, String remoteTargetFile, boolean expandOnCompletion)", "Exiting uploadFile");
                }
                return;
            }
            case 400: 
            case 500: {
                throw this.logServerException("uploadFile(String localSourceFile, String remoteTargetFile, boolean expandOnCompletion)", connection);
            }
            case 401: 
            case 403: {
                throw this.logCredentialsException("uploadFile(String localSourceFile, String remoteTargetFile, boolean expandOnCompletion)", responseCode, connection);
            }
            case 404: 
            case 410: {
                IOException ioe = this.logResponseCodeException("uploadFile(String localSourceFile, String remoteTargetFile, boolean expandOnCompletion)", responseCode, connection);
                this.restConnection.recoverConnection(ioe);
                throw ioe;
            }
        }
        throw this.logResponseCodeException("uploadFile(String localSourceFile, String remoteTargetFile, boolean expandOnCompletion)", responseCode, connection);
    }

    public void deleteFile(String remoteSourceFile) throws IOException {
        String methodName = "deleteFile(String remoteSourceFile)";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "deleteFile(String remoteSourceFile)", "Entering deleteFile with remoteSourceFile: " + remoteSourceFile);
        }
        URL url = this.getURL(null, this.getEncodedFilePath(remoteSourceFile));
        HttpsURLConnection connection = this.getFileTransferConnection(url, ClientConstants.HttpMethod.DELETE);
        int responseCode = connection.getResponseCode();
        switch (responseCode) {
            case 204: {
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, logger.getName(), "deleteFile(String remoteSourceFile)", FileTransferClientMessagesUtil.getMessage("filetransfer.delete.file", remoteSourceFile, this.restConnection.connector.getConnectionId()));
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, logger.getName(), "deleteFile(String remoteSourceFile)", "Exiting deleteFile");
                }
                return;
            }
            case 400: 
            case 500: {
                throw this.logServerException("deleteFile(String remoteSourceFile)", connection);
            }
            case 401: 
            case 403: {
                throw this.logCredentialsException("deleteFile(String remoteSourceFile)", responseCode, connection);
            }
            case 404: 
            case 410: {
                IOException ioe = this.logResponseCodeException("deleteFile(String remoteSourceFile)", responseCode, connection);
                this.restConnection.recoverConnection(ioe);
                throw ioe;
            }
        }
        throw this.logResponseCodeException("deleteFile(String remoteSourceFile)", responseCode, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll(List<String> remoteArtifacts) throws IOException {
        String methodName = "deleteAll(List<String> remoteArtifacts)";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "deleteAll(List<String> remoteArtifacts)", "Entering deleteAll with remoteArtifacts: " + remoteArtifacts);
        }
        URL url = this.getURL(null, COLLECTION_URL);
        HttpsURLConnection connection = this.getFileTransferConnection(url, ClientConstants.HttpMethod.POST, false);
        connection.setRequestProperty("Content-Type", FILE_TRANSFER_JSON_MIME);
        OutputStream outStream = null;
        try {
            outStream = connection.getOutputStream();
        }
        catch (ConnectException ce) {
            this.restConnection.recoverConnection(ce);
            FileTransferClient.tryToClose(outStream);
            throw ce;
        }
        try {
            JSONArray artifactsArray = new JSONArray();
            for (String artifact : remoteArtifacts) {
                artifactsArray.add(artifact);
            }
            JSONObject contentObject = new JSONObject();
            contentObject.put(COLLECTION_OPERATION_DELETE, artifactsArray);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "deleteAll(List<String> remoteArtifacts)", "Generated JSON: " + contentObject.toString());
            }
            outStream.write(contentObject.toString().getBytes(StandardCharsets.UTF_8));
            outStream.flush();
        }
        finally {
            FileTransferClient.tryToClose(outStream);
        }
        int responseCode = connection.getResponseCode();
        switch (responseCode) {
            case 204: {
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, logger.getName(), "deleteAll(List<String> remoteArtifacts)", FileTransferClientMessagesUtil.getMessage("filetransfer.delete.all", remoteArtifacts, this.restConnection.connector.getConnectionId()));
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, logger.getName(), "deleteAll(List<String> remoteArtifacts)", "Exiting deleteAll");
                }
                return;
            }
            case 400: 
            case 500: {
                throw this.logServerException("deleteAll(List<String> remoteArtifacts)", connection);
            }
            case 401: 
            case 403: {
                throw this.logCredentialsException("deleteAll(List<String> remoteArtifacts)", responseCode, connection);
            }
            case 404: 
            case 410: {
                IOException ioe = this.logResponseCodeException("deleteAll(List<String> remoteArtifacts)", responseCode, connection);
                this.restConnection.recoverConnection(ioe);
                throw ioe;
            }
        }
        throw this.logResponseCodeException("deleteAll(List<String> remoteArtifacts)", responseCode, connection);
    }

    public static boolean tryToClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    private IOException logClientException(String methodName, Exception e) {
        String errorMsg = FileTransferClientMessagesUtil.getMessage("filetransfer.client.error", e.getLocalizedMessage(), this.restConnection.connector.getConnectionId());
        logger.logp(Level.SEVERE, logger.getName(), methodName, errorMsg, e);
        return new IOException(errorMsg, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IOException logServerException(String methodName, HttpURLConnection connection) {
        Throwable t = null;
        JSONConverter converter = JSONConverter.getConverter();
        try {
            t = converter.readThrowable(connection.getErrorStream());
            logger.logp(Level.SEVERE, logger.getName(), methodName, t.getMessage());
        }
        catch (Exception e) {
            String responseMessage = "error";
            try {
                responseMessage = connection.getResponseMessage();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String errorMsg = FileTransferClientMessagesUtil.getMessage("filetransfer.server.error", responseMessage, this.restConnection.connector.getConnectionId());
            t = new IOException(errorMsg);
            logger.logp(Level.SEVERE, logger.getName(), methodName, errorMsg);
        }
        finally {
            JSONConverter.returnConverter(converter);
        }
        return t instanceof IOException ? (IOException)t : new IOException(t);
    }

    private IOException logCredentialsException(String methodName, int responseCode, HttpURLConnection connection) {
        String responseMessage = null;
        try {
            responseMessage = connection.getResponseMessage();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String errorMsg = FileTransferClientMessagesUtil.getMessage("filetransfer.client.bad.credentials", responseCode, responseMessage, this.restConnection.connector.getConnectionId());
        logger.logp(Level.SEVERE, logger.getName(), methodName, errorMsg);
        return new IOException(errorMsg);
    }

    private IOException logResponseCodeException(String methodName, int responseCode, HttpURLConnection connection) {
        String responseMessage = null;
        try {
            responseMessage = connection.getResponseMessage();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String errorMsg = FileTransferClientMessagesUtil.getMessage("filetransfer.response.code.error", responseCode, responseMessage, this.restConnection.connector.getConnectionId());
        logger.logp(Level.SEVERE, logger.getName(), methodName, errorMsg);
        return new IOException(errorMsg);
    }

    private IOException logUnsupportedOperationError(String methodName, String operation) {
        String errorMsg = FileTransferClientMessagesUtil.getMessage("filetransfer.unsupported.operation", operation, this.restConnection.connector.getConnectionId());
        logger.logp(Level.SEVERE, logger.getName(), methodName, errorMsg);
        return new IOException(errorMsg);
    }
}

