/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.h2internal.FrameTypes;
import com.ibm.ws.http.channel.h2internal.frames.Frame;
import java.util.concurrent.TimeUnit;

public class H2RateState {
    private static final TraceComponent tc = Tr.register(H2RateState.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private static final int maxReadControlFrameCount = 10000;
    private static final int maxResetFrameCount = 5000;
    private static final int maxEmptyFrameCount = 500;
    private static int maxResetFrames = 100;
    private static int resetFrameWindow = 30000;
    private static int maxStreamsRefused = 100;
    private volatile long controlFrameCount = 0L;
    private volatile int emptyFrameReceivedCount = 0;
    private volatile int resetFrameCount = 0;
    private volatile int refusedStreamCount = 0;
    private volatile long startResetTime = System.nanoTime();

    public H2RateState(int maxResetFrames, int resetFrameWindow, int maxStreamsRefused) {
        H2RateState.maxResetFrames = maxResetFrames;
        H2RateState.resetFrameWindow = resetFrameWindow;
        H2RateState.maxStreamsRefused = maxStreamsRefused;
    }

    public synchronized void incrementReadControlFrameCount() {
        ++this.controlFrameCount;
    }

    public synchronized void incrementReadNonControlFrameCount() {
        this.controlFrameCount /= 2L;
    }

    public synchronized void incrementEmptyFrameReceivedCount() {
        ++this.emptyFrameReceivedCount;
    }

    public synchronized void incrementRefusedStreamCount() {
        ++this.refusedStreamCount;
    }

    public synchronized int getRefusedStreamCount() {
        return this.refusedStreamCount;
    }

    public synchronized int getMaxStreamsRefused() {
        return maxStreamsRefused;
    }

    public synchronized boolean tooManyStreamsRefused() {
        if (maxStreamsRefused > 0 && this.refusedStreamCount > maxStreamsRefused) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("streams refused: " + this.refusedStreamCount + " is greater than max: " + maxStreamsRefused), (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    public synchronized boolean isControlRatioExceeded() {
        return this.controlFrameCount > 10000L || this.resetFrameCount > 5000;
    }

    public synchronized boolean isResetsInTimeExceeded() {
        if (maxResetFrames > 0) {
            if (resetFrameWindow > 0) {
                long curResetTime = System.nanoTime();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("setting curResetTime: " + curResetTime), (Object[])new Object[0]);
                }
                if (curResetTime - this.startResetTime < TimeUnit.MILLISECONDS.toNanos(resetFrameWindow)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("number of resets in time is " + this.resetFrameCount), (Object[])new Object[0]);
                    }
                    if (this.resetFrameCount >= maxResetFrames) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"too many resets within time", (Object[])new Object[0]);
                        }
                        return true;
                    }
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("restarting reset frame time window " + curResetTime), (Object[])new Object[0]);
                    }
                    this.startResetTime = curResetTime;
                    this.resetFrameCount = 0;
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("number of resets in unlimited time is " + this.resetFrameCount), (Object[])new Object[0]);
                }
                if (this.resetFrameCount >= maxResetFrames) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("reset frames in unlimited window exceeded: " + this.resetFrameCount), (Object[])new Object[0]);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public void updateCounters(Frame frame) {
        if (H2RateState.isControlFrame(frame)) {
            this.incrementReadControlFrameCount();
        } else {
            this.incrementReadNonControlFrameCount();
        }
        if (frame.getFrameType() == FrameTypes.RST_STREAM) {
            this.incrementResetFrameCount();
        }
    }

    public synchronized void incrementResetFrameCount() {
        ++this.resetFrameCount;
    }

    public synchronized boolean isInboundControlRatioExceeded(int totalClientStreams) {
        return this.resetFrameCount > 5000;
    }

    public synchronized boolean isStreamMisbehaving() {
        return this.emptyFrameReceivedCount > 500;
    }

    public static boolean isControlFrame(Frame frame) {
        switch (frame.getFrameType()) {
            case PRIORITY: {
                return true;
            }
            case RST_STREAM: {
                return true;
            }
            case SETTINGS: {
                return true;
            }
            case PING: {
                return true;
            }
            case GOAWAY: {
                return true;
            }
            case WINDOW_UPDATE: {
                return true;
            }
        }
        return false;
    }

    private String getReadableTime(Long nanos) {
        long tempSec = nanos / 1000000000L;
        long sec = tempSec % 60L;
        long min = tempSec / 60L % 60L;
        long hour = tempSec / 3600L % 24L;
        long day = tempSec / 86400L % 24L;
        return String.format("%dd %dh %dm %ds", day, hour, min, sec);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        String newLine = System.getProperty("line.separator");
        result.append(this.getClass().getName());
        result.append(newLine);
        result.append("controlFrameRatio: " + this.controlFrameCount);
        result.append(newLine);
        result.append("refusedStreamCount: " + this.refusedStreamCount);
        result.append(newLine);
        result.append("resetFrameCount: " + this.resetFrameCount);
        result.append(newLine);
        result.append("resetTimePeriod: " + this.getReadableTime(System.nanoTime() - this.startResetTime));
        return result.toString();
    }
}

