/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.objectManager;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.objectManager.ConcurrentLinkedList;
import com.ibm.ws.objectManager.List;
import com.ibm.ws.objectManager.LogFileInUseException;
import com.ibm.ws.objectManager.LogFileSizeTooSmallException;
import com.ibm.ws.objectManager.ManagedObject;
import com.ibm.ws.objectManager.NonExistentLogFileException;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerEventCallback;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectStore;
import com.ibm.ws.objectManager.PermanentIOException;
import com.ibm.ws.objectManager.SingleFileObjectStore;
import com.ibm.ws.objectManager.StoreFileSizeTooSmallException;
import com.ibm.ws.objectManager.Token;
import com.ibm.ws.objectManager.Transaction;
import com.ibm.ws.objectManager.UnknownObjectStoreException;
import com.ibm.ws.sib.msgstore.Configuration;
import com.ibm.ws.sib.msgstore.MessageStoreUnavailableException;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.SeverePersistenceException;
import com.ibm.ws.sib.msgstore.cache.links.RootMembership;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.persistence.BatchingContext;
import com.ibm.ws.sib.msgstore.persistence.BatchingContextFactory;
import com.ibm.ws.sib.msgstore.persistence.MELockOwner;
import com.ibm.ws.sib.msgstore.persistence.Operation;
import com.ibm.ws.sib.msgstore.persistence.Persistable;
import com.ibm.ws.sib.msgstore.persistence.PersistentMessageStore;
import com.ibm.ws.sib.msgstore.persistence.TupleTypeEnum;
import com.ibm.ws.sib.msgstore.persistence.UniqueKeyGenerator;
import com.ibm.ws.sib.msgstore.persistence.dispatcher.SpillDispatcher;
import com.ibm.ws.sib.msgstore.persistence.impl.Tuple;
import com.ibm.ws.sib.msgstore.persistence.objectManager.Anchor;
import com.ibm.ws.sib.msgstore.persistence.objectManager.BatchingContextFactoryImpl;
import com.ibm.ws.sib.msgstore.persistence.objectManager.BatchingContextImpl;
import com.ibm.ws.sib.msgstore.persistence.objectManager.MEStartupTimeouts;
import com.ibm.ws.sib.msgstore.persistence.objectManager.MEStoredOwner;
import com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableImpl;
import com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableMetaData;
import com.ibm.ws.sib.msgstore.persistence.objectManager.UniqueKeyManager;
import com.ibm.ws.sib.msgstore.task.TaskList;
import com.ibm.ws.sib.msgstore.transactions.impl.PersistenceManager;
import com.ibm.ws.sib.msgstore.transactions.impl.PersistentTransaction;
import com.ibm.ws.sib.msgstore.transactions.impl.TransactionState;
import com.ibm.ws.sib.msgstore.transactions.impl.XidManager;
import com.ibm.ws.sib.transactions.PersistentTranId;
import com.ibm.ws.sib.utils.DataSlice;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public final class PersistentMessageStoreImpl
implements PersistentMessageStore,
PersistenceManager,
ObjectManagerEventCallback {
    private static TraceComponent tc = SibTr.register(PersistentMessageStoreImpl.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static long MAXIMUM_STORE_FILE_SIZE = Long.MAX_VALUE;
    private static String PERMANENT_STORE_NAME = "PermanentStore";
    private static String TEMPORARY_STORE_NAME = "TemporaryStore";
    private MELockOwner _meOwner;
    private MessageStoreImpl _ms;
    private Configuration _configuration;
    private MEStartupTimeouts _timeouts;
    private ObjectManager _objectManager;
    private ObjectStore _permanentStore;
    private ObjectStore _temporaryStore;
    private Token _anchorToken;
    private Anchor _anchor;
    private UniqueKeyManager _uniqueKeyManager;
    private SpillDispatcher _spillDispatcher;
    private BatchingContextFactory _batchingContextFactory;
    private volatile boolean _available = false;
    private volatile boolean _starting = false;
    private boolean _shutdownRequested = false;
    private boolean _omgrStarted = false;
    private Map<String, String> storeLocations = new HashMap<String, String>();
    private String oldPermanentStore = null;
    private String oldTemporaryStore = null;
    private String fileSepPattern;

    public PersistentMessageStoreImpl() {
        String string = this.fileSepPattern = File.separatorChar == '/' ? File.separator : "\\" + File.separator;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        this._uniqueKeyManager = new UniqueKeyManager();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    public void initialize(MessageStoreImpl ms, XidManager xidManager, Configuration configuration) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"initialize", (Object)new Object[]{"MS=" + (Object)((Object)ms), "XidManager=" + xidManager, "Config=" + configuration});
        }
        this._ms = ms;
        this._configuration = configuration;
        this._timeouts = new MEStartupTimeouts(this._ms);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"initialize");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws PersistenceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"start");
        }
        String logFileName = null;
        String permanentStoreFileName = null;
        String temporaryStoreFileName = null;
        String logFileProperty = this._ms.getProperty("omLogFileName", "Log");
        String logPrefix = this._ms.getProperty("omLogFilePrefix", this._configuration.getObjectManagerLogDirectory());
        String logSizeStr = this._ms.getProperty("omLogFileSize", null);
        long logSize = this._configuration.getObjectManagerLogSize();
        if (logSizeStr != null) {
            logSize = Long.parseLong(logSizeStr);
        }
        String permanentStoreProperty = this._ms.getProperty("omPermanentStoreFileName", "PermanentStore");
        String permanentStorePrefix = this._ms.getProperty("omPermanentStoreFilePrefix", this._configuration.getObjectManagerPermanentStoreDirectory());
        String temporaryStoreProperty = this._ms.getProperty("omTemporaryStoreFileName", "TemporaryStore");
        String temporaryStorePrefix = this._ms.getProperty("omTemporaryStoreFilePrefix", this._configuration.getObjectManagerTemporaryStoreDirectory());
        this._ms.setRedeliveryCountColumn(true);
        boolean connected = false;
        long retryLimit = System.currentTimeMillis() + this._timeouts.getRetryTimeLimit();
        this._starting = true;
        do {
            logFileName = (logPrefix = this.createDirectoryPath(logPrefix)).endsWith(File.separator) ? logPrefix + logFileProperty : logPrefix + File.separator + logFileProperty;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("User directory for ObjectManager log file defined: " + logPrefix));
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("The file store is attempting to initalise its log file:" + logFileName));
            }
            permanentStorePrefix = this.createDirectoryPath(permanentStorePrefix);
            temporaryStorePrefix = this.createDirectoryPath(temporaryStorePrefix);
            permanentStoreFileName = permanentStorePrefix.endsWith(File.separator) ? permanentStorePrefix + permanentStoreProperty : permanentStorePrefix + File.separator + permanentStoreProperty;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Filename for ObjectManager permanent store is: " + permanentStoreFileName));
            }
            temporaryStoreFileName = temporaryStorePrefix.endsWith(File.separator) ? temporaryStorePrefix + temporaryStoreProperty : temporaryStorePrefix + File.separator + temporaryStoreProperty;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Filename for ObjectManager temporary store is: " + temporaryStoreFileName));
            }
            this.storeLocations.put(PERMANENT_STORE_NAME, permanentStoreFileName);
            this.storeLocations.put(TEMPORARY_STORE_NAME, temporaryStoreFileName);
            try {
                PersistentMessageStoreImpl persistentMessageStoreImpl = this;
                synchronized (persistentMessageStoreImpl) {
                    if (this._starting) {
                        if (this._configuration.isCleanPersistenceOnStart()) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Clean starting the Persistence Layer.");
                            }
                            this._objectManager = new ObjectManager(logFileName, 2, this.storeLocations, new ObjectManagerEventCallback[]{this});
                        } else {
                            this._objectManager = new ObjectManager(logFileName, 0, this.storeLocations, new ObjectManagerEventCallback[]{this});
                        }
                        connected = true;
                    }
                }
            }
            catch (PermanentIOException pioe) {
                FFDCFilter.processException((Throwable)pioe, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableMessageStoreImpl.start", (String)"1:397:1.81.1.6", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)"Unable to start ObjectManager instance!", (Object)pioe);
                }
                SibTr.error((TraceComponent)tc, (String)"FILE_STORE_UNEXPECTED_IO_EXCEPTION_SIMS1592");
            }
            catch (LogFileInUseException lfiue) {
                FFDCFilter.processException((Throwable)lfiue, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableMessageStoreImpl.start", (String)"1:404:1.81.1.6", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)"Unable to start ObjectManager instance!", (Object)lfiue);
                }
                SibTr.error((TraceComponent)tc, (String)"FILE_STORE_LOG_FILE_IN_USE_SIMS1579");
            }
            catch (NonExistentLogFileException nelfe) {
                FFDCFilter.processException((Throwable)nelfe, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableMessageStoreImpl.start", (String)"1:411:1.81.1.6", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)"Unable to start ObjectManager instance!", (Object)nelfe);
                }
                SibTr.error((TraceComponent)tc, (String)"FILE_STORE_CANNOT_FIND_LOG_FILE_SIMS1580", (Object)logFileName);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
                }
                throw new SeverePersistenceException("Unable to locate the file path: " + nelfe.getMessage(), (Throwable)nelfe);
            }
            catch (ObjectManagerException ome) {
                FFDCFilter.processException((Throwable)ome, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableMessageStoreImpl.start", (String)"1:418:1.81.1.6", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)"Unexpected exception caught initializing file store!", (Object)ome);
                }
                SibTr.error((TraceComponent)tc, (String)"FILE_STORE_UNEXPECTED_INITIALISATION_EXCEPTION_SIMS1591");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
                }
                throw new SeverePersistenceException("Unexpected exception caught initializing file store: " + ome.getMessage(), (Throwable)ome);
            }
            if (connected || !this._starting) continue;
            long currentTime = System.currentTimeMillis();
            if (currentTime < retryLimit) {
                SibTr.info((TraceComponent)tc, (String)"FILE_STORE_PROBLEM_INITIALISING_LOG_SIMS1582");
                try {
                    PersistentMessageStoreImpl persistentMessageStoreImpl = this;
                    synchronized (persistentMessageStoreImpl) {
                        this.wait(this._timeouts.getRetryWaitTime());
                    }
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            SibTr.error((TraceComponent)tc, (String)"FILE_STORE_INITIALISATION_RETRY_LIMIT_EXCEEDED_SIMS1583");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
            }
            throw new SeverePersistenceException("Retry time limit reached when starting file store!");
        } while (!connected && this._starting);
        if (this._starting) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"The file store has initialised successfully.");
            }
            this._omgrStarted = true;
            String minimumPermanentStoreSizeStr = this._ms.getProperty("omPermanentStoreFileSizeMin", null);
            String maximumPermanentStoreSizeStr = this._ms.getProperty("omPermanentStoreFileSizeMax", null);
            long minimumPermanentStoreSize = this._configuration.getObjectManagerMinimumPermanentStoreSize();
            if (minimumPermanentStoreSizeStr != null) {
                minimumPermanentStoreSize = Long.parseLong(minimumPermanentStoreSizeStr);
            }
            long maximumPermanentStoreSize = this._configuration.getObjectManagerMaximumPermanentStoreSize();
            if (maximumPermanentStoreSizeStr != null) {
                maximumPermanentStoreSize = Long.parseLong(maximumPermanentStoreSizeStr);
            }
            boolean isPermanentStoreSizeUnlimited = this._configuration.isObjectManagerPermanentStoreSizeUnlimited();
            String minimumTemporaryStoreSizeStr = this._ms.getProperty("omTemporaryStoreFileSizeMin", null);
            String maximumTemporaryStoreSizeStr = this._ms.getProperty("omTemporaryStoreFileSizeMax", null);
            long minimumTemporaryStoreSize = this._configuration.getObjectManagerMinimumTemporaryStoreSize();
            if (minimumTemporaryStoreSizeStr != null) {
                minimumTemporaryStoreSize = Long.parseLong(minimumTemporaryStoreSizeStr);
            }
            long maximumTemporaryStoreSize = this._configuration.getObjectManagerMaximumTemporaryStoreSize();
            if (maximumTemporaryStoreSizeStr != null) {
                maximumTemporaryStoreSize = Long.parseLong(maximumTemporaryStoreSizeStr);
            }
            boolean isTemporaryStoreSizeUnlimited = this._configuration.isObjectManagerTemporaryStoreSizeUnlimited();
            String storeFullWaitForCheckPointStr = this._ms.getProperty("storeFullWaitForCheckPoint", "false");
            boolean storeFullWaitForCheckPoint = Boolean.parseBoolean(storeFullWaitForCheckPointStr);
            String permanentStoreObjectCacheSizeStr = this._ms.getProperty("omPermanentStoreCacheSize", "1000");
            int permanentStoreObjectCacheSize = Integer.parseInt(permanentStoreObjectCacheSizeStr);
            String temporaryStoreObjectCacheSizeStr = this._ms.getProperty("omTemporaryStoreCacheSize", "1000");
            int temporaryStoreObjectCacheSize = Integer.parseInt(temporaryStoreObjectCacheSizeStr);
            Transaction transaction = null;
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("The file store is attempting to start its permanent store (" + PERMANENT_STORE_NAME + ") and temporary store (" + TEMPORARY_STORE_NAME + ")"));
                }
                if (this._objectManager.warmStarted()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Object Manager Warm Started");
                    }
                    try {
                        if (this.oldPermanentStore == null) {
                            this._permanentStore = this._objectManager.getObjectStore(PERMANENT_STORE_NAME);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Permanent Store Found");
                            }
                        } else {
                            this._permanentStore = this._objectManager.getObjectStore(this.oldPermanentStore);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Old Permanent Store Found");
                            }
                            this._permanentStore.setName(PERMANENT_STORE_NAME);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Old Permanent Store Renamed");
                            }
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"The file stores permanent store has been started successfully.");
                        }
                        if (this.oldTemporaryStore == null) {
                            this._temporaryStore = this._objectManager.getObjectStore(TEMPORARY_STORE_NAME);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Temporary Store Found");
                            }
                        } else {
                            this._temporaryStore = this._objectManager.getObjectStore(this.oldTemporaryStore);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Old Temporary Store Found");
                            }
                            this._temporaryStore.setName(TEMPORARY_STORE_NAME);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Old Temporary Store Renamed");
                            }
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"The file stores temporary store has been started successfully.");
                        }
                        this.setFileSizesAfterRestart(false, minimumPermanentStoreSize, maximumPermanentStoreSize, isPermanentStoreSizeUnlimited, minimumTemporaryStoreSize, maximumTemporaryStoreSize, isTemporaryStoreSizeUnlimited, logSize);
                    }
                    catch (UnknownObjectStoreException uose) {
                        FFDCFilter.processException((Throwable)uose, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableMessageStoreImpl.start", (String)"1:572:1.81.1.6", (Object)this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            SibTr.event((Object)this, (TraceComponent)tc, (String)"ObjectStore not found after warm start!", (Object)uose);
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
                        }
                        throw new SeverePersistenceException("ObjectStore not found after warm start!");
                    }
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Object Manager Cold Started");
                    }
                    this._permanentStore = new SingleFileObjectStore(PERMANENT_STORE_NAME, this._objectManager, 0);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"The file stores permanent store has been started successfully.");
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Permanent Store Created");
                    }
                    this._temporaryStore = new SingleFileObjectStore(TEMPORARY_STORE_NAME, this._objectManager, 1);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"The file stores temporary store has been started successfully.");
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Temporary Store Created");
                    }
                    this.setFileSizesAfterRestart(true, minimumPermanentStoreSize, maximumPermanentStoreSize, isPermanentStoreSizeUnlimited, minimumTemporaryStoreSize, maximumTemporaryStoreSize, isTemporaryStoreSizeUnlimited, logSize);
                }
                this._permanentStore.setStoreFullWaitForCheckPoint(storeFullWaitForCheckPoint);
                this._temporaryStore.setStoreFullWaitForCheckPoint(storeFullWaitForCheckPoint);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Permanent store object cache size set to: " + permanentStoreObjectCacheSize));
                }
                ((SingleFileObjectStore)this._permanentStore).setCachedManagedObjectsSize(permanentStoreObjectCacheSize);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Temporary store object cache size set to: " + temporaryStoreObjectCacheSize));
                }
                ((SingleFileObjectStore)this._temporaryStore).setCachedManagedObjectsSize(temporaryStoreObjectCacheSize);
                this._anchorToken = this._objectManager.getNamedObject("Anchor", null);
                if (this._anchorToken != null) {
                    this._anchor = (Anchor)this._anchorToken.getManagedObject();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Stored Anchor Found");
                    }
                } else {
                    transaction = this._objectManager.getTransaction();
                    this._anchor = new Anchor();
                    this._anchorToken = this._permanentStore.allocate(this._anchor);
                    transaction.add(this._anchor);
                    this._objectManager.putNamedObject("Anchor", this._anchorToken, transaction);
                    transaction.commit(false);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Stored Anchor Created");
                    }
                }
            }
            catch (ObjectManagerException ome) {
                block82: {
                    FFDCFilter.processException((Throwable)ome, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableMessageStoreImpl.start", (String)"1:647:1.81.1.6", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.event((Object)this, (TraceComponent)tc, (String)"Unexpected exception caught starting permanent and temporary stores!", (Object)ome);
                    }
                    if (transaction != null) {
                        try {
                            transaction.backout(false);
                        }
                        catch (ObjectManagerException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableMessageStoreImpl.start", (String)"1:659:1.81.1.6", (Object)this);
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block82;
                            SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught backing out persistent message store startup work!", (Object)e);
                        }
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
                }
                throw new SeverePersistenceException("Unexpected exception caught starting permanent and temporary stores: " + ome.getMessage(), (Throwable)ome);
            }
            if (this.checkAndUpdateMEOwner(this._meOwner)) {
                this._uniqueKeyManager.start(this._anchor, this._objectManager, this._permanentStore);
                this._batchingContextFactory = new BatchingContextFactoryImpl(this._objectManager, this._temporaryStore);
                this._spillDispatcher = new SpillDispatcher(this._ms, this._batchingContextFactory);
                this._spillDispatcher.start();
                this._available = true;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"The file store has started successfully.");
                }
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Startup processing halted as a stop was requested!");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
            }
            throw new PersistenceException("Startup processing halted as a stop was requested!");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
        }
    }

    @Deprecated
    public void stop(int mode) {
        this.stop(mode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(int mode, Throwable reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stop", (Object)("Mode=" + mode));
        }
        this._available = false;
        this._shutdownRequested = true;
        if (this._starting) {
            PersistentMessageStoreImpl persistentMessageStoreImpl = this;
            synchronized (persistentMessageStoreImpl) {
                this._starting = false;
                this.notify();
            }
        }
        if (this._spillDispatcher != null) {
            this._spillDispatcher.stop(mode, reason);
            this._spillDispatcher = null;
        }
        this._batchingContextFactory = null;
        if (this._objectManager != null) {
            block11: {
                try {
                    this._objectManager.shutdown();
                }
                catch (ObjectManagerException ome) {
                    FFDCFilter.processException((Throwable)ome, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableMessageStoreImpl.stop", (String)"1:764:1.81.1.6", (Object)this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block11;
                    SibTr.event((Object)this, (TraceComponent)tc, (String)"Unexpected exception caught stopping persistent message store!", (Object)ome);
                }
            }
            this._objectManager = null;
            this._permanentStore = null;
            this._temporaryStore = null;
        }
        if (this._uniqueKeyManager != null) {
            this._uniqueKeyManager.stop();
            this._uniqueKeyManager = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stop");
        }
    }

    @Override
    public void notification(int event, Object[] args) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"notification", (Object)new Object[]{event, args});
        }
        switch (event) {
            case 0: {
                if (!this._omgrStarted) break;
                this.objectManagerStopped();
                break;
            }
            case 1: {
                this.ensureStoreCanBeFound((ObjectStore)args[0]);
                break;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"notification");
        }
    }

    private void objectManagerStopped() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"objectManagerStopped");
        }
        this._available = false;
        if (!this._shutdownRequested) {
            this._ms.reportLocalError();
            SibTr.error((TraceComponent)tc, (String)"FILE_STORE_STOP_UNEXPECTED_SIMS1590");
        } else {
            SibTr.info((TraceComponent)tc, (String)"FILE_STORE_STOP_EXPECTED_SIMS1589");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"objectManagerStopped");
        }
    }

    private void ensureStoreCanBeFound(ObjectStore store) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"ensureStoreCanBeFound", (Object)store);
        }
        if (store instanceof SingleFileObjectStore) {
            String storeName = store.getName();
            String storeFileName = this.storeLocations.get(storeName);
            if (storeFileName != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)(storeName + " already maps to " + storeFileName));
                }
            } else {
                String[] nameParts = storeName.split(this.fileSepPattern);
                String lastPart = nameParts[nameParts.length - 1];
                String permStoreName = this.storeLocations.get(PERMANENT_STORE_NAME);
                if (permStoreName.endsWith(lastPart)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Mappping old PermanentStore: " + storeName + " to " + permStoreName));
                    }
                    this.storeLocations.put(storeName, permStoreName);
                    this.oldPermanentStore = storeName;
                } else {
                    String tempStoreName = this.storeLocations.get(TEMPORARY_STORE_NAME);
                    if (tempStoreName.endsWith(lastPart)) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Mappping old Temporary Store:" + storeName + " to " + tempStoreName));
                        }
                        this.storeLocations.put(storeName, tempStoreName);
                        this.oldTemporaryStore = storeName;
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"ensureStoreCanBeFound");
        }
    }

    @Override
    public List<DataSlice> readDataOnly(Persistable item) throws PersistenceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readDataOnly", (Object)("Item=" + item));
        }
        if (!this._available) {
            MessageStoreUnavailableException msue = new MessageStoreUnavailableException("Operation not possible as MessageStore is unavailable!");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Operation not possible as MessageStore is unavailable!");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"readDataOnly");
            }
            throw msue;
        }
        List<DataSlice> dataSlices = ((PersistableImpl)item).getPersistedData();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readDataOnly", (Object)("return=" + dataSlices));
        }
        return dataSlices;
    }

    @Override
    public Persistable readRootPersistable() throws PersistenceException, SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readRootPersistable");
        }
        if (!this._available) {
            MessageStoreUnavailableException msue = new MessageStoreUnavailableException("Operation not possible as MessageStore is unavailable!");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Operation not possible as MessageStore is unavailable!");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"readRootPersistable");
            }
            throw msue;
        }
        PersistableImpl root = null;
        Transaction transaction = null;
        try {
            if (this._anchor.getRootStreamToken() != null) {
                root = new PersistableImpl(this._anchor.getRootStreamToken());
            } else {
                transaction = this._objectManager.getTransaction();
                root = new PersistableImpl(-2L, -3L, TupleTypeEnum.ROOT);
                root.setStorageStrategy(4);
                root.setItemClassName(RootMembership.class.getName());
                root.addToStore(transaction, this._permanentStore);
                transaction.lock(this._anchor);
                this._anchor.setRootStreamToken(root.getMetaDataToken());
                transaction.replace(this._anchor);
                transaction.commit(false);
            }
        }
        catch (ObjectManagerException ome) {
            block14: {
                FFDCFilter.processException((Throwable)ome, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableMessageStoreImpl.readRootPersistable", (String)"1:982:1.81.1.6", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)"Unexpected exception caught reading root persistable!", (Object)ome);
                }
                if (transaction != null) {
                    try {
                        transaction.backout(false);
                    }
                    catch (ObjectManagerException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableMessageStoreImpl.readRootPersistable", (String)"1:994:1.81.1.6", (Object)this);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block14;
                        SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught backing out addition of root persistable!", (Object)e);
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"readRootPersistable");
            }
            throw new PersistenceException("Unexpected exception caught reading root persistable: " + ome.getMessage(), (Throwable)ome);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readRootPersistable", (Object)("return=" + root));
        }
        return root;
    }

    @Override
    public List readNonStreamItems(Persistable containingStream) throws PersistenceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readNonStreamItems", (Object)("Stream=" + containingStream));
        }
        if (!this._available) {
            MessageStoreUnavailableException msue = new MessageStoreUnavailableException("Operation not possible as MessageStore is unavailable!");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Operation not possible as MessageStore is unavailable!");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"readNonStreamItems");
            }
            throw msue;
        }
        Transaction storeMaybetransaction = null;
        LinkedList<PersistableImpl> items = new LinkedList<PersistableImpl>();
        try {
            storeMaybetransaction = this._objectManager.getTransaction();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Item Stream: " + containingStream));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"{");
            }
            Token itemListToken = ((PersistableImpl)containingStream).getMetaData().getItemListToken();
            ConcurrentLinkedList itemList = (ConcurrentLinkedList)itemListToken.getManagedObject();
            com.ibm.ws.objectManager.Iterator listIterator = itemList.entryIterator();
            int expirableCounter = 0;
            int storeMaybeCounter = 0;
            while (listIterator.hasNext()) {
                List.Entry entry = (List.Entry)listIterator.next();
                Token token = entry.getValue();
                if (storeMaybeCounter > 100) {
                    storeMaybetransaction.commit(false);
                    storeMaybeCounter = 0;
                    storeMaybetransaction = this._objectManager.getTransaction();
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)(" Token: " + token));
                }
                if (token.getManagedObject() == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)" Item Found: null");
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)" STORE_MAYBE Item cleaned-up at restart.");
                    }
                    entry.remove(storeMaybetransaction);
                    ++storeMaybeCounter;
                    continue;
                }
                PersistableImpl item = new PersistableImpl(token);
                if (item.getTupleType() == TupleTypeEnum.ITEM || item.getTupleType() == TupleTypeEnum.ITEM_REFERENCE) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)(" Item Found: " + item));
                    }
                    item.setContainingStream(containingStream);
                    items.add(item);
                }
                if (item.getExpiryTime() <= 0L) continue;
                ++expirableCounter;
            }
            PersistableImpl stream = (PersistableImpl)containingStream;
            if (stream.getMetaData().containsExpirables() && expirableCounter == 0) {
                Transaction transaction = this._objectManager.getTransaction();
                transaction.lock(stream.getMetaData());
                stream.getMetaData().setContainsExpirables(false);
                transaction.replace(stream.getMetaData());
                transaction.commit(false);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"}");
            }
        }
        catch (ObjectManagerException ome) {
            FFDCFilter.processException((Throwable)ome, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableMessageStoreImpl.readNonStreamItems", (String)"1:1122:1.81.1.6", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Unexpected exception caught reading in items!", (Object)ome);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"readNonStreamItems");
            }
            throw new PersistenceException("Unexpected exception caught reading in items: " + ome.getMessage(), (Throwable)ome);
        }
        finally {
            if (storeMaybetransaction != null) {
                try {
                    storeMaybetransaction.commit(false);
                }
                catch (ObjectManagerException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableMessageStoreImpl.readNonStreamItems", (String)"1:1077:1.74.1.4", (Object)this);
                    if (tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"Unexpected exception caught cleaning up STORE_MAYBE Items!", (Object)e);
                    }
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"readNonStreamItems");
                    }
                    throw new PersistenceException("Unexpected exception caught cleaning up STORE_MAYBE Items!", (Throwable)e);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readNonStreamItems", (Object)("return=" + items));
        }
        return items;
    }

    @Override
    public List readAllStreams() throws PersistenceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readAllStreams");
        }
        if (!this._available) {
            MessageStoreUnavailableException msue = new MessageStoreUnavailableException("Operation not possible as MessageStore is unavailable!");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Operation not possible as MessageStore is unavailable!");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"readAllStreams");
            }
            throw msue;
        }
        LinkedList streams = new LinkedList();
        Token rootToken = this._anchor.getRootStreamToken();
        Transaction transaction = null;
        try {
            transaction = this._objectManager.getTransaction();
            PersistableImpl root = new PersistableImpl(rootToken);
            this.addStreamsToList(root, streams, transaction);
            transaction.commit(false);
        }
        catch (Exception e) {
            block12: {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableMessageStoreImpl.readAllStreams", (String)"1:1182:1.81.1.6", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)"Unexpected exception caught reading in all streams!", (Object)e);
                }
                if (transaction != null) {
                    try {
                        transaction.backout(false);
                    }
                    catch (ObjectManagerException ome) {
                        FFDCFilter.processException((Throwable)ome, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableMessageStoreImpl.readAllStreams", (String)"1:1194:1.81.1.6", (Object)this);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block12;
                        SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught backing out read of existing streams!", (Object)ome);
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"readAllStreams");
            }
            throw new PersistenceException("Unexpected exception caught reading in all streams: " + e.getMessage(), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readAllStreams", streams);
        }
        return streams;
    }

    private void addStreamsToList(PersistableImpl stream, List allStreams, Transaction transaction) throws PersistenceException, ObjectManagerException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addStreamsToList", (Object)new Object[]{"Stream=" + stream, "Transaction=" + transaction});
        }
        try {
            Token streamListToken = stream.getMetaData().getStreamListToken();
            ConcurrentLinkedList streamsList = (ConcurrentLinkedList)streamListToken.getManagedObject();
            com.ibm.ws.objectManager.Iterator listIterator = streamsList.entryIterator();
            while (listIterator.hasNext(transaction)) {
                List.Entry entry = (List.Entry)listIterator.next(transaction);
                Token token = entry.getValue();
                PersistableImpl item = new PersistableImpl(token);
                if (item.getStorageStrategy() == 2) {
                    entry.remove(transaction);
                    item.removeFromStore(transaction);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"STORE_MAYBE Stream cleaned-up at restart.");
                    continue;
                }
                allStreams.add(item);
                if (item.getTupleType() != TupleTypeEnum.ITEM_STREAM) continue;
                this.addStreamsToList(item, allStreams, transaction);
            }
        }
        catch (PersistenceException pe) {
            FFDCFilter.processException((Throwable)pe, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableMessageStoreImpl.addStreamsToList", (String)"1:1260:1.81.1.6", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"PersistenceException caught cleaning up STORE_MAYBE ItemStream!", (Object)((Object)pe));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"addStreamsToList");
            }
            throw pe;
        }
        catch (ObjectManagerException ome) {
            FFDCFilter.processException((Throwable)ome, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableMessageStoreImpl.addStreamsToList", (String)"1:1267:1.81.1.6", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Unexpected exception caught building stream list from object store!", (Object)ome);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"addStreamsToList");
            }
            throw ome;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addStreamsToList");
        }
    }

    @Override
    public List readIndoubtXIDs() throws PersistenceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readIndoubtXIDs");
        }
        if (!this._available) {
            MessageStoreUnavailableException msue = new MessageStoreUnavailableException("Operation not possible as MessageStore is unavailable!");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Operation not possible as MessageStore is unavailable!");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"readIndoubtXIDs");
            }
            throw msue;
        }
        LinkedList<PersistentTranId> indoubtList = new LinkedList<PersistentTranId>();
        try {
            Iterator iterator = this._objectManager.getTransactionIterator();
            while (iterator.hasNext()) {
                Transaction tran = (Transaction)iterator.next();
                if (tran.getState() != 9) continue;
                byte[] xid = tran.getXID();
                if (xid != null) {
                    indoubtList.add(new PersistentTranId(xid));
                    continue;
                }
                PersistenceException pe = new PersistenceException("No XID found in prepared transaction!");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)"No XID found in prepared transaction!");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"readIndoubtXIDs");
                }
                throw pe;
            }
        }
        catch (ObjectManagerException ome) {
            FFDCFilter.processException((Throwable)ome, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableMessageStoreImpl.readIndoubtXids", (String)"1:1322:1.81.1.6", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Unexpected exception caught reading indoubt XIDs!", (Object)ome);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"readIndoubtXIDs");
            }
            throw new PersistenceException("Unexpected exception caught reading indoubt XIDs: " + ome.getMessage(), (Throwable)ome);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readIndoubtXIDs", (Object)("return=" + indoubtList));
        }
        return indoubtList;
    }

    @Override
    public Set identifyStreamsWithIndoubtItems() throws PersistenceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"identifyStreamsWithIndoubtItems");
        }
        if (!this._available) {
            MessageStoreUnavailableException msue = new MessageStoreUnavailableException("Operation not possible as MessageStore is unavailable!");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Operation not possible as MessageStore is unavailable!");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"identifyStreamsWithIndoubtItems");
            }
            throw msue;
        }
        HashSet<Long> set = new HashSet<Long>();
        try {
            Iterator iterator = this._objectManager.getTransactionIterator();
            while (iterator.hasNext()) {
                Transaction tran = (Transaction)iterator.next();
                if (tran.getState() != 9) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Indoubt Transaction: " + tran));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"{");
                }
                for (ManagedObject mo : tran.getIncludedManagedObjects()) {
                    if (mo != null && mo instanceof PersistableMetaData) {
                        PersistableMetaData metaData = (PersistableMetaData)mo;
                        if (metaData.getTupleType() == TupleTypeEnum.ITEM || metaData.getTupleType() == TupleTypeEnum.ITEM_REFERENCE) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)(" Item Found: " + metaData));
                            }
                            set.add(metaData.getStreamId());
                        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)(" Item Stream Found: " + metaData));
                        }
                        if (metaData.getState() != 5) continue;
                        metaData.setTransactionId(tran.getXID());
                        metaData.setLogicallyDeleted(true);
                        continue;
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)(" Managed Object Found: " + mo));
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"}");
            }
        }
        catch (ObjectManagerException ome) {
            FFDCFilter.processException((Throwable)ome, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableMessageStoreImpl.identifyStreamsWithIndoubtItems", (String)"1:1422:1.81.1.6", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Unexpected exception caught identifying indoubt streams!", (Object)ome);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"identifyStreamsWithIndoubtItems");
            }
            throw new PersistenceException("Unexpected exception caught identifying indoubt streams: " + ome.getMessage(), (Throwable)ome);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"identifyStreamsWithIndoubtItems", (Object)("return=" + set));
        }
        return set;
    }

    @Override
    public Set identifyStreamsWithExpirableItems() throws PersistenceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"identifyStreamsWithExpirableItems");
        }
        HashSet<Long> set = new HashSet<Long>();
        List streams = this.readAllStreams();
        for (PersistableImpl stream : streams) {
            if (!stream.getMetaData().containsExpirables()) continue;
            set.add(stream.getUniqueId());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"identifyStreamsWithExpirableItems", (Object)("return=" + set));
        }
        return set;
    }

    @Override
    public void prepare(PersistentTransaction transaction) throws PersistenceException, SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"prepare", (Object)("Transaction=" + transaction));
        }
        if (!this._available) {
            MessageStoreUnavailableException msue = new MessageStoreUnavailableException("Operation not possible as MessageStore is unavailable!");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Operation not possible as MessageStore is unavailable!");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"prepare");
            }
            throw msue;
        }
        TaskList taskList = (TaskList)transaction.getWorkList();
        PersistentTranId xid = transaction.getPersistentTranId();
        TransactionState tranState = transaction.getTransactionState();
        int numberOfTasks = taskList.countLinks();
        boolean requiresSyncPersistence = false;
        boolean requiresSpillPersistence = false;
        BatchingContext syncBatch = null;
        ArrayList<Persistable> syncList = null;
        if (taskList.hasStoreAlways() || taskList.hasStoreEventually() || taskList.hasStoreMaybe()) {
            Iterator iterator = taskList.iterator();
            while (iterator.hasNext()) {
                Operation operation = (Operation)iterator.next();
                Persistable persistable = operation.getPersistable();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Preparing Task: " + operation));
                }
                if (persistable == null || !persistable.requiresPersistence()) continue;
                int storageStrategy = persistable.getStorageStrategy();
                TupleTypeEnum tupleType = persistable.getTupleType();
                if (tupleType != TupleTypeEnum.ITEM_STREAM && tupleType != TupleTypeEnum.REFERENCE_STREAM && storageStrategy == 2) {
                    if (requiresSpillPersistence) continue;
                    requiresSpillPersistence = true;
                    continue;
                }
                if (!requiresSyncPersistence) {
                    syncList = new ArrayList<Persistable>(numberOfTasks);
                    syncBatch = new BatchingContextImpl(this._objectManager, this._permanentStore, transaction);
                    transaction.setBatchingContext(syncBatch);
                    requiresSyncPersistence = true;
                }
                persistable.setPersistentTranId(xid);
                operation.persist(syncBatch, tranState);
                syncList.add(persistable);
            }
        }
        if (requiresSpillPersistence && !this._spillDispatcher.isHealthy()) {
            PersistenceException pe = new PersistenceException("SPILL_DISPATCHER_CANNOT_ACCEPT_WORK_SIMS1578");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"The spill dispatcher cannot accept work!", (Object)((Object)pe));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"prepare");
            }
            throw pe;
        }
        if (requiresSyncPersistence) {
            try {
                syncBatch.addIndoubtXID(xid);
                syncBatch.executeBatch();
                for (Tuple tuple : syncList) {
                    tuple.persistableOperationBegun();
                    tuple.persistableOperationCompleted();
                }
            }
            catch (PersistenceException pe) {
                FFDCFilter.processException((Throwable)pe, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableMessageStoreImpl.prepare", (String)"1:1615:1.81.1.6", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught preparing transaction in object store!", (Object)((Object)pe));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"prepare");
                }
                throw pe;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"prepare");
        }
    }

    @Override
    public void commit(PersistentTransaction transaction, boolean onePhase) throws PersistenceException, SevereMessageStoreException {
        TupleTypeEnum tupleType;
        int storageStrategy;
        Persistable persistable;
        Iterator iterator;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"commit", (Object)new Object[]{"Transaction=" + transaction, "OnePhase=" + onePhase});
        }
        if (!this._available) {
            MessageStoreUnavailableException msue = new MessageStoreUnavailableException("Operation not possible as MessageStore is unavailable!");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Operation not possible as MessageStore is unavailable!");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"commit");
            }
            throw msue;
        }
        TaskList taskList = (TaskList)transaction.getWorkList();
        PersistentTranId xid = transaction.getPersistentTranId();
        TransactionState tranState = transaction.getTransactionState();
        int numberOfTasks = taskList.countLinks();
        boolean requiresSyncPersistence = false;
        boolean requiresSpillPersistence = false;
        BatchingContext syncBatch = null;
        ArrayList<Persistable> syncList = null;
        ArrayList<Operation> spillList = null;
        if (onePhase) {
            if (taskList.hasStoreAlways() || taskList.hasStoreEventually() || taskList.hasStoreMaybe()) {
                iterator = taskList.iterator();
                while (iterator.hasNext()) {
                    Operation operation = (Operation)iterator.next();
                    persistable = operation.getPersistable();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Committing Task(1PC): " + operation));
                    }
                    if (persistable == null || !persistable.requiresPersistence()) continue;
                    storageStrategy = persistable.getStorageStrategy();
                    tupleType = persistable.getTupleType();
                    if (tupleType != TupleTypeEnum.ITEM_STREAM && tupleType != TupleTypeEnum.REFERENCE_STREAM && storageStrategy == 2) {
                        if (!requiresSpillPersistence) {
                            spillList = new ArrayList<Operation>(numberOfTasks);
                            requiresSpillPersistence = true;
                        }
                        spillList.add(operation);
                        continue;
                    }
                    if (!requiresSyncPersistence) {
                        syncList = new ArrayList<Persistable>(numberOfTasks);
                        syncBatch = new BatchingContextImpl(this._objectManager, this._permanentStore);
                        requiresSyncPersistence = true;
                    }
                    operation.persist(syncBatch, tranState);
                    syncList.add(persistable);
                }
            }
        } else if (taskList.hasStoreAlways() || taskList.hasStoreEventually() || taskList.hasStoreMaybe()) {
            iterator = taskList.iterator();
            while (iterator.hasNext()) {
                Operation operation = (Operation)iterator.next();
                persistable = operation.getPersistable();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Committing Task(2PC): " + operation));
                }
                if (persistable == null || !persistable.requiresPersistence()) continue;
                storageStrategy = persistable.getStorageStrategy();
                tupleType = persistable.getTupleType();
                if (tupleType != TupleTypeEnum.ITEM_STREAM && tupleType != TupleTypeEnum.REFERENCE_STREAM && storageStrategy == 2) {
                    if (!requiresSpillPersistence) {
                        spillList = new ArrayList(numberOfTasks);
                        requiresSpillPersistence = true;
                    }
                    spillList.add(operation);
                    continue;
                }
                if (requiresSyncPersistence) continue;
                syncBatch = transaction.getBatchingContext();
                if (syncBatch == null) {
                    Transaction tran = null;
                    try {
                        tran = this._objectManager.getTransactionByXID(xid.toByteArray());
                    }
                    catch (ObjectManagerException ome) {
                        FFDCFilter.processException((Throwable)ome, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableMessageStoreImpl.commit", (String)"1:1800:1.81.1.6", (Object)this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught requesting recovered transaction from object manager!", (Object)ome);
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((Object)this, (TraceComponent)tc, (String)"commit");
                        }
                        throw new PersistenceException("Exception caught requesting recovered transaction from object manager: " + ome.getMessage(), (Throwable)ome);
                    }
                    if (tran != null) {
                        syncBatch = new BatchingContextImpl(this._objectManager, this._permanentStore, tran);
                        transaction.setBatchingContext(syncBatch);
                    } else {
                        PersistenceException pe = new PersistenceException("No existing batching context found during two-phase commit!");
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            SibTr.event((Object)this, (TraceComponent)tc, (String)"No existing batching context found during two-phase commit!", (Object)((Object)pe));
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((Object)this, (TraceComponent)tc, (String)"commit");
                        }
                        throw pe;
                    }
                }
                requiresSyncPersistence = true;
            }
        }
        if (requiresSpillPersistence && !this._spillDispatcher.isHealthy()) {
            PersistenceException pe = new PersistenceException("SPILL_DISPATCHER_CANNOT_ACCEPT_WORK_SIMS1578");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"The spill dispatcher cannot accept work!", (Object)((Object)pe));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"prepare");
            }
            throw pe;
        }
        if (requiresSyncPersistence) {
            try {
                syncBatch.updateXIDToCommitted(null);
                syncBatch.executeBatch();
                if (onePhase) {
                    for (Tuple tuple : syncList) {
                        tuple.persistableOperationBegun();
                        tuple.persistableOperationCompleted();
                    }
                }
            }
            catch (PersistenceException pe) {
                FFDCFilter.processException((Throwable)pe, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableMessageStoreImpl.commit", (String)"1:1880:1.81.1.6", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught committing transaction work in permanent store!", (Object)((Object)pe));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"commit");
                }
                throw pe;
            }
        }
        if (requiresSpillPersistence) {
            this._spillDispatcher.dispatch(spillList, transaction, false);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"commit");
        }
    }

    @Override
    public void rollback(PersistentTransaction transaction) throws PersistenceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"rollback", (Object)("Transaction=" + transaction));
        }
        if (!this._available) {
            MessageStoreUnavailableException msue = new MessageStoreUnavailableException("Operation not possible as MessageStore is unavailable!");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Operation not possible as MessageStore is unavailable!");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"rollback");
            }
            throw msue;
        }
        TaskList taskList = (TaskList)transaction.getWorkList();
        PersistentTranId xid = transaction.getPersistentTranId();
        if (taskList.hasStoreAlways() || taskList.hasStoreEventually()) {
            BatchingContext batch = transaction.getBatchingContext();
            if (batch == null) {
                Transaction tran = null;
                try {
                    tran = this._objectManager.getTransactionByXID(xid.toByteArray());
                }
                catch (ObjectManagerException ome) {
                    FFDCFilter.processException((Throwable)ome, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableMessageStoreImpl.rollback", (String)"1:1950:1.81.1.6", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught requesting recovered transaction from object manager!", (Object)ome);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)tc, (String)"rollback");
                    }
                    throw new PersistenceException("Exception caught requesting recovered transaction from object manager: " + ome.getMessage(), (Throwable)ome);
                }
                if (tran != null) {
                    batch = new BatchingContextImpl(this._objectManager, this._permanentStore, tran);
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Transaction could not be found");
                }
            }
            if (batch != null) {
                try {
                    batch.updateXIDToRolledback(xid);
                    batch.executeBatch();
                }
                catch (PersistenceException pe) {
                    FFDCFilter.processException((Throwable)pe, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableMessageStoreImpl.rollback", (String)"1:1994:1.81.1.6", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught rolling back transction in object store!", (Object)((Object)pe));
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)tc, (String)"rollback");
                    }
                    throw pe;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"rollback");
        }
    }

    @Override
    public boolean supports1PCOptimisation() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"supports1PCOptimisation");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"supports1PCOptimisation", (Object)"return=false");
        }
        return false;
    }

    @Override
    public void beforeCompletion(PersistentTransaction transaction) throws PersistenceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"beforeCompletion", (Object)("Transaction=" + transaction));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            SibTr.event((Object)this, (TraceComponent)tc, (String)"Connection sharing with JDBC not supported by FileStore!");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"beforeCompletion");
        }
        throw new PersistenceException("Connection sharing with JDBC not supported by FileStore!");
    }

    @Override
    public void afterCompletion(PersistentTransaction transaction, boolean committed) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"afterCompletion", (Object)new Object[]{"Transaction=" + transaction, "DidCommit=" + committed});
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"afterCompletion");
        }
    }

    @Override
    public UniqueKeyGenerator getUniqueKeyGenerator(String name, int range) {
        UniqueKeyGenerator retval;
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"getUniqueKeyGenerator", (Object)new Object[]{"Name=" + name, "Range=" + range});
            }
            retval = null;
            try {
                retval = this._uniqueKeyManager.createUniqueKeyGenerator(name, range);
            }
            catch (PersistenceException pe) {
                FFDCFilter.processException((Throwable)pe, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableMessageStoreImpl.getUniqueKeyGenerator", (String)"1:2089:1.81.1.6", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught creating new unique key generator!", (Object)((Object)pe));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getUniqueKeyGenerator", (Object)("return=" + retval));
        }
        return retval;
    }

    public boolean checkAndUpdateMEOwner(MELockOwner owner) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"checkAndUpdateMEOwner", (Object)("Owner=" + owner));
        }
        boolean disableUUIDCheck = true;
        boolean success = true;
        if (disableUUIDCheck) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Owner checking skipped as omDisableUUIDCheck=true");
            }
        } else {
            MEStoredOwner storedOwner = null;
            Transaction transaction = null;
            SibTr.info((TraceComponent)tc, (String)"FILE_STORE_LOCK_ATTEMPTING_SIMS1564", (Object)new Object[]{owner.getMeUUID(), owner.getIncUUID()});
            try {
                transaction = this._objectManager.getTransaction();
                Token storedOwnerToken = this._anchor.getMEOwnerToken();
                if (storedOwnerToken != null) {
                    storedOwner = (MEStoredOwner)storedOwnerToken.getManagedObject();
                    SibTr.info((TraceComponent)tc, (String)"FILE_STORE_LOCK_ONE_OWNER_SIMS1566", (Object)new Object[]{storedOwner.getMeUUID(), storedOwner.getIncUUID()});
                    if (this._ms.getProperty("STARTMODE", "NORMAL").equalsIgnoreCase("RECOVERY")) {
                        owner = new MELockOwner(storedOwner.getMeUUID(), storedOwner.getIncUUID(), storedOwner.getVersion(), storedOwner.getMigrationVersion(), "default");
                    }
                    if (owner.getMeUUID().equals(storedOwner.getMeUUID())) {
                        if (owner.getVersion() == storedOwner.getVersion()) {
                            transaction.lock(storedOwner);
                            storedOwner.setIncUUID(owner.getIncUUID());
                            transaction.replace(storedOwner);
                        } else {
                            SibTr.error((TraceComponent)tc, (String)"FILE_STORE_LOCK_VERSION_DOESNT_MATCH_SIMS1562", (Object)new Object[]{owner.getVersion(), storedOwner.getVersion()});
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                SibTr.event((Object)this, (TraceComponent)tc, (String)"Different ME version found in file store!", (Object)("ME Version=" + owner.getVersion() + ", ME Version(FS)=" + storedOwner.getVersion()));
                            }
                            this._ms.reportGlobalError();
                            success = false;
                        }
                    } else {
                        SibTr.error((TraceComponent)tc, (String)"FILE_STORE_LOCK_MEUUID_DOESNT_MATCH_SIMS1561", (Object)new Object[]{owner.getMeUUID(), storedOwner.getMeUUID()});
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            SibTr.event((Object)this, (TraceComponent)tc, (String)"Different ME unique id found in file store!", (Object)("ME_UUID=" + owner.getMeUUID() + ", ME_UUID(FS)=" + storedOwner.getMeUUID()));
                        }
                        this._ms.reportGlobalError();
                        success = false;
                    }
                } else {
                    SibTr.info((TraceComponent)tc, (String)"FILE_STORE_LOCK_NO_OWNER_SIMS1565");
                    storedOwner = new MEStoredOwner(owner.getMeUUID(), owner.getIncUUID(), 1, 0);
                    storedOwnerToken = this._permanentStore.allocate(storedOwner);
                    transaction.lock(this._anchor);
                    this._anchor.setMEOwnerToken(storedOwnerToken);
                    transaction.replace(this._anchor);
                    transaction.add(storedOwner);
                }
                transaction.commit(false);
            }
            catch (ObjectManagerException ome) {
                block23: {
                    FFDCFilter.processException((Throwable)ome, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableMessageStoreImpl.checkAndUpdateMEOwner", (String)"1:2214:1.81.1.6", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught updating ME Owner information!", (Object)ome);
                    }
                    if (transaction != null) {
                        try {
                            transaction.backout(false);
                        }
                        catch (ObjectManagerException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableMessageStoreImpl.checkAndUpdateMEOwner", (String)"1:2226:1.81.1.6", (Object)this);
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block23;
                            SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught backing out update of ME Owner information!", (Object)e);
                        }
                    }
                }
                this._ms.reportLocalError();
                success = false;
            }
            if (success) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("ME Owner information in ObjectStore updated successfully: " + storedOwner));
                }
                SibTr.info((TraceComponent)tc, (String)"FILE_STORE_LOCK_ACQUIRED_SIMS1563", (Object)new Object[]{storedOwner.getMeUUID(), storedOwner.getIncUUID()});
            } else {
                SibTr.error((TraceComponent)tc, (String)"CANNOT_OBTAIN_FILE_STORE_LOCK_SIMS1567", (Object)new Object[]{owner.getMeName()});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"checkAndUpdateMEOwner", (Object)("return=" + success));
        }
        return success;
    }

    private String createDirectoryPath(String path) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createDirectoryPath", (Object)("Path=" + path));
        }
        StringBuilder directoryPath = new StringBuilder("");
        if (path != null && path.length() > 0) {
            if (path.charAt(0) == '/') {
                directoryPath.append("/");
            }
            if (path.charAt(0) == '\\' && path.charAt(1) == '\\') {
                directoryPath.append("\\\\");
            }
            StringTokenizer tokenizer = new StringTokenizer(path, "\\/");
            while (tokenizer.hasMoreTokens()) {
                String pathChunk = tokenizer.nextToken();
                directoryPath.append(pathChunk);
                File test = new File(directoryPath.toString());
                if (!test.exists()) {
                    test.mkdir();
                }
                if (!tokenizer.hasMoreTokens()) continue;
                directoryPath.append(File.separator);
            }
        }
        String retval = directoryPath.toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createDirectoryPath", (Object)retval);
        }
        return retval;
    }

    private void setFileSizesAfterRestart(boolean coldStart, long minimumPermanentStoreSize, long maximumPermanentStoreSize, boolean isPermanentStoreSizeUnlimited, long minimumTemporaryStoreSize, long maximumTemporaryStoreSize, boolean isTemporaryStoreSizeUnlimited, long logSize) throws ObjectManagerException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setFileSizesAfterRestart", (Object)new Object[]{"ColdStart=" + coldStart, "LogSize=" + logSize, "MinimumPermanentStoreSize=" + minimumPermanentStoreSize, "MaximumPermanentStoreSize=" + maximumPermanentStoreSize, "IsPermanentStoreSizeUnlimited=" + isPermanentStoreSizeUnlimited, "MinimumTemporaryStoreSize=" + minimumTemporaryStoreSize, "MaximumTemporaryStoreSize=" + maximumTemporaryStoreSize, "IsTemporaryStoreSizeUnlimited=" + isTemporaryStoreSizeUnlimited});
        }
        try {
            if (coldStart) {
                long currentLogSize = this._objectManager.getLogFileSize();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("The current size of the log file is " + Long.valueOf(currentLogSize) + " bytes. The size in the configuration information of the log file is " + Long.valueOf(logSize) + " bytes."));
                }
                if (currentLogSize != logSize) {
                    if (!isPermanentStoreSizeUnlimited && logSize > maximumPermanentStoreSize || !isTemporaryStoreSizeUnlimited && logSize > maximumTemporaryStoreSize) {
                        SibTr.warning((TraceComponent)tc, (String)"FILE_STORE_LOG_SIZE_CHANGE_PREVENTED_SIMS1548");
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Log size not changed!");
                        }
                    } else {
                        this._objectManager.setLogFileSize(logSize);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Log size changed");
                        }
                    }
                }
            }
            SingleFileObjectStore store = (SingleFileObjectStore)this._permanentStore;
            long currentPermanentStoreUsed = store.getStoreFileUsed();
            long currentPermanentStoreSize = store.getStoreFileSize();
            long currentMinimumPermanentStoreSize = store.getMinimumStoreFileSize();
            long currentMaximumPermanentStoreSize = store.getMaximumStoreFileSize();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("currentPermanentStoreUsed        = " + currentPermanentStoreUsed));
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("currentPermanentStoreSize        = " + currentPermanentStoreSize));
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("currentMinimumPermanentStoreSize = " + currentMinimumPermanentStoreSize));
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("currentMaximumPermanentStoreSize = " + currentMaximumPermanentStoreSize));
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("The data in the permanent store file occupies " + Long.valueOf(currentPermanentStoreUsed) + " bytes."));
                if (currentMaximumPermanentStoreSize != MAXIMUM_STORE_FILE_SIZE) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("The current minimum reserved size of the permanent store file is " + Long.valueOf(currentMinimumPermanentStoreSize) + " bytes. The current maximum size is " + Long.valueOf(currentMaximumPermanentStoreSize) + " bytes."));
                } else {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("The current minimum reserved size of the permanent store file is " + Long.valueOf(currentMinimumPermanentStoreSize) + " bytes. The current maximum size is unlimited"));
                }
            }
            if (!isPermanentStoreSizeUnlimited && minimumPermanentStoreSize > maximumPermanentStoreSize) {
                SibTr.info((TraceComponent)tc, (String)"FILE_STORE_PERMANENT_STORE_SIZE_CONFIGURATION_INFO_SIMS1553", (Object)new Object[]{minimumPermanentStoreSize, maximumPermanentStoreSize});
                SibTr.warning((TraceComponent)tc, (String)"FILE_STORE_STORE_SIZE_CHANGE_PREVENTED_SIMS1549");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Permanent store size not changed!");
                }
            } else if (currentMinimumPermanentStoreSize != minimumPermanentStoreSize || !isPermanentStoreSizeUnlimited && currentMaximumPermanentStoreSize != maximumPermanentStoreSize || isPermanentStoreSizeUnlimited && currentMaximumPermanentStoreSize != MAXIMUM_STORE_FILE_SIZE) {
                if (!isPermanentStoreSizeUnlimited) {
                    SibTr.info((TraceComponent)tc, (String)"FILE_STORE_PERMANENT_STORE_SIZE_CONFIGURATION_INFO_SIMS1553", (Object)new Object[]{minimumPermanentStoreSize, maximumPermanentStoreSize});
                    store.setStoreFileSize(minimumPermanentStoreSize, maximumPermanentStoreSize);
                } else {
                    SibTr.info((TraceComponent)tc, (String)"FILE_STORE_PERMANENT_STORE_SIZE_CONFIGURATION_INFO_UNLIMITED_SIMS1554", (Object)new Object[]{minimumPermanentStoreSize});
                    store.setStoreFileSize(minimumPermanentStoreSize, MAXIMUM_STORE_FILE_SIZE);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Permanent Store size changed");
                }
            }
            store = (SingleFileObjectStore)this._temporaryStore;
            long currentTemporaryStoreUsed = store.getStoreFileUsed();
            long currentTemporaryStoreSize = store.getStoreFileSize();
            long currentMinimumTemporaryStoreSize = store.getMinimumStoreFileSize();
            long currentMaximumTemporaryStoreSize = store.getMaximumStoreFileSize();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("currentTemporaryStoreUsed        = " + currentTemporaryStoreUsed));
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("currentTemporaryStoreSize        = " + currentTemporaryStoreSize));
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("currentMinimumTemporaryStoreSize = " + currentMinimumTemporaryStoreSize));
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("currentMaximumTemporaryStoreSize = " + currentMaximumTemporaryStoreSize));
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("The data in the temporary store file occupies " + Long.valueOf(currentTemporaryStoreUsed) + " bytes."));
                if (currentMaximumTemporaryStoreSize != MAXIMUM_STORE_FILE_SIZE) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("The current minimum reserved size of the temporary store file is " + Long.valueOf(currentMinimumTemporaryStoreSize) + " bytes. The current maximum size is " + Long.valueOf(currentMaximumTemporaryStoreSize) + " bytes."));
                } else {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("The current minimum reserved size of the temporary store file is " + Long.valueOf(currentMinimumTemporaryStoreSize) + " bytes. The current maximum size is unlimited."));
                }
            }
            if (!isTemporaryStoreSizeUnlimited && minimumTemporaryStoreSize > maximumTemporaryStoreSize) {
                SibTr.info((TraceComponent)tc, (String)"FILE_STORE_TEMPORARY_STORE_SIZE_CONFIGURATION_INFO_SIMS1557", (Object)new Object[]{minimumTemporaryStoreSize, maximumTemporaryStoreSize});
                SibTr.warning((TraceComponent)tc, (String)"FILE_STORE_STORE_SIZE_CHANGE_PREVENTED_SIMS1549");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Temporary store size not changed!");
                }
            } else if (currentMinimumTemporaryStoreSize != minimumTemporaryStoreSize || !isTemporaryStoreSizeUnlimited && currentMaximumTemporaryStoreSize != maximumTemporaryStoreSize || isTemporaryStoreSizeUnlimited && currentMaximumTemporaryStoreSize != MAXIMUM_STORE_FILE_SIZE) {
                if (!isTemporaryStoreSizeUnlimited) {
                    SibTr.info((TraceComponent)tc, (String)"FILE_STORE_TEMPORARY_STORE_SIZE_CONFIGURATION_INFO_SIMS1557", (Object)new Object[]{minimumTemporaryStoreSize, maximumTemporaryStoreSize});
                    store.setStoreFileSize(minimumTemporaryStoreSize, maximumTemporaryStoreSize);
                } else {
                    SibTr.info((TraceComponent)tc, (String)"FILE_STORE_TEMPORARY_STORE_SIZE_CONFIGURATION_INFO_UNLIMITED_SIMS1558", (Object)new Object[]{minimumTemporaryStoreSize});
                    store.setStoreFileSize(minimumTemporaryStoreSize, MAXIMUM_STORE_FILE_SIZE);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Temporary Store size changed");
                }
            }
            if (!coldStart) {
                long currentLogSize = this._objectManager.getLogFileSize();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("The current size of the log file is " + Long.valueOf(currentLogSize) + " bytes. The size in the configuration information of the log file is " + Long.valueOf(logSize) + " bytes."));
                }
                if (currentLogSize != logSize) {
                    if (!isPermanentStoreSizeUnlimited && logSize > maximumPermanentStoreSize || !isTemporaryStoreSizeUnlimited && logSize > maximumTemporaryStoreSize) {
                        SibTr.warning((TraceComponent)tc, (String)"FILE_STORE_LOG_SIZE_CHANGE_PREVENTED_SIMS1548");
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Log size not changed!");
                        }
                    } else {
                        this._objectManager.setLogFileSize(logSize);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Log size changed");
                        }
                    }
                }
            }
        }
        catch (LogFileSizeTooSmallException lfse) {
            FFDCFilter.processException((Throwable)lfse, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableMessageStoreImpl.setFileSizesAfterRestart", (String)"1:2531:1.81.1.6", (Object)this);
            SibTr.warning((TraceComponent)tc, (String)"FILE_STORE_LOG_SIZE_CHANGE_PREVENTED_SIMS1548");
        }
        catch (IllegalArgumentException iae) {
            FFDCFilter.processException((Throwable)iae, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableMessageStoreImpl.setFileSizesAfterRestart", (String)"1:2536:1.81.1.6", (Object)this);
            SibTr.warning((TraceComponent)tc, (String)"FILE_STORE_STORE_SIZE_CHANGE_PREVENTED_SIMS1549");
        }
        catch (StoreFileSizeTooSmallException sfse) {
            FFDCFilter.processException((Throwable)sfse, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableMessageStoreImpl.setFileSizesAfterRestart", (String)"1:2541:1.81.1.6", (Object)this);
            SibTr.warning((TraceComponent)tc, (String)"FILE_STORE_STORE_SIZE_CHANGE_PREVENTED_SIMS1549");
        }
        catch (PermanentIOException pie) {
            FFDCFilter.processException((Throwable)pie, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableMessageStoreImpl.setFileSizesAfterRestart", (String)"1:2546:1.81.1.6", (Object)this);
            SibTr.warning((TraceComponent)tc, (String)"FILE_STORE_STORE_SIZE_CHANGE_PREVENTED_SIMS1549");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setFileSizesAfterRestart");
        }
    }

    @Override
    public void xmlWriteOn(FormattedWriter writer) throws IOException {
    }
}

