/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.cache.CacheAdminMBean;
import com.ibm.websphere.cache.CacheEntry;
import com.ibm.websphere.cache.exception.DynamicCacheException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.CacheAdmin;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.EntryInfo;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.ws.cache.util.MessageDigestUtility;
import com.ibm.ws.common.crypto.CryptoUtils;
import com.ibm.wsspi.cache.CacheStatistics;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import javax.management.StandardMBean;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@Component(service={MBeans.class, DynamicMBean.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM", "jmx.objectname=WebSphere:feature=CacheAdmin,type=DynaCache,name=DistributedMap"})
public class MBeans
extends StandardMBean
implements CacheAdmin {
    private static TraceComponent tc = Tr.register(MBeans.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private static String MESSAGE_DIGEST_ALGORITHM = CryptoUtils.isFips140_3Enabled() ? "SHA-256" : "MD5";
    private static MessageDigest messageDigest = null;

    public MBeans() {
        super(CacheAdminMBean.class, false);
    }

    @Override
    public int getCacheSize() {
        CacheConfig commonCacheConfig = ServerCache.getCacheService().getCacheConfig();
        if (commonCacheConfig != null) {
            return commonCacheConfig.cacheSize;
        }
        return 0;
    }

    @Override
    public int getUsedCacheSize() {
        DCache cache = null;
        if (ServerCache.servletCacheEnabled) {
            cache = ServerCache.cache;
        }
        int size = -1;
        if (cache != null) {
            size = cache.getNumberCacheEntries();
        } else {
            Tr.error((TraceComponent)tc, (String)"DYNA1059W", (Object[])new Object[]{"baseCache"});
        }
        return size;
    }

    @Override
    public boolean getDiskOverflow() {
        CacheConfig commonCacheConfig = ServerCache.getCacheService().getCacheConfig();
        if (commonCacheConfig != null) {
            return commonCacheConfig.enableDiskOffload;
        }
        return false;
    }

    @Override
    public String[] getCacheStatisticNames() {
        DCache cache = null;
        if (ServerCache.servletCacheEnabled) {
            cache = ServerCache.cache;
        } else if (ServerCache.objectCacheEnabled) {
            cache = ServerCache.getConfiguredCache("default");
        } else {
            Tr.error((TraceComponent)tc, (String)"DYNA1061E", (Object[])new Object[0]);
        }
        return this.getCacheStatisticNames(cache);
    }

    @Override
    public String[] getCacheStatisticNames(String cacheInstance) throws AttributeNotFoundException {
        DCache cache = this.getCache(cacheInstance);
        return this.getCacheStatisticNames(cache);
    }

    @Override
    public String[] getCacheStatisticNames(DCache cache) {
        Map statistics = MBeans.getCacheStatisticsMap(cache.getCacheStatistics());
        String[] names = new String[statistics.size()];
        Iterator it = statistics.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            names[i] = (String)it.next();
            ++i;
        }
        return names;
    }

    @Override
    public String[] getCacheInstanceNames() {
        Map instances = ServerCache.getCacheInstances();
        String[] names = new String[instances.size()];
        Iterator it = instances.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            names[i] = (String)it.next();
            ++i;
        }
        return names;
    }

    @Override
    public String[] getAllCacheStatistics() {
        DCache cache = null;
        if (ServerCache.servletCacheEnabled) {
            cache = ServerCache.cache;
        }
        String[] stats = null;
        if (cache != null) {
            Map statistics = MBeans.getCacheStatisticsMap(cache.getCacheStatistics());
            Iterator keys = statistics.keySet().iterator();
            Iterator values = statistics.values().iterator();
            stats = new String[statistics.size()];
            int i = 0;
            while (keys.hasNext()) {
                stats[i] = keys.next() + "=" + values.next();
                ++i;
            }
        } else {
            stats = new String[]{};
            Tr.error((TraceComponent)tc, (String)"DYNA1059W", (Object[])new Object[]{"baseCache"});
        }
        return stats;
    }

    @Override
    public String[] getAllCacheStatistics(String cacheInstance) throws AttributeNotFoundException {
        DCache cache1 = this.getCache(cacheInstance);
        Map statistics = MBeans.getCacheStatisticsMap(cache1.getCacheStatistics());
        Iterator keys = statistics.keySet().iterator();
        Iterator values = statistics.values().iterator();
        String[] stats = new String[statistics.size()];
        int i = 0;
        while (keys.hasNext()) {
            stats[i] = keys.next() + "=" + values.next();
            ++i;
        }
        return stats;
    }

    @Override
    public String[] getCacheStatistics(String[] names) throws AttributeNotFoundException {
        if (names == null) {
            return null;
        }
        DCache cache = null;
        if (ServerCache.servletCacheEnabled) {
            cache = ServerCache.cache;
        }
        String[] stats = null;
        if (cache != null) {
            Map statistics = MBeans.getCacheStatisticsMap(cache.getCacheStatistics());
            stats = new String[names.length];
            for (int i = 0; i < names.length; ++i) {
                if (!statistics.containsKey(names[i])) {
                    Tr.error((TraceComponent)tc, (String)"DYNA1052E", (Object[])new Object[]{names[i]});
                    throw new AttributeNotFoundException(names[i] + " is not a valid cache statistic name");
                }
                stats[i] = names[i] + "=" + statistics.get(names[i]);
            }
        } else {
            stats = new String[]{};
        }
        return stats;
    }

    @Override
    public String[] getCacheStatistics(String cacheInstance, String[] names) throws AttributeNotFoundException {
        if (names == null) {
            return null;
        }
        DCache cache1 = this.getCache(cacheInstance);
        Map statistics = MBeans.getCacheStatisticsMap(cache1.getCacheStatistics());
        String[] stats = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            if (!statistics.containsKey(names[i])) {
                Tr.error((TraceComponent)tc, (String)"DYNA1052E", (Object[])new Object[]{names[i]});
                throw new AttributeNotFoundException(names[i] + " is not a valid cache statistic name");
            }
            stats[i] = names[i] + "=" + statistics.get(names[i]);
        }
        return stats;
    }

    @Override
    public String[] getCacheIDsInMemory(String cacheInstance, String pattern) throws AttributeNotFoundException {
        DCache cache1 = this.getCache(cacheInstance);
        Pattern cpattern = this.checkPattern(pattern);
        ArrayList<String> matchSet = new ArrayList<String>(10);
        int i = 0;
        Enumeration vEnum = cache1.getAllIds();
        while (vEnum.hasMoreElements()) {
            Object key = vEnum.nextElement();
            String skey = key.toString();
            boolean matches = this.checkMatch(cpattern, skey);
            if (!matches) continue;
            matchSet.add(skey);
            ++i;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getCacheIDsInMemory/" + cacheInstance + "/Exiting. Number of matches found = " + i), (Object[])new Object[0]);
        }
        String[] cids = matchSet.toArray(new String[matchSet.size()]);
        return cids;
    }

    @Override
    public String[] getCacheIDsOnDisk(String cacheInstance, String pattern) throws AttributeNotFoundException {
        DCache cache1 = this.getCache(cacheInstance);
        if (!cache1.getSwapToDisk()) {
            Tr.error((TraceComponent)tc, (String)"DYNA1051E", (Object[])new Object[]{"getCacheIDsOnDisk", cacheInstance});
            throw new AttributeNotFoundException("Disk caching is not enabled.");
        }
        Pattern cpattern = this.checkPattern(pattern);
        ArrayList<String> matchSet = new ArrayList<String>(10);
        if (cache1.getIdsSizeDisk() > 0) {
            int index = 0;
            boolean more = false;
            do {
                more = false;
                Set diskSet = cache1.getIdsByRangeDisk(index, 100);
                if (diskSet != null && diskSet.contains("DISKCACHE_MORE")) {
                    more = true;
                }
                index = 1;
                diskSet.remove("DISKCACHE_MORE");
                for (Object key : diskSet) {
                    String skey = key.toString();
                    boolean matches = this.checkMatch(cpattern, skey);
                    if (!matches) continue;
                    matchSet.add(skey);
                }
            } while (more);
        }
        String[] cids = matchSet.toArray(new String[matchSet.size()]);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getCacheIDsOnDisk: Exiting. Number of matches found = " + matchSet.size()), (Object[])new Object[0]);
        }
        return cids;
    }

    @Override
    public String[] getCacheIDsInPushPullTable(String cacheInstance, String pattern) throws AttributeNotFoundException {
        DCache cache1 = this.getCache(cacheInstance);
        Pattern cpattern = this.checkPattern(pattern);
        ArrayList<String> matchSet = new ArrayList<String>(10);
        int count = 0;
        Object[] list = cache1.getCacheIdsInPushPullTable().toArray();
        for (int i = 0; i < list.length; ++i) {
            String skey = list[i].toString();
            boolean matches = this.checkMatch(cpattern, skey);
            if (!matches) continue;
            matchSet.add(skey);
            ++count;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getCacheIDsInPushPullTable/" + cacheInstance + "/Exiting. Number of matches found = " + count), (Object[])new Object[0]);
        }
        String[] cids = matchSet.toArray(new String[matchSet.size()]);
        return cids;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String[] invalidateCacheIDs(String cacheInstance, String pattern, boolean waitOnInvalidation) throws AttributeNotFoundException {
        String[] diskMatches;
        DCache cache1 = this.getCache(cacheInstance);
        if (pattern.equals("*")) {
            cache1.clear();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"invalidateCacheIDs: Exiting. Cleared memory and disk cache since input pattern is *", (Object[])new Object[0]);
            }
            return new String[]{"*"};
        }
        Pattern cpattern = this.checkPattern(pattern);
        ArrayList<String> invalidateSet = new ArrayList<String>();
        String[] memoryMatches = this.getCacheIDsInMemory(cacheInstance, pattern);
        if (null != memoryMatches) {
            for (int i = 0; i < memoryMatches.length; ++i) {
                invalidateSet.add(memoryMatches[i]);
            }
        }
        if (cache1.getSwapToDisk() && null != (diskMatches = this.getCacheIDsOnDisk(cacheInstance, pattern))) {
            void var9_12;
            boolean bl = false;
            while (var9_12 < diskMatches.length) {
                invalidateSet.add(diskMatches[var9_12]);
                ++var9_12;
            }
        }
        for (Object e : invalidateSet) {
            cache1.invalidateById(e, waitOnInvalidation);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("invalidateCacheIDs: Exiting. Number of matches found = " + invalidateSet.size()), (Object[])new Object[0]);
        }
        String[] stringArray = invalidateSet.toArray(new String[invalidateSet.size()]);
        return stringArray;
    }

    @Override
    public String getCacheEntry(String cacheInstance, String cacheId) throws AttributeNotFoundException {
        if (cacheId == null) {
            throw new AttributeNotFoundException(cacheId + " is null.");
        }
        DCache cache1 = this.getCache(cacheInstance);
        EntryInfo ei = new EntryInfo();
        ei.setId(cacheId);
        CacheEntry cacheEntry = cache1.getEntry(ei, true);
        String stringEntry = null;
        if (null != cacheEntry) {
            stringEntry = cacheEntry.toString();
            cacheEntry.finish();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getCacheEntry: Returning: " + stringEntry + " for cacheInstance = " + cacheInstance), (Object[])new Object[0]);
        }
        return stringEntry;
    }

    @Override
    public void clearCache(String cacheInstance) throws AttributeNotFoundException {
        DCache cache1 = this.getCache(cacheInstance);
        cache1.clear();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("clearCache: Exiting. Cleared memory and disk cache for cacheInstance = " + cacheInstance), (Object[])new Object[0]);
        }
    }

    @Override
    public String getCacheDigest(String cacheInstance, boolean useMemoryCacheDigest, boolean cacheIDOnly, boolean debug) throws AttributeNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getCacheDigest: cacheInstance=" + cacheInstance + " useMemoryCacheDigest=" + useMemoryCacheDigest + " cacheIDOnly=" + cacheIDOnly + " debug=" + debug), (Object[])new Object[0]);
        }
        DCache cache1 = this.getCache(cacheInstance);
        this.initMessageDigest();
        int totalHashcode = cache1.getMemoryCacheHashcode(debug, !cacheIDOnly);
        if (cacheIDOnly) {
            totalHashcode += cache1.getCacheIdsHashcodeInPushPullTable(debug);
        }
        if (!useMemoryCacheDigest) {
            try {
                totalHashcode += cache1.getDiskCacheHashcode(debug, !cacheIDOnly);
            }
            catch (DynamicCacheException e) {
                Tr.error((TraceComponent)tc, (String)"DYNA1053E", (Object[])new Object[]{"getCacheDigest", e.getMessage()});
                throw new AttributeNotFoundException(e.getMessage());
            }
        }
        String digest = MessageDigestUtility.processMessageDigestForData(messageDigest, totalHashcode);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getCacheDigest: Exiting. Entire cache hash in " + MESSAGE_DIGEST_ALGORITHM + " is " + digest + " for cacheInstance = " + cacheInstance));
        }
        return digest;
    }

    private void initMessageDigest() throws AttributeNotFoundException {
        if (messageDigest == null) {
            try {
                messageDigest = MessageDigestUtility.createMessageDigest(MESSAGE_DIGEST_ALGORITHM);
            }
            catch (NoSuchAlgorithmException e) {
                Tr.error((TraceComponent)tc, (String)"DYNA1044E", (Object[])new Object[]{e.getMessage()});
                throw new AttributeNotFoundException("Message digest for " + MESSAGE_DIGEST_ALGORITHM + " is not available. " + e.getMessage());
            }
        }
    }

    private DCache getCache(String cacheInstance) throws AttributeNotFoundException {
        if (cacheInstance == null) {
            Tr.error((TraceComponent)tc, (String)"DYNA1042E", (Object[])new Object[]{cacheInstance});
            throw new AttributeNotFoundException(cacheInstance + " is not a valid cache instance name.");
        }
        DCache cache = null;
        cache = cacheInstance.equals("baseCache") ? ServerCache.cache : ServerCache.getConfiguredCache(cacheInstance);
        if (cache == null) {
            Tr.error((TraceComponent)tc, (String)"DYNA1042E", (Object[])new Object[]{cacheInstance});
            throw new AttributeNotFoundException(cacheInstance + " is not a valid cache instance name.");
        }
        return cache;
    }

    private Pattern checkPattern(String pattern) throws AttributeNotFoundException {
        Pattern p = null;
        try {
            p = Pattern.compile(pattern);
        }
        catch (PatternSyntaxException pse) {
            Tr.error((TraceComponent)tc, (String)"DYNA1043E", (Object[])new Object[]{pattern, pse.getMessage()});
            throw new AttributeNotFoundException("The pattern " + pattern + " is not a valid regular expression. Caught PatternSyntaxException:" + pse.getMessage());
        }
        return p;
    }

    private boolean checkMatch(Pattern pattern, String key) {
        return pattern.matcher(key).find();
    }

    public static Map getCacheStatisticsMap(CacheStatistics cacheStatistics) {
        TreeMap<String, Number> stats = new TreeMap<String, Number>();
        if (cacheStatistics != null) {
            stats.put("CacheHits", cacheStatistics.getCacheHitsCount());
            stats.put("CacheLruRemoves", cacheStatistics.getCacheLruRemovesCount());
            stats.put("CacheMisses", cacheStatistics.getCacheMissesCount());
            stats.put("CacheRemoves", cacheStatistics.getCacheRemovesCount());
            stats.put("ExplicitInvalidationsFromMemory", cacheStatistics.getExplicitInvalidationsFromMemoryCount());
            stats.put("MemoryCacheEntries", cacheStatistics.getMemoryCacheEntriesCount());
            stats.put("MemoryCacheSizeInMB", Float.valueOf(cacheStatistics.getMemoryCacheSizeInMBCount()));
            stats.put("TimeoutInvalidationsFromMemory", cacheStatistics.getTimeoutInvalidationsFromMemoryCount());
            Map<String, Number> extendedStats = cacheStatistics.getExtendedStats();
            if (extendedStats != null) {
                stats.putAll(cacheStatistics.getExtendedStats());
            }
        }
        return stats;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo mbeanInfo = super.getMBeanInfo();
        MBeanOperationInfo[] existingMbeanOperationInfo = mbeanInfo.getOperations();
        MBeanOperationInfo getCacheInstanceNamesMbeanOperationInfo = this.createMbeanOperationInfo("getCacheInstanceNames", "[Ljava.lang.String;");
        MBeanOperationInfo getAllCacheStatisticsMbeanOperationInfo = this.createMbeanOperationInfo("getAllCacheStatistics", "[Ljava.lang.String;");
        MBeanOperationInfo getCacheStatisticNamesMbeanOperationInfo = this.createMbeanOperationInfo("getCacheStatisticNames", "[Ljava.lang.String;");
        MBeanOperationInfo getUsedCacheSizeMbeanOperationInfo = this.createMbeanOperationInfo("getUsedCacheSize", Integer.TYPE.getName());
        MBeanOperationInfo getCacheSizeMbeanOperationInfo = this.createMbeanOperationInfo("getCacheSize", Integer.TYPE.getName());
        MBeanOperationInfo getDiskOverflowMbeanOperationInfo = this.createMbeanOperationInfo("getDiskOverflow", Boolean.TYPE.getName());
        MBeanOperationInfo[] addedMbeanOperationInfo = new MBeanOperationInfo[]{getCacheInstanceNamesMbeanOperationInfo, getAllCacheStatisticsMbeanOperationInfo, getCacheStatisticNamesMbeanOperationInfo, getUsedCacheSizeMbeanOperationInfo, getCacheSizeMbeanOperationInfo, getDiskOverflowMbeanOperationInfo};
        MBeanOperationInfo[] modifiedMBeanOperationInfo = new MBeanOperationInfo[existingMbeanOperationInfo.length + addedMbeanOperationInfo.length];
        System.arraycopy(existingMbeanOperationInfo, 0, modifiedMBeanOperationInfo, 0, existingMbeanOperationInfo.length);
        System.arraycopy(addedMbeanOperationInfo, 0, modifiedMBeanOperationInfo, existingMbeanOperationInfo.length, addedMbeanOperationInfo.length);
        MBeanInfo nmbi = new MBeanInfo(this.getClass().getName(), mbeanInfo.getDescription(), null, mbeanInfo.getConstructors(), modifiedMBeanOperationInfo, mbeanInfo.getNotifications(), mbeanInfo.getDescriptor());
        return nmbi;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        Object o = null;
        try {
            Method m = this.getClass().getMethod(actionName, this.getParameterTypes(params));
            o = m.invoke((Object)this, params);
        }
        catch (SecurityException e) {
            throw new MBeanException(e);
        }
        catch (NoSuchMethodException e) {
            throw new MBeanException(e);
        }
        catch (IllegalArgumentException e) {
            throw new MBeanException(e);
        }
        catch (IllegalAccessException e) {
            throw new MBeanException(e);
        }
        catch (InvocationTargetException e) {
            throw new MBeanException(e);
        }
        return o;
    }

    Class<?>[] getParameterTypes(Object[] params) {
        Class[] parameterTypes = null;
        if (null != params) {
            parameterTypes = new Class[params.length];
            int i = 0;
            for (Object object : params) {
                parameterTypes[i++] = object.getClass();
            }
        }
        return parameterTypes;
    }

    public MBeanOperationInfo createMbeanOperationInfo(String operationName, String returnType) {
        MBeanOperationInfo addOperationInfo = new MBeanOperationInfo(operationName, "Operation exposed for management", null, returnType, 0);
        return addOperationInfo;
    }
}

