/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi.internal.common.services.OpenAPIEndpointProvider;
import io.openliberty.microprofile.openapi20.internal.utils.LoggingUtils;
import io.openliberty.microprofile.openapi20.internal.utils.ServerInfo;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ProxySupportUtil {
    private static final String HTTP_HEADER_REFERER = "Referer";
    private static final String DEFAULT_DOC_PATH = "/openapi";
    private static final String DEFAULT_UI_PATH = "/ui";
    private static final TraceComponent tc = Tr.register(ProxySupportUtil.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    static final long serialVersionUID = 7228303227547992470L;

    public static void processRequest(HttpServletRequest request, OpenAPIEndpointProvider openAPIEndpointProvider, ServerInfo serverInfo) {
        URL url = ProxySupportUtil.extractURL(request, openAPIEndpointProvider);
        if (url == null) {
            return;
        }
        serverInfo.setHost(url.getHost());
        Integer port = url.getPort() == -1 ? url.getDefaultPort() : url.getPort();
        if ("http".equalsIgnoreCase(url.getProtocol()) && port.intValue() != serverInfo.getHttpPort()) {
            serverInfo.setHttpPort(port);
            serverInfo.setHttpsPort(-1);
        } else if ("https".equalsIgnoreCase(url.getProtocol()) && port.intValue() != serverInfo.getHttpsPort()) {
            serverInfo.setHttpPort(-1);
            serverInfo.setHttpsPort(port);
        }
    }

    @FFDCIgnore(value={MalformedURLException.class})
    private static URL extractURL(HttpServletRequest request, OpenAPIEndpointProvider openAPIEndpointProvider) {
        URL url;
        block20: {
            String urlString;
            String refererHeader = request.getHeader(HTTP_HEADER_REFERER);
            String docPath = DEFAULT_DOC_PATH;
            String uiPath = docPath + DEFAULT_UI_PATH;
            if (openAPIEndpointProvider != null) {
                docPath = openAPIEndpointProvider.getOpenAPIDocUrl();
                uiPath = openAPIEndpointProvider.getOpenAPIUIUrl();
            }
            if (docPath == null) {
                docPath = DEFAULT_DOC_PATH;
            }
            if (uiPath == null) {
                uiPath = docPath + DEFAULT_UI_PATH;
            }
            if (refererHeader != null) {
                if (LoggingUtils.isEventEnabled(tc)) {
                    Tr.event((TraceComponent)tc, (String)("Using referer header to generate servers: " + refererHeader), (Object[])new Object[0]);
                }
                String string = refererHeader = refererHeader.endsWith("/") ? refererHeader.substring(0, refererHeader.length() - 1) : refererHeader;
                if (docPath.equals(DEFAULT_UI_PATH) && uiPath.equals("/openapi/ui")) {
                    if (!refererHeader.endsWith(DEFAULT_UI_PATH) && !refererHeader.endsWith(DEFAULT_DOC_PATH)) {
                        refererHeader = null;
                    }
                } else {
                    try {
                        URL refURL = new URL(refererHeader);
                        String refPath = refURL.getPath();
                        if (!refPath.equals(docPath) && !refPath.equals(uiPath)) {
                            refererHeader = null;
                        }
                    }
                    catch (MalformedURLException e) {
                        if (LoggingUtils.isEventEnabled(tc)) {
                            Tr.event((TraceComponent)tc, (String)("Failed to create URL for " + refererHeader + ": " + e.getMessage()), (Object[])new Object[0]);
                        }
                        refererHeader = null;
                    }
                }
                if (refererHeader != null) {
                    urlString = refererHeader;
                    if (LoggingUtils.isEventEnabled(tc)) {
                        Tr.event((TraceComponent)tc, (String)("Using Referer header to generate servers: " + urlString), (Object[])new Object[0]);
                    }
                } else {
                    urlString = request.getRequestURL().toString();
                    if (LoggingUtils.isEventEnabled(tc)) {
                        Tr.event((TraceComponent)tc, (String)("Unable to use Referer header, using request url to generate servers: " + urlString), (Object[])new Object[0]);
                    }
                }
            } else {
                urlString = request.getRequestURL().toString();
                if (LoggingUtils.isEventEnabled(tc)) {
                    Tr.event((TraceComponent)tc, (String)("Using request url to generate servers: " + urlString), (Object[])new Object[0]);
                }
            }
            url = null;
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException e) {
                if (!LoggingUtils.isEventEnabled(tc)) break block20;
                Tr.event((TraceComponent)tc, (String)("Failed to create URL for " + urlString + ": " + e.getMessage()), (Object[])new Object[0]);
            }
        }
        return url;
    }
}

