/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal.values;

import com.ibm.ws.http.channel.internal.values.AccessLogData;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.ws.http.internal.HttpDateFormatImpl;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;

public class AccessLogCurrentTime
extends AccessLogData {
    private static ThreadLocal<Long> accessLogDatetime = new ThreadLocal();

    public AccessLogCurrentTime() {
        super("%{t}W");
    }

    @Override
    public Object init(String rawToken) {
        if ("t".equals(rawToken)) {
            return null;
        }
        return rawToken;
    }

    @Override
    public boolean set(StringBuilder accessLogEntry, HttpResponseMessage response, HttpRequestMessage request, Object data) {
        if (data == null) {
            long currentTime = System.currentTimeMillis();
            String currentTimeFormatted = "[" + ((HttpDateFormatImpl)HttpDispatcher.getDateFormatter()).getNCSATime(currentTime, true) + "]";
            accessLogEntry.append(currentTimeFormatted);
            accessLogDatetime.set(currentTime);
        } else {
            accessLogEntry.append("%{").append(data).append("}W");
        }
        return true;
    }

    public static long getAccessLogCurrentTimeAsLong(HttpResponseMessage response, HttpRequestMessage request, Object data) {
        return accessLogDatetime.get();
    }
}

