/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.spi.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.spi.ResteasyConfiguration;
import org.jboss.resteasy.spi.config.ConfigurationFactory;
import org.jboss.resteasy.spi.config.SizeUnit;
import org.jboss.resteasy.spi.config.Threshold;
import org.jboss.resteasy.spi.util.Functions;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class Options<T> {
    public static final Options<Boolean> ENABLE_DEFAULT_EXCEPTION_MAPPER;
    public static final Options<Threshold> ENTITY_MEMORY_THRESHOLD;
    public static final Options<Threshold> ENTITY_FILE_THRESHOLD;
    public static final Options<Path> ENTITY_TMP_DIR;
    public static final Options<String> CLIENT_SSL_CONTEXT_ALGORITHM;
    public static final Options<Integer> SSE_CLOSED_RESPONSE_CODE;
    private final String key;
    private final Class<T> name;
    private final Supplier<T> dftValue;
    static final long serialVersionUID = 8362055660390029598L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected Options(String key, Class<T> name, Supplier<T> dftValue) {
        this.key = key;
        this.name = name;
        this.dftValue = dftValue;
    }

    public T getValue() {
        return Options.getProperty(this.key, this.name, this.dftValue);
    }

    public T getValue(ResteasyConfiguration configuration) {
        return Options.getProperty(configuration, this.key, this.name, this.dftValue);
    }

    public String name() {
        return this.key;
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Options)) {
            return false;
        }
        Options other = (Options)obj;
        return Objects.equals(this.key, other.key);
    }

    public String toString() {
        return "Option[name=" + this.key + ", type=" + this.name.getName() + "]";
    }

    protected static <T> T getProperty(String name, Class<T> returnType, Supplier<T> dft) {
        return Options.getProperty(name, returnType).orElseGet(dft);
    }

    private static <T> T getProperty(ResteasyConfiguration configuration, String name, Class<T> returnType, Supplier<T> dft) {
        return Options.getProperty(configuration, name, returnType).orElseGet(dft);
    }

    private static <T> Optional<T> getProperty(String name, Class<T> returnType) {
        return Options.getProperty(null, name, returnType);
    }

    private static <T> Optional<T> getProperty(ResteasyConfiguration configuration, String name, Class<T> returnType) {
        try {
            return ConfigurationFactory.getInstance().getConfiguration(configuration).getOptionalValue(name, returnType);
        }
        catch (Exception e) {
            LogMessages.LOGGER.tracef(e, "Failed to get property for %s of type %s.", name, returnType);
            return Optional.empty();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.spi.config.Options", Options.class, null, null);
        ENABLE_DEFAULT_EXCEPTION_MAPPER = new Options<Boolean>("dev.resteasy.exception.mapper", Boolean.class, Functions.singleton(() -> true));
        ENTITY_MEMORY_THRESHOLD = new Options<Threshold>("dev.resteasy.entity.memory.threshold", Threshold.class, Functions.singleton(() -> Threshold.of(5L, SizeUnit.MEGABYTE)));
        ENTITY_FILE_THRESHOLD = new Options<Threshold>("dev.resteasy.entity.file.threshold", Threshold.class, Functions.singleton(() -> Threshold.of(50L, SizeUnit.MEGABYTE)));
        ENTITY_TMP_DIR = new Options<Path>("dev.resteasy.entity.tmpdir", Path.class, Functions.singleton(() -> Path.of(System.getProperty("java.io.tmpdir"), new String[0]).toAbsolutePath()));
        CLIENT_SSL_CONTEXT_ALGORITHM = new Options<String>("dev.resteasy.client.ssl.context.algorithm", String.class, () -> "TLS");
        SSE_CLOSED_RESPONSE_CODE = new Options<Integer>("dev.resteasy.sse.closed.response.code", Integer.class, Functions.singleton(() -> 200));
    }
}

