/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.genericbnf.internal.BNFHeadersImpl;
import com.ibm.ws.http.channel.internal.HttpObjectFactory;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.http.channel.HttpTrailerGenerator;
import com.ibm.wsspi.http.channel.HttpTrailers;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;

public class HttpTrailersImpl
extends BNFHeadersImpl
implements HttpTrailers {
    private static final TraceComponent tc = Tr.register(HttpTrailersImpl.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private static final long serialVersionUID = -4872702714523122647L;
    private transient HttpObjectFactory myFactory = null;
    private transient Map<HeaderKeys, HttpTrailerGenerator> knownTGs = new HashMap<HeaderKeys, HttpTrailerGenerator>();

    @Override
    public void init(boolean useDirect, int outSize, int inSize, int cacheSize) {
        super.init(useDirect, outSize, inSize, cacheSize);
    }

    public void setFactory(HttpObjectFactory fact) {
        this.myFactory = fact;
    }

    @Override
    public boolean containsDeferredTrailer(String target) {
        HeaderKeys key = this.findKey(target, true);
        return key != null && this.containsDeferredTrailer(key);
    }

    @Override
    public boolean containsDeferredTrailer(HeaderKeys target) {
        if (null == target) {
            return false;
        }
        return this.knownTGs.containsKey(target);
    }

    @Override
    public void setDeferredTrailer(HeaderKeys hdr, HttpTrailerGenerator htg) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setDeferredTrailer(HeaderKeys): " + hdr), (Object[])new Object[0]);
        }
        if (null == hdr) {
            throw new IllegalArgumentException("Null header name");
        }
        if (null == htg) {
            throw new IllegalArgumentException("Null value generator");
        }
        this.knownTGs.put(hdr, htg);
    }

    @Override
    public void setDeferredTrailer(String hdr, HttpTrailerGenerator htg) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setDeferredTrailer(String): " + hdr), (Object[])new Object[0]);
        }
        if (null == hdr) {
            throw new IllegalArgumentException("Null header name");
        }
        if (null == htg) {
            throw new IllegalArgumentException("Null value generator");
        }
        this.knownTGs.put(this.findKey(hdr, false), htg);
    }

    @Override
    public void removeDeferredTrailer(String hdr) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("removeDeferredTrailer(String): " + hdr), (Object[])new Object[0]);
        }
        if (null == hdr) {
            throw new IllegalArgumentException("Null header name");
        }
        HeaderKeys key = this.findKey(hdr, true);
        if (key != null) {
            this.knownTGs.remove(key);
        }
    }

    @Override
    public void removeDeferredTrailer(HeaderKeys hdr) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("removeDeferredTrailer(HeaderKeys): " + hdr), (Object[])new Object[0]);
        }
        if (null == hdr) {
            throw new IllegalArgumentException("Null header name");
        }
        this.knownTGs.remove(hdr);
    }

    @Override
    public void computeRemainingTrailers() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"computeRemainingTrailers", (Object[])new Object[0]);
        }
        for (HeaderKeys key : this.knownTGs.keySet()) {
            this.setHeader(key, this.knownTGs.get(key).generateTrailerValue(key, (HttpTrailers)this));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"computeRemainingTrailers");
        }
    }

    @Override
    public void destroy() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Destroy trailers: " + this), (Object[])new Object[0]);
        }
        super.destroy();
        if (null != this.myFactory) {
            this.myFactory.releaseTrailers(this);
            this.myFactory = null;
        }
    }

    public HttpTrailersImpl duplicate() {
        if (null == this.myFactory) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Null factory, unable to duplicate: " + this), (Object[])new Object[0]);
            }
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Duplicating the trailer headers: " + this), (Object[])new Object[0]);
        }
        this.computeRemainingTrailers();
        HttpTrailersImpl msg = this.myFactory.getTrailers();
        super.duplicate(msg);
        return msg;
    }

    @Override
    public void readExternal(ObjectInput s) throws IOException, ClassNotFoundException {
        super.readExternal(s);
    }

    @Override
    public void writeExternal(ObjectOutput s) throws IOException {
        this.computeRemainingTrailers();
        super.writeExternal(s);
    }

    @Override
    protected HeaderKeys findKey(byte[] data, int offset, int length, boolean returnNullForInvalidName) {
        return HttpHeaderKeys.find(data, offset, length, returnNullForInvalidName);
    }

    @Override
    protected HeaderKeys findKey(byte[] name, boolean returnNullForInvalidName) {
        return HttpHeaderKeys.find(name, 0, name.length, returnNullForInvalidName);
    }

    @Override
    protected HeaderKeys findKey(String name, boolean returnNullForInvalidName) {
        return HttpHeaderKeys.find(name, returnNullForInvalidName);
    }
}

