/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.resolver.FeatureResolver;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RestrictedFeatureRespository
implements FeatureResolver.Repository {
    private final FeatureResolver.Repository repo;
    private final Collection<String> restricted;
    private final Collection<String> restrictedAttempts;
    static final long serialVersionUID = 5500720695731790429L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public RestrictedFeatureRespository(FeatureResolver.Repository repo, Collection<String> restricted) {
        this.repo = repo;
        this.restricted = restricted;
        this.restrictedAttempts = new ArrayList<String>();
    }

    @Override
    public Collection<ProvisioningFeatureDefinition> getAutoFeatures() {
        return this.repo.getAutoFeatures();
    }

    @Override
    public List<String> getConfiguredTolerates(String baseSymbolicName) {
        return this.repo.getConfiguredTolerates(baseSymbolicName);
    }

    public static List<ProvisioningFeatureDefinition> select(FeatureResolver.Repository repository, FeatureResolver.Selector<ProvisioningFeatureDefinition> selector) {
        return RestrictedFeatureRespository.select(repository.getFeatures(), selector);
    }

    public static List<ProvisioningFeatureDefinition> select(List<ProvisioningFeatureDefinition> defs, FeatureResolver.Selector<ProvisioningFeatureDefinition> selector) {
        ArrayList<ProvisioningFeatureDefinition> selected = new ArrayList<ProvisioningFeatureDefinition>(defs.size());
        for (ProvisioningFeatureDefinition def : defs) {
            if (selector != null && !selector.test(def)) continue;
            selected.add(def);
        }
        return selected;
    }

    @Override
    public List<ProvisioningFeatureDefinition> getFeatures() {
        return RestrictedFeatureRespository.select(this.repo, new FeatureResolver.Selector<ProvisioningFeatureDefinition>(){
            static final long serialVersionUID = 6726114037615190768L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public boolean test(ProvisioningFeatureDefinition def) {
                return !RestrictedFeatureRespository.this.restricted.contains(def.getSymbolicName());
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.RestrictedFeatureRespository$1", 1.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
            }
        });
    }

    @Override
    public ProvisioningFeatureDefinition getFeature(String featureName) {
        ProvisioningFeatureDefinition featureDef = this.repo.getFeature(featureName);
        if (featureDef == null) {
            return null;
        }
        String featureSymName = featureDef.getSymbolicName();
        if (!this.restricted.contains(featureSymName)) {
            return featureDef;
        }
        if (!this.restrictedAttempts.contains(featureSymName)) {
            this.restrictedAttempts.add(featureSymName);
        }
        return null;
    }

    Collection<String> getRestrictedFeatureAttempts() {
        return this.restrictedAttempts;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.RestrictedFeatureRespository", RestrictedFeatureRespository.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
    }
}

