/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ffdc;

import com.ibm.ws.ffdc.DiagnosticModule;
import com.ibm.wsspi.logging.IncidentForwarder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class FFDC {
    private static Map<String, DiagnosticModule> modules = new HashMap<String, DiagnosticModule>();
    private static final Set<IncidentForwarder> forwarders = new HashSet<IncidentForwarder>();

    public static int registerDiagnosticModule(DiagnosticModule diagnosticModule, String packageName) {
        if (modules.containsKey(packageName)) {
            return 1;
        }
        try {
            diagnosticModule.init();
        }
        catch (Throwable th) {
            return 3;
        }
        modules.put(packageName, diagnosticModule);
        return 0;
    }

    public static boolean deregisterDiagnosticModule(String packageName) {
        if (modules.containsKey(packageName)) {
            modules.remove(packageName);
            return true;
        }
        return false;
    }

    public static Map<String, DiagnosticModule> getDiagnosticModuleMap() {
        return modules;
    }

    public static boolean registerIncidentForwarder(IncidentForwarder forwarder) {
        return forwarders.add(forwarder);
    }

    public static boolean deregisterIncidentForwarder(IncidentForwarder forwarder) {
        return forwarders.remove(forwarder);
    }

    public static Set<IncidentForwarder> getIncidentForwarders() {
        return forwarders;
    }
}

