/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPException;
import com.ibm.ws.sib.processor.exceptions.SIMPRuntimeOperationFailedException;
import com.ibm.ws.sib.processor.gd.AIRequestedTick;
import com.ibm.ws.sib.processor.gd.AIStream;
import com.ibm.ws.sib.processor.gd.AIValueTick;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.processor.impl.exceptions.InvalidOperationException;
import com.ibm.ws.sib.processor.impl.store.itemstreams.AIProtocolItemStream;
import com.ibm.ws.sib.processor.runtime.SIMPRemoteMessageRequestControllable;
import com.ibm.ws.sib.processor.runtime.SIMPRequestMessageInfo;
import com.ibm.ws.sib.processor.runtime.SIMPRequestedValueMessageInfo;
import com.ibm.ws.sib.processor.runtime.anycast.RequestMessageInfo;
import com.ibm.ws.sib.processor.runtime.anycast.RequestedValueMessageInfo;
import com.ibm.ws.sib.processor.runtime.impl.AbstractControlAdapter;
import com.ibm.ws.sib.transactions.PersistentTranId;
import com.ibm.ws.sib.utils.ras.SibTr;

public class RemoteMessageRequest
extends AbstractControlAdapter
implements SIMPRemoteMessageRequestControllable {
    private long _tick;
    private AIStream _aiStream;
    private AIProtocolItemStream _aiProtocolItemStream;
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register(RemoteMessageRequest.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public RemoteMessageRequest(long tick, AIStream aiStream) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"RemoteMessageRequest", (Object)new Object[]{new Long(tick), aiStream});
        }
        this._tick = tick;
        this._aiStream = aiStream;
        this._aiProtocolItemStream = aiStream.getAIProtocolItemStream();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"RemoteMessageRequest", (Object)this);
        }
    }

    private TickRange getTickRange() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTickRange");
        }
        TickRange tr = this._aiStream.getTickRange(this._tick);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTickRange", (Object)tr);
        }
        return tr;
    }

    public JsMessage getJsMessage() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getJsMessage");
        }
        InvalidOperationException finalE = new InvalidOperationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"RemoteMessageRequest.getJsMessage", "1:127:1.34", this}, null));
        SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getJsMessage");
        }
        throw finalE;
    }

    public String getState() throws SIMPException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getState");
        }
        String state = this.getState(this.getTickRange());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getState", (Object)state);
        }
        return state;
    }

    private String getState(TickRange tickRange) throws SIMPException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getState", (Object)tickRange);
        }
        String state = null;
        byte tickState = tickRange.type;
        switch (tickState) {
            case 1: {
                state = SIMPRemoteMessageRequestControllable.State.REQUEST.toString();
                break;
            }
            case 5: {
                state = SIMPRemoteMessageRequestControllable.State.ACKNOWLEDGED.toString();
                break;
            }
            case 6: {
                state = SIMPRemoteMessageRequestControllable.State.REJECT.toString();
                break;
            }
            case 3: {
                state = SIMPRemoteMessageRequestControllable.State.VALUE.toString();
                break;
            }
            case 7: {
                state = SIMPRemoteMessageRequestControllable.State.COMPLETED.toString();
            }
        }
        if (state == null) {
            SIMPException e = new SIMPException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"RemoteMessageRequest.getState", "1:199:1.34", this}, null));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getState");
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getState", (Object)state);
        }
        return state;
    }

    public long getStartTick() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStartTick");
        }
        long startTick = this.getTickRange().startstamp;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStartTick", (Object)new Long(startTick));
        }
        return startTick;
    }

    public long getEndTick() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getEndTick");
        }
        long endTick = this.getTickRange().endstamp;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getEndTick", (Object)new Long(endTick));
        }
        return endTick;
    }

    public void moveMessage(boolean discard) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeMessage", (Object)new Boolean(discard));
        }
        InvalidOperationException finalE = new InvalidOperationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"RemoteMessageRequest.removeMessage", "1:259:1.34", this}, null));
        SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeMessage", (Object)((Object)finalE));
        }
        throw finalE;
    }

    public String getId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getId");
            SibTr.exit((TraceComponent)tc, (String)"getId", (Object)("" + this.getTick()));
        }
        return "" + this.getTick();
    }

    public String getName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getName");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"No implementation");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getName", null);
        }
        return null;
    }

    @Override
    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assertValidControllable");
        }
        if (this.getTick() == -1L) {
            SIMPControllableNotFoundException finalE = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"RemoteMessageRequest.assertValidControllable", "1:312:1.34", new Long(this.getTick())}, null));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"assertValidControllable");
            }
            throw finalE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assertValidControllable");
        }
    }

    @Override
    public void dereferenceControllable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"dereferenceControllable", (Object)"No implementation");
        }
    }

    @Override
    public void registerControlAdapterAsMBean() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"registerControlAdapterAsMBean", (Object)"No implementation");
        }
    }

    @Override
    public void deregisterControlAdapterMBean() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"deregisterControlAdapterMBean", (Object)"No implementation");
        }
    }

    @Override
    public void runtimeEventOccurred(RuntimeEvent event) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"runtimeEventOccurred", (Object)"No implementation");
        }
    }

    public String getTransactionId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTransactionId");
        }
        String tranID = null;
        PersistentTranId pTranID = this._aiProtocolItemStream.getTransactionId();
        if (pTranID != null) {
            tranID = pTranID.toTMString();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTransactionId", (Object)tranID);
        }
        return tranID;
    }

    public SIMPRequestMessageInfo getRequestMessageInfo() throws SIMPRuntimeOperationFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRequestMessageInfo");
        }
        RequestMessageInfo requestMessageInfo = null;
        try {
            if (SIMPRemoteMessageRequestControllable.State.REQUEST.toString().equals(this.getState())) {
                TickRange tickRange = this._aiStream.getTickRange(this._tick);
                requestMessageInfo = new RequestMessageInfo((AIRequestedTick)tickRange.value);
            }
        }
        catch (SIMPException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.RemoteMessageRequest.getRequestMessageInfo", (String)"1:407:1.34", (Object)this);
            SIMPRuntimeOperationFailedException e1 = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"RemoteMessageRequest.getRequestMessageInfo", "1:415:1.34", e, this._aiStream.getStreamId()}, null), (Throwable)e);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e1));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getRequestMessageInfo", (Object)((Object)e1));
            }
            throw e1;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRequestMessageInfo", requestMessageInfo);
        }
        return requestMessageInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIMPRequestedValueMessageInfo getRequestedValueMessageInfo() throws SIMPRuntimeOperationFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRequestedValueMessageInfo");
        }
        RequestedValueMessageInfo requestedValueMessageInfo = null;
        try {
            TickRange tickRange;
            TickRange tickRange2 = tickRange = this.getTickRange();
            synchronized (tickRange2) {
                if (SIMPRemoteMessageRequestControllable.State.VALUE.toString().equals(this.getState(tickRange))) {
                    requestedValueMessageInfo = new RequestedValueMessageInfo((AIValueTick)tickRange.value);
                }
            }
        }
        catch (SIMPException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.RemoteMessageRequest.getRequestedValueMessageInfo", (String)"1:456:1.34", (Object)this);
            SIMPRuntimeOperationFailedException e1 = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"RemoteMessageRequest.getRequestedValueMessageInfo", "1:464:1.34", e, this._aiStream.getStreamId()}, null), (Throwable)e);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e1));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getRequestedValueMessageInfo", (Object)((Object)e1));
            }
            throw e1;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRequestedValueMessageInfo", (Object)requestedValueMessageInfo);
        }
        return requestedValueMessageInfo;
    }

    public long getTick() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTick");
            SibTr.exit((TraceComponent)tc, (String)"getTick", (Object)new Long(this._tick));
        }
        return this._tick;
    }

    @Override
    public String getRemoteEngineUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteEngineUuid");
        }
        String remoteUUID = this._aiStream.getAnycastInputHandler().getLocalisationUuid().toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteEngineUuid", (Object)remoteUUID);
        }
        return remoteUUID;
    }

    public long getMEArrivalTimestamp() throws SIMPControllableNotFoundException, SIMPException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMEArrivalTimestamp");
        }
        long timestamp = this.getJsMessage().getCurrentMEArrivalTimestamp();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMEArrivalTimestamp", (Object)new Long(timestamp));
        }
        return timestamp;
    }
}

