/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.injection;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.jaxrs20.injection.InjectionRuntimeContextHelper;
import com.ibm.ws.jaxrs20.injection.metadata.InjectionRuntimeContext;
import com.ibm.ws.kernel.service.util.SecureAction;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HttpServletRequestInjectionProxy
extends HttpServletRequestWrapper {
    private static final TraceComponent tc = Tr.register(HttpServletRequestInjectionProxy.class, (String)"JaxRsCommon", (String)"com.ibm.ws.jaxrs20.internal.resources.JaxRsCommonMessages");
    static final SecureAction priv = (SecureAction)AccessController.doPrivileged(SecureAction.get());
    private static final Class<?> contextClass = HttpServletRequest.class;
    static final long serialVersionUID = 6708217866328724667L;

    public HttpServletRequestInjectionProxy() {
        super((HttpServletRequest)Proxy.newProxyInstance(priv.getClassLoader(contextClass), new Class[]{contextClass}, new InvocationHandler(){
            static final long serialVersionUID = -8467338610097015673L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            @ManualTrace
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                HttpServletRequest context;
                Object result = null;
                if ("toString".equals(method.getName()) && method.getParameterTypes().length == 0) {
                    result = "Injection Proxy for " + contextClass.getName();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("invoke - toString " + result), (Object[])new Object[0]);
                    }
                    return result;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)("invoke " + method + " "), (Object[])args);
                }
                if ((context = HttpServletRequestInjectionProxy.getHttpServletRequest()) != null) {
                    result = method.invoke((Object)context, args);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("invoke " + result));
                }
                return result;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxrs20.injection.HttpServletRequestInjectionProxy$1", 1.class, (String)"JaxRsCommon", (String)"com.ibm.ws.jaxrs20.internal.resources.JaxRsCommonMessages");
            }
        }));
    }

    @ManualTrace
    private static HttpServletRequest getHttpServletRequest() {
        String methodName = "getHttpServletRequest";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getHttpServletRequest", (Object[])new Object[0]);
        }
        InjectionRuntimeContext runtimeContext = InjectionRuntimeContextHelper.getRuntimeContext();
        Object context = runtimeContext.getRuntimeCtxObject(contextClass.getName());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getHttpServletRequest", (Object)context);
        }
        return (HttpServletRequest)context;
    }

    public String toString() {
        return "Injection Proxy for " + contextClass.getName();
    }

    public ServletRequest getRequest() {
        return HttpServletRequestInjectionProxy.getHttpServletRequest();
    }

    public boolean isWrapperFor(Class wrappedType) {
        if (!ServletRequest.class.isAssignableFrom(wrappedType)) {
            throw new IllegalArgumentException("Given class " + wrappedType.getName() + " not a subinterface of " + ServletRequest.class.getName());
        }
        HttpServletRequest request = HttpServletRequestInjectionProxy.getHttpServletRequest();
        if (request != null) {
            Class wrappedServletType = wrappedType;
            if (wrappedServletType.isAssignableFrom(request.getClass())) {
                return true;
            }
            if (request instanceof ServletRequestWrapper) {
                return ((ServletRequestWrapper)request).isWrapperFor(wrappedType);
            }
        }
        return false;
    }

    public boolean isWrapperFor(ServletRequest wrapped) {
        HttpServletRequest request = HttpServletRequestInjectionProxy.getHttpServletRequest();
        if (request != null) {
            if (request == wrapped) {
                return true;
            }
            if (request instanceof ServletRequestWrapper) {
                return ((ServletRequestWrapper)request).isWrapperFor(wrapped);
            }
        }
        return false;
    }

    public void setRequest(ServletRequest request) {
        throw new UnsupportedOperationException("ServletRequest may not be set on this proxy");
    }
}

