/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.ejb.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.managedobject.ManagedObjectContext;
import com.ibm.ws.managedobject.ManagedObjectInvocationContext;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InterceptionType;
import jakarta.enterprise.inject.spi.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.weld.bean.CommonBean;
import org.jboss.weld.construction.api.WeldCreationalContext;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.serialization.spi.BeanIdentifier;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class InterceptorChain
implements InvocationContext {
    private final InvocationContext delegateInvocationContext;
    private final List<Interceptor<?>> interceptors;
    private int nextInterceptor = 0;
    private final BeanManager beanManager;
    private final InterceptionType interceptionType;
    private final WeldCreationalContext<?> creationalContext;
    private final ConcurrentHashMap<BeanIdentifier, Object> activeInterceptors;
    private static final TraceComponent tc = Tr.register(InterceptorChain.class, (String)"JCDI", (String)"com.ibm.ws.cdi.ejb.resources.CDIEJB");
    static final long serialVersionUID = 8045310852278415222L;

    public InterceptorChain(InterceptionType interceptionType, InvocationContext delegateInvocationContext, List<Interceptor<?>> interceptors, BeanManager beanManager, ConcurrentHashMap<BeanIdentifier, Object> activeInterceptors) {
        this.interceptionType = interceptionType;
        this.delegateInvocationContext = delegateInvocationContext;
        this.interceptors = interceptors;
        this.beanManager = beanManager;
        this.activeInterceptors = activeInterceptors;
        ManagedObjectInvocationContext managedObjectInvocationContext = (ManagedObjectInvocationContext)delegateInvocationContext;
        ManagedObjectContext managedObjectContext = managedObjectInvocationContext.getManagedObjectContext();
        this.creationalContext = (WeldCreationalContext)managedObjectContext.getContextData(WeldCreationalContext.class);
    }

    public Object getTarget() {
        return this.delegateInvocationContext.getTarget();
    }

    public Object getTimer() {
        return this.delegateInvocationContext.getTimer();
    }

    public Method getMethod() {
        return this.delegateInvocationContext.getMethod();
    }

    public Constructor<?> getConstructor() {
        return this.delegateInvocationContext.getConstructor();
    }

    public Object[] getParameters() {
        return this.delegateInvocationContext.getParameters();
    }

    public void setParameters(Object[] paramArrayOfObject) {
        this.delegateInvocationContext.setParameters(paramArrayOfObject);
    }

    public Map<String, Object> getContextData() {
        return this.delegateInvocationContext.getContextData();
    }

    public Object proceed() throws Exception {
        Object rc = null;
        rc = this.nextInterceptor < this.interceptors.size() ? this.invokeNextInterceptor() : this.delegateInvocationContext.proceed();
        return rc;
    }

    /*
     * WARNING - void declaration
     */
    private <S> Object invokeNextInterceptor() throws Exception {
        Object rc = null;
        Interceptor<?> interceptor = this.interceptors.get(this.nextInterceptor);
        Object interceptorInstance = null;
        CommonBean commonBean = null;
        if (interceptor instanceof CommonBean) {
            commonBean = (CommonBean)interceptor;
            interceptorInstance = this.activeInterceptors.get(commonBean.getIdentifier());
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Interceptor " + interceptor.getName() + " : " + interceptor.getBeanClass() + " was not a CommonBean"), (Object[])new Object[0]);
        }
        if (interceptorInstance == null) {
            Object previous;
            interceptorInstance = this.beanManager.getReference(interceptor, (Type)interceptor.getBeanClass(), this.creationalContext);
            if (commonBean != null && (previous = this.activeInterceptors.putIfAbsent(commonBean.getIdentifier(), interceptorInstance)) != null) {
                interceptorInstance = previous;
            }
        }
        ++this.nextInterceptor;
        try {
            rc = interceptor.intercept(this.interceptionType, interceptorInstance, (InvocationContext)this);
        }
        catch (WeldException previous) {
            void e;
            FFDCFilter.processException((Throwable)previous, (String)"com.ibm.ws.cdi.ejb.impl.InterceptorChain", (String)"157", (Object)this, (Object[])new Object[0]);
            Throwable t = e.getCause();
            if (t != null && t instanceof Exception) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Unwrapping a WeldException", (Object[])new Object[0]);
                }
                throw (Exception)t;
            }
            throw e;
        }
        return rc;
    }
}

