/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.common;

import io.opentelemetry.api.common.AttributeType;
import io.opentelemetry.api.internal.InternalAttributeKeyImpl;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface AttributeKey<T> {
    public String getKey();

    public AttributeType getType();

    public static AttributeKey<String> stringKey(String key) {
        return InternalAttributeKeyImpl.create((String)key, (AttributeType)AttributeType.STRING);
    }

    public static AttributeKey<Boolean> booleanKey(String key) {
        return InternalAttributeKeyImpl.create((String)key, (AttributeType)AttributeType.BOOLEAN);
    }

    public static AttributeKey<Long> longKey(String key) {
        return InternalAttributeKeyImpl.create((String)key, (AttributeType)AttributeType.LONG);
    }

    public static AttributeKey<Double> doubleKey(String key) {
        return InternalAttributeKeyImpl.create((String)key, (AttributeType)AttributeType.DOUBLE);
    }

    public static AttributeKey<List<String>> stringArrayKey(String key) {
        return InternalAttributeKeyImpl.create((String)key, (AttributeType)AttributeType.STRING_ARRAY);
    }

    public static AttributeKey<List<Boolean>> booleanArrayKey(String key) {
        return InternalAttributeKeyImpl.create((String)key, (AttributeType)AttributeType.BOOLEAN_ARRAY);
    }

    public static AttributeKey<List<Long>> longArrayKey(String key) {
        return InternalAttributeKeyImpl.create((String)key, (AttributeType)AttributeType.LONG_ARRAY);
    }

    public static AttributeKey<List<Double>> doubleArrayKey(String key) {
        return InternalAttributeKeyImpl.create((String)key, (AttributeType)AttributeType.DOUBLE_ARRAY);
    }
}

