/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.richclient.impl;

import com.ibm.websphere.channelfw.ChainData;
import com.ibm.websphere.channelfw.FlowType;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.jfapchannel.ConversationMetaData;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.channelfw.ConnectionLink;
import com.ibm.wsspi.tcpchannel.SSLConnectionContext;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import java.net.InetAddress;
import javax.net.ssl.SSLSession;

public class ConversationMetaDataImpl
implements ConversationMetaData {
    private static final TraceComponent tc = SibTr.register(ConversationMetaData.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private String chainName;
    private boolean isInbound;
    private ConnectionLink baseLink;

    public ConversationMetaDataImpl(ChainData chainData, ConnectionLink baseLink) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{chainData, baseLink});
        }
        this.chainName = chainData.getName();
        this.isInbound = chainData.getType() == FlowType.INBOUND;
        this.baseLink = baseLink;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("chainName=" + this.chainName + "\nisInbound=" + this.isInbound));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    public String getChainName() {
        return this.chainName;
    }

    @Override
    public boolean isInbound() {
        return this.isInbound;
    }

    @Override
    public InetAddress getRemoteAddress() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getRemoteAddress");
        }
        InetAddress result = null;
        TCPConnectionContext tcpContext = null;
        ConnectionLink connLinkRef = this.baseLink.getDeviceLink();
        if (connLinkRef != null && (tcpContext = (TCPConnectionContext)connLinkRef.getChannelAccessor()) != null) {
            result = tcpContext.getRemoteAddress();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getRemoteAddress", (Object)result);
        }
        return result;
    }

    @Override
    public int getRemotePort() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getRemotePort");
        }
        int portNumber = 0;
        TCPConnectionContext tcpContext = null;
        ConnectionLink connLinkRef = this.baseLink.getDeviceLink();
        if (connLinkRef != null && (tcpContext = (TCPConnectionContext)connLinkRef.getChannelAccessor()) != null) {
            portNumber = tcpContext.getRemotePort();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getRemotePort", (Object)("" + portNumber));
        }
        return portNumber;
    }

    @Override
    public SSLSession getSSLSession() {
        SSLConnectionContext sslConnCtx;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getSSLSession");
        }
        SSLSession sslSession = null;
        TCPConnectionContext tcpContext = null;
        ConnectionLink connLinkRef = this.baseLink.getDeviceLink();
        if (connLinkRef != null && (tcpContext = (TCPConnectionContext)connLinkRef.getChannelAccessor()) != null && (sslConnCtx = tcpContext.getSSLContext()) != null) {
            sslSession = sslConnCtx.getSession();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getSSLSession", sslSession);
        }
        return sslSession;
    }
}

