/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.utils;

import com.ibm.ws.microprofile.openapi.impl.parser.processors.SchemaProcessor;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIModelFilter;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIModelFilterAdapter;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIModelVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.info.Contact;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.info.License;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Discriminator;
import org.eclipse.microprofile.openapi.models.media.Encoding;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.media.XML;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.security.OAuthFlow;
import org.eclipse.microprofile.openapi.models.security.OAuthFlows;
import org.eclipse.microprofile.openapi.models.security.Scopes;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.servers.ServerVariable;
import org.eclipse.microprofile.openapi.models.servers.ServerVariables;
import org.eclipse.microprofile.openapi.models.tags.Tag;

public final class OpenAPIModelWalker {
    private final OpenAPI openAPI;

    public OpenAPIModelWalker(OpenAPI openAPI) {
        this.openAPI = openAPI;
    }

    public void accept(OpenAPIModelVisitor visitor) {
        this.accept(visitor, true);
    }

    public void accept(OpenAPIModelVisitor visitor, boolean previsit) {
        if (visitor != null && this.openAPI != null) {
            new Walker(this.openAPI, visitor, previsit).traverseOpenAPI();
        }
    }

    public void accept(OpenAPIModelFilter visitor) {
        this.accept(visitor, true);
    }

    public void accept(OpenAPIModelFilter visitor, boolean previsit) {
        if (visitor != null && this.openAPI != null) {
            new Walker(this.openAPI, visitor, previsit).traverseOpenAPI();
        }
    }

    static final class Walker
    implements Context {
        private final OpenAPI openAPI;
        private final OpenAPIModelFilter visitor;
        private final boolean previsit;
        private final Deque<Object> ancestors = new LinkedList<Object>();
        private final Deque<String> pathSegments = new LinkedList<String>();
        private final IdentityHashMap<Object, Object> traversedObjects = new IdentityHashMap();

        public Walker(OpenAPI openAPI, OpenAPIModelVisitor visitor, boolean previsit) {
            this(openAPI, new OpenAPIModelFilterAdapter(visitor), previsit);
        }

        public Walker(OpenAPI openAPI, OpenAPIModelFilter visitor, boolean previsit) {
            this.openAPI = openAPI;
            this.visitor = visitor;
            this.previsit = previsit;
        }

        @Override
        public OpenAPI getModel() {
            return this.openAPI;
        }

        @Override
        public Object getParent() {
            return this.ancestors.peek();
        }

        @Override
        public String getLocation() {
            return this.getLocation(null);
        }

        @Override
        public String getLocation(String suffix) {
            Iterator<String> i = this.pathSegments.descendingIterator();
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            while (i.hasNext()) {
                if (!first) {
                    sb.append('/');
                }
                sb.append(this.escapeJSONPointerPathSegment(i.next()));
                first = false;
            }
            if (suffix != null && !suffix.isEmpty()) {
                sb.append('/');
                sb.append(this.escapeJSONPointerPathSegment(suffix));
            }
            return sb.toString();
        }

        private String escapeJSONPointerPathSegment(String pathSegment) {
            pathSegment = String.valueOf(pathSegment);
            return pathSegment.replace("~", "~0").replace("/", "~1");
        }

        public boolean isTraversed(Object o) {
            if (o == null) {
                return true;
            }
            return this.traversedObjects.put(o, o) != null;
        }

        public void traverseOpenAPI() {
            List tags;
            List servers;
            List security;
            Paths paths;
            Info info;
            ExternalDocumentation extDocs;
            Map extensions;
            this.pathSegments.push("#");
            if (this.previsit) {
                this.visitor.visitOpenAPI(this);
            }
            this.ancestors.push(this.openAPI);
            Components components = this.openAPI.getComponents();
            if (components != null) {
                this.pathSegments.push("components");
                Components c = this.traverseComponents(components);
                if (c != components) {
                    this.openAPI.setComponents(c);
                }
                this.pathSegments.pop();
            }
            if ((extensions = this.openAPI.getExtensions()) != null) {
                this.processExtensions(extensions);
            }
            if ((extDocs = this.openAPI.getExternalDocs()) != null) {
                this.pathSegments.push("externalDocs");
                ExternalDocumentation e = this.traverseExternalDocs(extDocs);
                if (e != extDocs) {
                    this.openAPI.setExternalDocs(e);
                }
                this.pathSegments.pop();
            }
            if ((info = this.openAPI.getInfo()) != null) {
                this.pathSegments.push("info");
                Info i = this.traverseInfo(info);
                if (i != info) {
                    this.openAPI.setInfo(info);
                }
                this.pathSegments.pop();
            }
            if ((paths = this.openAPI.getPaths()) != null) {
                this.pathSegments.push("paths");
                Paths p = this.traversePaths(paths);
                if (p != paths) {
                    this.openAPI.setPaths(p);
                }
                this.pathSegments.pop();
            }
            if ((security = this.openAPI.getSecurity()) != null) {
                this.processSecurityRequirements(security);
            }
            if ((servers = this.openAPI.getServers()) != null) {
                this.processServers(servers);
            }
            if ((tags = this.openAPI.getTags()) != null) {
                this.processTags(tags);
            }
            this.ancestors.pop();
            if (!this.previsit) {
                this.visitor.visitOpenAPI(this);
            }
            this.pathSegments.pop();
            this.ancestors.clear();
            this.pathSegments.clear();
            this.traversedObjects.clear();
        }

        public Components traverseComponents(Components components) {
            Map schemes;
            Map schemas;
            Map responses;
            Map requestBodies;
            Map parameters;
            Map links;
            Map headers;
            Map extensions;
            Map examples;
            if (this.isTraversed(components)) {
                return components;
            }
            if (this.previsit && (components = this.visitor.visitComponents(this, components)) == null) {
                return null;
            }
            this.ancestors.push(components);
            Map callbacks = components.getCallbacks();
            if (callbacks != null) {
                this.processCallbacks(callbacks);
            }
            if ((examples = components.getExamples()) != null) {
                this.processExamples(examples);
            }
            if ((extensions = components.getExtensions()) != null) {
                this.processExtensions(extensions);
            }
            if ((headers = components.getHeaders()) != null) {
                this.processHeaders(headers);
            }
            if ((links = components.getLinks()) != null) {
                this.processLinks(links);
            }
            if ((parameters = components.getParameters()) != null) {
                this.processParameters(parameters);
            }
            if ((requestBodies = components.getRequestBodies()) != null) {
                this.processRequestBodies(requestBodies);
            }
            if ((responses = components.getResponses()) != null) {
                this.processResponses(responses);
            }
            if ((schemas = components.getSchemas()) != null) {
                this.processSchemas(schemas, "schemas");
            }
            if ((schemes = components.getSecuritySchemes()) != null) {
                this.processSecuritySchemes(schemes);
            }
            this.ancestors.pop();
            if (!this.previsit) {
                components = this.visitor.visitComponents(this, components);
            }
            return components;
        }

        public Callback traverseCallback(String key, Callback callback) {
            if (this.isTraversed(callback)) {
                return callback;
            }
            if (this.previsit && (callback = this.visitor.visitCallback(this, key, callback)) == null) {
                return null;
            }
            this.ancestors.push(callback);
            Map extensions = callback.getExtensions();
            if (extensions != null) {
                this.processExtensions(extensions);
            }
            Map updates = this.map();
            callback.forEach((k, v) -> {
                this.pathSegments.push((String)k);
                PathItem p = this.traversePathItem((String)k, (PathItem)v);
                if (p != v) {
                    updates.put(k, p);
                }
                this.pathSegments.pop();
            });
            if (updates.size() > 0) {
                this.updateMap((Map)callback, updates);
            }
            this.ancestors.pop();
            if (!this.previsit) {
                callback = this.visitor.visitCallback(this, key, callback);
            }
            return callback;
        }

        public PathItem traversePathItem(String key, PathItem item) {
            List servers;
            if (this.isTraversed(item)) {
                return item;
            }
            if (this.previsit && (item = this.visitor.visitPathItem(this, key, item)) == null) {
                return null;
            }
            this.ancestors.push(item);
            Map extensions = item.getExtensions();
            if (extensions != null) {
                this.processExtensions(extensions);
            }
            final class OperationProperty {
                final Operation o;
                final String name;

                OperationProperty(Operation o, String name) {
                    this.o = o;
                    this.name = name;
                }
            }
            OperationProperty[] operations = new OperationProperty[]{new OperationProperty(item.getDELETE(), "delete"), new OperationProperty(item.getGET(), "get"), new OperationProperty(item.getHEAD(), "head"), new OperationProperty(item.getOPTIONS(), "options"), new OperationProperty(item.getPATCH(), "patch"), new OperationProperty(item.getPOST(), "post"), new OperationProperty(item.getPUT(), "put"), new OperationProperty(item.getTRACE(), "trace")};
            PathItem _item = item;
            Arrays.stream(operations).forEach(v -> {
                this.pathSegments.push(v.name);
                Operation o = this.traverseOperation(v.o);
                if (o != v.o) {
                    switch (v.name) {
                        case "delete": {
                            _item.setDELETE(o);
                            break;
                        }
                        case "get": {
                            _item.setGET(o);
                            break;
                        }
                        case "head": {
                            _item.setHEAD(o);
                            break;
                        }
                        case "options": {
                            _item.setOPTIONS(o);
                            break;
                        }
                        case "patch": {
                            _item.setPATCH(o);
                            break;
                        }
                        case "post": {
                            _item.setPOST(o);
                            break;
                        }
                        case "put": {
                            _item.setPUT(o);
                            break;
                        }
                        case "trace": {
                            _item.setTRACE(o);
                        }
                    }
                }
                this.pathSegments.pop();
            });
            List parameters = item.getParameters();
            if (parameters != null) {
                this.processParameters(parameters);
            }
            if ((servers = item.getServers()) != null) {
                this.processServers(servers);
            }
            this.ancestors.pop();
            if (!this.previsit) {
                item = this.visitor.visitPathItem(this, key, item);
            }
            return item;
        }

        public Operation traverseOperation(Operation operation) {
            List servers;
            List security;
            APIResponses responses;
            RequestBody rb;
            List parameters;
            ExternalDocumentation extDocs;
            Map extensions;
            if (this.isTraversed(operation)) {
                return operation;
            }
            if (this.previsit && (operation = this.visitor.visitOperation(this, operation)) == null) {
                return null;
            }
            this.ancestors.push(operation);
            Map callbacks = operation.getCallbacks();
            if (callbacks != null) {
                this.processCallbacks(callbacks);
            }
            if ((extensions = operation.getExtensions()) != null) {
                this.processExtensions(extensions);
            }
            if ((extDocs = operation.getExternalDocs()) != null) {
                this.pathSegments.push("externalDocs");
                ExternalDocumentation e = this.traverseExternalDocs(extDocs);
                if (e != extDocs) {
                    operation.setExternalDocs(e);
                }
                this.pathSegments.pop();
            }
            if ((parameters = operation.getParameters()) != null) {
                this.processParameters(parameters);
            }
            if ((rb = operation.getRequestBody()) != null) {
                this.pathSegments.push("requestBody");
                RequestBody r = this.traverseRequestBody(null, rb);
                if (r != rb) {
                    operation.setRequestBody(r);
                }
                this.pathSegments.pop();
            }
            if ((responses = operation.getResponses()) != null) {
                this.pathSegments.push("responses");
                APIResponses r = this.traverseResponses(responses);
                if (r != responses) {
                    operation.setResponses(r);
                }
                this.pathSegments.pop();
            }
            if ((security = operation.getSecurity()) != null) {
                this.processSecurityRequirements(security);
            }
            if ((servers = operation.getServers()) != null) {
                this.processServers(servers);
            }
            this.ancestors.pop();
            if (!this.previsit) {
                operation = this.visitor.visitOperation(this, operation);
            }
            return operation;
        }

        public Example traverseExample(String key, Example example) {
            if (this.isTraversed(example)) {
                return example;
            }
            if (this.previsit && (example = key != null ? this.visitor.visitExample(this, key, example) : this.visitor.visitExample(this, example)) == null) {
                return null;
            }
            this.ancestors.push(example);
            Map extensions = example.getExtensions();
            if (extensions != null) {
                this.processExtensions(extensions);
            }
            this.ancestors.pop();
            if (!this.previsit) {
                example = key != null ? this.visitor.visitExample(this, key, example) : this.visitor.visitExample(this, example);
            }
            return example;
        }

        public Header traverseHeader(String key, Header header) {
            Schema schema;
            Map extensions;
            Map examples;
            if (this.isTraversed(header)) {
                return header;
            }
            if (this.previsit && (header = this.visitor.visitHeader(this, key, header)) == null) {
                return null;
            }
            this.ancestors.push(header);
            Content content = header.getContent();
            if (content != null) {
                this.processContent(content);
            }
            if ((examples = header.getExamples()) != null) {
                this.processExamples(examples);
            }
            if ((extensions = header.getExtensions()) != null) {
                this.processExtensions(extensions);
            }
            if ((schema = header.getSchema()) != null) {
                this.pathSegments.push("schema");
                Schema s = this.traverseSchema(null, schema);
                if (s != schema) {
                    header.setSchema(s);
                }
                this.pathSegments.pop();
            }
            this.ancestors.pop();
            if (!this.previsit) {
                header = this.visitor.visitHeader(this, key, header);
            }
            return header;
        }

        public MediaType traverseMediaType(String key, MediaType mediaType) {
            Schema schema;
            Map extensions;
            Map examples;
            if (this.isTraversed(mediaType)) {
                return mediaType;
            }
            if (this.previsit && (mediaType = this.visitor.visitMediaType(this, key, mediaType)) == null) {
                return null;
            }
            this.ancestors.push(mediaType);
            Map encodings = mediaType.getEncoding();
            if (encodings != null) {
                this.processEncodings(encodings, "encoding");
            }
            if ((examples = mediaType.getExamples()) != null) {
                this.processExamples(examples);
            }
            if ((extensions = mediaType.getExtensions()) != null) {
                this.processExtensions(extensions);
            }
            if ((schema = mediaType.getSchema()) != null) {
                this.pathSegments.push("schema");
                Schema s = this.traverseSchema(null, schema);
                if (s != schema) {
                    mediaType.setSchema(schema);
                }
                this.pathSegments.pop();
            }
            this.ancestors.pop();
            if (!this.previsit) {
                mediaType = this.visitor.visitMediaType(this, key, mediaType);
            }
            return mediaType;
        }

        public Encoding traverseEncoding(String key, Encoding encoding) {
            Map headers;
            if (this.isTraversed(encoding)) {
                return encoding;
            }
            if (this.previsit && (encoding = this.visitor.visitEncoding(this, key, encoding)) == null) {
                return null;
            }
            this.ancestors.push(encoding);
            Map extensions = encoding.getExtensions();
            if (extensions != null) {
                this.processExtensions(extensions);
            }
            if ((headers = encoding.getHeaders()) != null) {
                this.processHeaders(headers);
            }
            this.ancestors.pop();
            if (!this.previsit) {
                encoding = this.visitor.visitEncoding(this, key, encoding);
            }
            return encoding;
        }

        public Link traverseLink(String key, Link link) {
            Server server;
            if (this.isTraversed(link)) {
                return link;
            }
            if (this.previsit && (link = this.visitor.visitLink(this, key, link)) == null) {
                return null;
            }
            this.ancestors.push(link);
            Map extensions = link.getExtensions();
            if (extensions != null) {
                this.processExtensions(extensions);
            }
            if ((server = link.getServer()) != null) {
                this.pathSegments.push("server");
                Server s = this.traverseServer(server);
                if (s != server) {
                    link.setServer(s);
                }
                this.pathSegments.pop();
            }
            this.ancestors.pop();
            if (!this.previsit) {
                link = this.visitor.visitLink(this, key, link);
            }
            return link;
        }

        public Parameter traverseParameter(String key, Parameter p) {
            Schema schema;
            Map extensions;
            Map examples;
            if (this.isTraversed(p)) {
                return p;
            }
            if (this.previsit && (p = key != null ? this.visitor.visitParameter(this, key, p) : this.visitor.visitParameter(this, p)) == null) {
                return null;
            }
            this.ancestors.push(p);
            Content content = p.getContent();
            if (content != null) {
                this.processContent(content);
            }
            if ((examples = p.getExamples()) != null) {
                this.processExamples(examples);
            }
            if ((extensions = p.getExtensions()) != null) {
                this.processExtensions(extensions);
            }
            if ((schema = p.getSchema()) != null) {
                this.pathSegments.push("schema");
                Schema s = this.traverseSchema(null, schema);
                if (s != schema) {
                    p.setSchema(s);
                }
                this.pathSegments.pop();
            }
            this.ancestors.pop();
            if (!this.previsit) {
                p = key != null ? this.visitor.visitParameter(this, key, p) : this.visitor.visitParameter(this, p);
            }
            return p;
        }

        public RequestBody traverseRequestBody(String key, RequestBody rb) {
            Map extensions;
            if (this.isTraversed(rb)) {
                return rb;
            }
            if (this.previsit && (rb = key != null ? this.visitor.visitRequestBody(this, key, rb) : this.visitor.visitRequestBody(this, rb)) == null) {
                return null;
            }
            this.ancestors.push(rb);
            Content content = rb.getContent();
            if (content != null) {
                this.processContent(content);
            }
            if ((extensions = rb.getExtensions()) != null) {
                this.processExtensions(extensions);
            }
            this.ancestors.pop();
            if (!this.previsit) {
                rb = key != null ? this.visitor.visitRequestBody(this, key, rb) : this.visitor.visitRequestBody(this, rb);
            }
            return rb;
        }

        public APIResponses traverseResponses(APIResponses responses) {
            APIResponse defaultResponse;
            if (this.isTraversed(responses)) {
                return responses;
            }
            if (this.previsit && (responses = this.visitor.visitResponses(this, responses)) == null) {
                return null;
            }
            this.ancestors.push(responses);
            Map updates = this.map();
            responses.forEach((k, v) -> {
                this.pathSegments.push((String)k);
                APIResponse r = this.traverseResponse((String)k, (APIResponse)v);
                if (r != v) {
                    updates.put(k, r);
                }
                this.pathSegments.pop();
            });
            if (updates.size() > 0) {
                this.updateMap((Map)responses, updates);
            }
            if ((defaultResponse = responses.getDefault()) != null) {
                this.pathSegments.push("default");
                APIResponse r = this.traverseResponse("default", defaultResponse);
                if (r != defaultResponse) {
                    responses.setDefaultValue(r);
                }
                this.pathSegments.pop();
            }
            this.ancestors.pop();
            if (!this.previsit) {
                responses = this.visitor.visitResponses(this, responses);
            }
            return responses;
        }

        public APIResponse traverseResponse(String key, APIResponse response) {
            Map links;
            Map headers;
            Map extensions;
            if (this.isTraversed(response)) {
                return response;
            }
            if (this.previsit && (response = this.visitor.visitResponse(this, key, response)) == null) {
                return null;
            }
            this.ancestors.push(response);
            Content content = response.getContent();
            if (content != null) {
                this.processContent(content);
            }
            if ((extensions = response.getExtensions()) != null) {
                this.processExtensions(extensions);
            }
            if ((headers = response.getHeaders()) != null) {
                this.processHeaders(headers);
            }
            if ((links = response.getLinks()) != null) {
                this.processLinks(links);
            }
            this.ancestors.pop();
            if (!this.previsit) {
                response = this.visitor.visitResponse(this, key, response);
            }
            return response;
        }

        public Schema traverseSchema(String key, Schema schema) {
            final class SchemaProperty {
                final Schema s;
                final String name;

                SchemaProperty(Schema s, String name) {
                    this.s = s;
                    this.name = name;
                }
            }
            List<SchemaProperty> nestedSchemas;
            XML xml;
            Map schemas;
            Schema notSchema;
            ExternalDocumentation extDocs;
            Map extensions;
            Discriminator d;
            if (this.isTraversed(schema)) {
                return schema;
            }
            if (this.previsit && (schema = key != null ? this.visitor.visitSchema(this, key, schema) : this.visitor.visitSchema(this, schema)) == null) {
                return null;
            }
            this.ancestors.push(schema);
            Object addProps = schema.getAdditionalProperties();
            if (addProps != null && addProps instanceof Schema) {
                this.pathSegments.push("additionalProperties");
                Schema s = this.traverseSchema(null, (Schema)addProps);
                if (s != addProps) {
                    schema.setAdditionalProperties(s);
                }
                this.pathSegments.pop();
            }
            if ((d = schema.getDiscriminator()) != null) {
                this.pathSegments.push("discriminator");
                Discriminator disc = this.traverseDiscriminator(d);
                if (disc != d) {
                    schema.setDiscriminator(disc);
                }
                this.pathSegments.pop();
            }
            if ((extensions = schema.getExtensions()) != null) {
                this.processExtensions(extensions);
            }
            if ((extDocs = schema.getExternalDocs()) != null) {
                this.pathSegments.push("externalDocs");
                ExternalDocumentation e = this.traverseExternalDocs(extDocs);
                if (e != extDocs) {
                    schema.setExternalDocs(e);
                }
                this.pathSegments.pop();
            }
            if ((notSchema = schema.getNot()) != null) {
                this.pathSegments.push("not");
                Schema s = this.traverseSchema(null, notSchema);
                if (s != notSchema) {
                    schema.setNot(s);
                }
                this.pathSegments.pop();
            }
            if ((schemas = schema.getProperties()) != null) {
                this.processSchemas(schemas, "properties");
            }
            if ((xml = schema.getXml()) != null) {
                this.pathSegments.push("xml");
                XML x = this.traverseXML(xml);
                if (x != xml) {
                    schema.setXml(x);
                }
                this.pathSegments.pop();
            }
            if (schema.getType() == Schema.SchemaType.ARRAY) {
                Schema arraySchema = schema;
                Schema items = arraySchema.getItems();
                nestedSchemas = items != null ? Collections.singletonList(new SchemaProperty(items, "items")) : null;
            } else if (SchemaProcessor.isComposedSchema(schema)) {
                List oneOf;
                List anyOf;
                Schema composedSchema = schema;
                ArrayList<SchemaProperty> _nestedSchemas = new ArrayList<SchemaProperty>();
                List allOf = composedSchema.getAllOf();
                if (allOf != null) {
                    allOf.forEach(v -> _nestedSchemas.add(new SchemaProperty((Schema)v, "allOf")));
                }
                if ((anyOf = composedSchema.getAnyOf()) != null) {
                    anyOf.forEach(v -> _nestedSchemas.add(new SchemaProperty((Schema)v, "anyOf")));
                }
                if ((oneOf = composedSchema.getOneOf()) != null) {
                    oneOf.forEach(v -> _nestedSchemas.add(new SchemaProperty((Schema)v, "oneOf")));
                }
                nestedSchemas = !_nestedSchemas.isEmpty() ? _nestedSchemas : null;
            } else {
                nestedSchemas = null;
            }
            if (nestedSchemas != null) {
                Schema _schema = schema;
                nestedSchemas.stream().forEach(v -> {
                    this.pathSegments.push(v.name);
                    Schema s = this.traverseSchema(null, v.s);
                    if (s != v.s) {
                        switch (v.name) {
                            case "items": {
                                _schema.setItems(s);
                                break;
                            }
                            case "allOf": {
                                List allOf = _schema.getAllOf();
                                allOf.remove(v.s);
                                if (s == null) break;
                                allOf.add(s);
                                break;
                            }
                            case "anyOf": {
                                List anyOf = _schema.getAnyOf();
                                anyOf.remove(v.s);
                                if (s == null) break;
                                anyOf.add(s);
                                break;
                            }
                            case "oneOf": {
                                List oneOf = _schema.getOneOf();
                                oneOf.remove(v.s);
                                if (s == null) break;
                                oneOf.add(s);
                            }
                        }
                    }
                    this.pathSegments.pop();
                });
            }
            this.ancestors.pop();
            if (!this.previsit) {
                schema = key != null ? this.visitor.visitSchema(this, key, schema) : this.visitor.visitSchema(this, schema);
            }
            return schema;
        }

        public Discriminator traverseDiscriminator(Discriminator d) {
            if (this.isTraversed(d)) {
                return d;
            }
            d = this.visitor.visitDiscriminator(this, d);
            return d;
        }

        public XML traverseXML(XML xml) {
            if (this.isTraversed(xml)) {
                return xml;
            }
            if (this.previsit && (xml = this.visitor.visitXML(this, xml)) == null) {
                return null;
            }
            this.ancestors.push(xml);
            Map extensions = xml.getExtensions();
            if (extensions != null) {
                this.processExtensions(extensions);
            }
            this.ancestors.pop();
            if (!this.previsit) {
                xml = this.visitor.visitXML(this, xml);
            }
            return xml;
        }

        public SecurityScheme traverseSecurityScheme(String key, SecurityScheme scheme) {
            OAuthFlows authFlows;
            if (this.isTraversed(scheme)) {
                return scheme;
            }
            if (this.previsit && (scheme = this.visitor.visitSecurityScheme(this, key, scheme)) == null) {
                return null;
            }
            this.ancestors.push(scheme);
            Map extensions = scheme.getExtensions();
            if (extensions != null) {
                this.processExtensions(extensions);
            }
            if ((authFlows = scheme.getFlows()) != null) {
                this.pathSegments.push("flows");
                OAuthFlows o = this.traverseOAuthFlows(authFlows);
                if (o != authFlows) {
                    scheme.setFlows(o);
                }
                this.pathSegments.pop();
            }
            this.ancestors.pop();
            if (!this.previsit) {
                scheme = this.visitor.visitSecurityScheme(this, key, scheme);
            }
            return scheme;
        }

        public OAuthFlows traverseOAuthFlows(OAuthFlows authFlows) {
            if (this.isTraversed(authFlows)) {
                return authFlows;
            }
            if (this.previsit && (authFlows = this.visitor.visitOAuthFlows(this, authFlows)) == null) {
                return null;
            }
            this.ancestors.push(authFlows);
            Map extensions = authFlows.getExtensions();
            if (extensions != null) {
                this.processExtensions(extensions);
            }
            final class OAuthFlowProperty {
                final OAuthFlow o;
                final String name;

                OAuthFlowProperty(OAuthFlow o, String name) {
                    this.o = o;
                    this.name = name;
                }
            }
            OAuthFlowProperty[] _authFlows = new OAuthFlowProperty[]{new OAuthFlowProperty(authFlows.getAuthorizationCode(), "authorizationCode"), new OAuthFlowProperty(authFlows.getClientCredentials(), "clientCredentials"), new OAuthFlowProperty(authFlows.getImplicit(), "implicit"), new OAuthFlowProperty(authFlows.getPassword(), "password")};
            OAuthFlows afs = authFlows;
            Arrays.stream(_authFlows).forEach(v -> {
                this.pathSegments.push(v.name);
                OAuthFlow o = this.traverseOAuthFlow(v.o);
                if (o != v.o) {
                    switch (v.name) {
                        case "authorizationCode": {
                            afs.setAuthorizationCode(o);
                            break;
                        }
                        case "clientCredentials": {
                            afs.setClientCredentials(o);
                            break;
                        }
                        case "implicit": {
                            afs.setImplicit(o);
                            break;
                        }
                        case "password": {
                            afs.setPassword(o);
                        }
                    }
                }
                this.pathSegments.pop();
            });
            this.ancestors.pop();
            if (!this.previsit) {
                authFlows = this.visitor.visitOAuthFlows(this, authFlows);
            }
            return authFlows;
        }

        public OAuthFlow traverseOAuthFlow(OAuthFlow authFlow) {
            Scopes scopes;
            if (this.isTraversed(authFlow)) {
                return authFlow;
            }
            if (this.previsit && (authFlow = this.visitor.visitOAuthFlow(this, authFlow)) == null) {
                return null;
            }
            this.ancestors.push(authFlow);
            Map extensions = authFlow.getExtensions();
            if (extensions != null) {
                this.processExtensions(extensions);
            }
            if ((scopes = authFlow.getScopes()) != null) {
                this.pathSegments.push("scopes");
                Scopes s = this.traverseScopes(scopes);
                if (s == scopes) {
                    authFlow.setScopes(s);
                }
                this.pathSegments.pop();
            }
            this.ancestors.pop();
            if (!this.previsit) {
                authFlow = this.visitor.visitOAuthFlow(this, authFlow);
            }
            return authFlow;
        }

        public Scopes traverseScopes(Scopes scopes) {
            if (this.isTraversed(scopes)) {
                return scopes;
            }
            if (this.previsit && (scopes = this.visitor.visitScopes(this, scopes)) == null) {
                return null;
            }
            this.ancestors.push(scopes);
            Map extensions = scopes.getExtensions();
            if (extensions != null) {
                this.processExtensions(extensions);
            }
            this.ancestors.pop();
            if (!this.previsit) {
                scopes = this.visitor.visitScopes(this, scopes);
            }
            return scopes;
        }

        public Object traverseExtension(String key, Object extension) {
            extension = this.visitor.visitExtension(this, key, extension);
            return extension;
        }

        public ExternalDocumentation traverseExternalDocs(ExternalDocumentation extDocs) {
            if (this.isTraversed(extDocs)) {
                return extDocs;
            }
            if (this.previsit && (extDocs = this.visitor.visitExternalDocumentation(this, extDocs)) == null) {
                return null;
            }
            this.ancestors.push(extDocs);
            Map extensions = extDocs.getExtensions();
            if (extensions != null) {
                this.processExtensions(extensions);
            }
            this.ancestors.pop();
            if (!this.previsit) {
                extDocs = this.visitor.visitExternalDocumentation(this, extDocs);
            }
            return extDocs;
        }

        public Info traverseInfo(Info info) {
            License license;
            Map extensions;
            if (this.isTraversed(info)) {
                return info;
            }
            if (this.previsit && (info = this.visitor.visitInfo(this, info)) == null) {
                return null;
            }
            this.ancestors.push(info);
            Contact contact = info.getContact();
            if (contact != null) {
                this.pathSegments.push("contact");
                Contact c = this.traverseContact(contact);
                if (c != contact) {
                    info.setContact(c);
                }
                this.pathSegments.pop();
            }
            if ((extensions = info.getExtensions()) != null) {
                this.processExtensions(extensions);
            }
            if ((license = info.getLicense()) != null) {
                this.pathSegments.push("license");
                License l = this.traverseLicense(license);
                if (l != license) {
                    info.setLicense(l);
                }
                this.pathSegments.pop();
            }
            this.ancestors.pop();
            if (!this.previsit) {
                info = this.visitor.visitInfo(this, info);
            }
            return info;
        }

        public Contact traverseContact(Contact contact) {
            if (this.isTraversed(contact)) {
                return contact;
            }
            if (this.previsit && (contact = this.visitor.visitContact(this, contact)) == null) {
                return null;
            }
            this.ancestors.push(contact);
            Map extensions = contact.getExtensions();
            if (extensions != null) {
                this.processExtensions(extensions);
            }
            this.ancestors.pop();
            if (!this.previsit) {
                contact = this.visitor.visitContact(this, contact);
            }
            return contact;
        }

        public License traverseLicense(License license) {
            if (this.isTraversed(license)) {
                return license;
            }
            if (this.previsit && (license = this.visitor.visitLicense(this, license)) == null) {
                return null;
            }
            this.ancestors.push(license);
            Map extensions = license.getExtensions();
            if (extensions != null) {
                this.processExtensions(extensions);
            }
            this.ancestors.pop();
            if (!this.previsit) {
                license = this.visitor.visitLicense(this, license);
            }
            return license;
        }

        public Paths traversePaths(Paths paths) {
            Map extensions;
            if (this.isTraversed(paths)) {
                return paths;
            }
            if (this.previsit && (paths = this.visitor.visitPaths(this, paths)) == null) {
                return null;
            }
            this.ancestors.push(paths);
            Map updates = this.map();
            paths.forEach((k, v) -> {
                this.pathSegments.push((String)k);
                PathItem p = this.traversePathItem((String)k, (PathItem)v);
                if (p != v) {
                    updates.put(k, p);
                }
                this.pathSegments.pop();
            });
            if (updates.size() > 0) {
                this.updateMap((Map)paths, updates);
            }
            if ((extensions = paths.getExtensions()) != null) {
                this.processExtensions(extensions);
            }
            this.ancestors.pop();
            if (!this.previsit) {
                paths = this.visitor.visitPaths(this, paths);
            }
            return paths;
        }

        public SecurityRequirement traverseSecurityRequirement(SecurityRequirement sr) {
            if (this.isTraversed(sr)) {
                return sr;
            }
            sr = this.visitor.visitSecurityRequirement(this, sr);
            return sr;
        }

        public Server traverseServer(Server server) {
            ServerVariables svs;
            if (this.isTraversed(server)) {
                return server;
            }
            if (this.previsit && (server = this.visitor.visitServer(this, server)) == null) {
                return null;
            }
            this.ancestors.push(server);
            Map extensions = server.getExtensions();
            if (extensions != null) {
                this.processExtensions(extensions);
            }
            if ((svs = server.getVariables()) != null) {
                this.pathSegments.push("variables");
                ServerVariables s = this.traverseServerVariables(svs);
                if (s != svs) {
                    server.setVariables(s);
                }
                this.pathSegments.pop();
            }
            this.ancestors.pop();
            if (!this.previsit) {
                server = this.visitor.visitServer(this, server);
            }
            return server;
        }

        public ServerVariables traverseServerVariables(ServerVariables svs) {
            Map extensions;
            if (this.isTraversed(svs)) {
                return svs;
            }
            if (this.previsit && (svs = this.visitor.visitServerVariables(this, svs)) == null) {
                return null;
            }
            this.ancestors.push(svs);
            Map updates = this.map();
            svs.forEach((k, v) -> {
                this.pathSegments.push((String)k);
                ServerVariable s = this.traverseServerVariable((String)k, (ServerVariable)v);
                if (s != v) {
                    updates.put(k, s);
                }
                this.pathSegments.pop();
            });
            if (updates.size() > 0) {
                this.updateMap((Map)svs, updates);
            }
            if ((extensions = svs.getExtensions()) != null) {
                this.processExtensions(extensions);
            }
            this.ancestors.pop();
            if (!this.previsit) {
                svs = this.visitor.visitServerVariables(this, svs);
            }
            return svs;
        }

        public ServerVariable traverseServerVariable(String key, ServerVariable sv) {
            if (this.isTraversed(sv)) {
                return sv;
            }
            if (this.previsit && (sv = this.visitor.visitServerVariable(this, key, sv)) == null) {
                return null;
            }
            this.ancestors.push(sv);
            Map extensions = sv.getExtensions();
            if (extensions != null) {
                this.processExtensions(extensions);
            }
            this.ancestors.pop();
            if (!this.previsit) {
                sv = this.visitor.visitServerVariable(this, key, sv);
            }
            return sv;
        }

        public Tag traverseTag(Tag tag) {
            ExternalDocumentation extDocs;
            if (this.isTraversed(tag)) {
                return tag;
            }
            if (this.previsit && (tag = this.visitor.visitTag(this, tag)) == null) {
                return null;
            }
            this.ancestors.push(tag);
            Map extensions = tag.getExtensions();
            if (extensions != null) {
                this.processExtensions(extensions);
            }
            if ((extDocs = tag.getExternalDocs()) != null) {
                this.pathSegments.push("externalDocs");
                ExternalDocumentation e = this.traverseExternalDocs(extDocs);
                if (e != extDocs) {
                    tag.setExternalDocs(e);
                }
                this.pathSegments.pop();
            }
            this.ancestors.pop();
            if (!this.previsit) {
                tag = this.visitor.visitTag(this, tag);
            }
            return tag;
        }

        private void processParameters(List<Parameter> parameters) {
            this.pathSegments.push("parameters");
            for (int i = 0; i < parameters.size(); ++i) {
                Parameter v = parameters.get(i);
                Parameter p = this.traverseParameter(null, v);
                if (p == v) continue;
                i = this.updateList(parameters, i, p);
            }
            this.pathSegments.pop();
        }

        private void processSecurityRequirements(List<SecurityRequirement> security) {
            this.pathSegments.push("security");
            for (int i = 0; i < security.size(); ++i) {
                SecurityRequirement v = security.get(i);
                SecurityRequirement s = this.traverseSecurityRequirement(v);
                if (s == v) continue;
                i = this.updateList(security, i, s);
            }
            this.pathSegments.pop();
        }

        private void processServers(List<Server> servers) {
            this.pathSegments.push("servers");
            for (int i = 0; i < servers.size(); ++i) {
                Server v = servers.get(i);
                Server s = this.traverseServer(v);
                if (s == v) continue;
                i = this.updateList(servers, i, s);
            }
            this.pathSegments.pop();
        }

        private void processTags(List<Tag> tags) {
            this.pathSegments.push("tags");
            for (int i = 0; i < tags.size(); ++i) {
                Tag v = tags.get(i);
                Tag t = this.traverseTag(v);
                if (t == v) continue;
                i = this.updateList(tags, i, t);
            }
            this.pathSegments.pop();
        }

        private void processCallbacks(Map<String, Callback> callbacks) {
            this.pathSegments.push("callbacks");
            Map updates = this.map();
            callbacks.forEach((k, v) -> {
                this.pathSegments.push((String)k);
                Callback c = this.traverseCallback((String)k, (Callback)v);
                if (c != v) {
                    updates.put(k, c);
                }
                this.pathSegments.pop();
            });
            if (updates.size() > 0) {
                this.updateMap(callbacks, updates);
            }
            this.pathSegments.pop();
        }

        private void processContent(Content content) {
            this.pathSegments.push("content");
            Map updates = this.map();
            content.forEach((k, v) -> {
                this.pathSegments.push((String)k);
                MediaType m = this.traverseMediaType((String)k, (MediaType)v);
                if (m != v) {
                    updates.put(k, m);
                }
                this.pathSegments.pop();
            });
            if (updates.size() > 0) {
                this.updateMap((Map)content, updates);
            }
            this.pathSegments.pop();
        }

        private void processEncodings(Map<String, Encoding> encodings, String propertyName) {
            this.pathSegments.push(propertyName);
            Map updates = this.map();
            encodings.forEach((k, v) -> {
                this.pathSegments.push((String)k);
                Encoding e = this.traverseEncoding((String)k, (Encoding)v);
                if (e != v) {
                    updates.put(k, e);
                }
                this.pathSegments.pop();
            });
            if (updates.size() > 0) {
                this.updateMap(encodings, updates);
            }
            this.pathSegments.pop();
        }

        private void processExamples(Map<String, Example> examples) {
            this.pathSegments.push("examples");
            Map updates = this.map();
            examples.forEach((k, v) -> {
                this.pathSegments.push((String)k);
                Example e = this.traverseExample((String)k, (Example)v);
                if (e != v) {
                    updates.put(k, e);
                }
                this.pathSegments.pop();
            });
            if (updates.size() > 0) {
                this.updateMap(examples, updates);
            }
            this.pathSegments.pop();
        }

        private void processExtensions(Map<String, Object> extensions) {
            this.pathSegments.push("extensions");
            Map updates = this.map();
            extensions.forEach((k, v) -> {
                if (k != null && v != null) {
                    this.pathSegments.push((String)k);
                    Object o = this.traverseExtension((String)k, v);
                    if (o != v) {
                        updates.put(k, o);
                    }
                    this.pathSegments.pop();
                }
            });
            if (updates.size() > 0) {
                this.updateMap(extensions, updates);
            }
            this.pathSegments.pop();
        }

        private void processHeaders(Map<String, Header> headers) {
            this.pathSegments.push("headers");
            Map updates = this.map();
            headers.forEach((k, v) -> {
                this.pathSegments.push((String)k);
                Header h = this.traverseHeader((String)k, (Header)v);
                if (h != v) {
                    updates.put(k, h);
                }
                this.pathSegments.pop();
            });
            if (updates.size() > 0) {
                this.updateMap(headers, updates);
            }
            this.pathSegments.pop();
        }

        private void processLinks(Map<String, Link> links) {
            this.pathSegments.push("links");
            Map updates = this.map();
            links.forEach((k, v) -> {
                this.pathSegments.push((String)k);
                Link l = this.traverseLink((String)k, (Link)v);
                if (l != v) {
                    updates.put(k, l);
                }
                this.pathSegments.pop();
            });
            if (updates.size() > 0) {
                this.updateMap(links, updates);
            }
            this.pathSegments.pop();
        }

        private void processParameters(Map<String, Parameter> parameters) {
            this.pathSegments.push("parameters");
            Map updates = this.map();
            parameters.forEach((k, v) -> {
                this.pathSegments.push((String)k);
                Parameter p = this.traverseParameter((String)k, (Parameter)v);
                if (p != v) {
                    updates.put(k, p);
                }
                this.pathSegments.pop();
            });
            if (updates.size() > 0) {
                this.updateMap(parameters, updates);
            }
            this.pathSegments.pop();
        }

        private void processRequestBodies(Map<String, RequestBody> requestBodies) {
            this.pathSegments.push("requestBodies");
            Map updates = this.map();
            requestBodies.forEach((k, v) -> {
                this.pathSegments.push((String)k);
                RequestBody r = this.traverseRequestBody((String)k, (RequestBody)v);
                if (r != v) {
                    updates.put(k, r);
                }
                this.pathSegments.pop();
            });
            if (updates.size() > 0) {
                this.updateMap(requestBodies, updates);
            }
            this.pathSegments.pop();
        }

        private void processResponses(Map<String, APIResponse> responses) {
            this.pathSegments.push("responses");
            Map updates = this.map();
            responses.forEach((k, v) -> {
                this.pathSegments.push((String)k);
                APIResponse r = this.traverseResponse((String)k, (APIResponse)v);
                if (r != v) {
                    updates.put(k, r);
                }
                this.pathSegments.pop();
            });
            if (updates.size() > 0) {
                this.updateMap(responses, updates);
            }
            this.pathSegments.pop();
        }

        private void processSchemas(Map<String, Schema> schemas, String propertyName) {
            this.pathSegments.push(propertyName);
            Map updates = this.map();
            schemas.forEach((k, v) -> {
                this.pathSegments.push((String)k);
                Schema s = this.traverseSchema((String)k, (Schema)v);
                if (s != v) {
                    updates.put(k, s);
                }
                this.pathSegments.pop();
            });
            if (updates.size() > 0) {
                this.updateMap(schemas, updates);
            }
            this.pathSegments.pop();
        }

        private void processSecuritySchemes(Map<String, SecurityScheme> schemes) {
            this.pathSegments.push("securitySchemes");
            Map updates = this.map();
            schemes.forEach((k, v) -> {
                this.pathSegments.push((String)k);
                SecurityScheme s = this.traverseSecurityScheme((String)k, (SecurityScheme)v);
                if (s != v) {
                    updates.put(k, s);
                }
                this.pathSegments.pop();
            });
            if (updates.size() > 0) {
                this.updateMap(schemes, updates);
            }
            this.pathSegments.pop();
        }

        private <V> int updateList(List<V> list, int index, V update) {
            if (update != null) {
                list.set(index, update);
                return index;
            }
            list.remove(index);
            return index - 1;
        }

        private <K, V> Map<K, V> map() {
            return new HashMap();
        }

        private <K, V> void updateMap(Map<K, V> map, Map<K, V> updates) {
            updates.forEach((k, v) -> {
                if (v != null) {
                    map.put(k, v);
                } else {
                    map.remove(k);
                }
            });
        }
    }

    public static interface Context {
        public OpenAPI getModel();

        public Object getParent();

        public String getLocation();

        public String getLocation(String var1);
    }
}

