/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.cmsf;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.yoko.orb.cmsf.CmsfVersion;
import org.apache.yoko.util.Hex;
import org.apache.yoko.util.cmsf.CmsfThreadLocal;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.InvalidSlot;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public final class CmsfServerInterceptor
extends LocalObject
implements ServerRequestInterceptor {
    private static final Logger LOGGER = Logger.getLogger(CmsfServerInterceptor.class.getName());
    private static final String NAME = CmsfServerInterceptor.class.getName();
    private final int slotId;

    public CmsfServerInterceptor(int slotId) {
        this.slotId = slotId;
    }

    public void receive_request_service_contexts(ServerRequestInfo ri) throws ForwardRequest {
        CmsfVersion cmsf;
        block5: {
            CmsfThreadLocal.reset();
            cmsf = CmsfVersion.CMSFv1;
            try {
                ServiceContext sc = ri.get_request_service_context(17);
                cmsf = CmsfVersion.readData(sc.context_data);
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest(String.format("Using custom marshal stream format version: %s, retrieved from bytes: %s", new Object[]{cmsf, Hex.formatHexPara((byte[])sc.context_data)}));
                }
            }
            catch (BAD_PARAM e) {
                if (e.minor == 1330446362) break block5;
                throw e;
            }
        }
        try {
            ri.set_slot(this.slotId, cmsf.getAny());
        }
        catch (InvalidSlot e) {
            throw (INTERNAL)new INTERNAL(e.getMessage()).initCause((Throwable)e);
        }
    }

    public void receive_request(ServerRequestInfo ri) throws ForwardRequest {
    }

    private void setupCmsfThreadLocalValue(ServerRequestInfo ri) {
        CmsfVersion cmsf = CmsfVersion.CMSFv1;
        try {
            cmsf = CmsfVersion.readAny(ri.get_slot(this.slotId));
        }
        catch (InvalidSlot e) {
            throw (INTERNAL)new INTERNAL(e.getMessage()).initCause((Throwable)e);
        }
        CmsfThreadLocal.push((byte)cmsf.getValue());
    }

    public void send_reply(ServerRequestInfo ri) {
        this.setupCmsfThreadLocalValue(ri);
    }

    public void send_exception(ServerRequestInfo ri) throws ForwardRequest {
        this.setupCmsfThreadLocalValue(ri);
    }

    public void send_other(ServerRequestInfo ri) throws ForwardRequest {
        this.setupCmsfThreadLocalValue(ri);
    }

    public String name() {
        return NAME;
    }

    public void destroy() {
    }

    private void readObject(ObjectInputStream ios) throws IOException {
        throw new NotSerializableException(NAME);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        throw new NotSerializableException(NAME);
    }
}

