/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OBPortableServer;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.yoko.orb.OB.LocationForward;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OB.ObjectIdHasher;
import org.apache.yoko.orb.OBPortableServer.ActiveObjectOnlyStrategy;
import org.apache.yoko.orb.OBPortableServer.DefaultServantHolder;
import org.apache.yoko.orb.OBPortableServer.POAPolicies;
import org.apache.yoko.orb.OBPortableServer.ServantActivatorStrategy;
import org.apache.yoko.orb.OBPortableServer.ServantManagerStrategy;
import org.apache.yoko.orb.OBPortableServer.TableEntry;
import org.apache.yoko.orb.PortableServer.PoaCurrentImpl;
import org.apache.yoko.util.MinorCodes;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.SystemException;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantLocatorPackage.CookieHolder;

class RetainStrategy
extends ActiveObjectOnlyStrategy {
    private ServantActivatorStrategy servantManager_;
    private DefaultServantHolder defaultServant_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void etherealize(ObjectIdHasher oid, POA poa, Servant servant, boolean cleanup) {
        if (this.servantManager_ != null) {
            boolean remaining = false;
            ServantActivatorStrategy servantActivatorStrategy = this.servantManager_;
            synchronized (servantActivatorStrategy) {
                if (this.servantIdTable_ == null) {
                    Enumeration keys = this.activeObjectTable_.keys();
                    while (keys.hasMoreElements()) {
                        TableEntry entry;
                        Object object = this.activeObjectTable_;
                        synchronized (object) {
                            entry = (TableEntry)this.activeObjectTable_.get(keys.nextElement());
                        }
                        if (entry == null) continue;
                        object = entry;
                        synchronized (object) {
                            if (entry.state() != 3 && entry.state() != 0 && entry.getServant() == servant) {
                                remaining = true;
                                break;
                            }
                        }
                    }
                }
            }
            this.servantManager_.etherealize(oid.getObjectId(), poa, servant, cleanup, remaining);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupEntry(ObjectIdHasher oid, TableEntry entry) {
        Object object = this.activeObjectTable_;
        synchronized (object) {
            this.activeObjectTable_.remove(oid);
        }
        object = entry;
        synchronized (object) {
            entry.setDeactivated();
        }
    }

    @Override
    protected void completeDeactivate(POA poa, ObjectIdHasher oid, TableEntry entry) {
        Servant servant = entry.getServant();
        super.completeDeactivate(poa, oid, entry);
        this.etherealize(oid, poa, servant, false);
    }

    RetainStrategy(POAPolicies policies, ORBInstance orbInstance, ServantActivatorStrategy servantManager, DefaultServantHolder defaultServant) {
        super(policies, orbInstance);
        this.servantManager_ = servantManager;
        this.defaultServant_ = defaultServant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void destroy(POA poa, boolean e) {
        if (this.servantManager_ != null && e) {
            Enumeration keys = this.activeObjectTable_.keys();
            block10: while (keys.hasMoreElements()) {
                Servant servant = null;
                TableEntry entry = null;
                ObjectIdHasher key = (ObjectIdHasher)keys.nextElement();
                block11: while (true) {
                    Object object = this.activeObjectTable_;
                    // MONITORENTER : object
                    entry = (TableEntry)this.activeObjectTable_.get(key);
                    // MONITOREXIT : object
                    if (entry == null) continue block10;
                    object = entry;
                    // MONITORENTER : object
                    switch (entry.state()) {
                        case 1: {
                            entry.setDeactivatePending();
                            servant = entry.getServant();
                            if (servant == null) break block11;
                            super.completeDeactivate(poa, key, entry);
                            this.etherealize(key, poa, servant, true);
                            Hashtable hashtable = this.activeObjectTable_;
                            // MONITORENTER : hashtable
                            this.activeObjectTable_.remove(key);
                            // MONITOREXIT : hashtable
                            break block11;
                        }
                        case 0: 
                        case 2: {
                            entry.waitForStateChange();
                            // MONITOREXIT : object
                            continue block11;
                        }
                    }
                    break;
                }
                // MONITOREXIT : object
            }
        }
        super.destroy(poa, e);
        if (this.servantManager_ != null) {
            this.servantManager_.destroy();
        }
        if (this.defaultServant_ == null) return;
        this.defaultServant_.destroy();
    }

    @Override
    public void etherealize(POA poa) {
        this.destroy(poa, true);
    }

    @Override
    public byte[] servantToId(Servant servant, PoaCurrentImpl poaCurrent) {
        byte[] oid = super.servantToId(servant, poaCurrent);
        if (oid == null && this.defaultServant_ != null) {
            return this.defaultServant_.servantToId(servant, poaCurrent);
        }
        return oid;
    }

    @Override
    public Servant idToServant(byte[] oid, boolean useDefaultServant) {
        Servant servant = super.idToServant(oid, useDefaultServant);
        if (servant == null && useDefaultServant && this.defaultServant_ != null) {
            servant = this.defaultServant_.getDefaultServant();
        }
        return servant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Servant locate(byte[] rawoid, POA poa, String op, CookieHolder cookie) throws LocationForward {
        ObjectIdHasher oid = new ObjectIdHasher(rawoid);
        block14: while (true) {
            TableEntry entry;
            boolean incarnate = false;
            Hashtable hashtable = this.activeObjectTable_;
            synchronized (hashtable) {
                entry = (TableEntry)this.activeObjectTable_.get(oid);
                if (entry == null) {
                    if (this.defaultServant_ != null) {
                        Servant servant = this.defaultServant_.getDefaultServant();
                        if (servant == null) {
                            throw new OBJ_ADAPTER(MinorCodes.describeObjAdapter((int)1330446339), 1330446339, CompletionStatus.COMPLETED_NO);
                        }
                        return servant;
                    }
                    entry = new TableEntry();
                    this.activeObjectTable_.put(oid, entry);
                    incarnate = true;
                }
            }
            Servant servant = null;
            if (incarnate) {
                try {
                    byte[] oid2;
                    servant = this.servantManager_.incarnate(oid.getObjectId(), poa);
                    if (this.servantIdTable_ != null && this.servantIdTable_.containsKey(servant) && !ObjectIdHasher.comp(rawoid, oid2 = (byte[])this.servantIdTable_.get(servant))) {
                        throw new OBJ_ADAPTER("ServantActivator returned a servant that is already active for a different object ID");
                    }
                }
                catch (LocationForward l) {
                    this.cleanupEntry(oid, entry);
                    throw l;
                }
                catch (SystemException e) {
                    this.cleanupEntry(oid, entry);
                    throw e;
                }
            }
            TableEntry tableEntry = entry;
            synchronized (tableEntry) {
                switch (entry.state()) {
                    case 0: {
                        if (incarnate) {
                            this.completeActivation(oid, servant, entry);
                            return servant;
                        }
                        entry.waitForStateChange();
                        continue block14;
                    }
                    case 2: {
                        entry.waitForStateChange();
                        continue block14;
                    }
                    case 1: {
                        Servant s = entry.getServant();
                        if (incarnate) {
                            if (s != servant) {
                                throw new OBJ_ADAPTER("ServantActivator returned a servant that does not match the active object map");
                            }
                            return servant;
                        }
                        return s;
                    }
                }
            }
        }
    }

    @Override
    public ServantManagerStrategy getServantManagerStrategy() {
        return this.servantManager_;
    }

    @Override
    public DefaultServantHolder getDefaultServantHolder() {
        return this.defaultServant_;
    }
}

