/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.util.ArrayList;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomToXMLStreamWriter {
    public void writeToStream(Node dom, String newUri, String newName, XMLStreamWriter xsw) throws XMLStreamException {
        Node currentNode = dom;
        if (dom.getNodeType() == 9) {
            Document doc = (Document)dom;
            xsw.writeStartDocument(doc.getXmlEncoding(), doc.getXmlVersion());
            currentNode = doc.getDocumentElement();
        }
        if (currentNode.getNodeType() == 1) {
            this.writeElement((Element)currentNode, newUri, newName, xsw);
        } else if (currentNode.getNodeType() == 2) {
            Attr attribute = (Attr)currentNode;
            if (attribute.getPrefix() != null && attribute.getPrefix().equals("xmlns")) {
                xsw.writeNamespace(attribute.getLocalName(), attribute.getValue());
            } else if (attribute.getPrefix() == null) {
                xsw.writeAttribute(attribute.getName(), attribute.getValue());
            } else {
                xsw.writeAttribute(attribute.getPrefix(), attribute.getNamespaceURI(), attribute.getLocalName(), attribute.getValue());
            }
        } else if (currentNode.getNodeType() == 3) {
            xsw.writeCharacters(currentNode.getNodeValue());
        }
        if (dom.getNodeType() == 9) {
            xsw.writeEndDocument();
        }
    }

    private void writeElement(Element elem, String newNamespace, String newName, XMLStreamWriter xsw) throws XMLStreamException {
        Node next2;
        String prefix = null;
        String namespace = null;
        String localName = null;
        String nodeName = null;
        if (newName != null) {
            namespace = newNamespace;
            localName = newName;
            nodeName = newName;
            if (newNamespace != null && !newNamespace.isEmpty()) {
                NamespaceResolver tempNR = new NamespaceResolver();
                tempNR.setDOM(elem);
                prefix = tempNR.resolveNamespaceURI(namespace);
                if (prefix == null || prefix.isEmpty()) {
                    String defaultNamespace = elem.getAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns");
                    prefix = defaultNamespace == null ? tempNR.generatePrefix() : (defaultNamespace != namespace ? tempNR.generatePrefix() : "");
                }
            }
        } else {
            prefix = elem.getPrefix();
            namespace = elem.getNamespaceURI();
            localName = elem.getLocalName();
            nodeName = elem.getNodeName();
        }
        String defaultNamespace = xsw.getNamespaceContext().getNamespaceURI("");
        boolean needToAddDefaultNS = false;
        if (prefix != null && !prefix.isEmpty()) {
            String namespaceURI = xsw.getNamespaceContext().getNamespaceURI(prefix);
            xsw.writeStartElement(prefix, localName, namespace);
            if (!namespace.equals(namespaceURI)) {
                xsw.writeNamespace(prefix, namespace);
            }
        } else if (namespace == null || namespace.isEmpty()) {
            xsw.writeStartElement(nodeName);
            if (defaultNamespace != null && !defaultNamespace.isEmpty()) {
                xsw.writeDefaultNamespace("");
            }
        } else {
            needToAddDefaultNS = true;
            xsw.writeStartElement("", localName, namespace);
        }
        NodeList childNodes = elem.getChildNodes();
        NamedNodeMap attrs = elem.getAttributes();
        ArrayList<Node> nonNamespaceDeclAttrs = new ArrayList<Node>();
        for (int i = 0; i < attrs.getLength(); ++i) {
            next2 = (Attr)attrs.item(i);
            if (next2.getNodeType() != 2) continue;
            if (next2.getPrefix() != null && next2.getPrefix().equals("xmlns")) {
                String currentUri = xsw.getNamespaceContext().getNamespaceURI(next2.getLocalName());
                if (currentUri != null && currentUri.equals(next2.getValue())) continue;
                xsw.writeNamespace(next2.getLocalName(), next2.getValue());
                continue;
            }
            if (next2.getName().equals("xmlns")) {
                xsw.writeDefaultNamespace(next2.getValue());
                needToAddDefaultNS = false;
                continue;
            }
            nonNamespaceDeclAttrs.add(next2);
        }
        if (needToAddDefaultNS && (defaultNamespace == null || !defaultNamespace.equals(namespace))) {
            xsw.writeDefaultNamespace(namespace);
        }
        for (Node next2 : nonNamespaceDeclAttrs) {
            if (next2.getPrefix() == null) {
                xsw.writeAttribute(next2.getName(), next2.getValue());
                continue;
            }
            xsw.writeAttribute(next2.getPrefix(), next2.getNamespaceURI(), next2.getLocalName(), next2.getValue());
        }
        for (int i = 0; i < childNodes.getLength(); ++i) {
            next2 = childNodes.item(i);
            if (next2.getNodeType() == 3) {
                xsw.writeCharacters(next2.getNodeValue());
                continue;
            }
            if (next2.getNodeType() == 4) {
                xsw.writeCData(next2.getNodeValue());
                continue;
            }
            if (next2.getNodeType() == 8) {
                xsw.writeComment(next2.getNodeValue());
                continue;
            }
            if (next2.getNodeType() != 1) continue;
            this.writeElement((Element)next2, null, null, xsw);
        }
        xsw.writeEndElement();
    }

    protected String getPrefix(NamespaceContext nc, Element elem, String uri) {
        NamespaceResolver tempResovler = new NamespaceResolver();
        tempResovler.setDOM(elem);
        String prefix = tempResovler.resolveNamespaceURI(uri);
        if (prefix == null || prefix.isEmpty()) {
            prefix = tempResovler.generatePrefix();
        }
        return prefix;
    }
}

