/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.CommsConstants;
import com.ibm.ws.sib.comms.common.CommsUtils;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.clientsupport.CATConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.CATMainConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.CATSyncAsynchReader;
import com.ibm.ws.sib.comms.server.clientsupport.CATTimer;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.JFapByteBuffer;
import com.ibm.ws.sib.jfapchannel.SendListener;
import com.ibm.ws.sib.processor.MPConsumerSession;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AsynchConsumerCallback;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.SICoreConnectionListener;

public class CATSessSynchConsumer
extends CATConsumer {
    private static String CLASS_NAME = CATSessSynchConsumer.class.getName();
    private CATMainConsumer mainConsumer = null;
    private CATSyncAsynchReader asynchReader = null;
    private boolean logicallyStarted = false;
    private static final TraceComponent tc = SibTr.register(CATSessSynchConsumer.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");

    public CATSessSynchConsumer(CATMainConsumer mainConsumer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)mainConsumer);
        }
        this.mainConsumer = mainConsumer;
        if (mainConsumer.isStarted()) {
            this.logicallyStarted = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    protected ConsumerSession getConsumerSession() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConsumerSession");
        }
        ConsumerSession sess = this.mainConsumer.getConsumerSession();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConsumerSession", (Object)sess);
        }
        return sess;
    }

    @Override
    protected Conversation getConversation() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConversation");
        }
        Conversation conv = this.mainConsumer.getConversation();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConversation", (Object)conv);
        }
        return conv;
    }

    @Override
    protected int getLowestPriority() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getLowestPriority");
        }
        int lowestPri = this.mainConsumer.getLowestPriority();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getLowestPriority", (Object)lowestPri);
        }
        return lowestPri;
    }

    @Override
    protected short getClientSessionId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getClientSessionId");
        }
        short sessId = this.mainConsumer.getClientSessionId();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getClientSessionId");
        }
        return sessId;
    }

    @Override
    protected Reliability getUnrecoverableReliability() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getUnrecoverableReliability");
        }
        Reliability rel = this.mainConsumer.getUnrecoverableReliability();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getUnrecoverableReliability");
        }
        return rel;
    }

    @Override
    public void receive(int requestNumber, int transaction, long timeout) {
        block41: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"receive", (Object)new Object[]{requestNumber, transaction, timeout});
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("RQ: " + requestNumber + ", Timeout: " + timeout));
                if (timeout == -1L) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Emulating a receiveNoWait()");
                } else if (timeout == 0L) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Emulating an indefinate receive()");
                } else {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Emulating a receive() for " + timeout + "ms"));
                }
            }
            ++this.requestsReceived;
            try {
                if (this.mainConsumer.isStarted()) {
                    this.getConsumerSession().stop();
                }
            }
            catch (SIException sis) {
                if (!((ConversationState)this.getConversation().getAttachment()).hasMETerminated()) {
                    FFDCFilter.processException((Throwable)sis, (String)(CLASS_NAME + ".receive"), (String)"3-020-0001", (Object)this);
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block41;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)sis.getMessage(), (Object)((Object)sis));
            }
        }
        if (this.asynchReader == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Creating async reader for first time");
            }
            this.asynchReader = new CATSyncAsynchReader(transaction, this.getConversation(), this.mainConsumer, requestNumber);
            try {
                boolean inlineCallbacks = CommsUtils.getRuntimeBooleanProperty((String)"sib.comms.InlineAsyncCBacks", (String)CommsConstants.INLINE_ASYNC_CBACKS);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Inline async callbacks: " + inlineCallbacks));
                }
                Reliability unrecov = this.getUnrecoverableReliability();
                if (transaction == 0) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Setting unrecoverable reliability to max");
                    }
                    unrecov = Reliability.ASSURED_PERSISTENT;
                }
                MPConsumerSession mpSession = (MPConsumerSession)this.getConsumerSession();
                mpSession.registerAsynchConsumerCallback((AsynchConsumerCallback)this.asynchReader, 0, 0L, 1, unrecov, inlineCallbacks, null);
            }
            catch (SIException s) {
                if (!((ConversationState)this.getConversation().getAttachment()).hasMETerminated()) {
                    FFDCFilter.processException((Throwable)s, (String)(CLASS_NAME + ".receive"), (String)"3-020-0002", (Object)this);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)s.getMessage(), (Object)((Object)s));
                }
                this.asynchReader.sendErrorToClient(s, "3-020-0002");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"receive");
                }
                return;
            }
        } else {
            this.asynchReader.setComplete(false);
            this.asynchReader.setRequestNumber(requestNumber);
            this.asynchReader.setTransaction(transaction);
        }
        try {
            if (this.logicallyStarted) {
                this.mainConsumer.getConsumerSession().activateAsynchConsumer(true);
            }
        }
        catch (SIException s) {
            if (!((ConversationState)this.getConversation().getAttachment()).hasMETerminated()) {
                FFDCFilter.processException((Throwable)s, (String)(CLASS_NAME + ".receive"), (String)"3-020-0003", (Object)this);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)s.getMessage(), (Object)((Object)s));
            }
            this.asynchReader.sendErrorToClient(s, "3-020-0003");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"receive");
            }
            return;
        }
        if (!this.asynchReader.isComplete()) {
            if (timeout == -1L) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"No message received");
                }
                this.asynchReader.sendNoMessageToClient();
            } else {
                this.asynchReader.setCurrentlyDoingReceiveWithWait(true);
                try {
                    MPConsumerSession mpSession = (MPConsumerSession)this.getConsumerSession();
                    mpSession.getConnection().addConnectionListener((SICoreConnectionListener)this.asynchReader);
                }
                catch (SIException s) {
                    if (!((ConversationState)this.getConversation().getAttachment()).hasMETerminated()) {
                        FFDCFilter.processException((Throwable)s, (String)(CLASS_NAME + ".receive"), (String)"3-020-0006", (Object)this);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)s.getMessage(), (Object)((Object)s));
                    }
                    this.asynchReader.sendErrorToClient(s, "3-020-0006");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)tc, (String)"receive");
                    }
                    return;
                }
                if (timeout != 0L) {
                    CATTimer catTimer = new CATTimer(this.asynchReader);
                    Alarm alarm = AlarmManager.createNonDeferrable((long)timeout, (AlarmListener)catTimer, (Object)("RQ: " + requestNumber));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Setting async readers alarm to: " + alarm.toString()));
                    }
                    this.asynchReader.setCATTimer(alarm);
                }
                if (this.logicallyStarted) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Starting async consumer. Timeout = " + timeout + "ms"));
                    }
                    this.mainConsumer.start(requestNumber, true, false, null);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"receive");
        }
    }

    @Override
    public void start(int requestNumber, boolean deliverImmediately, boolean sendReply, SendListener sendListener) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"start", (Object)new Object[]{requestNumber, deliverImmediately});
        }
        this.logicallyStarted = true;
        if (this.asynchReader.isCurrentlyDoingReceiveWithWait()) {
            super.start(requestNumber, true, sendReply, sendListener);
        } else if (sendReply) {
            try {
                this.getConversation().send((JFapByteBuffer)poolManager.allocate(), 244, requestNumber, 12, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, sendListener);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".start"), (String)"3-020-0005", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2013", (Object)((Object)e));
                sendListener.errorOccurred(null, this.getConversation());
            }
        } else {
            sendListener.dataSent(this.getConversation());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
        }
    }

    @Override
    public void stop(int requestNumber, SendListener sendListener) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stop", (Object)requestNumber);
        }
        this.logicallyStarted = false;
        super.stop(requestNumber, sendListener);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stop");
        }
    }

    @Override
    public void close(int requestNumber) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"close", (Object)requestNumber);
        }
        if (this.asynchReader != null) {
            block7: {
                try {
                    this.mainConsumer.getConsumerSession().getConnection().removeConnectionListener((SICoreConnectionListener)this.asynchReader);
                }
                catch (SIException e) {
                    if (!((ConversationState)this.getConversation().getAttachment()).hasMETerminated()) {
                        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".close"), (String)"3-020-0004", (Object)this);
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block7;
                    SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)e));
                }
            }
            if (this.asynchReader.isCurrentlyDoingReceiveWithWait()) {
                this.asynchReader.sendNoMessageToClient();
            }
        }
        super.close(requestNumber);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"close");
        }
    }

    public void setAsynchConsumerCallback(int requestNumber, int maxActiveMessages, long messageLockExpiry, int batchsize, OrderingContext orderContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setAsynchConsumerCallback", (Object)new Object[]{requestNumber, maxActiveMessages, messageLockExpiry, batchsize, orderContext});
        }
        this.mainConsumer.setAsynchConsumerCallback(requestNumber, maxActiveMessages, messageLockExpiry, batchsize, orderContext);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setAsynchConsumerCallback");
        }
    }

    @Override
    public String toString() {
        String s = "CATSessSyncConsumer@" + Integer.toHexString(this.hashCode()) + ": logicallyStarted: " + this.logicallyStarted + ", requestsReceived: " + this.requestsReceived + ", messagesSent: " + this.messagesSent;
        if (this.asynchReader != null) {
            s = s + ", " + this.asynchReader.toString();
        }
        return s;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.comms.server.impl/src/com/ibm/ws/sib/comms/server/clientsupport/CATSessSynchConsumer.java, SIB.comms, WASX.SIB, aa1225.01 1.55");
        }
    }
}

