/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.extension;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.webcontainer.WebContainer;
import com.ibm.ws.webcontainer.extension.WebExtensionProcessor;
import com.ibm.ws.webcontainer.servlet.ServletConfig;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppConfiguration;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.ws.webcontainer.webapp.WebGroup;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.metadata.WebComponentMetaData;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import com.ibm.wsspi.webcontainer.util.ServletUtil;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InvokerExtensionProcessor
extends WebExtensionProcessor {
    private static TraceNLS nls = TraceNLS.getTraceNLS(InvokerExtensionProcessor.class, (String)"com.ibm.ws.webcontainer.resources.Messages");
    protected static final Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.extension");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.extension.InvokerExtensionProcessor";
    private static String showCfg = "com.ibm.websphere.examples.ServletEngineConfigDumper";
    protected static final int numSyncObjects = 41;
    private static final Object syncObjectCreationLock = new Object();
    private List patternList = new ArrayList();
    private static final String DEFAULT_MAPPING = "/servlet/*";
    private Map params;
    private static final boolean servletCaseSensitive = WCCustomProperties.SERVLET_CASE_SENSITIVE;
    static HashSet blockedClassesList;
    static boolean doNotServeByClassName;

    private static final Object getSyncObject(String name) {
        int syncIndex = Math.abs(name.hashCode() % 41);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getSyncObject", "grabbed syncObject in position-->[" + syncIndex + "]");
        }
        return SyncHelper.syncObjects[syncIndex];
    }

    public InvokerExtensionProcessor(WebApp webApp, HashMap params) {
        super(webApp);
        this.params = params;
        String fileServingExtensions = this.getInitParameter("invoker.patterns");
        if (fileServingExtensions != null) {
            this.patternList = this.parseInvokerExtensions(fileServingExtensions);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "InvokerExtensionProcessor", "URI patterns for invoking servlets =[" + this.patternList + "]");
            }
        } else {
            this.patternList.add(DEFAULT_MAPPING);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "InvokerExtensionProcessor", "Default URI pattern for invoking servlets =[" + this.patternList + "]");
            }
        }
    }

    @Override
    public void handleRequest(ServletRequest req, ServletResponse res) throws Exception {
        IServletWrapper s;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "should not enter invoker extension processor to handle request");
        }
        if ((s = this.getServletWrapper(req, res, true)) != null) {
            s.handleRequest(req, res);
        } else if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "unable to find servlet wrapper to handle request");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IServletWrapper getServletWrapper(ServletRequest req, ServletResponse resp, boolean handleFailure) throws Exception {
        block53: {
            block51: {
                block49: {
                    block48: {
                        block47: {
                            block46: {
                                block45: {
                                    methodName = "getServletWrapper";
                                    if (TraceComponent.isAnyTracingEnabled() && InvokerExtensionProcessor.logger.isLoggable(Level.FINE)) {
                                        InvokerExtensionProcessor.logger.entering("com.ibm.ws.webcontainer.extension.InvokerExtensionProcessor", methodName);
                                    }
                                    request = (HttpServletRequest)req;
                                    response = (HttpServletResponse)resp;
                                    dispatchContext = (WebAppDispatcherContext)ServletUtil.unwrapRequest((ServletRequest)request).getWebAppDispatcherContext();
                                    errorString = null;
                                    invokePath = null;
                                    servletName = null;
                                    s = null;
                                    reqURI = null;
                                    failedAddMappingTarget = false;
                                    cacheKey = new StringBuffer(req.getServerName());
                                    cacheKey.append(':');
                                    cacheKey.append(req.getServerPort());
                                    try {
                                        isInclude = dispatchContext.isInclude();
                                        if (isInclude) {
                                            if (TraceComponent.isAnyTracingEnabled() && InvokerExtensionProcessor.logger.isLoggable(Level.FINE)) {
                                                InvokerExtensionProcessor.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.extension.InvokerExtensionProcessor", methodName, "InvokerExtensionProcessor is called from include so use request attributes");
                                            }
                                            invokePath = (String)request.getAttribute("jakarta.servlet.include.servlet_path");
                                            pathInfo = (String)request.getAttribute("jakarta.servlet.include.path_info");
                                            reqURI = (String)request.getAttribute("jakarta.servlet.include.request_uri");
                                        } else {
                                            if (TraceComponent.isAnyTracingEnabled() && InvokerExtensionProcessor.logger.isLoggable(Level.FINE)) {
                                                InvokerExtensionProcessor.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.extension.InvokerExtensionProcessor", methodName, "InvokerExtensionProcessor called directly or from forward.");
                                            }
                                            invokePath = request.getServletPath();
                                            pathInfo = request.getPathInfo();
                                            reqURI = request.getRequestURI();
                                        }
                                        if (TraceComponent.isAnyTracingEnabled() && InvokerExtensionProcessor.logger.isLoggable(Level.FINE)) {
                                            InvokerExtensionProcessor.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.extension.InvokerExtensionProcessor", methodName, "before stripping /servlet/, servletName-->[" + servletName + "], reqURI-->[" + reqURI + "]");
                                        }
                                        if ((servletName = this.getServletName(pathInfo)) == null || servletName.length() == 0 || servletName.equals(InvokerExtensionProcessor.showCfg)) {
                                            var17_17 = null;
                                            if (s != null || !handleFailure) break block45;
                                        }
                                        ** GOTO lbl-1000
                                    }
                                    catch (Throwable var25_35) {
                                        if (s == null && handleFailure) {
                                            response.sendError(404, MessageFormat.format(InvokerExtensionProcessor.nls.getString("Servlet.Not.Found.{0}", "Servlet Not Found: {0}"), new Object[]{errorString}));
                                        }
                                        if (TraceComponent.isAnyTracingEnabled() == false) throw var25_35;
                                        if (InvokerExtensionProcessor.logger.isLoggable(Level.FINE) == false) throw var25_35;
                                        InvokerExtensionProcessor.logger.exiting("com.ibm.ws.webcontainer.extension.InvokerExtensionProcessor", methodName);
                                        throw var25_35;
                                    }
                                    response.sendError(404, MessageFormat.format(InvokerExtensionProcessor.nls.getString("Servlet.Not.Found.{0}", "Servlet Not Found: {0}"), new Object[]{errorString}));
                                }
                                if (TraceComponent.isAnyTracingEnabled() == false) return var17_17;
                                if (InvokerExtensionProcessor.logger.isLoggable(Level.FINE) == false) return var17_17;
                                InvokerExtensionProcessor.logger.exiting("com.ibm.ws.webcontainer.extension.InvokerExtensionProcessor", methodName);
                                return var17_17;
lbl-1000:
                                // 1 sources

                                {
                                    if (TraceComponent.isAnyTracingEnabled() && InvokerExtensionProcessor.logger.isLoggable(Level.FINE)) {
                                        InvokerExtensionProcessor.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.extension.InvokerExtensionProcessor", methodName, "after stripping /servlet/, servletName-->[" + servletName + "]");
                                    }
                                    if (!InvokerExtensionProcessor.doNotServeByClassName) ** GOTO lbl-1000
                                    if (TraceComponent.isAnyTracingEnabled() && InvokerExtensionProcessor.logger.isLoggable(Level.FINE)) {
                                        InvokerExtensionProcessor.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.extension.InvokerExtensionProcessor", methodName, "Checking if " + servletName + " is on the blockedClassesList");
                                    }
                                    if (!InvokerExtensionProcessor.blockedClassesList.contains(servletName)) ** GOTO lbl-1000
                                    InvokerExtensionProcessor.logger.logp(Level.WARNING, "com.ibm.ws.webcontainer.extension.InvokerExtensionProcessor", methodName, MessageFormat.format(InvokerExtensionProcessor.nls.getString("servlet.on.blocked.list.{0}", "Servlet on the blocked list: {0}"), new Object[]{servletName}));
                                    if (handleFailure) {
                                        errorString = "/servlet/" + servletName;
                                    }
                                    var17_18 = null;
                                    if (s != null || !handleFailure) break block46;
                                }
                                response.sendError(404, MessageFormat.format(InvokerExtensionProcessor.nls.getString("Servlet.Not.Found.{0}", "Servlet Not Found: {0}"), new Object[]{errorString}));
                            }
                            if (TraceComponent.isAnyTracingEnabled() == false) return var17_18;
                            if (InvokerExtensionProcessor.logger.isLoggable(Level.FINE) == false) return var17_18;
                            InvokerExtensionProcessor.logger.exiting("com.ibm.ws.webcontainer.extension.InvokerExtensionProcessor", methodName);
                            return var17_18;
lbl-1000:
                            // 2 sources

                            {
                                if (pathInfo != null) {
                                    ind = pathInfo.indexOf(servletName);
                                    invokePath = invokePath + pathInfo.substring(0, ind += servletName.length());
                                    pathInfo = pathInfo.substring(ind);
                                }
                                if (TraceComponent.isAnyTracingEnabled() && InvokerExtensionProcessor.logger.isLoggable(Level.FINE)) {
                                    InvokerExtensionProcessor.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.extension.InvokerExtensionProcessor", methodName, "after parsing servletName from request elements, invokePath -->[" + invokePath + "], pathInfo-->[" + pathInfo + "]");
                                }
                                dispatchContext.setPathElements(invokePath, pathInfo);
                                cacheKey.append(reqURI);
                                cWrapper = WebContainer.getFromCache(cacheKey);
                                if (cWrapper == null) ** GOTO lbl-1000
                                if (TraceComponent.isAnyTracingEnabled() && InvokerExtensionProcessor.logger.isLoggable(Level.FINE)) {
                                    InvokerExtensionProcessor.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.extension.InvokerExtensionProcessor", methodName, "InvokerExtensionProcessor found cacheServletWrapper");
                                }
                                var18_21 = cWrapper.getCacheTarget();
                                if (s != null || !handleFailure) break block47;
                            }
                            response.sendError(404, MessageFormat.format(InvokerExtensionProcessor.nls.getString("Servlet.Not.Found.{0}", "Servlet Not Found: {0}"), new Object[]{errorString}));
                        }
                        if (TraceComponent.isAnyTracingEnabled() == false) return var18_21;
                        if (InvokerExtensionProcessor.logger.isLoggable(Level.FINE) == false) return var18_21;
                        InvokerExtensionProcessor.logger.exiting("com.ibm.ws.webcontainer.extension.InvokerExtensionProcessor", methodName);
                        return var18_21;
lbl-1000:
                        // 1 sources

                        {
                            if (!((WebApp)this.extensionContext).isInternalServlet(servletName)) ** GOTO lbl-1000
                            var18_22 = null;
                            if (s != null || !handleFailure) break block48;
                        }
                        response.sendError(404, MessageFormat.format(InvokerExtensionProcessor.nls.getString("Servlet.Not.Found.{0}", "Servlet Not Found: {0}"), new Object[]{errorString}));
                    }
                    if (TraceComponent.isAnyTracingEnabled() == false) return var18_22;
                    if (InvokerExtensionProcessor.logger.isLoggable(Level.FINE) == false) return var18_22;
                    InvokerExtensionProcessor.logger.exiting("com.ibm.ws.webcontainer.extension.InvokerExtensionProcessor", methodName);
                    return var18_22;
lbl-1000:
                    // 1 sources

                    {
                        s = ((WebApp)this.extensionContext).getServletWrapper(servletName);
                        if (s == null) ** GOTO lbl-1000
                        if (TraceComponent.isAnyTracingEnabled() && InvokerExtensionProcessor.logger.isLoggable(Level.FINE)) {
                            InvokerExtensionProcessor.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.extension.InvokerExtensionProcessor", methodName, "found servletWrapper already in the webApp for -->[" + servletName + "]");
                        }
                        var18_23 = s;
                        if (s != null || !handleFailure) break block49;
                    }
                    response.sendError(404, MessageFormat.format(InvokerExtensionProcessor.nls.getString("Servlet.Not.Found.{0}", "Servlet Not Found: {0}"), new Object[]{errorString}));
                }
                if (TraceComponent.isAnyTracingEnabled() == false) return var18_23;
                if (InvokerExtensionProcessor.logger.isLoggable(Level.FINE) == false) return var18_23;
                InvokerExtensionProcessor.logger.exiting("com.ibm.ws.webcontainer.extension.InvokerExtensionProcessor", methodName);
                return var18_23;
lbl-1000:
                // 1 sources

                {
                    if (TraceComponent.isAnyTracingEnabled() && InvokerExtensionProcessor.logger.isLoggable(Level.FINE)) {
                        InvokerExtensionProcessor.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.extension.InvokerExtensionProcessor", methodName, "Couldn't find servletWrapper, traverse servletInfos or create servletWrapper");
                    }
                    var18_24 = InvokerExtensionProcessor.getSyncObject(invokePath);
                    synchronized (var18_24) {
                        s = ((WebApp)this.extensionContext).getServletWrapper(servletName);
                        if (s == null) ** break block50
                        if (TraceComponent.isAnyTracingEnabled() && InvokerExtensionProcessor.logger.isLoggable(Level.FINE)) {
                            InvokerExtensionProcessor.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.extension.InvokerExtensionProcessor", methodName, "found servletWrapper already in the webApp for -->[" + servletName + "]");
                        }
                        var19_25 = s;
                        if (s != null || !handleFailure) break block51;
                    }
                }
                response.sendError(404, MessageFormat.format(InvokerExtensionProcessor.nls.getString("Servlet.Not.Found.{0}", "Servlet Not Found: {0}"), new Object[]{errorString}));
            }
            if (TraceComponent.isAnyTracingEnabled() == false) return var19_25;
            if (InvokerExtensionProcessor.logger.isLoggable(Level.FINE) == false) return var19_25;
            InvokerExtensionProcessor.logger.exiting("com.ibm.ws.webcontainer.extension.InvokerExtensionProcessor", methodName);
            return var19_25;
            {
                i = ((WebApp)this.extensionContext).getConfiguration().getServletInfos();
                while (i.hasNext()) {
                    sc = (ServletConfig)i.next();
                    className = sc.getClassName();
                    if (className == null || !(InvokerExtensionProcessor.servletCaseSensitive != false ? className.equals(servletName) != false : className.equalsIgnoreCase(servletName) != false)) continue;
                    if (TraceComponent.isAnyTracingEnabled() && InvokerExtensionProcessor.logger.isLoggable(Level.FINE)) {
                        InvokerExtensionProcessor.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.extension.InvokerExtensionProcessor", methodName, "className for current ServletConfig is [" + className + "]");
                    }
                    if ((s = ((WebApp)this.extensionContext).getServletWrapper(realName = sc.getServletName())) != null) {
                        if (TraceComponent.isAnyTracingEnabled() && InvokerExtensionProcessor.logger.isLoggable(Level.FINE)) {
                            InvokerExtensionProcessor.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.extension.InvokerExtensionProcessor", methodName, "found servletWrapper for real servlet name -->[" + realName + "], handle the request");
                        }
                        var23_32 = s;
                        // MONITOREXIT @DISABLED, blocks:[17, 24, 13] lbl133 : MonitorExitStatement: MONITOREXIT : var18_24
                        if (s == null && handleFailure) {
                            response.sendError(404, MessageFormat.format(InvokerExtensionProcessor.nls.getString("Servlet.Not.Found.{0}", "Servlet Not Found: {0}"), new Object[]{errorString}));
                        }
                        if (TraceComponent.isAnyTracingEnabled() == false) return var23_32;
                        if (InvokerExtensionProcessor.logger.isLoggable(Level.FINE) == false) return var23_32;
                        InvokerExtensionProcessor.logger.exiting("com.ibm.ws.webcontainer.extension.InvokerExtensionProcessor", methodName);
                        return var23_32;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && InvokerExtensionProcessor.logger.isLoggable(Level.FINE)) {
                        InvokerExtensionProcessor.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.extension.InvokerExtensionProcessor", methodName, "unable to retrieve a servlet wrapper even though the class names matched");
                    }
                    var23_33 = null;
                    // MONITOREXIT @DISABLED, blocks:[17, 13] lbl143 : MonitorExitStatement: MONITOREXIT : var18_24
                    if (s == null && handleFailure) {
                        response.sendError(404, MessageFormat.format(InvokerExtensionProcessor.nls.getString("Servlet.Not.Found.{0}", "Servlet Not Found: {0}"), new Object[]{errorString}));
                    }
                    if (TraceComponent.isAnyTracingEnabled() == false) return var23_33;
                    if (InvokerExtensionProcessor.logger.isLoggable(Level.FINE) == false) return var23_33;
                    InvokerExtensionProcessor.logger.exiting("com.ibm.ws.webcontainer.extension.InvokerExtensionProcessor", methodName);
                    return var23_33;
                }
                {
                    block52: {
                        s = ((WebApp)this.extensionContext).getServletWrapper(servletName);
                        if (s == null) {
                            sconfig = this.createConfig("Invoked_" + System.currentTimeMillis());
                            sconfig.setServletName(servletName);
                            sconfig.setDisplayName(servletName);
                            sconfig.setClassName(servletName);
                            sconfig.setStartUpWeight(1);
                            sconfig.setServletContext(((WebApp)this.extensionContext).getFacade());
                            sconfig.setIsJsp(false);
                            sconfig.setAsyncSupported(true);
                            try {
                                if (TraceComponent.isAnyTracingEnabled() && InvokerExtensionProcessor.logger.isLoggable(Level.FINE)) {
                                    InvokerExtensionProcessor.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.extension.InvokerExtensionProcessor", methodName, "InvokerExtensionProcessor will create a servlet wrapper");
                                }
                                s = this.createServletWrapper(sconfig);
                                wConfig = (WebAppConfiguration)this.extensionContext.getWebAppConfig();
                                internalSConfig = (ServletConfig)sconfig;
                                wConfig.addServletInfo(servletName, internalSConfig);
                                wConfig.addServletMapping(servletName, invokePath);
                                try {
                                    this.extensionContext.addMappingTarget(invokePath + "/*", s);
                                }
                                catch (Exception e2) {
                                    failedAddMappingTarget = true;
                                    if (TraceComponent.isAnyTracingEnabled() && InvokerExtensionProcessor.logger.isLoggable(Level.FINE)) {
                                        InvokerExtensionProcessor.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.extension.InvokerExtensionProcessor", methodName, "Error adding mapping Target", e2);
                                    }
                                }
                            }
                            catch (Throwable t) {
                                if (TraceComponent.isAnyTracingEnabled() && InvokerExtensionProcessor.logger.isLoggable(Level.FINE)) {
                                    InvokerExtensionProcessor.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.extension.InvokerExtensionProcessor", methodName, "exception caught creating servlet wrapper or adding mapping", t);
                                }
                                if (!handleFailure) break block52;
                                throw new ServletException("Initialization Error :" + t.getMessage());
                            }
                        }
                    }
                    // MONITOREXIT @DISABLED, blocks:[9, 13] lbl182 : MonitorExitStatement: MONITOREXIT : var18_24
                    if (s != null || !handleFailure) break block53;
                }
            }
            response.sendError(404, MessageFormat.format(InvokerExtensionProcessor.nls.getString("Servlet.Not.Found.{0}", "Servlet Not Found: {0}"), new Object[]{errorString}));
        }
        if (TraceComponent.isAnyTracingEnabled() == false) return s;
        if (InvokerExtensionProcessor.logger.isLoggable(Level.FINE) == false) return s;
        InvokerExtensionProcessor.logger.exiting("com.ibm.ws.webcontainer.extension.InvokerExtensionProcessor", methodName);
        return s;
    }

    private String getServletName(String pathInfo) {
        String servletName = null;
        if (pathInfo != null && (servletName = WebGroup.stripURL(pathInfo)) != null) {
            int index;
            if (servletName.charAt(0) == '/') {
                servletName = servletName.substring(1);
            }
            if ((index = servletName.indexOf("/")) != -1) {
                servletName = servletName.substring(0, index);
            }
        }
        return servletName;
    }

    @Override
    public List getPatternList() {
        return this.patternList;
    }

    private String getInitParameter(String param) {
        return (String)this.params.get(param);
    }

    private List parseInvokerExtensions(String exts) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(exts, ": ;");
        while (st.hasMoreTokens()) {
            String ext = st.nextToken();
            if (ext.equals("/")) {
                ext = "/*";
            }
            if (this.patternList.contains(ext)) continue;
            list.add(ext);
        }
        return list;
    }

    @Override
    public WebComponentMetaData getMetaData() {
        return null;
    }

    @Override
    public IServletWrapper getServletWrapper(ServletRequest req, ServletResponse resp) throws Exception {
        return this.getServletWrapper(req, resp, false);
    }

    static {
        doNotServeByClassName = false;
        if (WCCustomProperties.DO_NOT_SERVE_BY_CLASSNAME != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "InvokerExtensionProcessor", "doNotServeByClassName set to true");
            }
            doNotServeByClassName = true;
            String blockedClasses = WCCustomProperties.DO_NOT_SERVE_BY_CLASSNAME;
            StringTokenizer tokenizedBlockedClasses = new StringTokenizer(blockedClasses, "; \t\n\r\f");
            blockedClassesList = new HashSet(tokenizedBlockedClasses.countTokens());
            while (tokenizedBlockedClasses.hasMoreTokens()) {
                String classToBlock = tokenizedBlockedClasses.nextToken();
                if (classToBlock.equals("*")) {
                    logger.logp(Level.WARNING, CLASS_NAME, "handleRequest", nls.getString("filtering.by.asterisk", "Filtering by asterisk is not allowed."));
                }
                blockedClassesList.add(classToBlock);
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
                logger.logp(Level.FINE, CLASS_NAME, "InvokerExtensionProcessor", "Added " + classToBlock + " to blockedClassesList.");
            }
        }
    }

    private static class SyncHelper {
        public static Object[] syncObjects;

        private SyncHelper() {
        }

        static {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, InvokerExtensionProcessor.CLASS_NAME, "handleRequest", "Sync objects are being intialized for synchronization during creation of servlet wrappers.");
            }
            syncObjects = new Object[41];
            for (int k = 0; k < 41; ++k) {
                SyncHelper.syncObjects[k] = new Object();
            }
        }
    }
}

