/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.jaeger;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.exporter.internal.grpc.GrpcExporter;
import io.opentelemetry.exporter.jaeger.JaegerGrpcSpanExporterBuilder;
import io.opentelemetry.exporter.jaeger.PostSpansRequestMarshaler;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;

@Deprecated
@ThreadSafe
public final class JaegerGrpcSpanExporter
implements SpanExporter {
    private static final String DEFAULT_HOST_NAME = "unknown";
    private static final AttributeKey<String> CLIENT_VERSION_KEY = AttributeKey.stringKey("jaeger.version");
    private static final String CLIENT_VERSION_VALUE = "opentelemetry-java";
    private static final AttributeKey<String> HOSTNAME_KEY = AttributeKey.stringKey("hostname");
    private static final String IP_DEFAULT = "0.0.0.0";
    static final AttributeKey<String> IP_KEY = AttributeKey.stringKey("ip");
    private final GrpcExporter<PostSpansRequestMarshaler> delegate;
    private final Resource jaegerResource;

    JaegerGrpcSpanExporter(GrpcExporter<PostSpansRequestMarshaler> delegate) {
        String ipv4;
        String hostname;
        this.delegate = delegate;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
            ipv4 = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            hostname = DEFAULT_HOST_NAME;
            ipv4 = IP_DEFAULT;
        }
        this.jaegerResource = Resource.builder().put(CLIENT_VERSION_KEY, CLIENT_VERSION_VALUE).put(IP_KEY, ipv4).put(HOSTNAME_KEY, hostname).build();
    }

    @Override
    public CompletableResultCode export(Collection<SpanData> spans) {
        ArrayList<CompletableResultCode> results = new ArrayList<CompletableResultCode>();
        spans.stream().collect(Collectors.groupingBy(SpanData::getResource)).forEach((resource, spanData) -> results.add(this.delegate.export(this.buildRequest((Resource)resource, (List<SpanData>)spanData), spanData.size())));
        return CompletableResultCode.ofAll(results);
    }

    private PostSpansRequestMarshaler buildRequest(Resource resource, List<SpanData> spans) {
        Resource mergedResource = this.jaegerResource.merge(resource);
        return PostSpansRequestMarshaler.create(spans, mergedResource);
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public static JaegerGrpcSpanExporterBuilder builder() {
        return new JaegerGrpcSpanExporterBuilder();
    }

    @Override
    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }

    Resource getJaegerResource() {
        return this.jaegerResource;
    }
}

