/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.util.Collection;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class CollectionExpression
extends ConstantExpression {
    public CollectionExpression() {
    }

    public CollectionExpression(Object newValue, Expression baseExpression) {
        super(newValue, baseExpression);
    }

    @Override
    public void printSQL(ExpressionSQLPrinter printer) {
        Object value = this.value;
        if (this.localBase != null) {
            value = this.localBase.getFieldValue(value, this.getSession());
        }
        printer.printList((Collection)value, this.canBind);
    }

    @Override
    public Object valueFromObject(Object object, AbstractSession session, AbstractRecord translationRow, int valueHolderPolicy, boolean isObjectUnregistered) {
        if (this.value instanceof Collection) {
            Collection values = (Collection)this.value;
            Vector fieldValues = new Vector(values.size());
            for (Object value : values) {
                if (value instanceof Expression) {
                    value = ((Expression)value).valueFromObject(object, session, translationRow, valueHolderPolicy, isObjectUnregistered);
                } else if (this.localBase != null) {
                    value = this.localBase.getFieldValue(value, session);
                }
                fieldValues.add(value);
            }
            return fieldValues;
        }
        if (this.localBase != null) {
            return this.localBase.getFieldValue(this.value, session);
        }
        return this.value;
    }

    @Override
    public void setLocalBase(Expression e) {
        super.setLocalBase(e);
        if (this.value instanceof Collection) {
            Collection values = (Collection)this.value;
            for (Object val : values) {
                if (!(val instanceof Expression)) continue;
                ((Expression)val).setLocalBase(e);
            }
        }
    }

    @Override
    protected void postCopyIn(Map alreadyDone) {
        super.postCopyIn(alreadyDone);
        if (this.value instanceof Collection) {
            Collection values = (Collection)this.value;
            NonSynchronizedVector<Expression> newValues = NonSynchronizedVector.newInstance(values.size());
            for (Object val : values) {
                if (val instanceof Expression) {
                    ((Vector)newValues).add(((Expression)val).copiedVersionFrom(alreadyDone));
                    continue;
                }
                ((Vector)newValues).add((Expression)val);
            }
            this.setValue(newValues);
        }
    }
}

