/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcpchannel.internal;

import com.ibm.io.async.AsyncTimeoutException;
import com.ibm.io.async.IAbstractAsyncFuture;
import com.ibm.io.async.IAsyncFuture;
import com.ibm.io.async.ICompletionListener;
import com.ibm.io.async.TimerWorkItem;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.tcpchannel.internal.AioSocketIOChannel;
import com.ibm.ws.tcpchannel.internal.AioTCPWriteRequestContextImpl;
import com.ibm.wsspi.channelfw.VirtualConnection;
import java.io.IOException;
import java.net.SocketTimeoutException;

class AioWriteCompletionListener
implements ICompletionListener {
    private static final TraceComponent tc = Tr.register(AioWriteCompletionListener.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");
    private static volatile IOException connClosedException = null;

    AioWriteCompletionListener() {
    }

    @Override
    public void futureCompleted(IAbstractAsyncFuture future, Object o) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"AioWriteCompletionListener.futureCompleted", (Object[])new Object[0]);
        }
        AioTCPWriteRequestContextImpl req = (AioTCPWriteRequestContextImpl)o;
        boolean errorOccurred = false;
        IOException ioe = null;
        long byteCount = 0L;
        boolean complete = false;
        VirtualConnection vci = null;
        TimerWorkItem twi = future.getTimeoutWorkItem();
        if (twi != null) {
            twi.state = 2L;
        }
        if ((vci = req.getTCPConnLink().getVirtualConnection()) != null) {
            if (vci.isInputStateTrackingOperational() && !vci.requestPermissionToFinishWrite()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Can't get permission to finish write, throwing write request away.", (Object[])new Object[0]);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"AioWriteCompletionListener.futureCompleted");
                }
                return;
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Can't get virtual connection object, throwing write request away.", (Object[])new Object[0]);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"AioWriteCompletionListener.futureCompleted");
            }
            return;
        }
        try {
            IAsyncFuture fut = (IAsyncFuture)future;
            byteCount = fut.getByteCount();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("async write multi buffer bytesWritten: (" + byteCount), (Object[])new Object[0]);
            }
            req.postProcessWriteBuffers(byteCount);
            complete = req.getIOAmount() == -1L ? req.updateForAllData(byteCount) : req.updateIOCounts(byteCount, 1);
            if (byteCount == 0L) {
                errorOccurred = true;
                if (connClosedException == null) {
                    connClosedException = new IOException("Write failed: Connection closed by peer.");
                }
                ioe = connClosedException;
            }
        }
        catch (IOException ex) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("exception caught: " + ex), (Object[])new Object[0]);
            }
            if (ex instanceof AsyncTimeoutException) {
                ioe = new SocketTimeoutException(ex.getMessage());
                ioe.initCause(ex);
            } else {
                ioe = ex;
            }
            errorOccurred = true;
        }
        catch (InterruptedException ie) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("AioWriteCompletionListener caught exception. " + ie), (Object[])new Object[0]);
            }
            FFDCFilter.processException((Throwable)ie, (String)(this.getClass().getName() + ".futureCompleted"), (String)"134");
        }
        if (!errorOccurred) {
            if (complete) {
                future.setFullyCompleted(true);
                req.getWriteCompletedCallback().complete(req.getTCPConnLink().getVirtualConnection(), req);
            } else {
                long remainingTimeout;
                if (req.getTCPConnLink().getConfig().getDumpStatsInterval() > 0) {
                    req.getTCPConnLink().getTCPChannel().totalPartialAsyncWrites.incrementAndGet();
                }
                if ((remainingTimeout = (long)req.getTimeoutInterval()) != 0L && (remainingTimeout = req.getTimeoutTime() - System.currentTimeMillis()) <= 0L) {
                    ioe = new SocketTimeoutException("Async write timed out after writing partial data");
                    errorOccurred = true;
                }
                if (!errorOccurred) {
                    try {
                        ((AioSocketIOChannel)req.getTCPConnLink().getSocketIOChannel()).writeAIO(req, true, remainingTimeout);
                    }
                    catch (IOException ex) {
                        ioe = ex;
                        errorOccurred = true;
                    }
                }
            }
        }
        if (errorOccurred) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("IOException while doing IO requested on local: " + req.getTCPConnLink().getSocketIOChannel().getSocket().getLocalSocketAddress() + " remote: " + req.getTCPConnLink().getSocketIOChannel().getSocket().getRemoteSocketAddress()), (Object[])new Object[0]);
                Tr.event((TraceComponent)tc, (String)("Calling write error callback with Exception is: " + ioe), (Object[])new Object[0]);
            }
            req.getWriteCompletedCallback().error(req.getTCPConnLink().getVirtualConnection(), req, ioe);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"AioWriteCompletionListener.futureCompleted");
        }
    }
}

