/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.internal;

import com.ibm.ejs.container.EJBNotFoundException;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.EJSWrapperCommon;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.EJBReference;
import com.ibm.ws.ejbcontainer.EJBReferenceFactory;
import com.ibm.ws.ejbcontainer.internal.EJBReferenceImpl;
import com.ibm.ws.managedobject.ManagedObjectContext;
import jakarta.ejb.EJBException;

public class EJBReferenceFactoryImpl
implements EJBReferenceFactory {
    private static final TraceComponent tc = Tr.register(EJBReferenceFactoryImpl.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private final J2EEName j2eeName;
    private EJSHome home;

    public EJBReferenceFactoryImpl(J2EEName j2eeName) {
        this.j2eeName = j2eeName;
    }

    private synchronized EJSHome getEJSHome() {
        if (this.home == null) {
            try {
                this.home = EJSContainer.getDefaultContainer().getInstalledHome(this.j2eeName);
            }
            catch (EJBNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.home;
    }

    @Override
    public EJBReference create(ManagedObjectContext context) {
        EJSWrapperCommon wc;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("create : " + this.j2eeName + " : " + context), (Object[])new Object[0]);
        }
        try {
            wc = this.getEJSHome().createBusinessObjectWrappers(context);
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
        EJBReferenceImpl ejbReference = new EJBReferenceImpl(wc);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("create : " + ejbReference));
        }
        return ejbReference;
    }
}

