/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.data.internal.persistence.service;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.data.internal.persistence.Util;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AllPermission;
import java.security.Permissions;
import java.security.ProtectionDomain;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class ClassDefiner {
    private static final TraceComponent tc = Tr.register(ClassDefiner.class, (String)"data", (String)"io.openliberty.data.internal.persistence.resources.CWWKDMessages");
    private static volatile Method svFindLoadedClassMethod;
    private static volatile Method svDefineClassMethod;
    private static ProtectionDomain svAllPermissionProtectionDomain;
    static final long serialVersionUID = 866383332778423305L;

    ClassDefiner() {
    }

    /*
     * WARNING - void declaration
     */
    Class<?> findLoadedClass(ClassLoader classLoader, String className) {
        try {
            Method findLoadedClassMethod = svFindLoadedClassMethod;
            if (findLoadedClassMethod == null) {
                try {
                    findLoadedClassMethod = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    void ex;
                    FFDCFilter.processException((Throwable)noSuchMethodException, (String)"io.openliberty.data.internal.persistence.service.ClassDefiner", (String)"65", (Object)this, (Object[])new Object[]{classLoader, className});
                    throw new IllegalStateException((Throwable)ex);
                }
                findLoadedClassMethod.setAccessible(true);
                svFindLoadedClassMethod = findLoadedClassMethod;
            }
            return (Class)findLoadedClassMethod.invoke((Object)classLoader, className);
        }
        catch (IllegalAccessException findLoadedClassMethod) {
            void ex;
            FFDCFilter.processException((Throwable)findLoadedClassMethod, (String)"io.openliberty.data.internal.persistence.service.ClassDefiner", (String)"74", (Object)this, (Object[])new Object[]{classLoader, className});
            throw new IllegalStateException((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"io.openliberty.data.internal.persistence.service.ClassDefiner", (String)"76", (Object)this, (Object[])new Object[]{classLoader, className});
            Throwable cause = ex.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new IllegalStateException(cause);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    @ManualTrace
    Class<?> defineClass(ClassLoader classLoader, String className, byte[] classbytes) {
        Method defineClassMethod;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"defineClass", (Object[])new Object[]{classLoader, className, classbytes.length});
        }
        if ((defineClassMethod = svDefineClassMethod) == null) {
            Permissions perms = new Permissions();
            perms.add(new AllPermission());
            svAllPermissionProtectionDomain = new ProtectionDomain(null, perms);
            try {
                defineClassMethod = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                void ex;
                FFDCFilter.processException((Throwable)noSuchMethodException, (String)"io.openliberty.data.internal.persistence.service.ClassDefiner", (String)"116", (Object)this, (Object[])new Object[]{classLoader, className, classbytes});
                throw new IllegalStateException((Throwable)ex);
            }
            defineClassMethod.setAccessible(true);
            svDefineClassMethod = defineClassMethod;
        }
        try {
            Class c = (Class)defineClassMethod.invoke((Object)classLoader, className, classbytes, 0, classbytes.length, svAllPermissionProtectionDomain);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"defineClass", (Object)Util.toString(c, ""));
            }
            return c;
        }
        catch (IllegalAccessException c) {
            void ex;
            FFDCFilter.processException((Throwable)c, (String)"io.openliberty.data.internal.persistence.service.ClassDefiner", (String)"138", (Object)this, (Object[])new Object[]{classLoader, className, classbytes});
            throw new IllegalStateException((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"io.openliberty.data.internal.persistence.service.ClassDefiner", (String)"140", (Object)this, (Object[])new Object[]{classLoader, className, classbytes});
            Throwable cause = ex.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new IllegalStateException(cause);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    @ManualTrace
    Class<?> findLoadedOrDefineClass(ClassLoader classLoader, String className, byte[] classbytes) {
        Class<?> klass;
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"findLoadedOrDefineClass", (Object[])new Object[]{classLoader, className, classbytes.length});
            }
            if ((klass = this.findLoadedClass(classLoader, className)) == null) {
                try {
                    klass = this.defineClass(classLoader, className, classbytes);
                }
                catch (LinkageError linkageError) {
                    void ex;
                    FFDCFilter.processException((Throwable)linkageError, (String)"io.openliberty.data.internal.persistence.service.ClassDefiner", (String)"173", (Object)this, (Object[])new Object[]{classLoader, className, classbytes});
                    klass = this.findLoadedClass(classLoader, className);
                    if (klass != null) break block5;
                    throw ex;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findLoadedOrDefineClass", klass);
        }
        return klass;
    }
}

