/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.compiler.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.wsspi.jsp.resource.translation.JspResources;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
public class JspFileObject
extends SimpleJavaFileObject {
    protected static final Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.compiler.utils.JspFileObject";
    private URI uri;
    private final File source;
    private String binaryName;
    private boolean isJar;
    private String protocol;
    private String javaEncoding;
    private JarFile jarFile;
    static final long serialVersionUID = -3704839044299575147L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    JspFileObject(String binaryName, final URI uri, String protocol) {
        block10: {
            super(uri, JavaFileObject.Kind.CLASS);
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering(CLASS_NAME, "<init>", new Object[]{binaryName, uri, protocol});
            }
            this.isJar = false;
            this.protocol = "";
            this.javaEncoding = "UTF-8";
            this.jarFile = null;
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "JspFileObject", "Creating JspFileObject. binaryName = " + binaryName + " uri = " + uri + " protocol = " + protocol);
            }
            this.binaryName = binaryName;
            this.uri = uri;
            this.source = null;
            this.protocol = protocol;
            if (protocol.equals("jar")) {
                this.isJar = true;
            } else if (protocol.equals("wsjar")) {
                this.isJar = true;
                try {
                    this.jarFile = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedAction<JarFile>(){
                        static final long serialVersionUID = 7523770335522446089L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public JarFile run() {
                            try {
                                return new JarFile(uri.toURL().getFile());
                            }
                            catch (IOException e) {
                                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                    logger.logp(Level.FINE, JspFileObject.CLASS_NAME, "JspFileObject", "IOException in doPriviledged creating JarFile.", e);
                                }
                                return null;
                            }
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jsp.translator.compiler.utils.JspFileObject$1", 1.class, null, null);
                        }
                    }) : new JarFile(uri.toURL().getFile());
                }
                catch (MalformedURLException e) {
                    if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "JspFileObject", "Unable to get URI of wsjar file.", e);
                    }
                }
                catch (IOException e) {
                    if (!com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block10;
                    logger.logp(Level.FINE, CLASS_NAME, "JspFileObject", "IOException processing jar.", e);
                }
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspFileObject(JspResources source, JavaFileObject.Kind kind) {
        this(source, kind, null);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[]{source, kind});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspFileObject(JspResources source, JavaFileObject.Kind kind, String javaEncoding) {
        super(JspFileObject.jspResourceSourceOrClassURI(source, kind), kind);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[]{source, kind, javaEncoding});
        }
        this.isJar = false;
        this.protocol = "";
        this.javaEncoding = "UTF-8";
        this.jarFile = null;
        this.source = source.getGeneratedSourceFile();
        this.binaryName = source.getPackageName() + '.' + source.getClassName();
        this.uri = JspFileObject.jspResourceSourceOrClassURI(source, kind);
        if (javaEncoding != null) {
            this.javaEncoding = javaEncoding;
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "JspFileObject", "Creating JspFileObject. source = " + this.source + " uri = " + this.uri + " binaryName = " + this.binaryName + " Kind = " + (Object)((Object)kind));
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static URI jspResourceSourceOrClassURI(JspResources source, JavaFileObject.Kind kind) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "jspResourceSourceOrClassURI", new Object[]{source, kind});
        }
        if (kind.equals((Object)JavaFileObject.Kind.CLASS)) {
            URI uRI = new File(source.getGeneratedSourceFile().getAbsolutePath().replaceAll(JavaFileObject.Kind.SOURCE.extension + "$", JavaFileObject.Kind.CLASS.extension)).toURI();
            if (logger != null && logger.isLoggable(Level.FINER)) {
                uRI = uRI;
                logger.exiting(CLASS_NAME, "jspResourceSourceOrClassURI", uRI);
            }
            return uRI;
        }
        URI uRI = source.getGeneratedSourceFile().toURI();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            uRI = uRI;
            logger.exiting(CLASS_NAME, "jspResourceSourceOrClassURI", uRI);
        }
        return uRI;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws UnsupportedOperationException, IOException {
        StringBuffer sourceStringBuffer;
        block8: {
            String line;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering(CLASS_NAME, "getCharContent", new Object[]{ignoreEncodingErrors});
            }
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getCharContent", "Reading file = " + this.source);
            }
            if (this.source == null) {
                throw new UnsupportedOperationException("Trying to read a file that does not contain source code.");
            }
            FileInputStream jspSourceInputStream = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedAction<FileInputStream>(){
                static final long serialVersionUID = -229653156048465444L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public FileInputStream run() {
                    try {
                        return new FileInputStream(JspFileObject.this.source);
                    }
                    catch (FileNotFoundException e) {
                        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, JspFileObject.CLASS_NAME, "getCharContent", "There was a problem getting the FileInputStream of source = " + JspFileObject.this.source, e);
                        }
                        return null;
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.jsp.translator.compiler.utils.JspFileObject$2", 2.class, null, null);
                }
            }) : new FileInputStream(this.source);
            if (jspSourceInputStream == null) {
                throw new IOException("There was a problem getting the FileInputStream of source = [" + this.source + "]");
            }
            InputStreamReader file = new InputStreamReader((InputStream)jspSourceInputStream, this.javaEncoding);
            BufferedReader reader = new BufferedReader(file);
            sourceStringBuffer = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                sourceStringBuffer.append(line).append('\n');
            }
            try {
                reader.close();
            }
            catch (IOException ex) {
                if (!com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block8;
                logger.logp(Level.FINE, CLASS_NAME, "getCharContent", "There was a problem closing reader", ex);
            }
        }
        StringBuffer stringBuffer = sourceStringBuffer;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            stringBuffer = stringBuffer;
            logger.exiting(CLASS_NAME, "getCharContent", stringBuffer);
        }
        return stringBuffer;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public InputStream openInputStream() throws MalformedURLException, IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "openInputStream", new Object[0]);
        }
        JarFile jarFile = null;
        if (this.isJar) {
            if (this.protocol.equals("wsjar")) {
                jarFile = this.jarFile;
            } else {
                JarURLConnection jarUrlConnection = (JarURLConnection)this.uri.toURL().openConnection();
                jarFile = jarUrlConnection.getJarFile();
            }
            JarEntry jarEntry = jarFile.getJarEntry(this.binaryName.replace('.', '/') + JavaFileObject.Kind.CLASS.extension);
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "openInputStream", "Opening the stream of jarEntry = " + jarEntry + " from jar = " + jarFile);
            }
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            if (logger != null && logger.isLoggable(Level.FINER)) {
                inputStream = inputStream;
                logger.exiting(CLASS_NAME, "openInputStream", inputStream);
            }
            return inputStream;
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "openInputStream", "Opening the stream of uri = " + this.uri);
        }
        InputStream inputStream = this.uri.toURL().openStream();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            inputStream = inputStream;
            logger.exiting(CLASS_NAME, "openInputStream", inputStream);
        }
        return inputStream;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getBinaryName() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getBinaryName", new Object[0]);
        }
        String string = this.binaryName;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "getBinaryName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JarFile getJarFile() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getJarFile", new Object[0]);
        }
        JarFile jarFile = this.jarFile;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jarFile = jarFile;
            logger.exiting(CLASS_NAME, "getJarFile", jarFile);
        }
        return jarFile;
    }
}

