/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.classsource.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Factory;
import com.ibm.ws.annocache.service.internal.AnnotationCacheServiceImpl_Logging;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.anno.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.anno.classsource.ClassSource_ScanCounts;
import com.ibm.wsspi.anno.classsource.ClassSource_Streamer;
import com.ibm.wsspi.annocache.classsource.ClassSource;
import com.ibm.wsspi.annocache.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.annocache.classsource.ClassSource_ClassLoader;
import com.ibm.wsspi.annocache.classsource.ClassSource_Exception;
import com.ibm.wsspi.annocache.classsource.ClassSource_Options;
import com.ibm.wsspi.annocache.util.Util_InternMap;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class ClassSourceImpl_Aggregate
implements ClassSource_Aggregate {
    protected static final Logger logger = AnnotationCacheServiceImpl_Logging.ANNO_LOGGER;
    protected static final Logger stateLogger = AnnotationCacheServiceImpl_Logging.ANNO_STATE_LOGGER;
    protected static final Logger jandexLogger = AnnotationCacheServiceImpl_Logging.ANNO_JANDEX_LOGGER;
    public static final String CLASS_NAME = ClassSourceImpl_Aggregate.class.getSimpleName();
    protected final String hashText;
    private final ClassSource_Options options;
    private final ClassSourceImpl_Factory factory;
    private final Util_InternMap internMap;
    protected final String applicationName;
    protected final String moduleName;
    protected final String moduleCategoryName;
    private int openCount;
    private List<ClassSource> successfulOpens;
    private List<ClassSource> failedOpens;
    protected final List<ClassSource> classSources;
    protected final Map<String, String> classSourceNames;
    private int internalSourceCount;
    protected final Set<ClassSource> seedClassSources;
    protected final Set<ClassSource> partialClassSources;
    protected final Set<ClassSource> excludedClassSources;
    protected final Set<ClassSource> externalClassSources;
    protected long totalLookups;
    protected long repeatLookups;
    protected Map<String, Integer> i_lookupCounts;
    protected final Map<String, Boolean> i_globalResults;
    protected final Map<ClassSource, Set<String>> i_failedLookups;
    public Map<String, ClassSource> i_firstSuccesses;
    protected long cacheReadTime;
    protected long cacheWriteTime;
    private TimingDataImpl timingData;
    static final long serialVersionUID = -1471546409106125551L;

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getHashText() {
        return this.hashText;
    }

    @Trivial
    public String toString() {
        return this.hashText;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassSourceImpl_Aggregate(ClassSourceImpl_Factory factory, Util_InternMap internMap, String applicationName, String moduleName, String moduleCategoryName, ClassSource_Options options) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "<init>", new Object[]{factory, internMap, applicationName, moduleName, moduleCategoryName, options});
        }
        String methodName = "<init>";
        this.options = options;
        this.factory = factory;
        this.internMap = internMap;
        this.applicationName = applicationName;
        this.moduleName = moduleName;
        this.moduleCategoryName = moduleCategoryName;
        this.seedClassSources = new HashSet<ClassSource>();
        this.partialClassSources = new HashSet<ClassSource>();
        this.excludedClassSources = new HashSet<ClassSource>();
        this.externalClassSources = new HashSet<ClassSource>();
        this.classSources = new ArrayList<ClassSource>();
        this.classSourceNames = new HashMap<String, String>();
        this.internalSourceCount = 0;
        this.openCount = 0;
        this.successfulOpens = new ArrayList<ClassSource>();
        this.failedOpens = new ArrayList<ClassSource>();
        this.totalLookups = 0L;
        this.repeatLookups = 0L;
        this.i_lookupCounts = new IdentityHashMap<String, Integer>();
        this.i_globalResults = new IdentityHashMap<String, Boolean>();
        this.i_failedLookups = new IdentityHashMap<ClassSource, Set<String>>();
        this.i_firstSuccesses = new IdentityHashMap<String, ClassSource>();
        this.cacheReadTime = 0L;
        this.cacheWriteTime = 0L;
        this.hashText = this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + "(" + this.applicationName + ":" + this.moduleName + ":" + this.moduleCategoryName + ")";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ]", this.hashText);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "<init>", this);
        }
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassSource_Options getOptions() {
        return this.options;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassSourceImpl_Factory getFactory() {
        return this.factory;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Util_InternMap getInternMap() {
        return this.internMap;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String internClassName(String className) {
        return this.getInternMap().intern(className);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String internClassName(String className, boolean doForce) {
        return this.getInternMap().intern(className, doForce);
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getModuleCategoryName() {
        return this.moduleCategoryName;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getOpenCount() {
        return this.openCount;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean getIsOpen() {
        return this.openCount > 0;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected List<ClassSource> retrieveSuccessfulOpens() {
        List<ClassSource> oldSuccessfulOpens = this.successfulOpens;
        this.successfulOpens = new ArrayList<ClassSource>();
        return oldSuccessfulOpens;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<ClassSource> getSuccessfulOpens() {
        return this.successfulOpens;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void addSuccessfulOpen(ClassSource classSource) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "addSuccessfulOpen", new Object[]{classSource});
        }
        this.successfulOpens.add(classSource);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "addSuccessfulOpen");
        }
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<ClassSource> getFailedOpens() {
        return this.failedOpens;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void addFailedOpen(ClassSource classSource) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "addFailedOpen", new Object[]{classSource});
        }
        this.failedOpens.add(classSource);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "addFailedOpen");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized void open() throws ClassSource_Exception {
        String methodName = "open";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER Open count [ {1} ]", new Object[]{this.getHashText(), this.openCount});
        }
        ++this.openCount;
        if (this.openCount == 1) {
            for (ClassSource nextClassSource : this.retrieveSuccessfulOpens()) {
                try {
                    nextClassSource.open();
                    this.addSuccessfulOpen(nextClassSource);
                }
                catch (ClassSource_Exception classSource_Exception) {
                    void e;
                    FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", (String)"312", (Object)this, (Object[])new Object[0]);
                    this.addFailedOpen(nextClassSource);
                    logger.logp(Level.WARNING, CLASS_NAME, methodName, "ANNO_INFOSTORE_OPEN1_EXCEPTION", new Object[]{this.getHashText(), nextClassSource.getHashText(), e});
                }
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] RETURN Open count [ {1} ]", new Object[]{this.getHashText(), this.openCount});
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized void close() throws ClassSource_Exception {
        String methodName = "close";
        if (this.openCount == 0) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER/RETURN [ {1} ]", new Object[]{this.getHashText(), this.openCount});
            }
            return;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER [ {1} ]", new Object[]{this.getHashText(), this.openCount});
        }
        --this.openCount;
        if (this.openCount == 0) {
            for (ClassSource nextClassSource : this.getSuccessfulOpens()) {
                try {
                    nextClassSource.close();
                }
                catch (ClassSource_Exception classSource_Exception) {
                    void e;
                    FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", (String)"351", (Object)this, (Object[])new Object[0]);
                    logger.logp(Level.WARNING, CLASS_NAME, methodName, "ANNO_CLASSSOURCE_CLOSE1_EXCEPTION", new Object[]{this.getHashText(), nextClassSource.getCanonicalName(), nextClassSource.getHashText(), e});
                }
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[{0}] RETURN Open Count [{1}]", new Object[]{this.getHashText(), this.openCount});
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void addClassSource(ClassSource classSource) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "addClassSource", new Object[]{classSource});
        }
        this.addClassSource(classSource, ClassSource_Aggregate.ScanPolicy.SEED);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "addClassSource");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void addClassLoaderClassSource(ClassSource_ClassLoader classSource) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "addClassLoaderClassSource", new Object[]{classSource});
        }
        this.addClassSource(classSource, ClassSource_Aggregate.ScanPolicy.EXTERNAL);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "addClassLoaderClassSource");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void addClassSource(ClassSource classSource, ClassSource_Aggregate.ScanPolicy scanPolicy) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "addClassSource", new Object[]{classSource, scanPolicy});
        }
        String methodName = "addClassSource";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Adding [ {1} ] [ {2} ]", new Object[]{this.getHashText(), classSource.getHashText(), scanPolicy});
        }
        this.basicAddClassSource(classSource, scanPolicy);
        this.addSuccessfulOpen(classSource);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "addClassSource");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<ClassSource> getClassSources(ClassSource_Aggregate.ScanPolicy scanPolicy) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getClassSources", new Object[]{scanPolicy});
        }
        if (scanPolicy == ClassSource_Aggregate.ScanPolicy.SEED) {
            Set<ClassSource> set = this.seedClassSources;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                set = set;
                logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getClassSources", set);
            }
            return set;
        }
        if (scanPolicy == ClassSource_Aggregate.ScanPolicy.PARTIAL) {
            Set<ClassSource> set = this.partialClassSources;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                set = set;
                logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getClassSources", set);
            }
            return set;
        }
        if (scanPolicy == ClassSource_Aggregate.ScanPolicy.EXCLUDED) {
            Set<ClassSource> set = this.excludedClassSources;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                set = set;
                logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getClassSources", set);
            }
            return set;
        }
        Set<ClassSource> set = this.externalClassSources;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getClassSources", set);
        }
        return set;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<ClassSource> getSeedClassSources() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getSeedClassSources", new Object[0]);
        }
        Set<ClassSource> set = this.seedClassSources;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getSeedClassSources", set);
        }
        return set;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<ClassSource> getPartialClassSources() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getPartialClassSources", new Object[0]);
        }
        Set<ClassSource> set = this.partialClassSources;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getPartialClassSources", set);
        }
        return set;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<ClassSource> getExcludedClassSources() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getExcludedClassSources", new Object[0]);
        }
        Set<ClassSource> set = this.excludedClassSources;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getExcludedClassSources", set);
        }
        return set;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<ClassSource> getExternalClassSources() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getExternalClassSources", new Object[0]);
        }
        Set<ClassSource> set = this.externalClassSources;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getExternalClassSources", set);
        }
        return set;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<ClassSource> getClassSources() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getClassSources", new Object[0]);
        }
        List<ClassSource> list = this.classSources;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getClassSources", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void basicAddClassSource(ClassSource classSource, ClassSource_Aggregate.ScanPolicy scanPolicy) {
        boolean isInternal;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "basicAddClassSource", new Object[]{classSource, scanPolicy});
        }
        this.classSources.add(classSource);
        String classSourceName = classSource.getName();
        if (classSourceName != null) {
            this.classSourceNames.put(classSourceName, classSource.getCanonicalName());
        }
        classSource.setParentSource(this);
        if (scanPolicy == ClassSource_Aggregate.ScanPolicy.SEED) {
            this.seedClassSources.add(classSource);
            isInternal = true;
        } else if (scanPolicy == ClassSource_Aggregate.ScanPolicy.PARTIAL) {
            this.partialClassSources.add(classSource);
            isInternal = true;
        } else if (scanPolicy == ClassSource_Aggregate.ScanPolicy.EXCLUDED) {
            this.excludedClassSources.add(classSource);
            isInternal = true;
        } else {
            this.externalClassSources.add(classSource);
            isInternal = false;
        }
        if (isInternal) {
            ++this.internalSourceCount;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "basicAddClassSource");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassSource_Aggregate.ScanPolicy getScanPolicy(ClassSource classSource) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getScanPolicy", new Object[]{classSource});
        }
        if (this.seedClassSources.contains(classSource)) {
            ClassSource_Aggregate.ScanPolicy scanPolicy = ClassSource_Aggregate.ScanPolicy.SEED;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                scanPolicy = scanPolicy;
                logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getScanPolicy", (Object)scanPolicy);
            }
            return scanPolicy;
        }
        if (this.partialClassSources.contains(classSource)) {
            ClassSource_Aggregate.ScanPolicy scanPolicy = ClassSource_Aggregate.ScanPolicy.PARTIAL;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                scanPolicy = scanPolicy;
                logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getScanPolicy", (Object)scanPolicy);
            }
            return scanPolicy;
        }
        if (this.excludedClassSources.contains(classSource)) {
            ClassSource_Aggregate.ScanPolicy scanPolicy = ClassSource_Aggregate.ScanPolicy.EXCLUDED;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                scanPolicy = scanPolicy;
                logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getScanPolicy", (Object)scanPolicy);
            }
            return scanPolicy;
        }
        ClassSource_Aggregate.ScanPolicy scanPolicy = ClassSource_Aggregate.ScanPolicy.EXTERNAL;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            scanPolicy = scanPolicy;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getScanPolicy", (Object)scanPolicy);
        }
        return scanPolicy;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getInternalSourceCount() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getInternalSourceCount", new Object[0]);
        }
        int n = this.internalSourceCount;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getInternalSourceCount", n);
        }
        return n;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, String> getCanonicalNames() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getCanonicalNames", new Object[0]);
        }
        Map<String, String> map = this.classSourceNames;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            map = map;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getCanonicalNames", map);
        }
        return map;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getCanonicalName(String classSourceName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getCanonicalName", new Object[]{classSourceName});
        }
        String string = this.classSourceNames.get(classSourceName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getCanonicalName", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getTotalLookups() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getTotalLookups", new Object[0]);
        }
        long l = this.totalLookups;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getTotalLookups", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void recordLookup() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "recordLookup", new Object[0]);
        }
        ++this.totalLookups;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "recordLookup");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getRepeatLookups() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getRepeatLookups", new Object[0]);
        }
        long l = this.repeatLookups;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getRepeatLookups", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void recordRepeatLookup() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "recordRepeatLookup", new Object[0]);
        }
        ++this.repeatLookups;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "recordRepeatLookup");
        }
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, Integer> getLookupCounts() {
        return this.i_lookupCounts;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Integer i_recordLookup(String i_className) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "i_recordLookup", new Object[]{i_className});
        }
        Integer lookupCount = this.i_lookupCounts.get(i_className);
        if (lookupCount == null) {
            lookupCount = 1;
        } else {
            lookupCount = lookupCount + 1;
            this.recordRepeatLookup();
        }
        this.recordLookup();
        this.i_lookupCounts.put(i_className, lookupCount);
        Integer n = lookupCount;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "i_recordLookup", n);
        }
        return n;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, Boolean> getGlobalResults() {
        return this.i_globalResults;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Boolean getGlobalResult(String className) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getGlobalResult", new Object[]{className});
        }
        Boolean bl = this.i_getGlobalResult(this.internClassName(className));
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getGlobalResult", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Boolean i_getGlobalResult(String i_className) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "i_getGlobalResult", new Object[]{i_className});
        }
        Boolean bl = this.i_globalResults.get(i_className);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "i_getGlobalResult", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void i_setGlobalResult(String i_className, boolean value) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "i_setGlobalResult", new Object[]{i_className, value});
        }
        this.i_globalResults.put(i_className, value);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "i_setGlobalResult");
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<ClassSource, Set<String>> getFailedLookups() {
        return this.i_failedLookups;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getFailedLookups(ClassSource classSource) {
        return this.i_failedLookups.get(classSource);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Set<String> getFailedLookupsForcing(ClassSource classSource) {
        Set<String> specificFailedLookups = this.i_failedLookups.get(classSource);
        if (specificFailedLookups == null) {
            specificFailedLookups = new HashSet<String>();
            this.i_failedLookups.put(classSource, specificFailedLookups);
        }
        return specificFailedLookups;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean i_alreadyFailed(ClassSource classSource, String i_className) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "i_alreadyFailed", new Object[]{classSource, i_className});
        }
        Set<String> specificFailedLookups = this.getFailedLookups(classSource);
        boolean bl = specificFailedLookups != null && specificFailedLookups.contains(i_className);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "i_alreadyFailed", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void i_markFailed(ClassSource classSource, String i_className) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "i_markFailed", new Object[]{classSource, i_className});
        }
        this.getFailedLookupsForcing(classSource).add(i_className);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "i_markFailed");
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, ClassSource> getFirstSuccesses() {
        return this.i_firstSuccesses;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassSource getFirstSuccess(String className) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getFirstSuccess", new Object[]{className});
        }
        ClassSource classSource = this.i_getFirstSuccess(this.internClassName(className));
        if (logger != null && logger.isLoggable(Level.FINER)) {
            classSource = classSource;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getFirstSuccess", classSource);
        }
        return classSource;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected ClassSource i_getFirstSuccess(String i_className) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "i_getFirstSuccess", new Object[]{i_className});
        }
        ClassSource classSource = this.i_firstSuccesses.get(i_className);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            classSource = classSource;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "i_getFirstSuccess", classSource);
        }
        return classSource;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void i_setFirstSuccess(String i_className, ClassSource ClassSource2) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "i_setFirstSuccess", new Object[]{i_className, ClassSource2});
        }
        this.i_firstSuccesses.put(i_className, ClassSource2);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "i_setFirstSuccess");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void i_recordLookup(String i_className, ClassSource classSource) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "i_recordLookup", new Object[]{i_className, classSource});
        }
        this.i_setFirstSuccess(i_className, classSource);
        this.i_setGlobalResult(i_className, true);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "i_recordLookup");
        }
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public BufferedInputStream openClassResourceStream(String className, String resourceName) throws ClassSource_Exception {
        return this.openResourceStream(className, resourceName, 8192);
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public BufferedInputStream openResourceStream(String className, String resourceName, int bufferSize) throws ClassSource_Exception {
        InputStream inputStream = this.openResourceStream(className, resourceName);
        return new BufferedInputStream(inputStream, bufferSize);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized InputStream openResourceStream(String className, String resourceName) throws ClassSource_Exception {
        Object[] objectArray;
        String methodName = "openResourceStream";
        if (logger.isLoggable(Level.FINER)) {
            Object[] objectArray2 = new Object[4];
            objectArray2[0] = this.getHashText();
            objectArray2[1] = className;
            objectArray2[2] = resourceName;
            objectArray = objectArray2;
            objectArray2[3] = null;
        } else {
            objectArray = null;
        }
        Object[] logParams = objectArray;
        String i_className = this.internClassName(className);
        this.i_recordLookup(i_className);
        Boolean globalSuccess = this.i_getGlobalResult(i_className);
        if (globalSuccess != null) {
            if (!globalSuccess.booleanValue()) {
                if (logParams != null) {
                    logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Resource [ {1} ] Class [ {2} ] ENTER / RETURN [ null ] - prior failure", logParams);
                }
                return null;
            }
            ClassSource firstSuccess = this.i_getFirstSuccess(i_className);
            if (logParams != null) {
                logParams[3] = firstSuccess;
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Resource [ {1} ] Class [ {2} ] Found in [ {3} ] RETURN [ non-null ] - prior lookup", logParams);
            }
            return firstSuccess.openResourceStream(className, resourceName);
        }
        if (logParams != null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Resource [ {1} ] Class [ {2} ] ENTER - no prior lookup", logParams);
        }
        InputStream inputStream = null;
        for (ClassSource nextClassSource : this.getSuccessfulOpens()) {
            if (logParams != null) {
                logParams[3] = nextClassSource.hashCode();
            }
            if (this.i_alreadyFailed(nextClassSource, i_className)) {
                if (logParams == null) continue;
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Resource [ {1} ] Class [ {2} ] Skipping [ {3} ] - prior failure", logParams);
                continue;
            }
            try {
                inputStream = nextClassSource.openResourceStream(className, resourceName);
                if (inputStream == null) {
                    if (logParams != null) {
                        logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Resource [ {1} ] Class [ {2} ] Not found in [ {3} ]", logParams);
                    }
                    this.i_markFailed(nextClassSource, i_className);
                    continue;
                }
                this.i_setGlobalResult(i_className, true);
                this.i_setFirstSuccess(i_className, nextClassSource);
                break;
            }
            catch (ClassSource_Exception classSource_Exception) {
                void e;
                FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", (String)"768", (Object)this, (Object[])new Object[]{className, resourceName});
                this.i_setGlobalResult(i_className, true);
                this.i_setFirstSuccess(i_className, nextClassSource);
                throw e;
            }
        }
        if (inputStream == null) {
            this.i_setGlobalResult(i_className, false);
            if (logParams != null) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Resource [ {1} ] Class [ {2} ] ENTER / RETURN [ null ] - first failure", logParams);
            }
            return null;
        }
        if (logParams != null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Resource [ {1} ] Class [ {2} ] Found in [ {3} ] RETURN [ non-null ] - first lookup", logParams);
        }
        return inputStream;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized void closeResourceStream(String className, String resourceName, InputStream inputStream) {
        String methodName = "closeResourceStream";
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", (String)"803", (Object)this, (Object[])new Object[]{className, resourceName, inputStream});
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "ANNO_CLASSSOURCE_CLOSE2_EXCEPTION", new Object[]{this.getHashText(), resourceName, className, e});
        }
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void logState() {
        if (stateLogger.isLoggable(Level.FINER)) {
            this.log(stateLogger);
        }
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void log(Logger useLogger) {
        String methodName = "log";
        if (!useLogger.isLoggable(Level.FINER)) {
            return;
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "BEGIN STATE [ {0} ]", this.getHashText());
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Class sources: BEGIN");
        for (ClassSource nextClassSource : this.getClassSources()) {
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  [ {0} ]", nextClassSource);
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Class sources: END");
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Overall results: BEGIN");
        this.log_lookupCounts(useLogger);
        this.log_globalResults(useLogger);
        this.log_failedLookups(useLogger);
        this.log_firstSuccesses(useLogger);
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Overall results: END");
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "END STATE [ {0} ]", this.getHashText());
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void log_lookupCounts(Logger useLogger) {
        String methodName = "log_lookupCounts";
        if (!useLogger.isLoggable(Level.FINER)) {
            return;
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Lookup Counts: BEGIN");
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Total unique [ {0} ]", this.getLookupCounts().size());
        Object[] params = new Object[]{null, null};
        for (Map.Entry<String, Integer> nextEntry : this.getLookupCounts().entrySet()) {
            params[0] = nextEntry.getKey();
            params[1] = nextEntry.getValue();
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  [ {0} ] [ {1} ]", params);
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Lookup Counts: END");
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void log_globalResults(Logger useLogger) {
        String methodName = "log_globalResults";
        if (!useLogger.isLoggable(Level.FINER)) {
            return;
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Global Results: BEGIN");
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Total unique [ {0} ]", this.getGlobalResults().size());
        Object[] params = new Object[]{null, null};
        for (Map.Entry<String, Boolean> nextEntry : this.getGlobalResults().entrySet()) {
            params[0] = nextEntry.getKey();
            params[1] = nextEntry.getValue();
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  [ {0} ] [ {1} ]", params);
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Global Results: END");
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void log_firstSuccesses(Logger useLogger) {
        String methodName = "log_firstSuccesses";
        if (!useLogger.isLoggable(Level.FINER)) {
            return;
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "First Successes: BEGIN");
        Object[] params = new Object[]{null, null};
        for (Map.Entry<String, ClassSource> nextEntry : this.getFirstSuccesses().entrySet()) {
            params[0] = nextEntry.getKey();
            params[1] = nextEntry.getValue().getHashText();
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  [ {0} ] [ {1} ]", params);
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "First Successes: END");
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void log_failedLookups(Logger useLogger) {
        String methodName = "log_failedLookups";
        if (!useLogger.isLoggable(Level.FINER)) {
            return;
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Failed Lookups: BEGIN");
        for (Map.Entry<ClassSource, Set<String>> nextFailedLookups : this.getFailedLookups().entrySet()) {
            ClassSource nextClassSource = nextFailedLookups.getKey();
            Set<String> nextFailedClasses = nextFailedLookups.getValue();
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  [ {0} ]", nextClassSource.getHashText());
            for (String nextFailedClass : nextFailedClasses) {
                useLogger.logp(Level.FINER, CLASS_NAME, methodName, "    [ {0} ]", nextFailedClass);
            }
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Failed Lookups: END");
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long addCacheReadTime(long readTime, String description) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "addCacheReadTime", new Object[]{readTime, description});
        }
        long l = this.cacheReadTime = this.cacheReadTime + readTime;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "addCacheReadTime", l);
        }
        return l;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getCacheReadTime() {
        return this.cacheReadTime;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long addCacheWriteTime(long writeTime, String description) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "addCacheWriteTime", new Object[]{writeTime, description});
        }
        long l = this.cacheWriteTime = this.cacheWriteTime + writeTime;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "addCacheWriteTime", l);
        }
        return l;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getCacheWriteTime() {
        return this.cacheWriteTime;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setTimingData() {
        int scanSources = 0;
        long scanTime = 0L;
        int scanClasses = 0;
        int readSources = 0;
        long readTime = 0L;
        int readClasses = 0;
        int jandexSources = 0;
        long jandexTime = 0L;
        int jandexClasses = 0;
        int externalSources = 0;
        long externalTime = 0L;
        int externalClasses = 0;
        for (ClassSource classSource : this.getClassSources()) {
            long processTime = classSource.getProcessTime();
            int processCount = classSource.getProcessCount();
            if (this.getScanPolicy(classSource) == ClassSource_Aggregate.ScanPolicy.EXTERNAL) {
                ++externalSources;
                externalTime += processTime;
                externalClasses += processCount;
                continue;
            }
            if (classSource.isProcessedUsingJandex()) {
                ++jandexSources;
                jandexTime += processTime;
                jandexClasses += processCount;
                continue;
            }
            if (classSource.isReadFromCache()) {
                ++readSources;
                readTime += processTime;
                readClasses += processCount;
                continue;
            }
            ++scanSources;
            scanTime += processTime;
            scanClasses += processCount;
        }
        this.timingData = new TimingDataImpl(scanSources, scanTime, scanClasses, readSources, readTime, readClasses, jandexSources, jandexTime, jandexClasses, externalSources, externalTime, externalClasses, this.getCacheReadTime(), this.getCacheWriteTime());
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TimingDataImpl getTimingData() {
        return this.timingData;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void log(TraceComponent tc) {
        if (!tc.isDebugEnabled()) {
            return;
        }
        Tr.debug((TraceComponent)tc, (String)MessageFormat.format("BEGIN STATE [ {0} ]", this.getHashText()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)tc, (String)"Class sources: BEGIN", (Object[])new Object[0]);
        for (ClassSource nextClassSource : this.getClassSources()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("  [ {0} ]", nextClassSource), (Object[])new Object[0]);
        }
        Tr.debug((TraceComponent)tc, (String)"Class sources: END", (Object[])new Object[0]);
        this.logCounts(tc);
        Tr.debug((TraceComponent)tc, (String)"Overall results: BEGIN", (Object[])new Object[0]);
        this.log_lookupCounts(tc);
        this.log_globalResults(tc);
        this.log_failedLookups(tc);
        this.log_firstSuccesses(tc);
        Tr.debug((TraceComponent)tc, (String)"Overall results: END", (Object[])new Object[0]);
        Tr.debug((TraceComponent)tc, (String)MessageFormat.format("END STATE [ {0} ]", this.getHashText()), (Object[])new Object[0]);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void logCounts(TraceComponent tc) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("  Included classes: [ {0} ]", this.getClassInclusionCount()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("  Excluded classes: [ {0} ]", this.getClassExclusionCount()), (Object[])new Object[0]);
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void log_lookupCounts(TraceComponent tc) {
        if (!tc.isDebugEnabled()) {
            return;
        }
        Tr.debug((TraceComponent)tc, (String)"Lookup Counts: BEGIN", (Object[])new Object[0]);
        Tr.debug((TraceComponent)tc, (String)MessageFormat.format("Total unique [ {0} ]", this.getLookupCounts().size()), (Object[])new Object[0]);
        Object[] params = new Object[]{null, null};
        for (Map.Entry<String, Integer> nextEntry : this.getLookupCounts().entrySet()) {
            params[0] = nextEntry.getKey();
            params[1] = nextEntry.getValue();
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("  [ {0} ] [ {1} ]", params), (Object[])new Object[0]);
        }
        Tr.debug((TraceComponent)tc, (String)"Lookup Counts: END", (Object[])new Object[0]);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void log_globalResults(TraceComponent tc) {
        if (!tc.isDebugEnabled()) {
            return;
        }
        Tr.debug((TraceComponent)tc, (String)"Global Results: BEGIN", (Object[])new Object[0]);
        Tr.debug((TraceComponent)tc, (String)MessageFormat.format("Total unique [ {0} ]", this.getGlobalResults().size()), (Object[])new Object[0]);
        Object[] params = new Object[]{null, null};
        for (Map.Entry<String, Boolean> nextEntry : this.getGlobalResults().entrySet()) {
            params[0] = nextEntry.getKey();
            params[1] = nextEntry.getValue();
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("  [ {0} ] [ {1} ]", params), (Object[])new Object[0]);
        }
        Tr.debug((TraceComponent)tc, (String)"Global Results: END", (Object[])new Object[0]);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void log_firstSuccesses(TraceComponent tc) {
        if (!tc.isDebugEnabled()) {
            return;
        }
        Tr.debug((TraceComponent)tc, (String)"First Successes: BEGIN", (Object[])new Object[0]);
        Object[] params = new Object[]{null, null};
        for (Map.Entry<String, ClassSource> nextEntry : this.getFirstSuccesses().entrySet()) {
            params[0] = nextEntry.getKey();
            params[1] = nextEntry.getValue().getHashText();
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("  [ {0} ] [ {1} ]", params), (Object[])new Object[0]);
        }
        Tr.debug((TraceComponent)tc, (String)"First Successes: END", (Object[])new Object[0]);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void log_failedLookups(TraceComponent tc) {
        if (!tc.isDebugEnabled()) {
            return;
        }
        Tr.debug((TraceComponent)tc, (String)"Failed Lookups: BEGIN", (Object[])new Object[0]);
        for (Map.Entry<ClassSource, Set<String>> nextFailedLookups : this.getFailedLookups().entrySet()) {
            ClassSource nextClassSource = nextFailedLookups.getKey();
            Set<String> nextFailedClasses = nextFailedLookups.getValue();
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("  [ {0} ]", nextClassSource.getHashText()), (Object[])new Object[0]);
            for (String nextFailedClass : nextFailedClasses) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("    [ {0} ]", nextFailedClass), (Object[])new Object[0]);
            }
        }
        Tr.debug((TraceComponent)tc, (String)"Failed Lookups: END", (Object[])new Object[0]);
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void addClassSource(com.ibm.wsspi.anno.classsource.ClassSource classSource) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "addClassSource", new Object[]{classSource});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "addClassSource");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void addClassSource(com.ibm.wsspi.anno.classsource.ClassSource classSource, ClassSource_Aggregate.ScanPolicy scanPolicy) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "addClassSource", new Object[]{classSource, scanPolicy});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "addClassSource");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<? extends com.ibm.wsspi.anno.classsource.ClassSource> getClassSources(ClassSource_Aggregate.ScanPolicy scanPolicy) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getClassSources", new Object[]{scanPolicy});
        }
        Set<? extends com.ibm.wsspi.anno.classsource.ClassSource> set = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getClassSources", set);
        }
        return set;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassSource_Aggregate.ScanPolicy getScanPolicy(com.ibm.wsspi.anno.classsource.ClassSource classSource) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getScanPolicy", new Object[]{classSource});
        }
        ClassSource_Aggregate.ScanPolicy scanPolicy = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            scanPolicy = scanPolicy;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getScanPolicy", (Object)scanPolicy);
        }
        return scanPolicy;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void scanClasses(ClassSource_Streamer streamer) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "scanClasses", new Object[]{streamer});
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public com.ibm.wsspi.anno.classsource.ClassSource getParentSource() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getParentSource", new Object[0]);
        }
        com.ibm.wsspi.anno.classsource.ClassSource classSource = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            classSource = classSource;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getParentSource", classSource);
        }
        return classSource;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setParentSource(com.ibm.wsspi.anno.classsource.ClassSource classSource) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "setParentSource", new Object[]{classSource});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "setParentSource");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getName() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getName", new Object[0]);
        }
        String string = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getName", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getCanonicalName() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getCanonicalName", new Object[0]);
        }
        String string = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getCanonicalName", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void scanClasses(ClassSource_Streamer streamer, Set<String> i_seedClassNamesSet, ClassSource_Aggregate.ScanPolicy scanPolicy) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "scanClasses", new Object[]{streamer, i_seedClassNamesSet, scanPolicy});
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean scanSpecificSeedClass(String specificClassName, ClassSource_Streamer streamer) throws com.ibm.wsspi.anno.classsource.ClassSource_Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "scanSpecificSeedClass", new Object[]{specificClassName, streamer});
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean scanReferencedClass(String referencedClassNam, ClassSource_Streamer streamer) throws com.ibm.wsspi.anno.classsource.ClassSource_Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "scanReferencedClass", new Object[]{referencedClassNam, streamer});
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String resourceAppend(String head, String tail) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "resourceAppend", new Object[]{head, tail});
        }
        String string = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "resourceAppend", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isDirectoryResource(String resourceName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "isDirectoryResource", new Object[]{resourceName});
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "isDirectoryResource", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isClassResource(String resourceName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "isClassResource", new Object[]{resourceName});
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "isClassResource", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getClassNameFromResourceName(String resourceName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getClassNameFromResourceName", new Object[]{resourceName});
        }
        String string = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getClassNameFromResourceName", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getResourceNameFromClassName(String className) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getResourceNameFromClassName", new Object[]{className});
        }
        String string = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getResourceNameFromClassName", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String inconvertResourceName(String externalResourceName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "inconvertResourceName", new Object[]{externalResourceName});
        }
        String string = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "inconvertResourceName", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String outconvertResourceName(String internalResourceName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "outconvertResourceName", new Object[]{internalResourceName});
        }
        String string = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "outconvertResourceName", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public InputStream openClassStream(String className) throws com.ibm.wsspi.anno.classsource.ClassSource_Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "openClassStream", new Object[]{className});
        }
        InputStream inputStream = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            inputStream = inputStream;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "openClassStream", inputStream);
        }
        return inputStream;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void closeClassStream(String className, InputStream inputStream) throws com.ibm.wsspi.anno.classsource.ClassSource_Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "closeClassStream", new Object[]{className, inputStream});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "closeClassStream");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassSource_ScanCounts getScanResults() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getScanResults", new Object[0]);
        }
        ClassSource_ScanCounts classSource_ScanCounts = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            classSource_ScanCounts = classSource_ScanCounts;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getScanResults", classSource_ScanCounts);
        }
        return classSource_ScanCounts;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getResult(ClassSource_ScanCounts.ResultField resultField) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getResult", new Object[]{resultField});
        }
        int n = 0;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getResult", n);
        }
        return n;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getResourceExclusionCount() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getResourceExclusionCount", new Object[0]);
        }
        int n = 0;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getResourceExclusionCount", n);
        }
        return n;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getClassExclusionCount() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getClassExclusionCount", new Object[0]);
        }
        int n = 0;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getClassExclusionCount", n);
        }
        return n;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getClassInclusionCount() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getClassInclusionCount", new Object[0]);
        }
        int n = 0;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getClassInclusionCount", n);
        }
        return n;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getFailedLookups(com.ibm.wsspi.anno.classsource.ClassSource classSource) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getFailedLookups", new Object[]{classSource});
        }
        Set<String> set = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "getFailedLookups", set);
        }
        return set;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isProcessedUsingJandex() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "isProcessedUsingJandex", new Object[0]);
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate", "isProcessedUsingJandex", bl);
        }
        return bl;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class TimingDataImpl
    implements ClassSource_Aggregate.TimingData {
        private final int scanSources;
        private final long scanTime;
        private final int scanClasses;
        private final int readSources;
        private final long readTime;
        private final int readClasses;
        private final int jandexSources;
        private final long jandexTime;
        private final int jandexClasses;
        private final int externalSources;
        private final long externalTime;
        private final int externalClasses;
        private final long cacheReadTime;
        private final long cacheWriteTime;
        static final long serialVersionUID = -7075834401938487073L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        protected TimingDataImpl(int scanSources, long scanTime, int scanClasses, int readSources, long readTime, int readClasses, int jandexSources, long jandexTime, int jandexClasses, int externalSources, long externalTime, int externalClasses, long cacheReadTime, long cacheWriteTime) {
            this.scanSources = scanSources;
            this.scanTime = scanTime;
            this.scanClasses = scanClasses;
            this.readSources = readSources;
            this.readTime = readTime;
            this.readClasses = readClasses;
            this.jandexSources = jandexSources;
            this.jandexTime = jandexTime;
            this.jandexClasses = jandexClasses;
            this.externalSources = externalSources;
            this.externalTime = externalTime;
            this.externalClasses = externalClasses;
            this.cacheReadTime = cacheReadTime;
            this.cacheWriteTime = cacheWriteTime;
        }

        protected TimingDataImpl(TimingDataImpl other) {
            this(other.scanSources, other.scanTime, other.scanClasses, other.readSources, other.readTime, other.readClasses, other.jandexSources, other.jandexTime, other.jandexClasses, other.externalSources, other.externalTime, other.externalClasses, other.cacheReadTime, other.cacheWriteTime);
        }

        @Override
        public TimingDataImpl clone() {
            return new TimingDataImpl(this);
        }

        @Override
        @Trivial
        public int getScanSources() {
            return this.scanSources;
        }

        @Override
        @Trivial
        public int getScanClasses() {
            return this.scanClasses;
        }

        @Override
        @Trivial
        public long getScanTime() {
            return this.scanTime;
        }

        @Override
        @Trivial
        public int getReadSources() {
            return this.readSources;
        }

        @Override
        @Trivial
        public int getReadClasses() {
            return this.readClasses;
        }

        @Override
        @Trivial
        public long getReadTime() {
            return this.readTime;
        }

        @Override
        @Trivial
        public int getJandexSources() {
            return this.jandexSources;
        }

        @Override
        @Trivial
        public long getJandexTime() {
            return this.jandexTime;
        }

        @Override
        @Trivial
        public int getJandexClasses() {
            return this.jandexClasses;
        }

        @Override
        @Trivial
        public int getExternalSources() {
            return this.externalSources;
        }

        @Override
        @Trivial
        public long getExternalTime() {
            return this.externalTime;
        }

        @Override
        @Trivial
        public int getExternalClasses() {
            return this.externalClasses;
        }

        @Override
        @Trivial
        public long getCacheReadTime() {
            return this.cacheReadTime;
        }

        @Override
        @Trivial
        public long getCacheWriteTime() {
            return this.cacheWriteTime;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate$TimingDataImpl", TimingDataImpl.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        }
    }
}

