/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.lifecycle;

import jakarta.el.MethodExpression;
import jakarta.faces.FacesException;
import jakarta.faces.FactoryFinder;
import jakarta.faces.application.Application;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.application.ProtectedViewException;
import jakarta.faces.application.ViewExpiredException;
import jakarta.faces.application.ViewHandler;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PhaseEvent;
import jakarta.faces.event.PhaseId;
import jakarta.faces.event.PostAddToViewEvent;
import jakarta.faces.flow.FlowHandler;
import jakarta.faces.lifecycle.ClientWindow;
import jakarta.faces.lifecycle.Lifecycle;
import jakarta.faces.lifecycle.LifecycleFactory;
import jakarta.faces.render.RenderKit;
import jakarta.faces.render.RenderKitFactory;
import jakarta.faces.render.ResponseStateManager;
import jakarta.faces.view.ViewDeclarationLanguage;
import jakarta.faces.view.ViewMetadata;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.application.ViewIdSupport;
import org.apache.myfaces.config.webparameters.MyfacesConfig;
import org.apache.myfaces.event.PostClientWindowAndViewInitializedEvent;
import org.apache.myfaces.lifecycle.PhaseExecutor;
import org.apache.myfaces.lifecycle.RestoreViewSupport;
import org.apache.myfaces.renderkit.ErrorPageWriter;
import org.apache.myfaces.util.ExternalContextUtils;

class RestoreViewExecutor
extends PhaseExecutor {
    private static final Logger log = Logger.getLogger(RestoreViewExecutor.class.getName());
    private RestoreViewSupport _restoreViewSupport;
    private ViewIdSupport _viewIdSupport;
    private Boolean _viewNotFoundCheck;
    private RenderKitFactory _renderKitFactory = null;

    RestoreViewExecutor() {
    }

    @Override
    public void doPrePhaseActions(FacesContext facesContext) {
        facesContext.getApplication().getViewHandler().initView(facesContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(FacesContext facesContext) {
        boolean errorPageRequest;
        if (facesContext == null) {
            throw new FacesException("FacesContext is null");
        }
        Application application = facesContext.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        RestoreViewSupport restoreViewSupport = this.getRestoreViewSupport(facesContext);
        ViewIdSupport viewHandlerSupport = this.getViewIdSupport(facesContext);
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (viewRoot != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("View already exists in the FacesContext");
            }
            viewRoot.setLocale(facesContext.getExternalContext().getRequestLocale());
            restoreViewSupport.processComponentBinding(facesContext, viewRoot);
            this._invokeViewRootAfterPhaseListener(facesContext);
            return false;
        }
        String viewId = viewHandlerSupport.calculateViewId(facesContext);
        boolean bl = errorPageRequest = facesContext.getExternalContext().getRequestMap().get("jakarta.servlet.error.message") != null;
        if (!errorPageRequest && restoreViewSupport.isPostback(facesContext)) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Request is a postback");
            }
            if (this.checkViewNotFound(facesContext)) {
                String derivedViewId = viewHandler.deriveLogicalViewId(facesContext, viewId);
                ViewDeclarationLanguage vdl = viewHandler.getViewDeclarationLanguage(facesContext, derivedViewId);
                if (facesContext.getResponseComplete()) {
                    return true;
                }
                if (vdl == null || derivedViewId == null) {
                    this.sendSourceNotFound(facesContext, viewId);
                    return true;
                }
                if (!viewHandlerSupport.isViewExistent(facesContext, derivedViewId)) {
                    this.sendSourceNotFound(facesContext, viewId);
                    return true;
                }
            }
            try {
                facesContext.setProcessingEvents(false);
                viewRoot = viewHandler.restoreView(facesContext, viewId);
                if (viewRoot == null) {
                    if (facesContext.getResponseComplete()) {
                        boolean derivedViewId = true;
                        return derivedViewId;
                    }
                    throw new ViewExpiredException("View \"" + viewId + "\" could not be restored.", viewId);
                }
                if (viewRoot.isTransient()) {
                    this.checkViewProtection(facesContext, viewHandler, viewRoot.getViewId(), viewRoot);
                }
                facesContext.setViewRoot(viewRoot);
            }
            finally {
                facesContext.setProcessingEvents(true);
            }
            restoreViewSupport.processComponentBinding(facesContext, viewRoot);
            ClientWindow clientWindow = facesContext.getExternalContext().getClientWindow();
            if (clientWindow != null) {
                facesContext.getApplication().publishEvent(facesContext, PostClientWindowAndViewInitializedEvent.class, (Object)clientWindow);
            }
        } else {
            FlowHandler flowHandler;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Request is not a postback. New UIViewRoot will be created");
            }
            String logicalViewId = viewHandler.deriveLogicalViewId(facesContext, viewId);
            ViewDeclarationLanguage vdl = viewHandler.getViewDeclarationLanguage(facesContext, logicalViewId);
            if (facesContext.getResponseComplete()) {
                return true;
            }
            if (this.checkViewNotFound(facesContext)) {
                if (vdl == null || logicalViewId == null) {
                    this.sendSourceNotFound(facesContext, viewId);
                    return true;
                }
                if (!viewHandlerSupport.isViewExistent(facesContext, logicalViewId)) {
                    this.sendSourceNotFound(facesContext, viewId);
                    return true;
                }
            }
            if (vdl != null) {
                ViewMetadata metadata = vdl.getViewMetadata(facesContext, viewId);
                if (metadata != null) {
                    viewRoot = metadata.createMetadataView(facesContext);
                    if (facesContext.getResponseComplete()) {
                        return true;
                    }
                }
                if (viewRoot == null) {
                    facesContext.renderResponse();
                } else if (viewRoot != null && !ViewMetadata.hasMetadata((UIViewRoot)viewRoot)) {
                    facesContext.renderResponse();
                }
            } else {
                facesContext.renderResponse();
            }
            this.checkViewProtection(facesContext, viewHandler, logicalViewId, viewRoot);
            if (viewRoot == null) {
                viewRoot = viewHandler.createView(facesContext, viewId);
            }
            if (viewRoot == null && facesContext.getResponseComplete()) {
                return true;
            }
            facesContext.setViewRoot(viewRoot);
            ClientWindow clientWindow = facesContext.getExternalContext().getClientWindow();
            if (clientWindow != null) {
                facesContext.getApplication().publishEvent(facesContext, PostClientWindowAndViewInitializedEvent.class, (Object)clientWindow);
            }
            if ((flowHandler = facesContext.getApplication().getFlowHandler()) != null) {
                flowHandler.clientWindowTransition(facesContext);
            }
            application.publishEvent(facesContext, PostAddToViewEvent.class, (Object)viewRoot);
        }
        if (errorPageRequest && facesContext.isProjectStage(ProjectStage.Development)) {
            facesContext.getViewRoot().getViewMap().put("__myFacesErrorPageBean", new ErrorPageWriter.ErrorPageBean());
        }
        this._invokeViewRootAfterPhaseListener(facesContext);
        return false;
    }

    private void checkViewProtection(FacesContext facesContext, ViewHandler viewHandler, String viewId, UIViewRoot root) throws ProtectedViewException {
        boolean valid = true;
        if (this.getViewIdSupport(facesContext).isViewProtected(facesContext, viewId)) {
            String token = (String)facesContext.getExternalContext().getRequestParameterMap().get("jakarta.faces.Token");
            if (token != null && token.length() > 0) {
                RenderKit renderKit;
                ResponseStateManager rsm;
                String storedToken;
                String renderKitId = null;
                if (root != null) {
                    renderKitId = root.getRenderKitId();
                }
                if (renderKitId == null) {
                    renderKitId = viewHandler.calculateRenderKitId(facesContext);
                }
                if (token.equals(storedToken = (rsm = (renderKit = this.getRenderKitFactory().getRenderKit(facesContext, renderKitId)).getResponseStateManager()).getCryptographicallyStrongTokenFromSession(facesContext))) {
                    if (!ExternalContextUtils.isPortlet(facesContext.getExternalContext())) {
                        String referer = (String)facesContext.getExternalContext().getRequestHeaderMap().get("Referer");
                        if (referer != null) {
                            valid = valid && this.checkRefererOrOriginHeader(facesContext, viewHandler, referer);
                        }
                        String origin = (String)facesContext.getExternalContext().getRequestHeaderMap().get("Origin");
                        if (valid && origin != null) {
                            valid = valid && this.checkRefererOrOriginHeader(facesContext, viewHandler, origin);
                        }
                    }
                } else {
                    valid = false;
                }
            } else {
                valid = false;
            }
        }
        if (!valid) {
            throw new ProtectedViewException();
        }
    }

    private boolean checkRefererOrOriginHeader(FacesContext facesContext, ViewHandler viewHandler, String refererOrOrigin) {
        try {
            String refererViewId;
            String logicalViewId;
            ExternalContext ectx = facesContext.getExternalContext();
            URI refererURI = new URI(refererOrOrigin);
            String path = refererURI.getPath();
            String appContextPath = ectx.getApplicationContextPath();
            if (refererURI.isAbsolute()) {
                String host = refererURI.getHost();
                int port = refererURI.getPort();
                String serverHost = ectx.getRequestServerName();
                int serverPort = ectx.getRequestServerPort();
                boolean matchPort = true;
                if (serverPort != -1 && port != -1) {
                    matchPort = serverPort == port;
                }
                boolean isStrictJsf2OriginHeaderAppPath = MyfacesConfig.getCurrentInstance((FacesContext)facesContext).isStrictJsf2OriginHeaderAppPath();
                if (!path.isEmpty()) {
                    if (!(serverHost.equals(host) && matchPort && path.contains(appContextPath))) {
                        return false;
                    }
                } else if (!serverHost.equals(host) || !matchPort || isStrictJsf2OriginHeaderAppPath) {
                    return false;
                }
            }
            int appContextPathIndex = appContextPath != null ? path.indexOf(appContextPath) : -1;
            int servletPathIndex = -1;
            int pathInfoIndex = -1;
            if (ectx.getRequestServletPath() != null && ectx.getRequestPathInfo() != null) {
                int n = servletPathIndex = ectx.getRequestServletPath() != null ? path.indexOf(ectx.getRequestServletPath(), Math.max(appContextPathIndex, 0)) : -1;
                if (servletPathIndex != -1) {
                    pathInfoIndex = servletPathIndex + ectx.getRequestServletPath().length();
                }
            } else {
                servletPathIndex = -1;
                pathInfoIndex = Math.max(appContextPathIndex, 0) + appContextPath.length();
            }
            if (!(appContextPath != null && appContextPathIndex < 0 || servletPathIndex < 0 && pathInfoIndex < 0 || (logicalViewId = viewHandler.deriveViewId(facesContext, refererViewId = pathInfoIndex >= 0 ? path.substring(pathInfoIndex) : path.substring(servletPathIndex))) == null)) {
                return true;
            }
            return true;
        }
        catch (URISyntaxException ex) {
            return false;
        }
    }

    private void _invokeViewRootAfterPhaseListener(FacesContext facesContext) {
        UIViewRoot root = facesContext.getViewRoot();
        MethodExpression afterPhaseExpression = root.getAfterPhaseListener();
        if (afterPhaseExpression != null) {
            PhaseEvent event = new PhaseEvent(facesContext, this.getPhase(), this._getLifecycle(facesContext));
            try {
                afterPhaseExpression.invoke(facesContext.getELContext(), new Object[]{event});
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "An Exception occured while processing " + afterPhaseExpression.getExpressionString() + " in Phase " + this.getPhase(), t);
            }
        }
    }

    private Lifecycle _getLifecycle(FacesContext facesContext) {
        LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory((String)"jakarta.faces.lifecycle.LifecycleFactory");
        String id = facesContext.getExternalContext().getInitParameter("jakarta.faces.LIFECYCLE_ID");
        if (id == null) {
            id = "DEFAULT";
        }
        return factory.getLifecycle(id);
    }

    protected RestoreViewSupport getRestoreViewSupport(FacesContext context) {
        if (this._restoreViewSupport == null) {
            this._restoreViewSupport = new RestoreViewSupport(context);
        }
        return this._restoreViewSupport;
    }

    protected ViewIdSupport getViewIdSupport(FacesContext context) {
        if (this._viewIdSupport == null) {
            this._viewIdSupport = ViewIdSupport.getInstance(context);
        }
        return this._viewIdSupport;
    }

    protected RenderKitFactory getRenderKitFactory() {
        if (this._renderKitFactory == null) {
            this._renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"jakarta.faces.render.RenderKitFactory");
        }
        return this._renderKitFactory;
    }

    public void setRestoreViewSupport(RestoreViewSupport restoreViewSupport) {
        this._restoreViewSupport = restoreViewSupport;
    }

    public void setViewHandlerSupport(ViewIdSupport viewHandlerSupport) {
        this._viewIdSupport = viewHandlerSupport;
    }

    @Override
    public PhaseId getPhase() {
        return PhaseId.RESTORE_VIEW;
    }

    protected boolean checkViewNotFound(FacesContext facesContext) {
        if (this._viewNotFoundCheck == null) {
            this._viewNotFoundCheck = MyfacesConfig.getCurrentInstance((FacesContext)facesContext).isStrictJsf2ViewNotFound();
        }
        return this._viewNotFoundCheck;
    }

    private void sendSourceNotFound(FacesContext context, String message) {
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        try {
            context.responseComplete();
            response.sendError(404, message);
        }
        catch (IOException ioe) {
            throw new FacesException((Throwable)ioe);
        }
    }
}

