/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.async;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.webcontainer.async.AsyncContextImpl;
import com.ibm.ws.webcontainer.async.CompleteRunnable;
import com.ibm.ws.webcontainer.osgi.WebContainer;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.ITransferContextService;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServiceWrapper {
    protected static final Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.wsspi.webcontainer.async");
    private static final String CLASS_NAME = "com.ibm.wsspi.webcontainer.async.ServiceWrapper";
    private HashMap<String, Object> contextData = null;
    ClassLoader originalCL = null;
    ClassLoader newCL = null;
    AsyncContextImpl asyncContext;
    private static final String ComponentMetaData = "com-ibm-ws-runtime-metadata-ComponentMetaData-V1";

    static ServiceWrapper newFromPushedData(AsyncContextImpl asynContext) {
        ServiceWrapper orginalServiceWrapper = asynContext.serviceWrapper;
        ServiceWrapper sw = new ServiceWrapper(asynContext);
        sw.setContextData(orginalServiceWrapper.getContextData());
        sw.originalCL = orginalServiceWrapper.originalCL;
        sw.newCL = orginalServiceWrapper.newCL;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "newFromPushedData", "created ServiceWrapper [" + sw + "] , original ServiceWrapper [" + orginalServiceWrapper + "]");
            logger.logp(Level.FINEST, CLASS_NAME, "newFromPushedData", "transferred to new ServiceWrapper, originalCL [" + sw.originalCL + "] , newCL [" + sw.newCL + "]");
        }
        return sw;
    }

    public ServiceWrapper(AsyncContextImpl asyncContext) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "constructor", "creating with async context -> " + asyncContext);
        }
        this.asyncContext = asyncContext;
    }

    void setContextData(HashMap<String, Object> contextData) {
        this.contextData = contextData;
    }

    HashMap<String, Object> getContextData() {
        return this.contextData;
    }

    public void pushContextData() {
        Iterator<ITransferContextService> TransferIterator;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "pushContextData", this);
        }
        this.newCL = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                return old;
            }
        });
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "pushContextData", "thread context class loader [" + this.newCL + "]");
        }
        this.contextData = new HashMap();
        ComponentMetaDataAccessorImpl cmdai = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
        ComponentMetaData cmd = cmdai.getComponentMetaData();
        if (cmd != null) {
            this.contextData.put(ComponentMetaData, cmd);
        }
        if ((TransferIterator = WebContainer.getITransferContextServices()) != null) {
            while (TransferIterator.hasNext()) {
                ITransferContextService tcs = TransferIterator.next();
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "pushContextData", "calling storeState on: " + tcs);
                }
                tcs.storeState(this.contextData);
                this.asyncContext.storeStateCtxData = this.contextData;
            }
        } else if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "pushContextData", "no implmenting services found");
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.exiting(CLASS_NAME, "pushContextData", this);
        }
    }

    protected void popContextData() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "popContextData", this);
        }
        this.originalCL = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(ServiceWrapper.this.newCL);
                return old;
            }
        });
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "popContextData", "old context class loader [" + this.originalCL + "] , new context class loader [" + this.newCL + "]");
        }
        if (this.contextData != null) {
            Iterator<ITransferContextService> TransferIterator;
            ComponentMetaDataAccessorImpl cmdai = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
            ComponentMetaData cmd = (ComponentMetaData)this.contextData.get(ComponentMetaData);
            if (cmd != null) {
                cmdai.beginContext(cmd);
            }
            if ((TransferIterator = WebContainer.getITransferContextServices()) != null) {
                while (TransferIterator.hasNext()) {
                    ITransferContextService tcs = TransferIterator.next();
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                        logger.logp(Level.FINEST, CLASS_NAME, "popContextData", "calling restoreState on: " + tcs);
                    }
                    tcs.restoreState(this.contextData);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.exiting(CLASS_NAME, "popContextData", this);
        }
    }

    protected void resetContextData() {
        Iterator<ITransferContextService> TransferIterator;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "resetContextData", this);
        }
        if ((TransferIterator = WebContainer.getITransferContextServices()) != null) {
            while (TransferIterator.hasNext()) {
                ITransferContextService tcs = TransferIterator.next();
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "resetContextData", "calling resetState on: " + tcs);
                }
                tcs.resetState();
            }
        }
        ComponentMetaDataAccessorImpl cmdai = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
        cmdai.endContext();
        AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                Thread.currentThread().setContextClassLoader(ServiceWrapper.this.originalCL);
                return ServiceWrapper.this.originalCL;
            }
        });
        this.contextData = null;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.exiting(CLASS_NAME, "resetContextData", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wrapAndRun(Runnable runnable) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "wrapAndRun", runnable + " " + this.asyncContext);
        }
        try {
            this.popContextData();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "wrapAndRun", "run with context class loader: " + Thread.currentThread().getContextClassLoader());
            }
            runnable.run();
        }
        finally {
            try {
                this.resetContextData();
            }
            finally {
                if (runnable instanceof CompleteRunnable) {
                    this.asyncContext.notifyITransferContextCompleteState();
                }
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.exiting(CLASS_NAME, "wrapAndRun", runnable);
                }
            }
        }
    }
}

