/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.gd;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.control.ControlAck;
import com.ibm.ws.sib.mfp.control.ControlAreYouFlushed;
import com.ibm.ws.sib.mfp.control.ControlNack;
import com.ibm.ws.sib.mfp.control.ControlNotFlushed;
import com.ibm.ws.sib.processor.exceptions.SIMPErrorException;
import com.ibm.ws.sib.processor.gd.InternalOutputStream;
import com.ibm.ws.sib.processor.gd.Stream;
import com.ibm.ws.sib.processor.gd.StreamSet;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.DownstreamControl;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.interfaces.UpstreamControl;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPPubSubOutboundTransmitControllable;
import com.ibm.ws.sib.processor.runtime.impl.BasicSIMPIterator;
import com.ibm.ws.sib.processor.runtime.impl.ControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.InternalOutputStreamSetControl;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class InternalOutputStreamManager {
    private final UpstreamControl upControl;
    private final SIBUuid8 targetMEUuid;
    private static final TraceComponent tc = SibTr.register(InternalOutputStreamManager.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private final DownstreamControl downControl;
    private final Map<SIBUuid12, StreamSet> streamSets;
    private boolean shellStreamSetOnly = false;
    private boolean isLink = false;
    private final MessageProcessor messageProcessor;

    public InternalOutputStreamManager(DownstreamControl downControl, UpstreamControl upControl, MessageProcessor messageProcessor, SIBUuid8 targetMEUuid, boolean isLink) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"InternalOutputStreamManager", (Object)new Object[]{downControl, upControl, messageProcessor, targetMEUuid, isLink});
        }
        this.downControl = downControl;
        this.upControl = upControl;
        this.targetMEUuid = targetMEUuid;
        this.isLink = isLink;
        this.messageProcessor = messageProcessor;
        this.streamSets = Collections.synchronizedMap(new HashMap());
        this.createShellStreamSet();
        this.shellStreamSetOnly = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"InternalOutputStreamManager", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createShellStreamSet() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createShellStreamSet");
        }
        StreamSet streamSet = null;
        Map<SIBUuid12, StreamSet> map = this.streamSets;
        synchronized (map) {
            streamSet = new StreamSet(null, this.targetMEUuid, 0L, this.isLink ? StreamSet.Type.LINK_INTERNAL_OUTPUT : StreamSet.Type.INTERNAL_OUTPUT);
            this.streamSets.put(null, streamSet);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createShellStreamSet", (Object)streamSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamSet getStreamSet(SIBUuid12 streamID, boolean create) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamSet", (Object)new Object[]{streamID, create});
        }
        StreamSet streamSet = null;
        Map<SIBUuid12, StreamSet> map = this.streamSets;
        synchronized (map) {
            if (this.shellStreamSetOnly) {
                streamSet = this.streamSets.get(null);
                this.streamSets.remove(null);
                this.shellStreamSetOnly = false;
                if (streamSet != null) {
                    streamSet.setStreamID(streamID);
                    this.streamSets.put(streamID, streamSet);
                }
            } else {
                streamSet = this.streamSets.get(streamID);
            }
            if (streamSet == null && create) {
                streamSet = new StreamSet(streamID, this.targetMEUuid, 0L, this.isLink ? StreamSet.Type.LINK_INTERNAL_OUTPUT : StreamSet.Type.INTERNAL_OUTPUT);
                this.streamSets.put(streamID, streamSet);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamSet", (Object)streamSet);
        }
        return streamSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(SIMPMessage msgItem, boolean commitInsert) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addMessage", (Object)new Object[]{msgItem, commitInsert});
        }
        JsMessage jsMsg = msgItem.getMessage();
        SIBUuid12 streamID = jsMsg.getGuaranteedStreamUUID();
        int priority = jsMsg.getPriority();
        Reliability reliability = jsMsg.getReliability();
        StreamSet streamSet = this.getStreamSet(streamID, true);
        long streamStart = jsMsg.getGuaranteedValueCompletedPrefix();
        InternalOutputStream internalOutputStream = null;
        StreamSet streamSet2 = streamSet;
        synchronized (streamSet2) {
            internalOutputStream = (InternalOutputStream)streamSet.getStream(priority, reliability);
            if (internalOutputStream == null && reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0) {
                internalOutputStream = this.createStream(streamSet, priority, reliability, streamStart, jsMsg.getGuaranteedValueStartTick() - 1L);
            }
        }
        if (!msgItem.isFromRemoteME() && internalOutputStream != null) {
            if (commitInsert) {
                internalOutputStream.writeValue(msgItem);
            } else {
                internalOutputStream.writeUncommitted(msgItem);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSilence(SIMPMessage msgItem) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addSilence", (Object)msgItem);
        }
        JsMessage jsMsg = msgItem.getMessage();
        SIBUuid12 streamID = jsMsg.getGuaranteedStreamUUID();
        int priority = jsMsg.getPriority();
        Reliability reliability = jsMsg.getReliability();
        StreamSet streamSet = this.getStreamSet(streamID, true);
        long streamStart = jsMsg.getGuaranteedValueCompletedPrefix();
        InternalOutputStream internalOutputStream = null;
        StreamSet streamSet2 = streamSet;
        synchronized (streamSet2) {
            internalOutputStream = (InternalOutputStream)streamSet.getStream(priority, reliability);
            if (internalOutputStream == null && reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0) {
                internalOutputStream = this.createStream(streamSet, priority, reliability, streamStart, jsMsg.getGuaranteedValueStartTick() - 1L);
            }
        }
        if (internalOutputStream != null) {
            internalOutputStream.writeSilence(msgItem);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addSilence");
        }
    }

    public void processAckExpected(long stamp, int priority, Reliability reliability, SIBUuid12 streamID) throws SIResourceException {
        StreamSet streamSet;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processAckExpected", (Object)new Object[]{stamp, priority, reliability, streamID});
        }
        if ((streamSet = this.getStreamSet(streamID, false)) != null) {
            InternalOutputStream internalOutputStream = (InternalOutputStream)streamSet.getStream(priority, reliability);
            if (reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0) {
                if (internalOutputStream != null) {
                    internalOutputStream.processAckExpected(stamp);
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Unexpected AckExpected message for streamID " + streamID + " Reliability " + reliability + " priority " + priority));
                }
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("AckExpected message for unknown streamID " + streamID));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processAckExpected");
        }
    }

    public void processAck(ControlAck ackMsg) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processAck", (Object)new Object[]{ackMsg});
        }
        long ackPrefix = ackMsg.getAckPrefix();
        this.processAck(ackMsg, ackPrefix);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processAck");
        }
    }

    public void processAck(ControlAck ackMsg, long ackPrefix) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processAck", (Object)new Object[]{ackMsg});
        }
        int priority = ackMsg.getPriority();
        Reliability reliability = ackMsg.getReliability();
        SIBUuid12 streamID = ackMsg.getGuaranteedStreamUUID();
        StreamSet streamSet = this.getStreamSet(streamID, false);
        if (streamSet != null) {
            InternalOutputStream internalOutputStream = (InternalOutputStream)streamSet.getStream(priority, reliability);
            if (reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0) {
                if (internalOutputStream != null) {
                    internalOutputStream.removeTickRangeObjectFromHashmap(new TickRange(7, ackPrefix, ackPrefix));
                    long completedPrefix = internalOutputStream.getAckPrefix();
                    if (ackPrefix > completedPrefix) {
                        internalOutputStream.writeAckPrefix(ackPrefix);
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Unexpected Ack " + ackPrefix + " : completed prefix is " + completedPrefix));
                    }
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Unexpected Ack message for streamID " + streamID + " Reliability " + reliability + " priority " + priority));
                }
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Ack message for unknown streamID " + streamID));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processAck");
        }
    }

    public void processNack(ControlNack nackMsg) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processNack", (Object)nackMsg);
        }
        int priority = nackMsg.getPriority();
        Reliability reliability = nackMsg.getReliability();
        SIBUuid12 streamID = nackMsg.getGuaranteedStreamUUID();
        StreamSet streamSet = this.getStreamSet(streamID, false);
        if (streamSet != null) {
            InternalOutputStream internalOutputStream = (InternalOutputStream)streamSet.getStream(priority, reliability);
            if (reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0) {
                if (internalOutputStream != null) {
                    internalOutputStream.processNack(nackMsg);
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Unexpected Nack message for streamID " + streamID + " Reliability " + reliability + " priority " + priority));
                }
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Nack message for unknown streamID " + streamID));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processNack");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFlushQuery(ControlAreYouFlushed flushQuery) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processFlushQuery", (Object)new Object[]{flushQuery});
        }
        SIBUuid12 streamID = flushQuery.getGuaranteedStreamUUID();
        try {
            InternalOutputStreamManager internalOutputStreamManager = this;
            synchronized (internalOutputStreamManager) {
                SIBUuid8 requestor = flushQuery.getGuaranteedSourceMessagingEngineUUID();
                if (this.isFlushed(streamID)) {
                    this.downControl.sendFlushedMessage(requestor, streamID);
                } else {
                    this.downControl.sendNotFlushedMessage(requestor, streamID, flushQuery.getRequestID());
                }
            }
        }
        catch (SIResourceException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.InternalOutputStreamManager.processFlushQuery", (String)"1:516:1.48.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"processFlushQuery", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processFlushQuery");
        }
    }

    private InternalOutputStream createStream(StreamSet streamSet, int priority, Reliability reliability, long completedPrefix, long LastMessageTickWhenStreamCreated) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createStream", (Object)new Object[]{priority, reliability});
        }
        InternalOutputStream stream = null;
        if (reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0) {
            stream = new InternalOutputStream(priority, reliability, completedPrefix, this.downControl, this.upControl, null, streamSet.getStreamID(), streamSet, this.messageProcessor.getAlarmManager(), this.messageProcessor, LastMessageTickWhenStreamCreated);
        }
        streamSet.setStream(priority, reliability, stream);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createStream", stream);
        }
        return stream;
    }

    public boolean commitInsert(SIMPMessage msg) throws SIResourceException {
        Reliability reliability;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"commitInsert", (Object)new Object[]{msg});
        }
        boolean sendMessage = false;
        JsMessage jsMsg = msg.getMessage();
        SIBUuid12 streamID = jsMsg.getGuaranteedStreamUUID();
        StreamSet streamSet = this.getStreamSet(streamID, false);
        if (streamSet == null) {
            SIMPErrorException e = new SIMPErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.gd.InternalOutputStreamManager.commitInsert", "1:585:1.48.1.1", this}, null));
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.InternalOutputStreamManager.commitInsert", (String)"1:592:1.48.1.1", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)e);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"commitInsert");
            }
            throw e;
        }
        int priority = jsMsg.getPriority();
        InternalOutputStream internalOutputStream = (InternalOutputStream)streamSet.getStream(priority, reliability = jsMsg.getReliability());
        if (internalOutputStream != null) {
            sendMessage = internalOutputStream.writeValue(msg);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"commitInsert");
        }
        return sendMessage;
    }

    public boolean rollbackInsert(MessageItem msg) throws SIResourceException {
        Reliability reliability;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rollbackInsert", (Object)msg);
        }
        boolean sendMessage = false;
        JsMessage jsMsg = msg.getMessage();
        SIBUuid12 streamID = jsMsg.getGuaranteedStreamUUID();
        StreamSet streamSet = this.getStreamSet(streamID, false);
        if (streamSet == null) {
            SIMPErrorException e = new SIMPErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.gd.InternalOutputStreamManager.rollbackInsert", "1:647:1.48.1.1", this}, null));
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.InternalOutputStreamManager.rollbackInsert", (String)"1:654:1.48.1.1", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)e);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"rollbackInsert");
            }
            throw e;
        }
        int priority = jsMsg.getPriority();
        InternalOutputStream internalOutputStream = (InternalOutputStream)streamSet.getStream(priority, reliability = jsMsg.getReliability());
        if (internalOutputStream != null) {
            sendMessage = internalOutputStream.writeSilence(msg);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rollbackInsert");
        }
        return sendMessage;
    }

    public long checkAck(ControlAck ack, long min) throws SIResourceException {
        long ackPrefix;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkAck", (Object)new Object[]{ack, min});
        }
        int priority = ack.getPriority();
        Reliability reliability = ack.getReliability();
        SIBUuid12 streamID = ack.getGuaranteedStreamUUID();
        StreamSet streamSet = this.getStreamSet(streamID, false);
        if (streamSet == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkAck", (Object)min);
            }
            return min;
        }
        InternalOutputStream internalOutputStream = (InternalOutputStream)streamSet.getStream(priority, reliability);
        if (internalOutputStream != null && (ackPrefix = internalOutputStream.getAckPrefix()) < min) {
            min = ackPrefix;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkAck", (Object)new Long(min));
        }
        return min;
    }

    public void forceFlush(SIBUuid12 streamID) throws SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"forceFlush", (Object)streamID);
        }
        StreamSet streamSet = this.streamSets.get(streamID);
        streamSet.dereferenceControlAdapter();
        try {
            this.downControl.sendFlushedMessage(null, streamID);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.InternalOutputStreamManager.forceFlush", (String)"1:743:1.48.1.1", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"forceFlush", (Object)e);
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"forceFlush");
        }
    }

    public void remove(SIBUuid12 streamID) {
        this.streamSets.remove(streamID);
    }

    private boolean isFlushed(SIBUuid12 streamID) {
        return this.getStreamSet(streamID, false) == null;
    }

    public ControlNotFlushed stampNotFlushed(ControlNotFlushed msg, SIBUuid12 streamID) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stampNotFlushed", (Object)new Object[]{msg});
        }
        int count = 0;
        int max = 10 * (Reliability.MAX_INDEX + 1);
        int[] ps = new int[max];
        int[] qs = new int[max];
        long[] cs = new long[max];
        StreamSet streamSet = this.getStreamSet(streamID, false);
        Iterator<Stream> itr = streamSet.iterator();
        while (itr.hasNext()) {
            InternalOutputStream oStream = (InternalOutputStream)itr.next();
            ps[count] = oStream.getPriority();
            qs[count] = oStream.getReliability().toInt();
            cs[count] = oStream.getCompletedPrefix();
            ++count;
        }
        int[] realps = new int[count];
        int[] realqs = new int[count];
        long[] realcs = new long[count];
        System.arraycopy(ps, 0, realps, 0, count);
        System.arraycopy(qs, 0, realqs, 0, count);
        System.arraycopy(cs, 0, realcs, 0, count);
        msg.setCompletedPrefixPriority(realps);
        msg.setCompletedPrefixQOS(realqs);
        msg.setCompletedPrefixTicks(realcs);
        msg.setDuplicatePrefixPriority(realps);
        msg.setDuplicatePrefixQOS(realqs);
        msg.setDuplicatePrefixTicks(realcs);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stampNotFlushed", (Object)msg);
        }
        return msg;
    }

    public SIMPIterator getStreamSetControlIterator(ControlAdapter parent) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamSetControlIterator", (Object)parent);
        }
        InternalOutputStreamSetControllableIterator itr = new InternalOutputStreamSetControllableIterator(this.streamSets.values().iterator(), parent);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamSetControlIterator", this.streamSets.values());
        }
        return itr;
    }

    public void removeMessage(StreamSet streamSet, SIMPMessage msgItem) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeMessage", (Object)new Object[]{streamSet, msgItem});
        }
        int priority = msgItem.getPriority();
        Reliability reliability = msgItem.getReliability();
        InternalOutputStream ioStream = (InternalOutputStream)streamSet.getStream(priority, reliability);
        JsMessage jsMsg = msgItem.getMessage();
        long start = jsMsg.getGuaranteedValueStartTick();
        long end = jsMsg.getGuaranteedValueEndTick();
        TickRange tr = new TickRange(7, start, end);
        if (ioStream != null) {
            ioStream.writeSilenceForced(tr);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeMessage");
        }
    }

    private static final class InternalOutputStreamSetControllableIterator
    extends BasicSIMPIterator {
        private final TraceComponent innerTC = SibTr.register(InternalOutputStreamSetControllableIterator.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
        ControlAdapter parent = null;

        InternalOutputStreamSetControllableIterator(Iterator it, ControlAdapter parent) {
            super(it);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)this.innerTC, (String)"InternalOutputStreamSetControllableIterator", (Object)new Object[]{it, parent});
            }
            this.parent = parent;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)this.innerTC, (String)"InternalOutputStreamSetControllableIterator", (Object)this);
            }
        }

        @Override
        public Object next() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)this.innerTC, (String)"next");
            }
            StreamSet set = (StreamSet)super.next();
            SIMPPubSubOutboundTransmitControllable ioSet = null;
            if (set != null) {
                ioSet = (SIMPPubSubOutboundTransmitControllable)set.getControlAdapter();
                ((InternalOutputStreamSetControl)ioSet).setParentControlAdapter(this.parent);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)this.innerTC, (String)"next", (Object)ioSet);
            }
            return ioSet;
        }
    }
}

