/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.BaseDestinationDefinition;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.ForeignBusDefinition;
import com.ibm.ws.sib.admin.SIBExceptionBase;
import com.ibm.ws.sib.admin.SIBExceptionDestinationNotFound;
import com.ibm.ws.sib.admin.SIBExceptionNoLinkExists;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.ExternalAutoCommitTransaction;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.AbstractAliasDestinationHandler;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.BusHandler;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.LinkHandler;
import com.ibm.ws.sib.processor.impl.MQLinkHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.indexes.DestinationIndex;
import com.ibm.ws.sib.processor.impl.indexes.DestinationTypeFilter;
import com.ibm.ws.sib.processor.impl.indexes.ForeignBusIndex;
import com.ibm.ws.sib.processor.impl.indexes.ForeignBusTypeFilter;
import com.ibm.ws.sib.processor.impl.indexes.LinkIndex;
import com.ibm.ws.sib.processor.impl.indexes.LinkTypeFilter;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationType;
import java.util.Set;

public class DynamicConfigManager {
    private static final TraceComponent tc = SibTr.register(DynamicConfigManager.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls_cwsik = TraceNLS.getTraceNLS((String)"com.ibm.websphere.sib.CWSIKMessages");
    private MessageProcessor _messageProcessor;
    private DestinationManager _destinationManager;
    private DestinationIndex _destinationIndex;
    private ForeignBusIndex _foreignBusIndex;
    private LinkIndex _linkIndex;

    DynamicConfigManager(MessageProcessor messageProcessor) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"DynamicConfigManager", (Object)messageProcessor);
        }
        this._messageProcessor = messageProcessor;
        this._destinationManager = messageProcessor.getDestinationManager();
        this._destinationIndex = this._destinationManager.getDestinationIndex();
        this._foreignBusIndex = this._destinationManager.getForeignBusIndex();
        this._linkIndex = this._destinationManager.getLinkIndex();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"DynamicConfigManager", (Object)this);
        }
    }

    public void refreshDestinations() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"refreshDestinations");
        }
        DestinationTypeFilter filter = new DestinationTypeFilter();
        filter.VISIBLE = Boolean.TRUE;
        filter.CORRUPT = Boolean.FALSE;
        filter.RESET_ON_RESTART = Boolean.FALSE;
        SIMPIterator itr = this._destinationIndex.iterator(filter);
        while (itr.hasNext()) {
            DestinationHandler destinationHandler = (DestinationHandler)itr.next();
            try {
                if (destinationHandler.isSystem() || destinationHandler.isTemporary() || destinationHandler.isToBeDeleted() || destinationHandler.isDeleted()) continue;
                this.reloadDestinationFromAdmin(destinationHandler);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DynamicConfigManager.refreshDestinations", (String)"1:149:1.32", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)e);
            }
        }
        itr.finished();
        ForeignBusTypeFilter foreignFilter = new ForeignBusTypeFilter();
        foreignFilter.VISIBLE = Boolean.TRUE;
        foreignFilter.CORRUPT = Boolean.FALSE;
        foreignFilter.RESET_ON_RESTART = Boolean.FALSE;
        SIMPIterator foreignItr = this._foreignBusIndex.iterator(foreignFilter);
        while (foreignItr.hasNext()) {
            BusHandler busHandler = (BusHandler)foreignItr.next();
            try {
                if (busHandler.isToBeDeleted() || busHandler.isDeleted()) continue;
                this.reloadForeignBusFromAdmin(busHandler);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DynamicConfigManager.refreshDestinations", (String)"1:184:1.32", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)e);
            }
        }
        foreignItr.finished();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"refreshDestinations");
        }
    }

    private void reloadDestinationFromAdmin(DestinationHandler destinationHandler) throws SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reloadDestinationFromAdmin");
        }
        try {
            BaseDestinationDefinition bdd = this._messageProcessor.getMessagingEngine().getSIBDestinationByUuid(destinationHandler.getBus(), destinationHandler.getUuid().toString());
            if (!bdd.isAlias() && !bdd.isForeign() && destinationHandler.getDestinationType() != DestinationType.SERVICE) {
                destinationHandler.updateDefinition(bdd);
                Set queuePointLocalitySet = this._messageProcessor.getMessagingEngine().getSIBDestinationLocalitySet(destinationHandler.getBus(), destinationHandler.getUuid().toString());
                if (queuePointLocalitySet == null || queuePointLocalitySet.size() == 0) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"reloadDestinationFromAdmin", (Object)"SIErrorException");
                    }
                    throw new SIErrorException(nls.getFormattedMessage("INTERNAL_CONFIGURATION_ERROR_CWSIP0006", new Object[]{"DynamicConfigManager", "1:245:1.32", destinationHandler.getName()}, null));
                }
                if (bdd.isLocal()) {
                    DestinationDefinition dd = (DestinationDefinition)bdd;
                    BaseDestinationHandler bdh = (BaseDestinationHandler)destinationHandler;
                    bdh.updateLocalizationSet(queuePointLocalitySet);
                } else {
                    destinationHandler.updateDefinition(bdd);
                }
            }
        }
        catch (SIBExceptionDestinationNotFound e) {
            if (destinationHandler.isAlias() || destinationHandler.isForeign() || !destinationHandler.hasLocal()) {
                this.deleteDestination(destinationHandler);
            } else {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DynamicConfigManager.reloadDestinationFromAdmin", (String)"1:325:1.32", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
        }
        catch (SIBExceptionBase sIBExceptionBase) {
            // empty catch block
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reloadDestinationFromAdmin");
        }
    }

    private void reloadForeignBusFromAdmin(BusHandler busHandler) throws SIResourceException, SINotPossibleInCurrentConfigurationException {
        ForeignBusDefinition foreignBusDefinition;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reloadForeignBusFromAdmin");
        }
        if ((foreignBusDefinition = this._messageProcessor.getForeignBus(busHandler.getName())) != null) {
            busHandler.updateDefinition(foreignBusDefinition);
            if (foreignBusDefinition.hasLink()) {
                try {
                    if ("SIBVirtualMQLink".equals(foreignBusDefinition.getLink().getType())) {
                        LinkTypeFilter filter = new LinkTypeFilter();
                        filter.MQLINK = Boolean.TRUE;
                        DestinationHandler link = this._linkIndex.findByUuid(foreignBusDefinition.getLink().getUuid(), filter);
                        if (link != null) {
                            ((MQLinkHandler)link).getMQLinkObject().busReloaded();
                        }
                    }
                }
                catch (SIBExceptionNoLinkExists sibExNLE) {
                    FFDCFilter.processException((Throwable)sibExNLE, (String)"com.ibm.ws.sib.processor.impl.DynamicConfigManager.reloadForeignBusFromAdmin", (String)"357", (Object)foreignBusDefinition);
                }
            }
        } else {
            this.deleteForeignBus(busHandler);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reloadForeignBusFromAdmin");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDestination(DestinationHandler destinationHandler) throws SINotPossibleInCurrentConfigurationException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteDestination", (Object)destinationHandler);
        }
        DestinationManager destinationManager = this._destinationManager;
        synchronized (destinationManager) {
            Object objLock;
            Object object = objLock = new Object();
            synchronized (object) {
                DestinationHandler destinationHandler2 = destinationHandler;
                synchronized (destinationHandler2) {
                    if (destinationHandler.isToBeDeleted() || destinationHandler.isDeleted()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"deleteDestination", (Object)"Destination to be deleted");
                        }
                        throw new SINotPossibleInCurrentConfigurationException(nls_cwsik.getFormattedMessage("DESTINATION_DELETE_ERROR_CWSIP0331", new Object[]{destinationHandler.getName(), this._messageProcessor.getMessagingEngineName()}, null));
                    }
                    if (!destinationHandler.isAlias() && !destinationHandler.isForeign()) {
                        ExternalAutoCommitTransaction transaction = this._messageProcessor.getTXManager().createAutoCommitTransaction();
                        BaseDestinationHandler baseDestinationHandler = (BaseDestinationHandler)destinationHandler;
                        baseDestinationHandler.setToBeDeleted(true);
                        this._destinationIndex.delete(destinationHandler);
                        try {
                            baseDestinationHandler.requestUpdate((Transaction)transaction);
                        }
                        catch (MessageStoreException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DynamicConfigManager.deleteDestination", (String)"1:464:1.32", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"deleteDestination", (Object)"SIResourceException");
                            }
                            throw new SIResourceException((Throwable)e);
                        }
                    } else {
                        destinationHandler.setDeleted();
                    }
                    destinationHandler.closeProducers();
                    destinationHandler.closeConsumers();
                    destinationHandler.deleteTargettingAliases();
                    if (!destinationHandler.isAlias() && !destinationHandler.isForeign()) {
                        BaseDestinationHandler bdh = (BaseDestinationHandler)destinationHandler;
                        bdh.addAllLocalisationsForCleanUp();
                        bdh.clearLocalisingUuidsSet();
                        this._destinationManager.startAsynchDeletion();
                    } else {
                        AbstractAliasDestinationHandler abstractAliasDestinationHandler = (AbstractAliasDestinationHandler)destinationHandler;
                        this.deleteAbstractAliasDestinationHandler(abstractAliasDestinationHandler);
                        abstractAliasDestinationHandler.delete();
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteDestination");
        }
    }

    public void deleteAbstractAliasDestinationHandler(AbstractAliasDestinationHandler abstractAliasDestinationHandler) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteAbstractAliasDestinationHandler");
        }
        if (abstractAliasDestinationHandler instanceof BusHandler) {
            this._foreignBusIndex.remove(abstractAliasDestinationHandler);
        } else {
            this._destinationIndex.remove(abstractAliasDestinationHandler);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteAbstractAliasDestinationHandler");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteForeignBus(BusHandler busHandler) throws SINotPossibleInCurrentConfigurationException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteForeignBus", (Object)busHandler);
        }
        DestinationManager destinationManager = this._destinationManager;
        synchronized (destinationManager) {
            BusHandler busHandler2 = busHandler;
            synchronized (busHandler2) {
                this._foreignBusIndex.delete(busHandler);
                busHandler.closeProducers();
                busHandler.closeConsumers();
                busHandler.deleteTargettingAliases();
                LinkHandler linkHandler = (LinkHandler)busHandler.getTarget();
                if (linkHandler.isToBeDeleted() || linkHandler.isDeleted()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"deleteForeignBus", (Object)"Link to be deleted");
                    }
                    throw new SINotPossibleInCurrentConfigurationException(nls_cwsik.getFormattedMessage("DESTINATION_DELETE_ERROR_CWSIP0331", new Object[]{linkHandler.getName(), this._messageProcessor.getMessagingEngineName()}, null));
                }
                ExternalAutoCommitTransaction transaction = this._messageProcessor.getTXManager().createAutoCommitTransaction();
                LinkHandler baseDestinationHandler = linkHandler;
                baseDestinationHandler.setToBeDeleted(true);
                this._linkIndex.delete(linkHandler);
                try {
                    baseDestinationHandler.requestUpdate((Transaction)transaction);
                }
                catch (MessageStoreException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DynamicConfigManager.deleteForeignBus", (String)"1:333:1.25", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"deleteForeignBus", (Object)"SIResourceException");
                    }
                    throw new SIResourceException((Throwable)e);
                }
                linkHandler.addAllLocalisationsForCleanUp();
                linkHandler.clearLocalisingUuidsSet();
                this._destinationManager.startAsynchDeletion();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteForeignBus");
        }
    }
}

