/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.ws.sib.mfp.JmsBodyType;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.mfp.MessageType;
import com.ibm.ws.sib.mfp.PersistenceType;
import com.ibm.ws.sib.mfp.WebJsMessageEncoder;
import com.ibm.ws.sib.mfp.impl.JsApiMessageImpl;
import com.ibm.ws.sib.mfp.impl.JsMsgObject;
import com.ibm.ws.sib.mfp.impl.WebJsJmsMessageEncoderImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class JsJmsMessageImpl
extends JsApiMessageImpl
implements JsJmsMessage {
    private static final long serialVersionUID = 1L;
    private static final byte[] flattenedClassName;
    private static TraceComponent tc;
    static final int FLATTENED_PAYLOAD_PART = 40;
    private static final int FLUFFED_JMS_BASE_SIZE;
    private static final int FLUFFED_PAYLOAD_BASE_SIZE;
    private transient int payloadLength = 0;

    JsJmsMessageImpl() {
    }

    JsJmsMessageImpl(int flag) throws MessageDecodeFailedException {
        super(flag);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        this.setJsMessageType(MessageType.JMS);
        this.setSubtype(JmsBodyType.NULL.toInt());
        if (flag != 2) {
            this.setJmsDeliveryMode(PersistenceType.PERSISTENT);
            this.setJmsExpiration(0L);
            this.setJmsType(null);
            this.setJmsDeliveryTime(0L);
        }
        this.setFormat("JMS:");
    }

    JsJmsMessageImpl(JsMsgObject inJmo) {
        super(inJmo);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"<init>, inbound jmo ");
        }
    }

    @Override
    final void clearCachedLengths() {
        super.clearCachedLengths();
        this.payloadLength = 0;
    }

    @Override
    int guessApproxLength() {
        if (this.payloadLength == 0) {
            this.payloadLength = this.guessPayloadLength();
        }
        int total = super.guessApproxLength() + this.payloadLength;
        return total;
    }

    int guessPayloadLength() {
        return 0;
    }

    @Override
    int guessFluffedSize() {
        int total = super.guessFluffedSize();
        total += FLUFFED_JMS_BASE_SIZE;
        if (this.jmo.getPayloadPart().getChoiceField(4) != 0) {
            total += FLUFFED_PAYLOAD_BASE_SIZE;
            total += this.guessFluffedDataSize();
        }
        return total;
    }

    int guessFluffedDataSize() {
        return 0;
    }

    @Override
    public final void clearMessagePayload() {
        this.clearBody();
    }

    @Override
    public void clearBody() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"clearBody");
        }
        this.jmo.getPayloadPart().setChoiceField(4, 0);
        this.clearCachedLengths();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"clearBody");
        }
    }

    @Override
    public final boolean alreadySent() {
        return this.isSent();
    }

    @Override
    public JsMessage getSent(boolean copy) throws MessageCopyFailedException {
        byte[] apiMsgId;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getSent", (Object)copy);
        }
        if (this.hasMQMDPropertiesSet() && (apiMsgId = (byte[])this.getMQMDSetPropertiesMap().get("JMS_IBM_MQMD_MsgId")) != null) {
            this.setApiMessageIdAsBytes(apiMsgId);
        }
        JsMessage newMsg = super.getSent(copy);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getSent", (Object)newMsg);
        }
        return newMsg;
    }

    @Override
    public final JmsBodyType getBodyType() {
        return JmsBodyType.getJmsBodyType(this.getSubtype());
    }

    final void setDerivedJmsFields() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setDerivedJmsFields");
        }
        if (this.getHdr2().getChoiceField(81) == 0) {
            this.setJmsDeliveryMode(this.getDerivedJmsDeliveryMode());
        }
        if (this.getHdr2().getChoiceField(82) == 0) {
            this.setJmsExpiration(this.getDerivedJmsExpiration());
        }
        if (this.getHdr2().getChoiceField(93) == 0) {
            this.setJmsDeliveryTime(this.getDerivedJmsDeliveryTime());
        }
        if (this.getHdr2().getChoiceField(85) == 0) {
            this.setJmsType(this.getDerivedJmsType());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setDerivedJmsFields");
        }
    }

    @Override
    public final void setJmsDeliveryMode(PersistenceType value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setJmsDeliveryMode", (Object)value);
        }
        this.getHdr2().setField(52, value.toByte());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setJmsDeliveryMode");
        }
    }

    @Override
    public final void setJmsExpiration(long value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setJmsExpiration", (Object)value);
        }
        this.getHdr2().setField(53, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setJmsExpiration");
        }
    }

    @Override
    public void setJmsDeliveryTime(long value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setJmsDeliveryTime", (Object)value);
        }
        this.getHdr2().setField(65, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setJmsDeliveryTime");
        }
    }

    @Override
    public final void setJmsDestination(byte[] value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setJmsDestination", (Object)value);
        }
        this.getHdr2().setField(54, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setJmsDestination");
        }
    }

    @Override
    public final void setJmsReplyTo(byte[] value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setJmsReplyTo", (Object)value);
        }
        this.getHdr2().setField(55, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setJmsReplyTo");
        }
    }

    final void setBodyType(JmsBodyType value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setBodyType", (Object)value);
        }
        this.setSubtype(value.toByte());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setBodyType");
        }
    }

    @Override
    public final void uncheckedSetForwardRoutingPath(List<SIDestinationAddress> value) {
        this.setFRP(value);
    }

    @Override
    public final void uncheckedSetReverseRoutingPath(List<SIDestinationAddress> value) {
        this.setRRP(value);
    }

    @Override
    public final void uncheckedSetDiscriminator(String value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"uncheckedSetDiscriminator", (Object)value);
        }
        this.jmo.setField(0, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"uncheckedSetDiscriminator");
        }
    }

    @Override
    public final void uncheckedSetTimeToLive(long value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"uncheckedSetTimeToLive", (Object)value);
        }
        this.getHdr2().setLongField(10, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"uncheckedSetTimeToLive");
        }
    }

    @Override
    public void uncheckedSetDeliveryDelay(long value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"uncheckedSetDeliveryDelay", (Object)value);
        }
        this.getHdr2().setLongField(64, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"uncheckedSetDeliveryDelay");
        }
    }

    @Override
    public final void uncheckedSetReplyDiscriminator(String value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"uncheckedSetReplyDiscriminator", (Object)value);
        }
        if (value != null) {
            this.getApi().setField(5, value);
        } else {
            this.getApi().setChoiceField(47, 0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"uncheckedSetReplyDiscriminator");
        }
    }

    @Override
    public final void uncheckedSetReplyPriority(Integer value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"uncheckedSetReplyPriority", (Object)value);
        }
        if (value != null) {
            this.getApi().setField(6, value);
        } else {
            this.getApi().setChoiceField(48, 0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"uncheckedSetReplyPriority");
        }
    }

    @Override
    public final void uncheckedSetReplyReliability(Reliability value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"uncheckedSetReplyReliability", (Object)value);
        }
        if (value != null) {
            this.getApi().setField(7, value.toByte());
        } else {
            this.getApi().setChoiceField(49, 0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"uncheckedSetReplyReliability");
        }
    }

    @Override
    public final void uncheckedSetReplyTimeToLive(Long value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"uncheckedSetReplyTimeToLive", (Object)value);
        }
        if (value != null) {
            this.getApi().setField(8, value);
        } else {
            this.getApi().setChoiceField(50, 0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"uncheckedSetReplyTimeToLive");
        }
    }

    @Override
    public final Object getObjectProperty(String name) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getObjectProperty", (Object)name);
        }
        Object value = null;
        if ("JMSXDeliveryCount".equals(name)) {
            int deliveryCount = this.getJmsxDeliveryCount();
            value = deliveryCount == 0 ? null : Integer.valueOf(deliveryCount);
        } else if (name.equals("JMS_IBM_MsgType")) {
            if (value == null && this.mayHaveMappedJmsSystemProperties()) {
                value = this.getJmsSystemPropertyMap().get(name);
            }
        } else if ("JMS_IBM_ArmCorrelator".equals(name)) {
            value = this.getARMCorrelator();
        } else if ("JMS_TOG_ARM_Correlator".equals(name)) {
            value = this.getARMCorrelator();
        } else if (name.startsWith("JMS")) {
            value = name.startsWith("JMS_IBM_MQMD_") ? this.getMQMDProperty(name) : this.getJMSSystemProperty(name, false);
        } else if (name.equals("transportVersion")) {
            value = this.getTransportVersion();
        } else if (this.mayHaveJmsUserProperties()) {
            value = this.getJmsUserPropertyMap().get(name);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getObjectProperty", (Object)value);
        }
        return value;
    }

    @Override
    public final void setObjectProperty(String name, Object value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setObjectProperty", (Object)new Object[]{name, value});
        }
        if ("JMSXAppID".equals(name)) {
            this.setJmsxAppId((String)value);
        } else if ("JMSXUserID".equals(name)) {
            this.setUserid((String)value);
        } else if ("JMS_IBM_ArmCorrelator".equals(name)) {
            this.setARMCorrelator((String)value);
        } else if ("JMS_TOG_ARM_Correlator".equals(name)) {
            this.setARMCorrelator((String)value);
        } else if (value != null) {
            this.setNonNullProperty(name, value);
        } else if (!name.startsWith("JMS")) {
            if (name.equals("transportVersion")) {
                this.clearTransportVersion();
            } else if (this.mayHaveJmsUserProperties()) {
                this.getJmsUserPropertyMap().remove(name);
            }
        } else if (name.startsWith("JMS_IBM_MQMD_")) {
            this.deleteMQMDProperty(name);
        } else {
            if (this.mayHaveMappedJmsSystemProperties()) {
                this.getJmsSystemPropertyMap().remove(name);
            }
            if (name.equals("JMS_IBM_Character_Set")) {
                this.setCcsid(null);
            } else if (name.equals("JMS_IBM_Encoding")) {
                this.setEncoding(null);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setObjectProperty");
        }
    }

    @Override
    public final void setNonNullProperty(String name, Object value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setNonNullProperty", (Object)new Object[]{name, value});
        }
        if (!name.startsWith("JMS")) {
            if (name.equals("transportVersion")) {
                this.setTransportVersion(value);
            } else {
                this.getJmsUserPropertyMap().put(name, value);
            }
            if (this.mayHaveOtherUserProperties()) {
                this.getOtherUserPropertyMap().remove(name);
            }
        } else if (name.startsWith("JMS_IBM_MQMD_")) {
            this.setMQMDProperty(name, value);
        } else {
            this.getJmsSystemPropertyMap().put(name, value);
            if (name.equals("JMS_IBM_Character_Set")) {
                this.setCcsid(value);
            } else if (name.equals("JMS_IBM_Encoding")) {
                this.setEncoding(value);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setNonNullProperty");
        }
    }

    @Override
    public final void setJmsxAppId(Byte value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setJmsxAppId", (Object)value);
        }
        this.getHdr2().setField(17, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setJmsxAppId");
        }
    }

    @Override
    public final void clearProperties() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"clearProperties");
        }
        if (this.mayHaveJmsUserProperties()) {
            this.getJmsUserPropertyMap().clear();
        }
        if (this.mayHaveMappedJmsSystemProperties()) {
            this.getJmsSystemPropertyMap().clear();
        }
        this.clearSmokeAndMirrorsProperties();
        if (this.hasMQMDPropertiesSet()) {
            this.getMQMDSetPropertiesMap().clear();
        }
        super.clearCachedLengths();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"clearProperties");
        }
    }

    private final Set<String> getNonSmokeAndMirrorsPropertyNameSet() {
        HashSet<String> names = new HashSet<String>();
        if (this.mayHaveJmsUserProperties()) {
            names.addAll(this.getJmsUserPropertyMap().keySet());
        }
        if (this.mayHaveMappedJmsSystemProperties()) {
            names.addAll(this.getJmsSystemPropertyMap().keySet());
        }
        if (this.hasMQMDPropertiesSet()) {
            names.addAll(this.getMQMDSetPropertiesMap().keySet());
        }
        return names;
    }

    @Override
    public final Set<String> getPropertyNameSet() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPropertyNameSet");
        }
        Set<String> names = this.getNonSmokeAndMirrorsPropertyNameSet();
        if (this.isTransportVersionSet()) {
            names.add("transportVersion");
        }
        if (this.getHdr2().getChoiceField(66) != 0) {
            names.add("JMSXAppID");
        }
        if (this.getUserid() != null) {
            names.add("JMSXUserID");
        }
        if (this.isSent()) {
            names.add("JMSXDeliveryCount");
        }
        if (this.getARMCorrelator() != null) {
            names.add("JMS_IBM_ArmCorrelator");
            names.add("JMS_TOG_ARM_Correlator");
        }
        if (this.getHdr2().getChoiceField(78) != 0) {
            names.add("JMS_IBM_ExceptionReason");
            names.add("JMS_IBM_ExceptionTimestamp");
            names.add("JMS_IBM_ExceptionMessage");
            if (this.getExceptionProblemDestination() != null) {
                names.add("JMS_IBM_ExceptionProblemDestination");
            }
            if (this.getExceptionProblemSubscription() != null) {
                names.add("JMS_IBM_ExceptionProblemSubscription");
            }
        }
        if (this.getSystemMessageId() != null) {
            names.add("JMS_IBM_System_MessageID");
        }
        if (this.getApi().getChoiceField(57) != 0 || this.getApi().getChoiceField(60) != 0) {
            names.add("JMS_IBM_Feedback");
        }
        if (this.getHdr2().getChoiceField(69) != 0) {
            names.add("JMS_IBM_Report_Expiration");
        }
        if (this.getHdr2().getChoiceField(70) != 0) {
            names.add("JMS_IBM_Report_COD");
        }
        if (this.getHdr2().getChoiceField(71) != 0) {
            names.add("JMS_IBM_Report_COA");
        }
        if (this.getApi().getChoiceField(51) != 0) {
            names.add("JMS_IBM_Report_Exception");
        }
        if (this.getApi().getChoiceField(52) != 0) {
            names.add("JMS_IBM_Report_PAN");
        }
        if (this.getApi().getChoiceField(53) != 0) {
            names.add("JMS_IBM_Report_NAN");
        }
        if (this.getApi().getChoiceField(54) != 0) {
            names.add("JMS_IBM_Report_Pass_Msg_ID");
        }
        if (this.getApi().getChoiceField(55) != 0) {
            names.add("JMS_IBM_Report_Pass_Correl_ID");
        }
        if (this.getApi().getChoiceField(56) != 0) {
            names.add("JMS_IBM_Report_Discard_Msg");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getPropertyNameSet", names);
        }
        return names;
    }

    @Override
    public final boolean propertyExists(String name) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"propertyExists", (Object)name);
        }
        boolean result = false;
        if (name.equals("transportVersion") && this.isTransportVersionSet()) {
            result = true;
        } else if (this.mayHaveJmsUserProperties() && this.getJmsUserPropertyMap().containsKey(name)) {
            result = true;
        } else if (name.startsWith("JMS")) {
            if (name.charAt(3) == 'X') {
                int count = name.length() - 4;
                if (name.regionMatches(4, "JMSXDeliveryCount", 4, count)) {
                    if (this.isSent()) {
                        result = true;
                    }
                } else if (name.regionMatches(4, "JMSXAppID", 4, count)) {
                    if (this.getHdr2().getChoiceField(66) != 0) {
                        result = true;
                    }
                } else if (name.regionMatches(4, "JMSXUserID", 4, count)) {
                    if (this.getUserid() != null) {
                        result = true;
                    }
                } else if (this.mayHaveMappedJmsSystemProperties()) {
                    result = this.getJmsSystemPropertyMap().containsKey(name);
                }
            } else if (name.startsWith("_IBM_", 3)) {
                if (name.regionMatches(8, "Report_", 0, REPORT_LENGTH)) {
                    int count = name.length() - REPORT_OFFSET;
                    if (name.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_Expiration", REPORT_OFFSET, count)) {
                        if (this.getHdr2().getChoiceField(69) != 0) {
                            result = true;
                        }
                    } else if (name.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_COA", REPORT_OFFSET, count)) {
                        if (this.getHdr2().getChoiceField(71) != 0) {
                            result = true;
                        }
                    } else if (name.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_COD", REPORT_OFFSET, count)) {
                        if (this.getHdr2().getChoiceField(70) != 0) {
                            result = true;
                        }
                    } else if (name.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_Exception", REPORT_OFFSET, count)) {
                        if (this.getApi().getChoiceField(51) != 0) {
                            result = true;
                        }
                    } else if (name.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_PAN", REPORT_OFFSET, count)) {
                        if (this.getApi().getChoiceField(52) != 0) {
                            result = true;
                        }
                    } else if (name.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_NAN", REPORT_OFFSET, count)) {
                        if (this.getApi().getChoiceField(53) != 0) {
                            result = true;
                        }
                    } else if (name.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_Pass_Msg_ID", REPORT_OFFSET, count)) {
                        if (this.getApi().getChoiceField(54) != 0) {
                            result = true;
                        }
                    } else if (name.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_Pass_Correl_ID", REPORT_OFFSET, count)) {
                        if (this.getApi().getChoiceField(55) != 0) {
                            result = true;
                        }
                    } else if (name.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_Discard_Msg", REPORT_OFFSET, count) && this.getApi().getChoiceField(56) != 0) {
                        result = true;
                    }
                } else {
                    int count = name.length() - 8;
                    if (name.regionMatches(8, "JMS_IBM_ExceptionReason", 8, count)) {
                        if (this.getHdr2().getChoiceField(78) != 0) {
                            result = true;
                        }
                    } else if (name.regionMatches(8, "JMS_IBM_ExceptionTimestamp", 8, count)) {
                        if (this.getHdr2().getChoiceField(78) != 0) {
                            result = true;
                        }
                    } else if (name.regionMatches(8, "JMS_IBM_ExceptionMessage", 8, count)) {
                        if (this.getHdr2().getChoiceField(78) != 0) {
                            result = true;
                        }
                    } else if (name.regionMatches(8, "JMS_IBM_ExceptionProblemDestination", 8, count)) {
                        if (this.getExceptionProblemDestination() != null) {
                            result = true;
                        }
                    } else if (name.regionMatches(8, "JMS_IBM_ExceptionProblemSubscription", 8, count)) {
                        if (this.getExceptionProblemSubscription() != null) {
                            result = true;
                        }
                    } else if (name.regionMatches(8, "JMS_IBM_Feedback", 8, count)) {
                        if (this.getApi().getChoiceField(57) != 0 || this.getApi().getChoiceField(60) != 0) {
                            result = true;
                        }
                    } else if (name.regionMatches(8, "JMS_IBM_System_MessageID", 8, count)) {
                        if (this.getSystemMessageId() != null) {
                            result = true;
                        }
                    } else if (name.regionMatches(8, "JMS_IBM_ArmCorrelator", 8, count)) {
                        if (this.getARMCorrelator() != null) {
                            result = true;
                        }
                    } else {
                        if (this.mayHaveMappedJmsSystemProperties()) {
                            result = this.getJmsSystemPropertyMap().containsKey(name);
                        }
                        if (!result) {
                            result = this.getMQMDSetPropertiesMap().containsKey(name);
                        }
                    }
                }
            } else if (name.equals("JMS_TOG_ARM_Correlator") && this.getARMCorrelator() != null) {
                result = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"propertyExists", (Object)result);
        }
        return result;
    }

    @Override
    public Object getJMSXGroupSeq() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getJMSXGroupSeq");
        }
        Object result = null;
        if (this.mayHaveMappedJmsSystemProperties()) {
            result = this.getObjectProperty("JMSXGroupSeq");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getJMSXGroupSeq", (Object)result);
        }
        return result;
    }

    @Override
    public WebJsMessageEncoder getWebEncoder() {
        return new WebJsJmsMessageEncoderImpl(this);
    }

    @Override
    byte[] getFlattenedClassName() {
        return flattenedClassName;
    }

    static {
        tc = SibTr.register(JsJmsMessageImpl.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
        flattenedClassName = JsJmsMessageImpl.flattenClassName(JsJmsMessageImpl.class.getName());
        FLUFFED_JMS_BASE_SIZE = FLUFFED_REF_SIZE * 4 + FLUFFED_STRING_OVERHEAD + 20;
        FLUFFED_PAYLOAD_BASE_SIZE = FLUFFED_JMF_MESSAGE_SIZE + FLUFFED_JSMSGPART_SIZE + FLUFFED_REF_SIZE;
    }
}

