/*
 * Decompiled with CFR 0.152.
 */
package wlp.lib.extract;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ProductMatch {
    private String productId;
    private String version;
    private String installType;
    private List editions = new ArrayList();
    private String licenseType;
    private static final Pattern validNumericVersionOrRange = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)\\+?$");
    private static final Pattern validBaseVersion = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)$");
    public static final int MATCHED = 0;
    public static final int NOT_APPLICABLE = -1;
    public static final int INVALID_VERSION = -2;
    public static final int INVALID_EDITION = -3;
    public static final int INVALID_INSTALL_TYPE = -4;
    public static final int INVALID_LICENSE = -5;
    public static final String NOT_OPENLIBERTY_PRODUCTID = "com.ibm.websphere.appserver";
    public static final String OPENLIBERTY_PRODUCTID = "io.openliberty";

    public void add(String substring) {
        substring = substring.trim();
        if (this.productId == null) {
            this.productId = substring;
        } else if (substring.startsWith("productVersion")) {
            this.version = this.getValue(substring);
        } else if (substring.startsWith("productEdition")) {
            String editionStr = this.getValue(substring);
            Collections.addAll(this.editions, editionStr.split(","));
        } else if (substring.startsWith("edition")) {
            if (!this.editions.isEmpty() && this.editions.contains("Open")) {
                String editionStr = this.getValue(substring);
                Collections.addAll(this.editions, editionStr.split(","));
            }
        } else if (substring.startsWith("productInstallType")) {
            this.installType = this.getValue(substring);
        } else if (substring.startsWith("productLicenseType")) {
            this.licenseType = this.getValue(substring);
        }
    }

    public int matches(Properties props) {
        if (this.productId.equals(props.getProperty("com.ibm.websphere.productId"))) {
            if (this.version != null) {
                String productVersion = props.getProperty("com.ibm.websphere.productVersion");
                Matcher appliesToMatcher = validNumericVersionOrRange.matcher(this.version);
                boolean appliesToIsRange = this.version.endsWith("+");
                Matcher productVersionMatcher = validNumericVersionOrRange.matcher(productVersion);
                if (appliesToMatcher.matches() && appliesToIsRange && productVersionMatcher.matches()) {
                    int[] targetProductVersion;
                    int[] minAppliesToVersion = this.allMatcherGroupsToIntArray(appliesToMatcher);
                    if (!ProductMatch.versionSatisfiesMinimum(minAppliesToVersion, targetProductVersion = this.allMatcherGroupsToIntArray(productVersionMatcher))) {
                        return -2;
                    }
                } else {
                    boolean baseProductVersionMatches;
                    Matcher baseAppliesToMatcher = validBaseVersion.matcher(this.version);
                    Matcher baseProductVersionMatcher = validBaseVersion.matcher(productVersion);
                    boolean baseAppliesToMatches = baseAppliesToMatcher.matches();
                    if (baseAppliesToMatches ^ (baseProductVersionMatches = baseProductVersionMatcher.matches()) ? (baseAppliesToMatches ? !productVersionMatcher.matches() || !productVersion.startsWith(this.version + '.') : !appliesToMatcher.matches() || !this.version.startsWith(productVersion + '.')) : !this.version.equals(productVersion)) {
                        return -2;
                    }
                }
            }
            if (!this.editions.isEmpty() && !this.editions.contains(props.getProperty("com.ibm.websphere.productEdition"))) {
                return -3;
            }
            if (this.licenseType != null && !this.licenseType.equals(props.getProperty("com.ibm.websphere.productLicenseType"))) {
                return -5;
            }
            if (this.installType != null && !this.installType.equals(props.getProperty("com.ibm.websphere.productInstallType"))) {
                return -4;
            }
            return 0;
        }
        return -1;
    }

    private int[] allMatcherGroupsToIntArray(Matcher matcher) {
        int numGroups = matcher.groupCount();
        int[] digits = new int[numGroups];
        for (int i = 0; i < numGroups; ++i) {
            digits[i] = Integer.parseInt(matcher.group(i + 1));
        }
        return digits;
    }

    private String getValue(String substring) {
        int index = substring.indexOf(61);
        if ((substring = substring.substring(index + 1).trim()).charAt(0) == '\"') {
            return substring.substring(1, substring.length() - 1);
        }
        return substring;
    }

    protected void setProductId(String productId) {
        this.productId = productId;
    }

    protected void setVersion(String version) {
        this.version = version;
    }

    protected void setInstallType(String installType) {
        this.installType = installType;
    }

    protected void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    protected void setEditions(List editions) {
        this.editions = editions;
    }

    public String getVersion() {
        return this.version;
    }

    public List getEditions() {
        return this.editions;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public String getInstallType() {
        return this.installType;
    }

    public static boolean versionSatisfiesMinimum(int[] minimumVersion, int[] queryVersion) {
        if (minimumVersion.length == queryVersion.length) {
            for (int i = 0; i < minimumVersion.length; ++i) {
                if (queryVersion[i] < minimumVersion[i]) {
                    return false;
                }
                if (queryVersion[i] == minimumVersion[i] || queryVersion[i] <= minimumVersion[i]) continue;
                return true;
            }
            return true;
        }
        return false;
    }
}

