/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.microprofile.openapi.impl.validation.OASValidationResult;
import com.ibm.ws.microprofile.openapi.impl.validation.TypeValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidationHelper;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidatorUtils;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIModelWalker;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;

public class SecuritySchemeValidator
extends TypeValidator<SecurityScheme> {
    private static final TraceComponent tc = Tr.register(SecuritySchemeValidator.class);
    private static final SecuritySchemeValidator INSTANCE = new SecuritySchemeValidator();

    public static SecuritySchemeValidator getInstance() {
        return INSTANCE;
    }

    private SecuritySchemeValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, SecurityScheme t) {
        String reference = t.getRef();
        if (reference != null && !reference.isEmpty()) {
            ValidatorUtils.referenceValidatorHelper(reference, t, helper, context, key);
            return;
        }
        Optional<OASValidationResult.ValidationEvent> op_type = ValidatorUtils.validateRequiredField(t.getType(), context, "type");
        if (op_type.isPresent()) {
            op_type.ifPresent(helper::addValidationEvent);
        } else {
            String message;
            String type = t.getType().toString();
            if ("apiKey".equals(type)) {
                ValidatorUtils.validateRequiredField(t.getName(), context, "name").ifPresent(helper::addValidationEvent);
                Optional<OASValidationResult.ValidationEvent> op_in = ValidatorUtils.validateRequiredField(t.getIn(), context, "in");
                if (op_in.isPresent()) {
                    op_in.ifPresent(helper::addValidationEvent);
                } else {
                    HashSet<String> inValues = new HashSet<String>(Arrays.asList("query", "header", "cookie"));
                    if (!inValues.contains(t.getIn().toString())) {
                        String message2 = Tr.formatMessage((TraceComponent)tc, (String)"securitySchemeInFieldInvalid", (Object[])new Object[]{key, t.getIn().toString()});
                        helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message2));
                    }
                }
            } else if ("http".equals(type)) {
                ValidatorUtils.validateRequiredField(t.getScheme(), context, "scheme").ifPresent(helper::addValidationEvent);
            } else if ("oauth2".equals(type)) {
                ValidatorUtils.validateRequiredField(t.getFlows(), context, "flows").ifPresent(helper::addValidationEvent);
            } else if ("openIdConnect".equals(type)) {
                Optional<OASValidationResult.ValidationEvent> op_url = ValidatorUtils.validateRequiredField(t.getOpenIdConnectUrl(), context, "openIdConnectUrl");
                if (op_url.isPresent()) {
                    op_url.ifPresent(helper::addValidationEvent);
                } else if (!ValidatorUtils.isValidURI(t.getOpenIdConnectUrl())) {
                    String message3 = Tr.formatMessage((TraceComponent)tc, (String)"securitySchemeInvalidURL", (Object[])new Object[]{t.getOpenIdConnectUrl()});
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message3));
                }
            }
            if (t.getBearerFormat() != null && !t.getBearerFormat().isEmpty() && !"http".equals(type)) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"nonApplicableFieldWithValue", (Object[])new Object[]{"bearerFormat", t.getBearerFormat(), "Security Scheme Object", type});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, context.getLocation(), message));
            }
            if (t.getScheme() != null && !t.getScheme().isEmpty() && !"http".equals(type)) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"nonApplicableFieldWithValue", (Object[])new Object[]{"scheme", t.getScheme(), "Security Scheme Object", type});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, context.getLocation(), message));
            }
            if (t.getIn() != null && !"apiKey".equals(type)) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"nonApplicableFieldWithValue", (Object[])new Object[]{"in", t.getIn(), "Security Scheme Object", type});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, context.getLocation(), message));
            }
            if (t.getName() != null && !t.getName().isEmpty() && !"apiKey".equals(type)) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"nonApplicableFieldWithValue", (Object[])new Object[]{"name", t.getName(), "Security Scheme Object", type});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, context.getLocation(), message));
            }
            if (t.getOpenIdConnectUrl() != null && !t.getOpenIdConnectUrl().isEmpty() && !"openIdConnect".equals(type)) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"nonApplicableFieldWithValue", (Object[])new Object[]{"openIdConnectUrl", t.getOpenIdConnectUrl(), "Security Scheme Object", type});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, context.getLocation(), message));
            }
            if (!"oauth2".equals(type) && ValidatorUtils.flowsIsSet(t.getFlows())) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"nonApplicableField", (Object[])new Object[]{"flows", "Security Scheme Object", type});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, context.getLocation(), message));
            }
        }
    }
}

