/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.persistence.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.persistence.DDLGenerationWriter;
import com.ibm.wsspi.persistence.internal.DatabaseManager;
import com.ibm.wsspi.persistence.internal.PUInfoImpl;
import com.ibm.wsspi.persistence.internal.eclipselink.PsPersistenceProvider;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.spi.PersistenceUnitInfo;
import jakarta.transaction.TransactionManager;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.platform.database.DB2Platform;
import org.eclipse.persistence.platform.database.DerbyPlatform;
import org.eclipse.persistence.platform.database.Informix11Platform;
import org.eclipse.persistence.platform.database.JavaDBPlatform;
import org.eclipse.persistence.platform.database.OraclePlatform;
import org.eclipse.persistence.platform.database.SQLServerPlatform;
import org.eclipse.persistence.sessions.DatabaseSession;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class SchemaManager {
    private static final String SCHEMA_GENERATION_SCRIPTS_CREATE_TARGET;
    private static final Map<String, String> platformTerminationToken;
    private final Map<String, String> _serviceProperties;
    private final PUInfoImpl _pui;
    private final PsPersistenceProvider _provider;
    private final DatabaseManager _dbMgr;
    static final long serialVersionUID = 140861272727989606L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    SchemaManager(Map<String, String> props, PUInfoImpl pui, PsPersistenceProvider provider, DatabaseManager dbMgr) {
        this._pui = pui;
        this._serviceProperties = props;
        this._provider = provider;
        this._dbMgr = dbMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void generateSchema(TransactionManager tranMgr, Object ... schemaGenkeyValuePair) {
        DDLGenerationWriter writer;
        boolean closeWriter;
        block24: {
            HashMap<Object, Object> props = new HashMap<Object, Object>();
            for (int i = 0; i < schemaGenkeyValuePair.length; i += 2) {
                props.put(schemaGenkeyValuePair[i], schemaGenkeyValuePair[i + 1]);
            }
            props.putAll(this._serviceProperties);
            closeWriter = false;
            writer = null;
            Writer out = (Writer)props.get(SCHEMA_GENERATION_SCRIPTS_CREATE_TARGET);
            if (out != null) {
                if (out instanceof DDLGenerationWriter) {
                    writer = (DDLGenerationWriter)out;
                } else {
                    writer = new DDLGenerationWriter(out);
                    closeWriter = true;
                }
                props.put(SCHEMA_GENERATION_SCRIPTS_CREATE_TARGET, writer);
            }
            PersistenceUnitInfo puiCopy = this._pui.createCopyWithNewName();
            this.overrideDatabaseTerminationToken(props);
            try (EntityManagerFactory emf = null;){
                block25: {
                    emf = this._provider.createContainerEMF(puiCopy, props, false);
                    if (writer != null) {
                        this.postProcess(emf, writer);
                        break block24;
                    }
                    if (tranMgr == null) break block24;
                    EntityManager em = null;
                    try {
                        tranMgr.begin();
                        em = emf.createEntityManager();
                        DatabaseSession ss2332 = (DatabaseSession)em.unwrap(DatabaseSession.class);
                        new org.eclipse.persistence.tools.schemaframework.SchemaManager(ss2332).createSequences();
                        if (em == null) break block25;
                    }
                    catch (Exception e) {
                        try {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.wsspi.persistence.internal.SchemaManager", (String)"142", (Object)this, (Object[])new Object[]{tranMgr, schemaGenkeyValuePair});
                            throw new PersistenceException((Throwable)e);
                        }
                        catch (Throwable throwable) {
                            if (em != null) {
                                try {
                                    em.close();
                                }
                                catch (Throwable throwable2) {
                                    FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.wsspi.persistence.internal.SchemaManager", (String)"148", (Object)this, (Object[])new Object[]{tranMgr, schemaGenkeyValuePair});
                                }
                            }
                            try {
                                tranMgr.commit();
                                throw throwable;
                            }
                            catch (Exception exception) {
                                void e2;
                                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.wsspi.persistence.internal.SchemaManager", (String)"155", (Object)this, (Object[])new Object[]{tranMgr, schemaGenkeyValuePair});
                                throw new PersistenceException((Throwable)e2);
                            }
                        }
                    }
                    try {
                        em.close();
                    }
                    catch (Throwable ss2332) {
                        FFDCFilter.processException((Throwable)ss2332, (String)"com.ibm.wsspi.persistence.internal.SchemaManager", (String)"148", (Object)this, (Object[])new Object[]{tranMgr, schemaGenkeyValuePair});
                    }
                }
                try {
                    tranMgr.commit();
                }
                catch (Exception ss2332) {
                    void e;
                    FFDCFilter.processException((Throwable)ss2332, (String)"com.ibm.wsspi.persistence.internal.SchemaManager", (String)"155", (Object)this, (Object[])new Object[]{tranMgr, schemaGenkeyValuePair});
                    throw new PersistenceException((Throwable)e);
                }
            }
        }
        if (writer == null) return;
        if (!closeWriter) return;
        try {
            writer.writeExitAndClose();
            return;
        }
        catch (IOException em) {
            void e;
            FFDCFilter.processException((Throwable)em, (String)"com.ibm.wsspi.persistence.internal.SchemaManager", (String)"169", (Object)this, (Object[])new Object[]{tranMgr, schemaGenkeyValuePair});
            throw new PersistenceException((Throwable)ValidationException.fileError((IOException)e));
        }
    }

    private void overrideDatabaseTerminationToken(Map<Object, Object> props) {
        String overrideTermToken = null;
        String platformClassName = this._dbMgr.getDatabasePlatformClassName(this._pui);
        if (platformClassName != null) {
            overrideTermToken = platformTerminationToken.get(platformClassName);
        }
        if (overrideTermToken != null) {
            String existing = (String)props.get("eclipselink.target-database-properties");
            existing = existing != null ? existing + "," : "";
            existing = existing + "StoredProcedureTerminationToken=" + overrideTermToken;
            props.put("eclipselink.target-database-properties", existing);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void postProcess(EntityManagerFactory emf, DDLGenerationWriter writer) {
        if (this._dbMgr.isOracle(emf)) {
            try {
                writer.setExitCommand("\nEXIT;");
            }
            catch (IOException iOException) {
                void e;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.wsspi.persistence.internal.SchemaManager", (String)"205", (Object)this, (Object[])new Object[]{emf, writer});
                throw new PersistenceException((Throwable)ValidationException.fileError((IOException)e));
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.wsspi.persistence.internal.SchemaManager", SchemaManager.class, (String)"persistenceService", (String)"com.ibm.wsspi.persistence.internal.PersistenceServiceMessages");
        platformTerminationToken = new ConcurrentHashMap<String, String>();
        platformTerminationToken.put(DB2Platform.class.getCanonicalName(), ";");
        platformTerminationToken.put(Informix11Platform.class.getCanonicalName(), ";");
        platformTerminationToken.put(JavaDBPlatform.class.getCanonicalName(), " ");
        platformTerminationToken.put(DerbyPlatform.class.getCanonicalName(), " ");
        platformTerminationToken.put(OraclePlatform.class.getCanonicalName(), ";");
        platformTerminationToken.put("org.eclipse.persistence.platform.database.oracle.OraclePlatform", ";");
        platformTerminationToken.put("org.eclipse.persistence.platform.database.oracle.Oracle9Platform", ";");
        platformTerminationToken.put("org.eclipse.persistence.platform.database.oracle.Oracle10Platform", ";");
        platformTerminationToken.put("org.eclipse.persistence.platform.database.oracle.Oracle11Platform", ";");
        platformTerminationToken.put("org.eclipse.persistence.platform.database.oracle.Oracle12Platform", ";");
        platformTerminationToken.put(SQLServerPlatform.class.getCanonicalName(), ";");
        platformTerminationToken.put("org.eclipse.persistence.platform.database.MySQLPlatform", ";");
        String emName = EntityManager.class.getName();
        boolean isJakarta = emName.startsWith("jakarta");
        String prefix = isJakarta ? "jakarta" : "javax";
        SCHEMA_GENERATION_SCRIPTS_CREATE_TARGET = prefix + ".persistence.schema-generation.scripts.create-target";
    }
}

