/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal.frames;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.h2internal.FrameReadProcessor;
import com.ibm.ws.http.channel.h2internal.FrameTypes;
import com.ibm.ws.http.channel.h2internal.H2ConnectionSettings;
import com.ibm.ws.http.channel.h2internal.exceptions.FrameSizeException;
import com.ibm.ws.http.channel.h2internal.exceptions.ProtocolException;
import com.ibm.ws.http.channel.h2internal.frames.Frame;
import com.ibm.ws.http.channel.h2internal.frames.utils;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;

public class FrameWindowUpdate
extends Frame {
    private int windowSizeIncrement;

    public FrameWindowUpdate(int streamId, int payloadLength, byte flags, boolean reserveBit, Frame.FrameDirection direction) {
        super(streamId, payloadLength, flags, reserveBit, direction);
        this.frameType = FrameTypes.WINDOW_UPDATE;
    }

    public FrameWindowUpdate(int streamId, int windowSizeIncrement, boolean reserveBit) {
        super(streamId, 4, (byte)0, reserveBit, Frame.FrameDirection.WRITE);
        this.windowSizeIncrement = windowSizeIncrement;
        this.frameType = FrameTypes.WINDOW_UPDATE;
        this.writeFrameLength += this.payloadLength;
        this.setInitialized();
    }

    @Override
    public void processPayload(FrameReadProcessor frp) throws FrameSizeException {
        byte firstPayloadByte = frp.grabNextByte();
        this.reservedBit = utils.getReservedBit(firstPayloadByte);
        firstPayloadByte = (byte)(firstPayloadByte & 0x7F);
        this.windowSizeIncrement = frp.grabNext24BitInt(firstPayloadByte);
    }

    @Override
    public WsByteBuffer buildFrameForWrite() {
        WsByteBuffer buffer = super.buildFrameForWrite();
        byte[] frame = buffer.hasArray() ? buffer.array() : super.createFrameArray();
        this.setFrameHeaders(frame, (byte)8);
        int frameIndex = 9;
        utils.Move31BitstoByteArray(this.windowSizeIncrement, frame, frameIndex);
        buffer.put(frame, 0, this.writeFrameLength);
        buffer.flip();
        return buffer;
    }

    public int getWindowSizeIncrement() {
        return this.windowSizeIncrement;
    }

    @Override
    protected void setFlags() {
    }

    @Override
    public void validate(H2ConnectionSettings settings) throws ProtocolException, FrameSizeException {
        if (this.windowSizeIncrement < 1) {
            ProtocolException e = new ProtocolException("WINDOW_UPDATE flow-control window increment must be greater than 0");
            if (this.streamId > 0) {
                e.setConnectionError(false);
                throw e;
            }
            throw e;
        }
        if (this.payloadLength != 4) {
            throw new FrameSizeException("WINDOW_UPDATE frame must have a length of 4.  Actual length : " + this.payloadLength);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof FrameWindowUpdate)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("equals: object is not a FrameWindowUpdate, it is a " + object.getClass()), (Object[])new Object[0]);
            }
            return false;
        }
        FrameWindowUpdate frameWindowUpdateToCompare = (FrameWindowUpdate)object;
        if (!super.equals(frameWindowUpdateToCompare)) {
            return false;
        }
        if (this.getWindowSizeIncrement() != frameWindowUpdateToCompare.getWindowSizeIncrement()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("this.getWindowSizeIncrement() = " + this.getWindowSizeIncrement() + " frameWindowUpdateToCompare.getWindowSizeIncrement() = " + frameWindowUpdateToCompare.getWindowSizeIncrement()), (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder frameToString = new StringBuilder();
        frameToString.append(super.toString());
        frameToString.append("WindowSizeIncrement: " + this.getWindowSizeIncrement() + "\n");
        return frameToString.toString();
    }
}

