/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.ArrayList;
import java.util.logging.Level;
import org.apache.yoko.io.Buffer;
import org.apache.yoko.logging.VerboseLogging;
import org.apache.yoko.orb.CORBA.OutputStream;
import org.apache.yoko.orb.CORBA.OutputStreamHolder;
import org.apache.yoko.orb.IOP.ServiceContexts;
import org.apache.yoko.orb.OB.Client;
import org.apache.yoko.orb.OB.CodeConverters;
import org.apache.yoko.orb.OB.CodeSetInfo;
import org.apache.yoko.orb.OB.CodeSetUtil;
import org.apache.yoko.orb.OB.Downcall;
import org.apache.yoko.orb.OB.DowncallEmitter;
import org.apache.yoko.orb.OB.GIOPConnection;
import org.apache.yoko.orb.OB.GIOPConnectionThreaded;
import org.apache.yoko.orb.OB.GIOPOutgoingMessage;
import org.apache.yoko.orb.OB.GIOPServer;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OB.RefCountPolicyList;
import org.apache.yoko.orb.OB.SendingContextRuntimes;
import org.apache.yoko.orb.OB.Server;
import org.apache.yoko.orb.OBPortableServer.POAManager_impl;
import org.apache.yoko.orb.OCI.Connector;
import org.apache.yoko.orb.OCI.ConnectorInfo;
import org.apache.yoko.orb.OCI.GiopVersion;
import org.apache.yoko.orb.OCI.ProfileInfo;
import org.apache.yoko.orb.OCI.SendReceiveMode;
import org.apache.yoko.orb.OCI.Transport;
import org.apache.yoko.orb.OCI.TransportInfo;
import org.apache.yoko.orb.exceptions.Transients;
import org.apache.yoko.util.Assert;
import org.apache.yoko.util.Cache;
import org.apache.yoko.util.Factory;
import org.apache.yoko.util.Reference;
import org.omg.CONV_FRAME.CodeSetContext;
import org.omg.CONV_FRAME.CodeSetContextHelper;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.IOP.IOR;
import org.omg.IOP.ServiceContext;
import org.omg.PortableServer.POAManager;

final class GIOPClient
extends Client {
    protected ORBInstance orbInstance_;
    protected final Connector connector_;
    private GIOPConnection connection_;
    private Reference<GIOPConnection> connectionRef;
    protected ServiceContext codeSetSC_;
    protected ServiceContext codeBaseSC_;
    protected boolean bidirWorker_;
    private boolean destroy_;

    @Override
    public String toString() {
        return super.toString() + " to " + this.connector_.get_info() + " -- " + this.connection_;
    }

    protected GIOPConnection find_bidir_worker() {
        try {
            for (POAManager poaManager : this.orbInstance_.getPOAManagerFactory().list()) {
                for (Server aServSeq : ((POAManager_impl)poaManager)._OB_getServerManager().getServers()) {
                    GIOPConnection conn = ((GIOPServer)aServSeq)._OB_getGIOPServerStarter().getMatchingConnection(this.connectorInfo());
                    if (conn == null) continue;
                    return conn;
                }
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    protected synchronized GIOPConnection getWorker(boolean create, int timeout) {
        if (this.destroy_) {
            throw Transients.ACTIVE_CONNECTION_MANAGEMENT.create();
        }
        if (this.connection_ == null) {
            this.reuseInboundConnection();
        }
        if (this.connection_ == null) {
            this.reuseOrCreateOutboundConnection(create, timeout);
        }
        this.initServiceContexts();
        return this.connection_;
    }

    private synchronized void reuseOrCreateOutboundConnection(boolean create, final int timeout) {
        Cache<ConnectorInfo, GIOPConnection> connCache = this.orbInstance_.getOutboundConnectionCache();
        this.connectionRef = create ? connCache.getOrCreate((Object)this.connector_.get_info(), (Factory)new Factory<GIOPConnection>(){

            public GIOPConnection create() {
                return GIOPClient.this.createOutboundConnection(timeout);
            }
        }) : connCache.get((Object)this.connector_.get_info());
        connCache.clean();
        this.connection_ = (GIOPConnection)this.connectionRef.get();
        if (this.bidirWorker_) {
            this.connection_.activateServerSide();
        }
    }

    private synchronized void reuseInboundConnection() {
        this.connection_ = this.find_bidir_worker();
        if (this.connection_ == null) {
            return;
        }
        this.connection_.activateClientSide();
        if (VerboseLogging.CONN_OUT_LOG.isLoggable(Level.FINE)) {
            VerboseLogging.CONN_OUT_LOG.fine("reusing established bidir connection\n" + this.connection_.transport());
        }
    }

    private GIOPConnectionThreaded createOutboundConnection(int t) {
        Transport transport;
        if (VerboseLogging.CONN_OUT_LOG.isLoggable(Level.FINE)) {
            String timeout = t >= 0 ? t + "ms" : "none";
            String msg = String.format("trying to establish connection: %s    timeout: %s", this.connector_, timeout);
            VerboseLogging.CONN_OUT_LOG.fine(msg);
        }
        if (t >= 0) {
            transport = this.connector_.connect_timeout(t);
            if (transport == null) {
                throw new NO_RESPONSE("Connection timeout", 0, CompletionStatus.COMPLETED_NO);
            }
        } else {
            transport = this.connector_.connect();
            Assert.ensure((transport != null ? 1 : 0) != 0);
        }
        Assert.ensure((this.concurrencyModel == 2 ? 1 : 0) != 0);
        return new GIOPConnectionThreaded(this.orbInstance_, transport, this);
    }

    private void initServiceContexts() {
        if (this.codeSetSC_ == null) {
            CodeSetContext ctx = new CodeSetContext();
            CodeConverters conv = this.codeConverters();
            ctx.char_data = conv.outputCharConverter == null ? CodeSetInfo.ISO_LATIN_1.id : conv.outputCharConverter.getDestinationCodeSet().id;
            ctx.wchar_data = conv.outputWcharConverter == null ? this.orbInstance_.getNativeWcs() : conv.outputWcharConverter.getDestinationCodeSet().id;
            try (OutputStream outCSC = new OutputStream();){
                outCSC._OB_writeEndian();
                CodeSetContextHelper.write((org.omg.CORBA.portable.OutputStream)outCSC, (CodeSetContext)ctx);
                this.codeSetSC_ = new ServiceContext();
                this.codeSetSC_.context_id = 1;
                this.codeSetSC_.context_data = outCSC.copyWrittenBytes();
            }
        }
        if (this.codeBaseSC_ == null) {
            this.codeBaseSC_ = SendingContextRuntimes.SENDING_CONTEXT_RUNTIME;
        }
    }

    GIOPClient(ORBInstance orbInstance, Connector connector, int concModel, CodeConverters conv, boolean bidirEnable) {
        super(concModel, conv);
        this.orbInstance_ = orbInstance;
        this.connector_ = connector;
        this.connection_ = null;
        this.destroy_ = false;
        this.bidirWorker_ = bidirEnable;
    }

    @Override
    public synchronized void destroy() {
        if (this.destroy_) {
            return;
        }
        try (Reference<GIOPConnection> closeMe = this.connectionRef;){
            this.destroy_ = true;
        }
    }

    @Override
    public int getNewRequestID() {
        return this.connection_.getNewRequestId();
    }

    @Override
    public ServiceContexts getAMIRouterContexts() {
        this.initServiceContexts();
        return ServiceContexts.unmodifiable(this.codeSetSC_);
    }

    @Override
    public ProfileInfo[] getUsableProfiles(IOR ior, Policy[] policies) {
        ArrayList<ProfileInfo> profileInfos = new ArrayList<ProfileInfo>();
        for (ProfileInfo anAll : this.connector_.get_usable_profiles(ior, policies)) {
            CodeConverters conv = CodeSetUtil.getCodeConverters(this.orbInstance_, anAll);
            if (!this.codeConverters().equals(conv)) continue;
            profileInfos.add(anAll);
        }
        return profileInfos.toArray(new ProfileInfo[profileInfos.size()]);
    }

    @Override
    public ConnectorInfo connectorInfo() {
        return this.connector_.get_info();
    }

    @Override
    public TransportInfo transportInfo() {
        GIOPConnection connection = this.getWorker(false, -1);
        if (connection == null) {
            return null;
        }
        Transport transport = connection.transport();
        return transport.get_info();
    }

    @Override
    public DowncallEmitter startDowncall(Downcall down, OutputStreamHolder out) {
        GIOPConnection connection;
        try {
            connection = this.getWorker(true, down.policies().connectTimeout);
        }
        catch (SystemException ex) {
            Assert.ensure((ex.completed == CompletionStatus.COMPLETED_NO ? 1 : 0) != 0);
            down.setFailureException(ex);
            return null;
        }
        try {
            byte major = down.profileInfo().major;
            byte minor = down.profileInfo().minor;
            if (!(connection.isRequestSent() || major <= 1 && minor < 1)) {
                if (VerboseLogging.CONN_OUT_LOG.isLoggable(Level.FINEST)) {
                    VerboseLogging.CONN_OUT_LOG.finest("sending transmission code sets: \n" + this.codeConverters());
                }
                Assert.ensure((this.codeSetSC_ != null ? 1 : 0) != 0);
                down.addToRequestContexts(this.codeSetSC_);
                Assert.ensure((this.codeBaseSC_ != null ? 1 : 0) != 0);
                down.addToRequestContexts(this.codeBaseSC_);
            }
            boolean validGIOPVersion = false;
            if (major > 1 || major == 1 && minor >= 2) {
                validGIOPVersion = true;
            }
            if (validGIOPVersion && down.policies().biDirMode == 1) {
                Transport t = connection.transport();
                ServiceContexts contexts = t.get_info().get_service_contexts(down.policies().value);
                for (ServiceContext context : contexts) {
                    down.addToRequestContexts(context);
                }
            }
            ProfileInfo profileInfo = down.profileInfo();
            out.value = new OutputStream(Buffer.createWriteBuffer((int)12).padAll(), this.codeConverters(), GiopVersion.get(profileInfo.major, profileInfo.minor));
            GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out.value, profileInfo);
            if (down.operation().equals("_locate")) {
                outgoing.writeLocateRequestHeader(down.requestId());
            } else {
                outgoing.writeRequestHeader(down.requestId(), down.operation(), down.responseExpected(), down.requestContexts);
            }
            return connection.emitterInterface();
        }
        catch (SystemException ex) {
            Assert.ensure((ex.completed == CompletionStatus.COMPLETED_NO ? 1 : 0) != 0);
            down.setFailureException(ex);
            return null;
        }
    }

    @Override
    public boolean matches(Client other) {
        if (!(other instanceof GIOPClient)) {
            return false;
        }
        GIOPClient that = (GIOPClient)other;
        return this.connector_.equal(that.connector_) && this.codeConverters().equals(that.codeConverters());
    }

    @Override
    public void bind(int connectTimeout) {
        this.getWorker(true, connectTimeout);
    }

    @Override
    public boolean twoway() {
        GIOPConnection connection = this.getWorker(false, -1);
        Assert.ensure((connection != null ? 1 : 0) != 0);
        Transport transport = connection.transport();
        return transport.mode() == SendReceiveMode.SendReceive;
    }

    @Override
    public void prepareForDowncall(RefCountPolicyList policies) {
        this.getWorker(true, policies.connectTimeout);
    }
}

