/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.interceptor;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.management.counters.Counter;
import org.apache.cxf.management.counters.CounterRepository;
import org.apache.cxf.management.counters.MessageHandlingTimeRecorder;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.OperationInfo;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public abstract class AbstractMessageResponseTimeInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractMessageResponseTimeInterceptor.class);
    private static final String QUESTION_MARK = "?";
    private static final String ESCAPED_QUESTION_MARK = "\\?";
    Logger log;
    static final long serialVersionUID = 4931825844436140536L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    AbstractMessageResponseTimeInterceptor(String phase) {
        super(phase);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.management.interceptor.AbstractMessageResponseTimeInterceptor", "<init>", new Object[]{phase});
        }
        this.log = Logger.getLogger(AbstractMessageResponseTimeInterceptor.class.getName());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.management.interceptor.AbstractMessageResponseTimeInterceptor", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean isClient(Message msg) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.management.interceptor.AbstractMessageResponseTimeInterceptor", "isClient", new Object[]{msg});
        }
        boolean bl = msg != null && Boolean.TRUE.equals(msg.get((Object)"org.apache.cxf.client"));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.management.interceptor.AbstractMessageResponseTimeInterceptor", "isClient", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void beginHandlingMessage(Exchange ex) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.management.interceptor.AbstractMessageResponseTimeInterceptor", "beginHandlingMessage", new Object[]{ex});
        }
        if (null == ex) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.management.interceptor.AbstractMessageResponseTimeInterceptor", "beginHandlingMessage");
            }
            return;
        }
        MessageHandlingTimeRecorder mhtr = (MessageHandlingTimeRecorder)ex.get(MessageHandlingTimeRecorder.class);
        if (null != mhtr) {
            mhtr.beginHandling();
        } else {
            mhtr = new MessageHandlingTimeRecorder(ex);
            mhtr.beginHandling();
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.management.interceptor.AbstractMessageResponseTimeInterceptor", "beginHandlingMessage");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void endHandlingMessage(Exchange ex) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.management.interceptor.AbstractMessageResponseTimeInterceptor", "endHandlingMessage", new Object[]{ex});
        }
        if (null == ex) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.management.interceptor.AbstractMessageResponseTimeInterceptor", "endHandlingMessage");
            }
            return;
        }
        MessageHandlingTimeRecorder mhtr = (MessageHandlingTimeRecorder)ex.get(MessageHandlingTimeRecorder.class);
        if (null != mhtr) {
            mhtr.endHandling();
            mhtr.setFaultMode((FaultMode)ex.get(FaultMode.class));
            this.increaseCounter(ex, mhtr);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.management.interceptor.AbstractMessageResponseTimeInterceptor", "endHandlingMessage");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void setOneWayMessage(Exchange ex) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.management.interceptor.AbstractMessageResponseTimeInterceptor", "setOneWayMessage", new Object[]{ex});
        }
        MessageHandlingTimeRecorder mhtr = (MessageHandlingTimeRecorder)ex.get(MessageHandlingTimeRecorder.class);
        if (null == mhtr) {
            mhtr = new MessageHandlingTimeRecorder(ex);
        } else {
            mhtr.endHandling();
        }
        mhtr.setOneWay(true);
        this.increaseCounter(ex, mhtr);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.management.interceptor.AbstractMessageResponseTimeInterceptor", "setOneWayMessage");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void increaseCounter(Exchange ex, MessageHandlingTimeRecorder mhtr) {
        CounterRepository cr;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.management.interceptor.AbstractMessageResponseTimeInterceptor", "increaseCounter", new Object[]{ex, mhtr});
        }
        Bus bus = ex.getBus();
        if (null == bus) {
            LOG.log(Level.INFO, "CAN_NOT_GET_BUS_FROM_EXCHANGE");
            bus = BusFactory.getThreadDefaultBus();
        }
        if (null == (cr = (CounterRepository)bus.getExtension(CounterRepository.class))) {
            LOG.log(Level.WARNING, "NO_COUNTER_REPOSITORY");
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.management.interceptor.AbstractMessageResponseTimeInterceptor", "increaseCounter");
            }
            return;
        }
        ObjectName serviceCountername = this.getServiceCounterName(ex);
        cr.increaseCounter(serviceCountername, mhtr);
        ObjectName operationCounter = this.getOperationCounterName(ex, serviceCountername);
        cr.increaseCounter(operationCounter, mhtr);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.management.interceptor.AbstractMessageResponseTimeInterceptor", "increaseCounter");
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected ObjectName getServiceCounterName(Exchange ex) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.management.interceptor.AbstractMessageResponseTimeInterceptor", "getServiceCounterName", new Object[]{ex});
        }
        Bus bus = ex.getBus();
        StringBuilder buffer = new StringBuilder();
        ObjectName serviceCounterName = null;
        if (ex.get((Object)"org.apache.cxf.management.service.counter.name") != null) {
            buffer.append((String)ex.get((Object)"org.apache.cxf.management.service.counter.name"));
            try {
                serviceCounterName = new ObjectName(buffer.toString());
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                void e;
                FFDCFilter.processException((Throwable)malformedObjectNameException, (String)"org.apache.cxf.management.interceptor.AbstractMessageResponseTimeInterceptor", (String)"124", (Object)((Object)this), (Object[])new Object[]{ex});
                LOG.log(Level.WARNING, "CREATE_COUNTER_OBJECTNAME_FAILED", (Throwable)e);
            }
        } else {
            Service service = ex.getService();
            Endpoint endpoint = ex.getEndpoint();
            serviceCounterName = (ObjectName)endpoint.get((Object)"javax.management.ObjectName");
            if (serviceCounterName == null) {
                String serviceName = "\"" + this.escapePatternChars(service.getName().toString()) + "\"";
                String portName = "\"" + endpoint.getEndpointInfo().getName().getLocalPart() + "\"";
                buffer.append("org.apache.cxf").append(':');
                buffer.append("bus.id").append('=').append(bus.getId()).append(',');
                Message message = ex.getOutMessage();
                if (this.isClient(message)) {
                    buffer.append("type").append('=').append("Performance.Counter").append(".Client,");
                } else {
                    buffer.append("type").append('=').append("Performance.Counter").append(".Server,");
                }
                buffer.append("service").append('=').append(serviceName).append(',');
                buffer.append("port").append('=').append(portName);
                try {
                    serviceCounterName = new ObjectName(buffer.toString());
                    endpoint.put((Object)"javax.management.ObjectName", (Object)serviceCounterName);
                }
                catch (MalformedObjectNameException malformedObjectNameException) {
                    void e;
                    FFDCFilter.processException((Throwable)malformedObjectNameException, (String)"org.apache.cxf.management.interceptor.AbstractMessageResponseTimeInterceptor", (String)"152", (Object)((Object)this), (Object[])new Object[]{ex});
                    LOG.log(Level.WARNING, "CREATE_COUNTER_OBJECTNAME_FAILED", (Throwable)e);
                }
            }
        }
        ObjectName objectName = serviceCounterName;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            objectName = objectName;
            LOG.exiting("org.apache.cxf.management.interceptor.AbstractMessageResponseTimeInterceptor", "getServiceCounterName", objectName);
        }
        return objectName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean isServiceCounterEnabled(Exchange ex) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.management.interceptor.AbstractMessageResponseTimeInterceptor", "isServiceCounterEnabled", new Object[]{ex});
        }
        Bus bus = ex.getBus();
        CounterRepository counterRepo = (CounterRepository)bus.getExtension(CounterRepository.class);
        if (counterRepo == null || this.skipCounter(ex)) {
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.management.interceptor.AbstractMessageResponseTimeInterceptor", "isServiceCounterEnabled", bl);
            }
            return bl;
        }
        ObjectName serviceCounterName = this.getServiceCounterName(ex);
        Counter serviceCounter = counterRepo.getCounter(serviceCounterName);
        boolean bl = serviceCounter == null || serviceCounter.isEnabled();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.management.interceptor.AbstractMessageResponseTimeInterceptor", "isServiceCounterEnabled", bl);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected ObjectName getOperationCounterName(Exchange ex, ObjectName sericeCounterName) {
        Object nameProperty;
        String operationName;
        ObjectName o;
        OperationInfo opInfo;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.management.interceptor.AbstractMessageResponseTimeInterceptor", "getOperationCounterName", new Object[]{ex, sericeCounterName});
        }
        BindingOperationInfo bop = ex.getBindingOperationInfo();
        OperationInfo operationInfo = opInfo = bop == null ? null : bop.getOperationInfo();
        if (opInfo != null && (o = (ObjectName)opInfo.getProperty("javax.management.ObjectName", ObjectName.class)) != null) {
            ObjectName objectName = o;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                objectName = objectName;
                LOG.exiting("org.apache.cxf.management.interceptor.AbstractMessageResponseTimeInterceptor", "getOperationCounterName", objectName);
            }
            return objectName;
        }
        String string = operationName = opInfo == null ? null : "\"" + opInfo.getName().getLocalPart() + "\"";
        if (operationName == null && (nameProperty = ex.get((Object)"org.apache.cxf.resource.operation.name")) != null) {
            operationName = "\"" + this.escapePatternChars(nameProperty.toString()) + "\"";
        }
        StringBuilder buffer = new StringBuilder(sericeCounterName.toString());
        if (operationName != null) {
            buffer.append(',').append("operation").append('=').append(operationName);
        }
        String operationCounterName = buffer.toString();
        ObjectName operationCounter = null;
        try {
            operationCounter = new ObjectName(operationCounterName);
            if (opInfo != null) {
                opInfo.setProperty("javax.management.ObjectName", (Object)operationCounter);
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            void e;
            FFDCFilter.processException((Throwable)malformedObjectNameException, (String)"org.apache.cxf.management.interceptor.AbstractMessageResponseTimeInterceptor", (String)"201", (Object)((Object)this), (Object[])new Object[]{ex, sericeCounterName});
            LOG.log(Level.WARNING, "CREATE_COUNTER_OBJECTNAME_FAILED", (Throwable)e);
        }
        ObjectName objectName = operationCounter;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            objectName = objectName;
            LOG.exiting("org.apache.cxf.management.interceptor.AbstractMessageResponseTimeInterceptor", "getOperationCounterName", objectName);
        }
        return objectName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String escapePatternChars(String value) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.management.interceptor.AbstractMessageResponseTimeInterceptor", "escapePatternChars", new Object[]{value});
        }
        if (value.lastIndexOf(QUESTION_MARK) != -1) {
            value = value.replace(QUESTION_MARK, ESCAPED_QUESTION_MARK);
        }
        String string = value;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.management.interceptor.AbstractMessageResponseTimeInterceptor", "escapePatternChars", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean skipCounter(Exchange ex) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.management.interceptor.AbstractMessageResponseTimeInterceptor", "skipCounter", new Object[]{ex});
        }
        Object interfaceObject = ex.get((Object)"jakarta.xml.ws.wsdl.interface");
        Object portService = ex.get((Object)"jakarta.xml.ws.wsdl.service");
        Object portObject = ex.get((Object)"jakarta.xml.ws.wsdl.port");
        Object portOperation = ex.get((Object)"jakarta.xml.ws.wsdl.operation");
        boolean bl = this.checkForSpecialCharacters(interfaceObject) || this.checkForSpecialCharacters(portService) || this.checkForSpecialCharacters(portObject) || this.checkForSpecialCharacters(portOperation);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.management.interceptor.AbstractMessageResponseTimeInterceptor", "skipCounter", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean checkForSpecialCharacters(Object obj) {
        String namespaceURI;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.management.interceptor.AbstractMessageResponseTimeInterceptor", "checkForSpecialCharacters", new Object[]{obj});
        }
        if (obj != null && obj instanceof QName && !(namespaceURI = ((QName)obj).getNamespaceURI()).matches("[a-zA-Z0-9./:?_]*$")) {
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.management.interceptor.AbstractMessageResponseTimeInterceptor", "checkForSpecialCharacters", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.management.interceptor.AbstractMessageResponseTimeInterceptor", "checkForSpecialCharacters", bl);
        }
        return bl;
    }
}

