/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.oidcclientcore.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Utils {
    private static final TraceComponent tc = Tr.register(Utils.class, (String)"OpenIdConnect", (String)"io.openliberty.security.oidcclientcore.internal.resources.OidcClientCoreMessages");
    public static final int TIMESTAMP_LENGTH = 15;
    static final long serialVersionUID = -7667087940989122492L;

    public static String getTimeStamp() {
        long lNumber = new Date().getTime();
        return Utils.getTimeStamp(lNumber);
    }

    public static String getTimeStamp(long lNumber) {
        String timeStamp = "" + lNumber;
        return StringUtils.leftPad((String)timeStamp, (int)15, (char)'0');
    }

    @Sensitive
    @Trivial
    public static String getStrHashCode(String input) {
        if (input != null && !input.isEmpty()) {
            int hashCode = input.hashCode();
            if (hashCode < 0) {
                return "n" + (hashCode *= -1);
            }
            return "p" + hashCode;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"hash() gets a null or empty parameter", (Object[])new Object[0]);
        }
        return "";
    }

    public static long convertNormalizedTimeStampToLong(String input) {
        String timeStamp = input.substring(0, 15);
        return Long.parseLong(timeStamp);
    }
}

