/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.mcp.meta;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public record MetaKey(String prefix, String name) {
    static final Pattern NAME_PATTERN;
    static final Pattern PREFIX_PATTERN;
    static final long serialVersionUID = -6982265593169217040L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public MetaKey {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (!MetaKey.isValidName(name)) {
            throw new IllegalArgumentException("name %s is not valid".formatted(name));
        }
        if (prefix != null && !MetaKey.isValidPrefix(prefix)) {
            throw new IllegalArgumentException("prefix %s is not valid".formatted(prefix));
        }
    }

    public static MetaKey from(String value) {
        if (!value.contains("/")) {
            return new MetaKey(null, value);
        }
        int slashIdx = value.indexOf(47);
        return new MetaKey(value.substring(0, slashIdx + 1), value.substring(slashIdx + 1));
    }

    public static MetaKey of(String name) {
        return new MetaKey(null, name);
    }

    public static MetaKey of(String name, String ... prefixLabels) {
        return new MetaKey(Arrays.stream(prefixLabels).collect(Collectors.joining(".")) + "/", name);
    }

    @Override
    public String toString() {
        if (this.prefix == null) {
            return this.name;
        }
        return this.prefix + this.name;
    }

    public static boolean isValidName(String value) {
        if (value == null || value.isBlank()) {
            return false;
        }
        return NAME_PATTERN.matcher(value).matches();
    }

    public static boolean isValidPrefix(String value) {
        if (value == null || value.isBlank() || !value.endsWith("/")) {
            return false;
        }
        return PREFIX_PATTERN.matcher(value).matches();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.mcp.meta.MetaKey", MetaKey.class, (String)"MCP", null);
        NAME_PATTERN = Pattern.compile("[a-zA-Z0-9][a-zA-Z0-9_.-]*[a-zA-Z0-9]");
        PREFIX_PATTERN = Pattern.compile("([a-zA-Z][a-zA-Z0-9-]*[a-zA-Z0-9])+(\\.[a-zA-Z][a-zA-Z0-9-]*[a-zA-Z0-9])*/");
    }
}

