/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.servlets;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.header.GenericNameAddressHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.GenericParametersHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ParametersHeaderImpl;
import com.ibm.ws.sip.container.failover.repository.SessionRepository;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.parser.SipServletDesc;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.container.router.SipAppDescManager;
import com.ibm.ws.sip.container.servlets.AddressImpl;
import com.ibm.ws.sip.container.servlets.BaseURI;
import com.ibm.ws.sip.container.servlets.OutgoingSipServletRequest;
import com.ibm.ws.sip.container.servlets.ParameterableImpl;
import com.ibm.ws.sip.container.servlets.SipApplicationSessionImpl;
import com.ibm.ws.sip.container.servlets.SipServletMessageImpl;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.servlets.SipURIImpl;
import com.ibm.ws.sip.container.servlets.TelURLImpl;
import com.ibm.ws.sip.container.servlets.URIImpl;
import com.ibm.ws.sip.container.servlets.WASXSipApplicationSessionFactory;
import com.ibm.ws.sip.container.servlets.WildcardNameAddress;
import com.ibm.ws.sip.container.tu.TransactionUserBase;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import com.ibm.ws.sip.container.util.SipUtil;
import com.ibm.ws.sip.container.was.ThreadLocalStorage;
import com.ibm.ws.sip.security.auth.AuthInfoFactory;
import com.ibm.ws.sip.stack.properties.StackProperties;
import com.ibm.ws.sip.stack.transaction.util.SIPStackUtil;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.SipProvider;
import jain.protocol.ip.sip.address.NameAddress;
import jain.protocol.ip.sip.address.SipURL;
import jain.protocol.ip.sip.header.FromHeader;
import jain.protocol.ip.sip.header.Header;
import jain.protocol.ip.sip.header.NameAddressHeader;
import jain.protocol.ip.sip.message.Request;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import javax.servlet.sip.Address;
import javax.servlet.sip.AuthInfo;
import javax.servlet.sip.Parameterable;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import javax.servlet.sip.ar.SipApplicationRoutingDirective;
import javax.servlet.sip.ar.SipApplicationRoutingRegion;

public class SipServletsFactoryImpl
implements SipFactory {
    private static final char GREATER_THEN = '>';
    public static final String UNKNOWN_APPLICATION = "Unknown application";
    private static final LogMgr c_logger = Log.get(SipServletsFactoryImpl.class);
    private static SipServletsFactoryImpl c_sipFactory;
    private SipAppDesc m_sipAppDesc;

    private SipServletsFactoryImpl(SipAppDesc appDesc) {
        this.m_sipAppDesc = appDesc;
    }

    private SipServletsFactoryImpl() {
    }

    @Override
    public Address createAddress(String sipAddress) throws ServletParseException {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{sipAddress};
            c_logger.traceEntry((Object)this, "createAddress", params);
        }
        Address address = null;
        if (sipAddress.equals("*")) {
            address = new WildcardNameAddress();
        } else {
            StackProperties sp = StackProperties.getInstance();
            try {
                boolean parseAddressAccordingToJSr = PropertiesStore.getInstance().getProperties().getBoolean("sipJsr289ParseAddress");
                String headerTemplate = "Route";
                if (parseAddressAccordingToJSr) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "createAddress", "To header is used as a template, the address will be parsed according to the JSR");
                    }
                    headerTemplate = "To";
                }
                NameAddressHeader header = (NameAddressHeader)sp.getHeadersFactory().createHeader(headerTemplate, sipAddress);
                address = new AddressImpl(header);
            }
            catch (SipParseException e2) {
                throw new ServletParseException(e2.getMessage() + "\n" + e2.toString());
            }
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "createAddress", "Address = " + address);
        }
        return address;
    }

    @Override
    public Parameterable createParameterable(String paramString) throws ServletParseException {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{paramString};
            c_logger.traceEntry((Object)this, "createParameterable", params);
        }
        if (paramString == null) {
            throw new IllegalArgumentException("null parameterable string");
        }
        ParametersHeaderImpl parametersHeader = new GenericNameAddressHeaderImpl("IBM-GenericAddressHeader");
        try {
            parametersHeader.setValue(paramString);
            parametersHeader.parse();
        }
        catch (SipParseException dontPrintMe) {
            parametersHeader = new GenericParametersHeaderImpl("IBM-GenericParametersHeader");
            try {
                parametersHeader.setValue(paramString);
                parametersHeader.parse();
            }
            catch (SipParseException e2) {
                throw new ServletParseException("bad parameterable syntax [" + paramString + ']');
            }
        }
        ParameterableImpl parameterable = new ParameterableImpl(parametersHeader);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "createParameterable", "parameterable created [" + parameterable + ']');
        }
        return parameterable;
    }

    private int measureFieldLeftTrim(String fieldString, int fieldNameBegin) {
        char c;
        int delimiter;
        int i = delimiter = fieldString.indexOf(":");
        while (i-- > fieldNameBegin && ((c = fieldString.charAt(i)) == ' ' || c == '\t') && fieldNameBegin == 0) {
            delimiter = i;
        }
        return delimiter;
    }

    private int measureFieldRightTrim(String fieldString) {
        char c;
        int fieldNameBegin = 0;
        for (int i = 0; i < fieldString.length() && (c = fieldString.charAt(i)) != ':'; ++i) {
            if (c != ' ' && c != '\t' || fieldNameBegin != 0) break;
            fieldNameBegin = i;
        }
        return fieldNameBegin;
    }

    @Override
    public Address createAddress(URI uri, String displayName) {
        AddressImpl address;
        block8: {
            if (c_logger.isTraceEntryExitEnabled()) {
                Object[] params = new Object[]{uri, displayName};
                c_logger.traceEntry((Object)this, "createAddress", params);
            }
            address = null;
            try {
                jain.protocol.ip.sip.address.URI jainSipURI = null;
                StackProperties sp = StackProperties.getInstance();
                if (uri instanceof URIImpl) {
                    jainSipURI = ((URIImpl)uri).getJainURI();
                } else {
                    String local = uri.toString();
                    local = local.substring(local.indexOf(58) + 1);
                    jainSipURI = sp.getAddressFactory().createURI(uri.getScheme(), local);
                }
                NameAddress nameAddress = displayName == null ? sp.getAddressFactory().createNameAddress(jainSipURI) : sp.getAddressFactory().createNameAddress(displayName, jainSipURI);
                FromHeader header = sp.getHeadersFactory().createFromHeader(nameAddress);
                address = new AddressImpl(header);
            }
            catch (IllegalArgumentException e2) {
                if (c_logger.isErrorEnabled()) {
                    Object[] args = new Object[]{uri, "not exist"};
                    c_logger.error("error.create.address", "Request", args, (Throwable)e2);
                }
            }
            catch (SipParseException e3) {
                if (!c_logger.isErrorEnabled()) break block8;
                Object[] args = new Object[]{uri, "not exist"};
                c_logger.error("error.create.address", "Request", args, (Throwable)e3);
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "createAddress", address);
        }
        return address;
    }

    @Override
    public Address createAddress(URI uri) {
        return this.createAddress(uri, null);
    }

    @Override
    public SipApplicationSession createApplicationSession() {
        if (this.m_sipAppDesc == null) {
            this.m_sipAppDesc = new SipAppDesc(UNKNOWN_APPLICATION, UNKNOWN_APPLICATION);
            this.m_sipAppDesc.addSipServlet(new SipServletDesc(this.m_sipAppDesc, "AsynchWorkSiplet", "none"));
        }
        return this.createApplicationSession(null);
    }

    public SipApplicationSession createApplicationSession(String logicalName) {
        SipApplicationSessionImpl appSession = (SipApplicationSessionImpl)WASXSipApplicationSessionFactory.getInstance().createSipApplicationSession(TransactionUserBase.createNextApplicationSessionId(logicalName));
        appSession.setSynchronizer(new Object());
        appSession.setServiceSynchronizer(new Object());
        appSession.setSipApp(this.m_sipAppDesc, true);
        appSession.addToApplicationSessionsTable();
        return appSession;
    }

    @Override
    public SipServletRequest createRequest(SipApplicationSession appSession, String method, Address from, Address to) {
        return this.createRequest(appSession, method, from, to, true);
    }

    private SipServletRequest createRequest(SipApplicationSession appSession, String method, Address fromParam, Address toParam, boolean requiresCloning) {
        Address from = fromParam;
        Address to = toParam;
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{appSession, method, from, to};
            c_logger.traceEntry((Object)this, "createRequest", params);
        }
        if (method.equalsIgnoreCase("ACK") || method.equalsIgnoreCase("CANCEL")) {
            throw new IllegalArgumentException("ACK/CANCEL can not be created by this method. See documentation");
        }
        if (from.isWildcard() || to.isWildcard()) {
            throw new IllegalArgumentException("From/To address can not be a wildcard address");
        }
        if (null == appSession || !appSession.isValid()) {
            throw new IllegalArgumentException("Sip Application Session does not exists or had been invalidated.");
        }
        if (requiresCloning) {
            from = (Address)((AddressImpl)from).clone(true);
            to = (Address)((AddressImpl)to).clone(true);
        }
        Address sipUri = (Address)to.clone();
        this.cleanSIPUri(to);
        this.cleanSIPUri(from);
        ((AddressImpl)from).removeTag();
        ((AddressImpl)to).removeTag();
        OutgoingSipServletRequest request = new OutgoingSipServletRequest(method, from, to, this.createCallId(), null, (SipApplicationSessionImpl)appSession, null);
        request.setRequestURI(sipUri.getURI());
        SipAppDesc appDesc = ((SipApplicationSessionImpl)appSession).getAppDescriptor();
        if (null != appDesc) {
            String servletName = ThreadLocalStorage.getSipServletName();
            SipServletDesc sipletDesc = appDesc.getSipServlet(servletName);
            if (!appDesc.hasMainServlet()) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("Creating request from jsr116 application");
                }
                if (sipletDesc == null) {
                    sipletDesc = appDesc.getDefaultSiplet();
                }
                request.getTransactionUser().setSipServletDesc(sipletDesc);
                if (!appDesc.hasMainServlet()) {
                    request.setAppInvokedName(appDesc.getApplicationName());
                }
            } else {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("Creating request from jsr289 application");
                }
                if (sipletDesc != null) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("Set handler to be - [" + sipletDesc + "]");
                    }
                    request.getTransactionUser().setSipServletDesc(sipletDesc);
                } else {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("Set handler to be - [" + appDesc.getMainSiplet() + "]");
                    }
                    request.getTransactionUser().setSipServletDesc(appDesc.getMainSiplet());
                }
            }
            if (!method.equals("ASYNWORK")) {
                request.getTransactionUser().createSessionsWhenListenerExists();
            }
        }
        return request;
    }

    private void cleanSIPUri(Address addr) {
        if (addr.getURI() instanceof SipURIImpl) {
            SipURIImpl uri = (SipURIImpl)addr.getURI();
            uri.removeHeaders();
            uri.removeParameter("lr");
            uri.removeParameter("maddr");
            uri.removeParameter("method");
            uri.removeParameter("transport");
            uri.removeParameter("ttl");
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "cleanSIPUri", "Can not clean non SIP URI: " + addr.getURI());
        }
    }

    @Override
    public SipServletRequest createRequest(SipApplicationSession appSession, String method, String from, String to) throws ServletParseException {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{appSession, method, from, to};
            c_logger.traceEntry((Object)this, "createRequest", params);
        }
        return this.createRequest(appSession, method, this.createAddress(from), this.createAddress(to), false);
    }

    @Override
    public SipServletRequest createRequest(SipApplicationSession appSession, String method, URI from, URI to) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{appSession, method, from, to};
            c_logger.traceEntry((Object)this, "createRequest", params);
        }
        return this.createRequest(appSession, method, this.createAddress((URI)((BaseURI)((Object)from)).clone(false)), this.createAddress((URI)((BaseURI)((Object)to)).clone(false)), false);
    }

    @Override
    public SipServletRequest createRequest(SipServletRequest origRequest, boolean sameCallId) {
        OutgoingSipServletRequest request;
        block10: {
            if (c_logger.isTraceEntryExitEnabled()) {
                Object[] params = new Object[]{origRequest, new Boolean(sameCallId)};
                c_logger.traceEntry((Object)this, "createRequest", params);
            }
            String callId = null;
            callId = sameCallId ? origRequest.getCallId() : this.createCallId();
            AddressImpl from = (AddressImpl)((AddressImpl)origRequest.getFrom()).clone(true);
            from.removeTag();
            AddressImpl to = (AddressImpl)((AddressImpl)origRequest.getTo()).clone(true);
            to.removeTag();
            TransactionUserWrapper tu = ((SipServletRequestImpl)origRequest).getTransactionUser();
            SipApplicationSession appSession = null;
            if (tu != null) {
                appSession = tu.getApplicationSession(true);
            }
            request = new OutgoingSipServletRequest(origRequest.getMethod(), (Address)from, (Address)to, callId, ((SipServletRequestImpl)origRequest).getSipProvider(), (SipApplicationSessionImpl)appSession, (SipServletRequestImpl)origRequest);
            Serializable stateInfo = ((SipServletRequestImpl)origRequest).getStateInfo();
            String nextApp = ((SipServletRequestImpl)origRequest).getNextApplication();
            SipApplicationRoutingDirective appDir = ((SipServletRequestImpl)origRequest).getDirective();
            SipApplicationRoutingRegion routingRegion = ((SipServletRequestImpl)origRequest).getRegion();
            request.setStateInfo(stateInfo);
            request.setNextApplication(nextApp);
            request.setDirective(appDir);
            request.setRoutingRegion(routingRegion);
            try {
                byte[] content;
                if (origRequest.getContentLength() > 0 && null != (content = origRequest.getRawContent())) {
                    request.setContent(origRequest.getContent(), origRequest.getContentType());
                }
            }
            catch (UnsupportedEncodingException e2) {
                if (c_logger.isErrorEnabled()) {
                    Object[] args = new Object[]{request};
                    c_logger.error("error.create.request", "Request", args, (Throwable)e2);
                }
            }
            catch (IOException e3) {
                if (!c_logger.isErrorEnabled()) break block10;
                Object[] args = new Object[]{request};
                c_logger.error("error.create.request", "Request", args, (Throwable)e3);
            }
        }
        request.setRequestURI(origRequest.getRequestURI());
        this.copyNonSystemHeaders(origRequest, request);
        SipServletDesc sipletDesc = ((SipServletMessageImpl)((Object)origRequest)).getTransactionUser().getSipServletDesc();
        request.getTransactionUser().setSipServletDesc(sipletDesc);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("Creating request from jsr289 application - " + sipletDesc.getSipApp().hasMainServlet());
        }
        if (!sipletDesc.getSipApp().hasMainServlet()) {
            request.setAppInvokedName(sipletDesc.getSipApp().getApplicationName());
        }
        if (!origRequest.getMethod().equals("ASYNWORK")) {
            request.getTransactionUser().createSessionsWhenListenerExists();
        }
        return request;
    }

    public void copyNonSystemHeaders(SipServletRequest origRequest, OutgoingSipServletRequest request) {
        Iterator iterator = ((SipServletRequestImpl)origRequest).getJainSipHeaders();
        if (iterator != null) {
            Request jainOutReq = request.getRequest();
            while (iterator.hasNext()) {
                Header header = (Header)iterator.next();
                if ((header.getName().equals("Via") || header.getName().equals("Record-Route") || header.getName().equals("CSeq") || header.getName().equals("To") || header.getName().equals("From") || header.getName().equals("Call-ID") || header.getName().equals("Max-Forwards") || header.getName().equals("Content-Type") || header.getName().equals("Content-Length") || header.getName().equals("IBM-Destination") || header.getName().equals("Contact")) && (!header.getName().equals("Contact") || !request.getMethod().equals("REGISTER"))) continue;
                jainOutReq.addHeader(header, false);
            }
        }
    }

    @Override
    public SipURI createSipURI(String user, String host) {
        SipURIImpl sipURI;
        block6: {
            if (c_logger.isTraceEntryExitEnabled()) {
                Object[] params = new Object[]{user, host};
                c_logger.traceEntry((Object)this, "createSipURI", params);
            }
            sipURI = null;
            try {
                StackProperties sp = StackProperties.getInstance();
                SipURL jainSipURL = sp.getAddressFactory().createSipURL(user, host);
                sipURI = new SipURIImpl(jainSipURL);
            }
            catch (IllegalArgumentException e2) {
                if (c_logger.isErrorEnabled()) {
                    Object[] args = new Object[]{user, host};
                    c_logger.error("error.create.sip.uri", "Request", args, (Throwable)e2);
                }
            }
            catch (SipParseException e3) {
                if (!c_logger.isErrorEnabled()) break block6;
                Object[] args = new Object[]{user, host};
                c_logger.error("error.create.sip.uri", "Request", args, (Throwable)e3);
            }
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "createSipURI", "SIP Uri = " + sipURI);
        }
        return sipURI;
    }

    @Override
    public URI createURI(String str) throws ServletParseException {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{str};
            c_logger.traceEntry((Object)this, "createURI", params);
        }
        if (null == str) {
            throw new ServletParseException("The URI was not specified.");
        }
        int gtIndex = str.indexOf(62);
        if (gtIndex > -1) {
            throw new ServletParseException("Bad URI.");
        }
        URI uri = null;
        try {
            int index = str.indexOf(58);
            if (index == -1) {
                if (c_logger.isErrorEnabled()) {
                    Object[] args = new Object[]{uri};
                    c_logger.error("error.create.uri", "Request", args);
                }
                throw new ServletParseException("Invalid URI scheme");
            }
            String scheme = str.substring(0, index);
            String uriString = str.substring(index + 1);
            StackProperties sp = StackProperties.getInstance();
            if (SipURIImpl.isSchemeSupported(scheme)) {
                jain.protocol.ip.sip.address.URI jainURI = sp.getAddressFactory().createURI(scheme, uriString);
                uri = new SipURIImpl((SipURL)jainURI);
            } else if (TelURLImpl.isSchemeSupported(scheme)) {
                jain.protocol.ip.sip.address.URI jainURI = sp.getAddressFactory().createURI(scheme, uriString + '>');
                uri = new TelURLImpl(jainURI, true);
            } else {
                jain.protocol.ip.sip.address.URI jainURI = sp.getAddressFactory().createURI(scheme, uriString);
                uri = new URIImpl(jainURI);
            }
        }
        catch (IllegalArgumentException e2) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug((Object)"error.create.uri", "Request", uri == null ? null : uri.toString(), e2);
            }
            throw new ServletParseException(e2.toString());
        }
        catch (SipParseException e3) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug((Object)"error.create.uri", "Request", uri == null ? null : uri.toString(), e3);
            }
            throw new ServletParseException(e3.toString());
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "createURI", "Uri = " + uri);
        }
        return uri;
    }

    public static synchronized SipFactory getInstance(String appName) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{appName};
            c_logger.traceEntry((Object)"SIP Servlets Factory", "getInstance", params);
        }
        SipFactory factory = null;
        SipAppDesc appDesc = SipAppDescManager.getInstance().getSipAppDescByAppName(appName);
        if (appDesc == null) {
            appDesc = SipAppDescManager.getInstance().getSipAppDesc(appName);
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug((Object)"SIP Servlets Factory", "getInstance", "getApp by WebAppName, result" + appDesc);
            }
        }
        if (null != appDesc) {
            factory = appDesc.getSipFactory();
            if (null == factory) {
                factory = new SipServletsFactoryImpl(appDesc);
                appDesc.setSipFactory(factory);
            }
        } else {
            factory = SipServletsFactoryImpl.getInstance();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug((Object)"SIP Servlets Factory", "getInstance", "Using global factory, Unknown SIP App descriptor : " + appName);
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)"SIP Servlets Factory", "getInstance", factory);
        }
        return factory;
    }

    public static synchronized SipServletsFactoryImpl getInstance() {
        if (null == c_sipFactory) {
            c_sipFactory = new SipServletsFactoryImpl();
        }
        return c_sipFactory;
    }

    private String createCallId() {
        SipProvider provider = StackProperties.getInstance().getFirstProvider();
        return SIPStackUtil.generateCallIdentifier(provider.getListeningPoint().getCallIdValue());
    }

    public URI generateURI(jain.protocol.ip.sip.address.URI jainUri) {
        URIImpl uri = null;
        String scheme = jainUri.getScheme();
        uri = SipURIImpl.isSchemeSupported(scheme) ? new SipURIImpl((SipURL)jainUri) : (TelURLImpl.isSchemeSupported(scheme) ? new TelURLImpl(jainUri) : new URIImpl(jainUri));
        return uri;
    }

    @Override
    public AuthInfo createAuthInfo() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "createAuthInfo");
        }
        AuthInfo authInfo = AuthInfoFactory.createAuthInfo();
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "createAuthInfo", authInfo);
        }
        return authInfo;
    }

    @Override
    public SipApplicationSession createApplicationSessionByKey(String applicationSessionKey) {
        return this.createApplicationSessionByKey(applicationSessionKey, true);
    }

    public SipApplicationSession createApplicationSessionByKey(String applicationSessionKey, boolean create) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "createApplicationSessionByKey", applicationSessionKey, create);
        }
        if (applicationSessionKey == null) {
            throw new NullPointerException("applicationSessionKey is null");
        }
        String appName = this.m_sipAppDesc != null ? this.m_sipAppDesc.getApplicationName() : "";
        String appKey = SipUtil.composeSessionKeyBaseKey(appName, applicationSessionKey);
        String sipAppID = SessionRepository.getInstance().getKeyBaseAppSession(appKey);
        SipApplicationSession sipAppSession = null;
        if (sipAppID != null) {
            sipAppSession = SipApplicationSessionImpl.getAppSession(sipAppID);
        } else if (create) {
            sipAppSession = this.createApplicationSession();
            SessionRepository.getInstance().setSessionKeyBase(appKey, sipAppSession.getId());
            ((SipApplicationSessionImpl)sipAppSession).setSessionKeyBaseTargeting(appKey);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "createApplicationSessionByKey", sipAppSession);
        }
        return sipAppSession;
    }
}

