/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.router.tasks;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.router.tasks.RoutedTask;
import com.ibm.ws.sip.container.sessions.SipTransactionUserTable;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import jain.protocol.ip.sip.SipProvider;
import jain.protocol.ip.sip.message.Response;

public class StrayResponseRoutedTask
extends RoutedTask {
    private static final transient LogMgr c_logger = Log.get(StrayResponseRoutedTask.class);
    private SipProvider _provider;
    private Response _JAINresponse;
    private boolean _createDerived;

    public static StrayResponseRoutedTask getInstance(TransactionUserWrapper transactionUser, Response response, SipProvider provider, boolean createDerived) {
        return new StrayResponseRoutedTask(transactionUser, response, provider, createDerived);
    }

    public StrayResponseRoutedTask(TransactionUserWrapper transactionUser, Response response, SipProvider provider, boolean createDerived) {
        super(transactionUser);
        this._provider = provider;
        this._JAINresponse = response;
        this._createDerived = createDerived;
    }

    @Override
    protected void doTask() {
        if (this._transactionUser.isInvalidating() || this._transactionUser.isTransactionUserInvalidated()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "StrayResponseRoutedTask", "Transaction user got invalidated by the time this task was queued. Aborting task. TU ID = " + this._transactionUser.getId());
            }
            return;
        }
        TransactionUserWrapper tu = this._transactionUser;
        if (this._createDerived) {
            TransactionUserWrapper transactionUser = SipTransactionUserTable.getInstance().getTransactionUserInboundResponse(this._JAINresponse);
            if (transactionUser != null) {
                if (transactionUser.isInvalidating()) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "doTask", "return because got stray response on invalidating transaction: " + transactionUser.getId());
                    }
                    return;
                }
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "StrayResponseRoutedTask", " appropriate TU was already created ID = " + tu.getId());
                }
                tu = transactionUser;
            } else {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "StrayResponseRoutedTask", " Derived should be created for " + tu.getId());
                }
                if (!tu.isProxying()) {
                    tu = tu.createDerivedTU(this._JAINresponse, "StrayResponseRoutedTask - create Derived as reason of stray response");
                }
            }
        }
        tu.processStrayResponse(this._JAINresponse, this._provider);
    }

    @Override
    public String getMethod() {
        return "Stray Response";
    }

    @Override
    public int priority() {
        return 100;
    }
}

