/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.resolver.dns.impl.netty;

import com.ibm.ws.sip.channel.resolver.dns.impl.netty.Name;
import com.ibm.ws.sip.channel.resolver.dns.impl.netty.ResourceRecord;
import io.netty.buffer.ByteBuf;

public class SOARecord
extends ResourceRecord {
    private Name _mname;
    private Name _rname;
    private int _serial;
    private int _refresh;
    private int _retry;
    private int _expire;
    private int _minTTL;

    protected SOARecord() {
        this._mname = null;
        this._rname = null;
        this._serial = 0;
        this._refresh = 0;
        this._retry = 0;
        this._expire = 0;
        this._minTTL = 0;
    }

    protected SOARecord(ByteBuf buffer) {
        super(buffer);
        this._mname = new Name(buffer);
        this._rname = new Name(buffer);
        this._serial = buffer.readInt();
        this._refresh = buffer.readInt();
        this._retry = buffer.readInt();
        this._expire = buffer.readInt();
        this._minTTL = buffer.readInt();
    }

    @Override
    protected void toBuffer(ByteBuf buffer) {
        super.toBuffer(buffer);
        this._mname.toBuffer(buffer);
        this._rname.toBuffer(buffer);
        buffer.writeInt(this._serial);
        buffer.writeInt(this._refresh);
        buffer.writeInt(this._retry);
        buffer.writeInt(this._expire);
        buffer.writeInt(this._minTTL);
    }

    public void setMname(Name n) {
        this._mname = n;
    }

    public void setRname(Name n) {
        this._rname = n;
    }

    public void setSerial(int i) {
        this._serial = i;
    }

    public void setRefresh(int i) {
        this._refresh = i;
    }

    public void setRetry(int i) {
        this._retry = i;
    }

    public void setExpire(int i) {
        this._expire = i;
    }

    public void setMinTTL(int i) {
        this._minTTL = i;
    }

    public short calcrdLength() {
        int length = 0;
        length = this._mname.length() + this._rname.length() + 4 + 4 + 4 + 4 + 4;
        return (short)length;
    }

    public Name getMname() {
        return this._mname;
    }

    public Name getRname() {
        return this._rname;
    }

    @Override
    public String toString() {
        String s = new String();
        s = super.toString();
        s = s + "      mname: " + this._mname.toString() + "\n      rname: " + this._rname.toString() + "\n      serial: " + this._serial + "\n      refresh: " + this._refresh + "\n      retry: " + this._retry + "\n      expire: " + this._expire + "\n      minimum TTL: " + this._minTTL + "\n";
        return s;
    }
}

